
<?php $__env->startSection('title','ডিপোজিট সাবমিট হয়েছে'); ?>
<?php $__env->startSection('content'); ?>
<div class="max-w-2xl mx-auto px-3 py-4">

  
  <div class="rounded-2xl bg-teal-50 border border-teal-200 p-4">
    <div class="flex items-start gap-3">
      <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-teal-600" viewBox="0 0 20 20" fill="currentColor">
        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.707a1 1 0 00-1.414-1.414L9 10.172 7.707 8.879A1 1 0 106.293 10.293l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
      </svg>
      <div>
        <h3 class="font-semibold text-teal-800">Deposit Submitted!</h3>
        <div class="mt-1 text-sm text-teal-700">
          Reference: <code class="px-1 py-0.5 bg-white rounded"><?php echo e($bank->reference); ?></code>
        </div>
        <div class="mt-1 text-xs text-teal-700">
          Status:
          <?php
            $badge = [
              'pending' => 'bg-amber-100 text-amber-800',
              'approved'=> 'bg-emerald-100 text-emerald-700',
              'rejected'=> 'bg-rose-100 text-rose-700',
            ][$bank->status] ?? 'bg-slate-100 text-slate-700';
          ?>
          <span class="uppercase px-2 py-0.5 rounded <?php echo e($badge); ?>"><?php echo e($bank->status); ?></span>
        </div>
      </div>
    </div>
  </div>

  
  <div class="mt-4 bg-white rounded-2xl shadow p-4">
    <div class="grid grid-cols-1 sm:grid-cols-2 gap-3 text-sm text-slate-700">
      <p><span class="text-slate-500">Method:</span> <?php echo e($bank->method->bank_name); ?></p>
      <p><span class="text-slate-500">Amount:</span> <?php echo e(number_format($bank->amount, 2)); ?></p>
      <p><span class="text-slate-500">Date:</span> <?php echo e($bank->created_at->format('Y-m-d H:i')); ?></p>

      <?php if($bank->proof_screenshot): ?>
        <p class="col-span-full">
          <a href="<?php echo e(asset('storage/'.$bank->proof_screenshot)); ?>" target="_blank"
             class="inline-flex items-center gap-2 text-teal-700 hover:text-teal-800">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" viewBox="0 0 20 20" fill="currentColor">
              <path d="M14 3h3a1 1 0 011 1v3a1 1 0 11-2 0V6.414l-6.293 6.293a1 1 0 01-1.414-1.414L14.586 5H14a1 1 0 110-2z"/>
              <path d="M5 4a1 1 0 00-1 1v10a1 1 0 001 1h10a1 1 0 001-1v-5a1 1 0 112 0v5a3 3 0 01-3 3H5a3 3 0 01-3-3V5a3 3 0 013-3h5a1 1 0 010 2H5z"/>
            </svg>
            View Proof
          </a>
        </p>
      <?php endif; ?>
    </div>

    <div class="mt-4 flex gap-3">
      <a href="<?php echo e(route('addmoney_bank.transactions')); ?>"
         class="flex-1 h-11 rounded-xl bg-[#2FAAA6] text-white font-medium hover:opacity-95 shadow-md grid place-items-center">
        লেনদেনসমূহ দেখুন
      </a>
      <a href="<?php echo e(route('addmoney_bank.methods')); ?>"
         class="flex-1 h-11 rounded-xl border border-slate-200 text-slate-700 hover:bg-slate-50 shadow-sm grid place-items-center">
        মেথডে ফিরুন
      </a>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\production_re_banking\resources\views/frontend/add-money-bank/success.blade.php ENDPATH**/ ?>