<!doctype html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <?php
        $companySetup = \App\Models\CompanySetup::first();
    ?>

    <title><?php echo e($companySetup->company_name ?? config('app.name')); ?> - PIN</title>

    <?php if($companySetup && $companySetup->fav_icon): ?>
        <link rel="icon" href="<?php echo e(asset('storage/'.$companySetup->fav_icon)); ?>" type="image/png">
    <?php endif; ?>

    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: { mint: {50:'#effcf7',100:'#d9faf0',200:'#baf4e3',300:'#8febd1',400:'#5fdbba',500:'#34c9a3',600:'#22b08f',700:'#1a8d74',800:'#176f5d',900:'#145a4c'} },
                    boxShadow: { soft: '0 10px 25px rgba(0,0,0,0.06)' },
                    fontFamily: { bangla: ['Noto Sans Bengali','Hind Siliguri','ui-sans-serif','system-ui'] }
                }
            }
        }
    </script>
    <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@400;500;600;700&family=Noto+Sans+Bengali:wght@400;600;700&display=swap" rel="stylesheet">

    <style>
        .btn-gradient { background-image: linear-gradient(90deg, #22b08f, #176f5d); }
        .btn-gradient:hover { filter: brightness(1.05); }

        .digit-group {
            display: flex;
            justify-content: center;
            gap: 10px;
        }
        .digit-box {
            width: 52px;
            height: 52px;
            border-radius: 12px;
            border: 2px solid rgba(95,219,186,0.35);
            text-align: center;
            font-size: 22px;
            background-color: #f0fdf4;
            outline: none;
        }
        .digit-box:focus {
            border-color: #22b08f;
            background-color: #ffffff;
            box-shadow: 0 0 0 1px rgba(34,176,143,0.25);
        }
    </style>
</head>
<body class="min-h-screen bg-gradient-to-b from-mint-50 to-white font-bangla">
<div class="min-h-screen flex items-center justify-center p-4">
    <div class="w-full max-w-md">
        <div class="flex flex-col items-center mb-6">
            <div class="w-16 h-16 rounded-2xl bg-mint-100 flex items-center justify-center shadow-soft">
                <svg viewBox="0 0 24 24" class="w-9 h-9 text-mint-700" fill="currentColor" aria-hidden="true">
                    <path d="M6 18a4 4 0 0 1 1.2-7.8A5 5 0 0 1 18 8a4 4 0 0 1 1 7.87V16a3 3 0 0 1-3 3H9a3 3 0 0 1-3-3v2z" opacity=".25"/>
                    <path d="M9 11a3 3 0 1 1 6 0v1h.5A2.5 2.5 0 0 1 18 14.5v2A2.5 2.5 0 0 1 15.5 19h-7A2.5 2.5 0 0 1 6 16.5v-2A2.5 2.5 0 0 1 8.5 12H9v-1zm2 1h2v-1a1 1 0 1 0-2 0v1z"/>
                </svg>
            </div>
            <h4 class="mt-3 text-2xl font-bold text-mint-800">Type your PIN</h4>
            <p class="text-center text-sm text-mint-700 mt-1">
                Account: <?php echo e(auth()->user()->phone ?? auth()->user()->email); ?>

            </p>
            <div class="mt-2 h-1 w-24 bg-mint-200 rounded-full"></div>
        </div>

        <div class="bg-white rounded-3xl shadow-soft p-6 border border-mint-100">
            <?php if(session('status')): ?>
                <div class="mb-3 p-3 rounded-xl bg-mint-100 text-mint-800 border border-mint-200 text-sm text-center">
                    <?php echo e(session('status')); ?>

                </div>
            <?php endif; ?>

            <?php if($errors->any()): ?>
                <div class="mb-3 p-3 rounded-xl bg-red-50 text-red-700 border border-red-200 text-xs">
                    <ul class="list-disc list-inside space-y-1">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>

            <form method="POST" action="<?php echo e(route('pin.verify')); ?>" id="pin-form" class="space-y-3">
                <?php echo csrf_field(); ?>

                <div class="digit-group mb-1" data-length="4">
                    <?php for($i = 1; $i <= 4; $i++): ?>
                        <input
                            type="password"
                            inputmode="numeric"
                            maxlength="1"
                            class="digit-box"
                            data-index="<?php echo e($i); ?>"
                            id="digit-<?php echo e($i); ?>"
                        >
                    <?php endfor; ?>
                </div>

                <input type="hidden" name="pin" id="pin-hidden">

                <?php $__errorArgs = ['pin'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-center text-red-600 text-xs"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                <button type="submit"
                        class="btn-gradient w-full text-white font-semibold py-3 rounded-2xl shadow-soft mt-2">
                    Log in
                </button>
            </form>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function () {
    const inputs = document.querySelectorAll('.digit-box');
    const hidden = document.getElementById('pin-hidden');
    const form   = document.getElementById('pin-form');

    function updateHidden() {
        hidden.value = Array.from(inputs).map(i => i.value).join('');
    }

    inputs.forEach((input, index) => {
        input.addEventListener('input', function () {
            this.value = this.value.replace(/\D/g, '').slice(0, 1);

            if (this.value && index < inputs.length - 1) {
                inputs[index + 1].focus();
            }

            updateHidden();
        });

        input.addEventListener('keydown', function (e) {
            if (e.key === 'Backspace' && !this.value && index > 0) {
                inputs[index - 1].focus();
            }
        });
    });

    form.addEventListener('submit', function (e) {
        updateHidden();
        if (hidden.value.length !== 4) {
            e.preventDefault();
            alert('৪-সংখ্যার PIN পূর্ণভাবে লিখুন।');
        }
    });
});
</script>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\new-development-re-banking\re_banking_2\resources\views/frontend/auth/pin.blade.php ENDPATH**/ ?>