

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-3">

    
    <div class="d-flex flex-wrap justify-content-between align-items-center mb-3">
        <h4 class="mb-2 mb-md-0">
            <i class="bi bi-wallet2 me-1"></i>
            User Balances
        </h4>

        <form method="GET" class="d-flex gap-2" style="max-width: 360px; width: 100%;">
            <div class="input-group">
                <span class="input-group-text">
                    <i class="bi bi-search"></i>
                </span>
                <input type="text"
                       name="q"
                       value="<?php echo e($q); ?>"
                       class="form-control"
                       placeholder="Search by name, phone, email">
            </div>
        </form>
    </div>

    
    <div class="card">
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-striped table-hover mb-0 align-middle">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Name</th>
                            <th>Phone</th>
                            <th>Email</th>
                            <th class="text-end">Balance (TK)</th>
                            <th class="text-center">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($user->id); ?></td>
                            <td>
                                <div class="fw-semibold"><?php echo e($user->name); ?></div>
                                <small class="text-muted text-uppercase"><?php echo e($user->role); ?></small>
                            </td>
                            <td><?php echo e($user->phone ?? '-'); ?></td>
                            <td><?php echo e($user->email ?? '-'); ?></td>
                            <td class="text-end"><?php echo e(number_format($user->balance, 2)); ?></td>
                            <td class="text-center">
                                <a href="<?php echo e(route('admin.users.balance.edit', $user)); ?>"
                                   class="btn btn-sm btn-outline-primary">
                                    <i class="bi bi-pencil-square me-1"></i>
                                    Adjust
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="6" class="text-center text-muted py-3">
                                No users found.
                            </td>
                        </tr>
                    <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    
    <div class="mt-3">
        <?php echo e($users->links()); ?>

    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ecareba2/new1.rkmotorsbike.top/resources/views/admin/users/balance/index.blade.php ENDPATH**/ ?>