
<?php $__env->startSection('content'); ?>
  <style>
    body{font-family:system-ui,-apple-system,Segoe UI,Roboto,Ubuntu,"Helvetica Neue",Arial,sans-serif;margin:20px}
    .topbar{display:flex;justify-content:space-between;align-items:center;margin-bottom:16px}
    .btn{display:inline-block;padding:8px 12px;border:1px solid #333;background:#333;color:#fff;text-decoration:none;border-radius:6px}
    .btn.outline{background:#fff;color:#333}
    table{border-collapse:collapse;width:100%}
    th,td{border:1px solid #ddd;padding:8px;text-align:left}
    th{background:#f4f4f4}
    .badge{padding:2px 8px;border-radius:999px;border:1px solid #888;font-size:12px}
    .success{background:#e6ffed;border-color:#2ea043}
    .muted{background:#f2f2f2;color:#444}
    .flash{margin-bottom:12px;padding:10px;border:1px solid #cce5cc;background:#eaffea;border-radius:6px}
    form{display:inline}
  </style>
 
  <div class="topbar">
    <h1 style="margin:0">Reward Settings</h1>
    <a class="btn" href="<?php echo e(route('reward-settings.create')); ?>">Create</a>
  </div>

  <?php if(session('success')): ?>
    <div class="flash"><?php echo e(session('success')); ?></div>
  <?php endif; ?>

  <?php if($rewardSettings->count() === 0): ?>
    <p>No reward settings found.</p>
  <?php else: ?>
    <div style="overflow:auto">
      <table>
        <thead>
          <tr>
            <th>#</th>
            <th>Add</th>
            <th>Send</th>
            <th>Drive</th>
            <th>Recharge</th>
            <th>Paybills</th>
            <th>MobileBank</th>
            <th>BankTrans</th>
            <th>Active</th>
            <th>Created</th>
            <th style="text-align:right">Actions</th>
          </tr>
        </thead>
        <tbody>
          <?php $__currentLoopData = $rewardSettings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
              <td><?php echo e($rs->id); ?></td>
              <td><?php echo e(number_format($rs->add_money_comm, 2)); ?></td>
              <td><?php echo e(number_format($rs->send_money_comm, 2)); ?></td>
              <td><?php echo e(number_format($rs->drive_offer_comm, 2)); ?></td>
              <td><?php echo e(number_format($rs->mobile_recharge_comm, 2)); ?></td>
              <td><?php echo e(number_format($rs->paybills_comm, 2)); ?></td>
              <td><?php echo e(number_format($rs->mobile_banking_comm, 2)); ?></td>
              <td><?php echo e(number_format($rs->bank_trans_comm, 2)); ?></td>
              <td>
                <?php if($rs->is_active): ?>
                  <span class="badge success">Yes</span>
                <?php else: ?>
                  <span class="badge muted">No</span>
                <?php endif; ?>
              </td>
              <td><?php echo e($rs->created_at?->format('Y-m-d')); ?></td>
              <td style="text-align:right; white-space:nowrap">
                <a class="btn outline" href="<?php echo e(route('reward-settings.show', $rs)); ?>">Show</a>
                <a class="btn outline" href="<?php echo e(route('reward-settings.edit', $rs)); ?>">Edit</a>
                <form action="<?php echo e(route('reward-settings.destroy', $rs)); ?>" method="POST" onsubmit="return confirm('Delete this item?')">
                  <?php echo csrf_field(); ?>
                  <?php echo method_field('DELETE'); ?>
                  <button class="btn outline" type="submit">Delete</button>
                </form>
              </td>
            </tr>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
      </table>
    </div>

    <div style="margin-top:12px">
      <?php echo e($rewardSettings->links()); ?>

    </div>
  <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ecareba2/new.rkmotorsbike.top/resources/views/admin/reward_settings/index.blade.php ENDPATH**/ ?>