<!doctype html>
<html lang="bn">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />

  <?php
      $companySetup = \App\Models\CompanySetup::first();
  ?>

  <title><?php echo e($companySetup->company_name ?? config('app.name')); ?> - OTP যাচাই</title>

  <?php if($companySetup && $companySetup->fav_icon): ?>
      <link rel="icon" href="<?php echo e(asset('storage/'.$companySetup->fav_icon)); ?>" type="image/png">
  <?php endif; ?>

  <script src="https://cdn.tailwindcss.com"></script>
  <script>
    tailwind.config = {
      theme: {
        extend: {
          colors: {
            mint: {
              50:'#effcf7',100:'#d9faf0',200:'#baf4e3',300:'#8febd1',
              400:'#5fdbba',500:'#34c9a3',600:'#22b08f',700:'#1a8d74',
              800:'#176f5d',900:'#145a4c'
            }
          },
          boxShadow: { soft: '0 10px 25px rgba(0,0,0,0.06)' },
          fontFamily: {
            bangla: ['Noto Sans Bengali','Hind Siliguri','ui-sans-serif','system-ui']
          }
        }
      }
    }
  </script>
  <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@400;500;600;700&family=Noto+Sans+Bengali:wght@400;600;700&display=swap" rel="stylesheet">

  <style>
    .btn-gradient { background-image: linear-gradient(90deg, #22b08f, #176f5d); }
    .btn-gradient:hover { filter: brightness(1.05); }

    .otp-box {
        letter-spacing: 0.6rem;
        text-align: center;
        font-size: 22px;
        border-radius: 14px;
        border-width: 2px;
    }
  </style>
</head>
<body class="min-h-screen bg-gradient-to-b from-mint-50 to-white font-bangla">
  <div class="min-h-screen flex items-center justify-center p-4">
    <div class="w-full max-w-md">

      
      <div class="flex flex-col items-center mb-6">
        <div class="w-16 h-16 rounded-2xl bg-mint-100 flex items-center justify-center shadow-soft">
          
          <svg viewBox="0 0 24 24" class="w-9 h-9 text-mint-700" fill="currentColor" aria-hidden="true">
            <path d="M11.17 2.23a2 2 0 0 1 1.66 0l5.26 2.33A2 2 0 0 1 19 6.42V11c0 4.52-2.98 7.92-7.54 8.93a1 1 0 0 1-.42 0C6.48 18.92 3.5 15.52 3.5 11V6.42a2 2 0 0 1 .91-1.86l5.26-2.33Z" opacity=".25"/>
            <path d="M12 7a3 3 0 0 0-3 3v1h-.25A1.75 1.75 0 0 0 7 12.75v2.5C7 16.33 7.67 17 8.5 17h7a1.5 1.5 0 0 0 1.5-1.5v-2.75A1.75 1.75 0 0 0 15.25 11H15v-1a3 3 0 0 0-3-3Zm-1.5 3a1.5 1.5 0 1 1 3 0v1h-3v-1Z"/>
          </svg>
        </div>
        <h1 class="mt-3 text-2xl font-bold text-mint-800">OTP যাচাই করুন</h1>
        <p class="text-xs text-mint-700/80 mt-1">স্টেপ ২: OTP কনফার্ম করুন</p>
        <div class="mt-2 h-1 w-24 bg-mint-200 rounded-full"></div>
      </div>

      
      <div class="bg-white rounded-3xl shadow-soft p-6 border border-mint-100">
        <form method="POST"
              action="<?php echo e(route('phone.login.otp.submit')); ?>"
              class="space-y-4"
        >
          <?php echo csrf_field(); ?>

          <?php if($errors->any()): ?>
            <div class="p-3 rounded-xl bg-red-50 text-red-700 border border-red-200 text-sm">
              <ul class="list-disc list-inside space-y-1">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </ul>
            </div>
          <?php endif; ?>

          
          <div>
            <label for="otp" class="block text-sm font-medium text-mint-800 mb-1">
              আপনার OTP
            </label>
            <div class="relative">
              <span class="absolute inset-y-0 left-0 flex items-center pl-3 text-mint-700/70">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                     class="w-5 h-5" fill="currentColor">
                  <path d="M12 3.25 4.75 6v4.5c0 4.18 2.83 8 7.25 9.25 4.42-1.25 7.25-5.07 7.25-9.25V6L12 3.25Zm-1 4a1 1 0 0 1 2 0v3.42a2 2 0 1 1-2 0V7.25Z"/>
                </svg>
              </span>
              <input
                id="otp"
                type="text"
                name="otp"
                maxlength="6"
                readonly
                required
                class="otp-box w-full pl-11 pr-3 py-3 border-mint-200 bg-mint-50
                       focus:bg-white focus:outline-none focus:border-mint-500 transition tracking-[0.6em]"
              >
            </div>
            <p class="text-xs text-mint-700/80 mt-2 text-center">
              এই OTP নিশ্চিত করতে নিচের বাটনে চাপুন।
            </p>
          </div>

          <button type="submit"
                  class="btn-gradient w-full text-white font-semibold py-3 rounded-2xl shadow-soft
                         flex items-center justify-center gap-2 mt-1">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                 class="w-5 h-5" fill="currentColor">
              <path d="M5 12a1 1 0 0 1 .993.883L6 13v5h12v-5a1 1 0 0 1 1.993-.117L20 13v5a3 3 0 0 1-2.824 2.995L17 21H7a3 3 0 0 1-2.995-2.824L4 18v-5a1 1 0 0 1 1-1Zm6.293-7.707a1 1 0 0 1 1.32-.083l.094.083 6 6a1 1 0 0 1-1.32 1.497l-.094-.083L13 7.415V17a1 1 0 0 1-1.993.117L11 17V7.415l-3.293 3.292a1 1 0 0 1-1.32.083l-.094-.083a1 1 0 0 1-.083-1.32l.083-.094 6-6Z"/>
            </svg>
            OTP কনফার্ম করে লগইন করুন
          </button>

          <p class="text-center text-xs text-mint-700/80 mt-3">
            ভুল পেইজে এসেছেন?
            <a href="<?php echo e(route('phone.login')); ?>" class="text-mint-700 font-semibold hover:underline">
              মোবাইল লগইন পেইজে ফিরে যান
            </a>
          </p>
        </form>
      </div>

    </div>
  </div>

<script>
document.addEventListener('DOMContentLoaded', function () {
    const otpInput = document.getElementById('otp');
    if (otpInput) {
        const fakeOtp = Math.floor(100000 + Math.random() * 900000); // 100000 - 999999
        otpInput.value = fakeOtp.toString();
    }
});
</script>
</body>
</html>
<?php /**PATH /home/ecareba2/new1.rkmotorsbike.top/resources/views/auth/phone/otp.blade.php ENDPATH**/ ?>