<?php $__env->startSection('title','Send Money'); ?>

<?php $__env->startPush('styles'); ?>
    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@400;500;600;700&family=Poppins:wght@400;500;600&display=swap" rel="stylesheet">

    <style>
        body {
            font-family: "Hind Siliguri", system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
        }

        @keyframes blobFloat {
            0%   { transform: translate3d(-10%, -10%, 0) scale(1); }
            50%  { transform: translate3d(15%, 10%, 0) scale(1.08); }
            100% { transform: translate3d(40%, -5%, 0) scale(1); }
        }

        @keyframes blobFloat2 {
            0%   { transform: translate3d(40%, 20%, 0) scale(1); }
            50%  { transform: translate3d(5%, 0, 0) scale(1.04); }
            100% { transform: translate3d(-20%, 10%, 0) scale(1); }
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<?php
    $me = auth()->user();
?>
<div class="min-h-screen bg-gradient-to-b from-slate-950 via-slate-900 to-slate-950 flex justify-center items-start px-3 sm:px-4 py-8 relative overflow-hidden">

    
    <svg class="pointer-events-none absolute -top-32 -left-32 w-80 h-80 text-emerald-500/20"
         viewBox="0 0 200 200" xmlns="http://www.w3.org/2000/svg"
         style="animation: blobFloat 18s ease-in-out infinite alternate;">
        <path fill="currentColor"
              d="M45.1,-62C58.8,-54.8,69.1,-39.4,73.4,-22.5C77.7,-5.7,75.9,12.7,67.4,26.8C58.8,40.9,43.4,50.7,27.2,58.2C11,65.7,-6,70.9,-20.4,66.3C-34.7,61.6,-46.4,47.1,-55.3,31.5C-64.3,15.9,-70.4,-0.7,-68.1,-16.7C-65.8,-32.7,-55.1,-48.1,-41.2,-55.6C-27.3,-63.1,-10.1,-62.6,5.7,-69C21.5,-75.3,43,-88.4,45.1,-62Z"/>
    </svg>

    <svg class="pointer-events-none absolute bottom-0 -right-24 w-72 h-72 text-cyan-400/10"
         viewBox="0 0 200 200" xmlns="http://www.w3.org/2000/svg"
         style="animation: blobFloat2 22s ease-in-out infinite alternate%;">
        <path fill="currentColor"
              d="M35.8,-54.7C46.3,-47.4,54,-38,60.9,-27.1C67.7,-16.2,73.7,-4.1,71.9,6.8C70.1,17.7,60.5,27.3,50.4,36.6C40.4,46,29.9,55.3,17.3,60.4C4.6,65.6,-10.1,66.6,-24.4,62.4C-38.7,58.3,-52.6,49.1,-59.8,36.3C-66.9,23.4,-67.3,7,-64.6,-8.3C-61.9,-23.6,-56.1,-37.9,-45.7,-45.9C-35.2,-53.9,-20.1,-55.7,-5.2,-49.9C9.7,-44,19.3,-30.5,35.8,-54.7Z"/>
    </svg>

    <div class="w-full max-w-md relative z-10">

        
        <div class="mb-4 flex items-center justify-between text-xs text-slate-300">
            <button type="button"
                    onclick="window.history.back()"
                    class="inline-flex items-center gap-1 text-slate-300 hover:text-emerald-400 transition">
                <svg class="h-4 w-4" viewBox="0 0 24 24" fill="currentColor">
                    <path d="M15.75 4.75 9.5 11l6.25 6.25-1.5 1.5L6.5 11l7.75-7.75 1.5 1.5Z"/>
                </svg>
                Back
            </button>
            <span class="tracking-[0.18em] uppercase text-emerald-400 font-semibold text-[11px]">
                Send Money
            </span>
        </div>

        
        <div class="rounded-3xl bg-slate-900/80 border border-emerald-500/25 shadow-[0_25px_70px_-35px_rgba(16,185,129,0.7)] backdrop-blur-sm p-5 sm:p-6">

            
            <div class="mb-4 flex items-center gap-3">
                <div class="h-11 w-11 rounded-2xl bg-gradient-to-br from-emerald-500 to-cyan-500 flex items-center justify-center text-white shadow-lg shadow-emerald-500/40">
                    <svg class="h-5 w-5" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M4 7a3 3 0 0 1 3-3h10a3 3 0 0 1 3 3v2a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1Zm0 6a1 1 0 0 1 1-1h14a1 1 0 0 1 1 1v4a3 3 0 0 1-3 3H7a3 3 0 0 1-3-3Z"/>
                    </svg>
                </div>
                <div class="flex-1 min-w-0">
                    <div class="text-sm font-semibold text-slate-50 truncate">
                        <?php echo e($me->name ?? 'User'); ?>

                    </div>
                    <div class="flex items-center gap-1 text-[11px] text-slate-400">
                        <svg class="h-3.5 w-3.5" viewBox="0 0 24 24" fill="currentColor">
                            <path d="M6.62 10.79a15.05 15.05 0 0 0 6.59 6.59l2.2-2.2a1 1 0 0 1 1-.24 11.36 11.36 0 0 0 3.56.57 1 1 0 0 1 1 1V20a2 2 0 0 1-2 2A17.62 17.62 0 0 1 2 4a2 2 0 0 1 2-2h3.5a1 1 0 0 1 1 1 11.36 11.36 0 0 0 .57 3.56 1 1 0 0 1-.24 1Z"/>
                        </svg>
                        <span><?php echo e($me->phone ?? 'Phone not set'); ?></span>
                    </div>
                </div>
            </div>

            <p class="mb-3 text-[11px] text-slate-400 leading-relaxed">
                Make sure the receiver phone number and amount are correct before sending.
                If you send to a wrong number, the money may not be recoverable.
            </p>

            
            <?php if($errors->any()): ?>
                <div class="rounded-2xl bg-red-950/40 border border-red-500/40 px-3 py-2 text-[11px] text-red-100 mb-3">
                    <ul class="list-disc list-inside space-y-0.5">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>

            
            <form method="POST"
                  action="<?php echo e(route('wallet.send.store')); ?>"
                  id="sendForm"
                  class="space-y-4 mt-2"
                  autocomplete="off">
                <?php echo csrf_field(); ?>

                
                <div class="space-y-1">
                    <label for="to_phone" class="text-[11px] font-semibold tracking-wide text-slate-300 uppercase">
                        Receiver Phone Number
                    </label>
                    <div class="relative">
                        <input
                            type="text"
                            name="to_phone"
                            id="to_phone"
                            class="peer w-full rounded-2xl border-2 border-slate-700 bg-slate-950/70 px-4 py-2.5 text-sm text-slate-100 outline-none transition
                                   focus:border-emerald-400 focus:ring-2 focus:ring-emerald-500/30 placeholder-slate-500 pr-10"
                            placeholder="017XXXXXXXX or +8801XXXXXXXXX"
                            value="<?php echo e(old('to_phone')); ?>"
                            required
                            autocomplete="off"
                            inputmode="numeric"
                        />
                        <span class="pointer-events-none absolute inset-y-0 right-3 flex items-center text-emerald-400">
                            <svg class="h-4 w-4" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M6.62 10.79a15.05 15.05 0 0 0 6.59 6.59l2.2-2.2a1 1 0 0 1 1-.24 11.36 11.36 0 0 0 3.56.57 1 1 0 0 1 1 1V20a2 2 0 0 1-2 2A17.62 17.62 0 0 1 2 4a2 2 0 0 1 2-2h3.5a1 1 0 0 1 1 1 11.36 11.36 0 0 0 .57 3.56 1 1 0 0 1-.24 1Z"/>
                            </svg>
                        </span>
                    </div>
                    <div id="searchStatus" class="mt-1.5 text-[11px] text-slate-500">
                        Enter at least 10 digits.
                    </div>

                    
                    <div id="receiverCard"
                         class="mt-3 hidden items-center gap-3 rounded-2xl border border-emerald-500/25 bg-emerald-500/5 px-3 py-2 shadow-sm">
                        <div class="flex h-9 w-9 items-center justify-center rounded-full bg-gradient-to-br from-emerald-500 to-cyan-500 text-white text-sm font-semibold shadow-md"
                             id="receiverAvatar">
                            U
                        </div>
                        <div class="min-w-0">
                            <div class="truncate text-sm font-medium text-emerald-300" id="receiverName">—</div>
                            <div class="truncate text-xs text-emerald-400/90" id="receiverPhone">—</div>
                        </div>
                    </div>
                </div>

                
                <div class="space-y-1">
                    <label for="amount" class="text-[11px] font-semibold tracking-wide text-slate-300 uppercase">
                        Amount
                    </label>
                    <div class="relative">
                        <span class="pointer-events-none absolute inset-y-0 left-3 flex items-center text-emerald-400 text-xs">
                            ৳
                        </span>
                        <input
                            type="number"
                            step="0.01"
                            min="1"
                            name="amount"
                            id="amount"
                            class="w-full rounded-2xl border-2 border-slate-700 bg-slate-950/70 pl-7 pr-4 py-2.5 text-sm text-slate-100 outline-none
                                   focus:border-emerald-400 focus:ring-2 focus:ring-emerald-500/30 placeholder-slate-500 transition"
                            placeholder="0.00"
                            value="<?php echo e(old('amount')); ?>"
                            required
                        />
                    </div>
                </div>

                
                <div class="space-y-1">
                    <label for="login_pin" class="text-[11px] font-semibold tracking-wide text-slate-300 uppercase">
                        PIN (4 digits) *
                    </label>
                    <input
                        type="password"
                        name="login_pin"
                        id="login_pin"
                        maxlength="4"
                        inputmode="numeric"
                        pattern="\d*"
                        class="mt-1 w-full rounded-2xl border-2 border-slate-700 bg-slate-950/70 px-3 py-2.5 text-sm text-slate-100 placeholder-slate-500 text-center tracking-[0.3em] outline-none focus:border-emerald-400 focus:ring-2 focus:ring-emerald-400/40 <?php $__errorArgs = ['login_pin'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-rose-400 ring-rose-400/60 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                        placeholder="••••"
                        required
                    >
                    <?php $__errorArgs = ['login_pin'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-[11px] text-rose-400 mt-1 block"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                
                <div class="space-y-1">
                    <label for="note" class="text-[11px] font-semibold tracking-wide text-slate-300 uppercase">
                        Note (optional)
                    </label>
                    <div class="relative">
                        <input
                            type="text"
                            name="note"
                            id="note"
                            maxlength="160"
                            class="w-full rounded-2xl border-2 border-slate-700 bg-slate-950/70 px-4 py-2.5 text-sm text-slate-100 outline-none transition
                                   focus:border-emerald-400 focus:ring-2 focus:ring-emerald-500/30 placeholder-slate-500"
                            placeholder="Why are you sending?"
                            value="<?php echo e(old('note')); ?>"
                        />
                    </div>
                </div>

                
                <input type="hidden" name="idempotency_key" id="idempotency" value="<?php echo e((string) \Illuminate\Support\Str::uuid()); ?>">

                
                <button
                    id="sendBtn"
                    disabled
                    class="mt-2 w-full rounded-2xl bg-gradient-to-r from-emerald-500 to-cyan-500 py-2.5 text-sm font-semibold text-slate-950
                           shadow-[0_18px_45px_-20px_rgba(16,185,129,0.9)] hover:from-emerald-400 hover:to-cyan-400
                           active:scale-[0.98] transition-transform disabled:opacity-60 disabled:cursor-not-allowed flex items-center justify-center gap-2"
                >
                    <span id="btnText">Send Money</span>
                </button>
            </form>
        </div>
    </div>
</div>


<script>
const phoneInput   = document.getElementById('to_phone');
const amountInput  = document.getElementById('amount');
const pinInput     = document.getElementById('login_pin');
const statusEl     = document.getElementById('searchStatus');
const sendBtn      = document.getElementById('sendBtn');
const receiverCard = document.getElementById('receiverCard');
const recvNameEl   = document.getElementById('receiverName');
const recvPhoneEl  = document.getElementById('receiverPhone');
const recvAvatarEl = document.getElementById('receiverAvatar');

let foundUser = false;
let pendingController = null;

function normalizeDigits(s=''){
  const map = {'০':'0','১':'1','২':'2','৩':'3','৪':'4','৫':'5','৬':'6','৭':'7','৮':'8','৯':'9'};
  return s.replace(/[০-৯]/g, d => map[d]).replace(/[^\d+]/g, '');
}
function validatePhone(p){ return /^\+?\d{10,15}$/.test((p||'').trim()); }
function validateAmount(a){ return !isNaN(a) && Number(a) >= 1; }
function validatePin(p){ return /^\d{4}$/.test((p || '').trim()); }

function setStatus(text, type='muted'){
  const map = { muted:'text-slate-500', ok:'text-emerald-400', error:'text-rose-400', wait:'text-sky-400' };
  statusEl.className = 'mt-1.5 text-[11px] ' + (map[type] || map.muted);
  statusEl.textContent = text;
}
function showReceiver(user){
  recvNameEl.textContent  = user.name || 'Unknown';
  recvPhoneEl.textContent = user.phone || '';
  recvAvatarEl.textContent = (user.name || 'U').trim()[0]?.toUpperCase() || 'U';
  receiverCard.classList.remove('hidden');
}
function hideReceiver(){
  receiverCard.classList.add('hidden');
  recvNameEl.textContent = '—';
  recvPhoneEl.textContent = '—';
}

function updateSendState(){
  sendBtn.disabled = !(foundUser && validateAmount(amountInput.value) && validatePin(pinInput.value));
}

const debounce = (fn, ms=400) => { let t; return (...a)=>{ clearTimeout(t); t=setTimeout(()=>fn(...a), ms); }; };

async function searchPhone(phone){
  if (pendingController) pendingController.abort();
  pendingController = new AbortController();

  setStatus('Searching...', 'wait');
  foundUser = false; updateSendState(); hideReceiver();

  try{
    const r = await fetch(`<?php echo e(route('wallet.search')); ?>?phone=${encodeURIComponent(phone)}`, {
      headers:{'X-Requested-With':'XMLHttpRequest'}, signal: pendingController.signal
    });
    if (r.ok){
      const data = await r.json();
      setStatus(`Found: ${data.user.name} (${data.user.phone})`, 'ok');
      showReceiver(data.user);
      foundUser = true;
    } else {
      setStatus('User not found.', 'error');
      foundUser = false;
    }
  } catch(e){
    if (e.name !== 'AbortError'){
      setStatus('Search failed. Please check your network.', 'error');
    }
    foundUser = false;
  } finally {
    updateSendState();
  }
}

const onPhoneInput = debounce(() => {
  const raw = phoneInput.value;
  const normalized = normalizeDigits(raw);
  if (raw !== normalized) phoneInput.value = normalized;

  if (!validatePhone(normalized)) {
    setStatus('Enter a valid phone number (10–15 digits).', 'error');
    foundUser = false; updateSendState(); hideReceiver(); return;
  }
  searchPhone(normalized);
}, 400);

phoneInput.addEventListener('input', onPhoneInput);
amountInput.addEventListener('input', updateSendState);
pinInput.addEventListener('input', updateSendState);
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\new-development-re-banking\re_banking_1\resources\views/frontend/wallet/send.blade.php ENDPATH**/ ?>