

<?php $__env->startSection('title','Statement'); ?>

<?php $__env->startPush('styles'); ?>
    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@400;500;600;700&family=Poppins:wght@400;500;600&display=swap" rel="stylesheet">

    <style>
        body {
            font-family: "Hind Siliguri", system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
        }

        @keyframes blobFloat {
            0%   { transform: translate3d(-10%, -10%, 0) scale(1); }
            50%  { transform: translate3d(15%, 10%, 0) scale(1.08); }
            100% { transform: translate3d(40%, -5%, 0) scale(1); }
        }

        @keyframes blobFloat2 {
            0%   { transform: translate3d(40%, 20%, 0) scale(1); }
            50%  { transform: translate3d(5%, 0, 0) scale(1.04); }
            100% { transform: translate3d(-20%, 10%, 0) scale(1); }
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-gradient-to-b from-slate-950 via-slate-900 to-slate-950 flex justify-center items-start px-3 sm:px-4 py-8 relative overflow-hidden">

    
    <svg class="pointer-events-none absolute -top-32 -left-32 w-80 h-80 text-emerald-500/20"
         viewBox="0 0 200 200" xmlns="http://www.w3.org/2000/svg"
         style="animation: blobFloat 18s ease-in-out infinite alternate;">
        <path fill="currentColor"
              d="M45.1,-62C58.8,-54.8,69.1,-39.4,73.4,-22.5C77.7,-5.7,75.9,12.7,67.4,26.8C58.8,40.9,43.4,50.7,27.2,58.2C11,65.7,-6,70.9,-20.4,66.3C-34.7,61.6,-46.4,47.1,-55.3,31.5C-64.3,15.9,-70.4,-0.7,-68.1,-16.7C-65.8,-32.7,-55.1,-48.1,-41.2,-55.6C-27.3,-63.1,-10.1,-62.6,5.7,-69C21.5,-75.3,43,-88.4,45.1,-62Z"/>
    </svg>

    <svg class="pointer-events-none absolute bottom-0 -right-24 w-72 h-72 text-cyan-400/10"
         viewBox="0 0 200 200" xmlns="http://www.w3.org/2000/svg"
         style="animation: blobFloat2 22s ease-in-out infinite alternate;">
        <path fill="currentColor"
              d="M35.8,-54.7C46.3,-47.4,54,-38,60.9,-27.1C67.7,-16.2,73.7,-4.1,71.9,6.8C70.1,17.7,60.5,27.3,50.4,36.6C40.4,46,29.9,55.3,17.3,60.4C4.6,65.6,-10.1,66.6,-24.4,62.4C-38.7,58.3,-52.6,49.1,-59.8,36.3C-66.9,23.4,-67.3,7,-64.6,-8.3C-61.9,-23.6,-56.1,-37.9,-45.7,-45.9C-35.2,-53.9,-20.1,-55.7,-5.2,-49.9C9.7,-44,19.3,-30.5,35.8,-54.7Z"/>
    </svg>

    <div class="w-full max-w-md relative z-10">

        
        <div class="mb-4 flex items-center justify-between text-xs text-slate-300">
            <button type="button"
                    onclick="window.history.back()"
                    class="inline-flex items-center gap-1 text-slate-300 hover:text-emerald-400 transition">
                <svg class="h-4 w-4" viewBox="0 0 24 24" fill="currentColor">
                    <path d="M15.75 4.75 9.5 11l6.25 6.25-1.5 1.5L6.5 11l7.75-7.75 1.5 1.5Z"/>
                </svg>
                Back
            </button>
            <span class="tracking-[0.18em] uppercase text-emerald-400 font-semibold text-[11px]">
                Statement
            </span>
        </div>

        
        <div class="rounded-3xl bg-slate-900/80 border border-emerald-500/25 shadow-[0_25px_70px_-35px_rgba(16,185,129,0.7)] backdrop-blur-sm p-5 sm:p-6">

            
            <div class="mb-4 flex items-center gap-3">
                <div class="h-11 w-11 rounded-2xl bg-gradient-to-br from-emerald-500 to-cyan-500 flex items-center justify-center text-white shadow-lg shadow-emerald-500/40">
                    <svg class="h-5 w-5" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M12 12a4 4 0 1 0-4-4 4.01 4.01 0 0 0 4 4Zm0 2c-3.33 0-6 1.34-6 3v1a1 1 0 0 0 1 1h10a1 1 0 0 0 1-1v-1c0-1.66-2.67-3-6-3Z"/>
                    </svg>
                </div>
                <div class="flex-1 min-w-0">
                    <div class="text-sm font-semibold text-slate-50 truncate">
                        <?php echo e($user->name); ?>

                    </div>
                    <div class="flex items-center gap-1 text-[11px] text-slate-400">
                        <svg class="h-3.5 w-3.5" viewBox="0 0 24 24" fill="currentColor">
                            <path d="M6.62 10.79a15.05 15.05 0 0 0 6.59 6.59l2.2-2.2a1 1 0 0 1 1-.24 11.36 11.36 0 0 0 3.56.57 1 1 0 0 1 1 1V20a2 2 0 0 1-2 2A17.62 17.62 0 0 1 2 4a2 2 0 0 1 2-2h3.5a1 1 0 0 1 1 1 11.36 11.36 0 0 0 .57 3.56 1 1 0 0 1-.24 1Z"/>
                        </svg>
                        <span><?php echo e($user->phone ?? 'N/A'); ?></span>
                    </div>
                </div>
            </div>

            
            <form action="<?php echo e(route('statement.generate')); ?>" method="POST" class="space-y-4 mt-2">
                <?php echo csrf_field(); ?>

                <?php if($errors->any()): ?>
                    <div class="rounded-2xl bg-red-950/40 border border-red-500/40 px-3 py-2 text-[11px] text-red-100 mb-1">
                        <ul class="list-disc list-inside space-y-0.5">
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                <?php endif; ?>

                
                <div class="space-y-1">
                    <label class="text-[11px] font-semibold tracking-wide text-slate-300 uppercase">
                        From Date
                    </label>
                    <div class="relative">
                        <input type="date"
                               name="from_date"
                               value="<?php echo e(old('from_date')); ?>"
                               class="w-full rounded-2xl border-2 border-slate-700 bg-slate-950/70 text-sm text-slate-100
                                      px-4 py-2.5 pr-11 placeholder-slate-500 outline-none
                                      focus:border-emerald-400 focus:ring-2 focus:ring-emerald-500/30 transition">
                        <span class="pointer-events-none absolute inset-y-0 right-3 flex items-center text-emerald-400">
                            <svg class="h-5 w-5" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M7 2a1 1 0 0 0-1 1v1H5a3 3 0 0 0-3 3v11a3 3 0 0 0 3 3h14a3 3 0 0 0 3-3V7a3 3 0 0 0-3-3h-1V3a1 1 0 0 0-2 0v1H8V3A1 1 0 0 0 7 2Zm13 7H4v9a1 1 0 0 0 1 1h14a1 1 0 0 0 1-1Z"/>
                            </svg>
                        </span>
                    </div>
                </div>

                
                <div class="space-y-1">
                    <label class="text-[11px] font-semibold tracking-wide text-slate-300 uppercase">
                        To Date
                    </label>
                    <div class="relative">
                        <input type="date"
                               name="to_date"
                               value="<?php echo e(old('to_date', now()->toDateString())); ?>"
                               class="w-full rounded-2xl border-2 border-slate-700 bg-slate-950/70 text-sm text-slate-100
                                      px-4 py-2.5 pr-11 placeholder-slate-500 outline-none
                                      focus:border-emerald-400 focus:ring-2 focus:ring-emerald-500/30 transition">
                        <span class="pointer-events-none absolute inset-y-0 right-3 flex items-center text-emerald-400">
                            <svg class="h-5 w-5" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M7 2a1 1 0 0 0-1 1v1H5a3 3 0 0 0-3 3v11a3 3 0 0 0 3 3h14a3 3 0 0 0 3-3V7a3 3 0 0 0-3-3h-1V3a1 1 0 0 0-2 0v1H8V3A1 1 0 0 0 7 2Zm13 7H4v9a1 1 0 0 0 1 1h14a1 1 0 0 0 1-1Z"/>
                            </svg>
                        </span>
                    </div>
                </div>

                
                <div class="space-y-1">
                    <label class="text-[11px] font-semibold tracking-wide text-slate-300 uppercase">
                        Password
                    </label>
                    <div class="relative">
                        <span class="pointer-events-none absolute inset-y-0 left-3 flex items-center text-emerald-400">
                            <svg class="h-4 w-4" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M12 2a5 5 0 0 0-5 5v3H6.5A2.5 2.5 0 0 0 4 12.5v6A2.5 2.5 0 0 0 6.5 21h11A2.5 2.5 0 0 0 20 18.5v-6A2.5 2.5 0 0 0 17.5 10H17V7a5 5 0 0 0-5-5Zm-3 8V7a3 3 0 1 1 6 0v3Z"/>
                            </svg>
                        </span>
                        <input type="password"
                               name="password"
                               placeholder="Password"
                               class="w-full rounded-2xl border-2 border-slate-700 bg-slate-950/70 text-sm text-slate-100
                                      pl-9 pr-4 py-2.5 placeholder-slate-500 outline-none
                                      focus:border-emerald-400 focus:ring-2 focus:ring-emerald-500/30 transition">
                    </div>
                </div>

                
                <button type="submit"
                        class="mt-2 w-full rounded-2xl bg-gradient-to-r from-emerald-500 to-cyan-500 py-2.5 text-sm font-semibold text-slate-950
                               shadow-[0_18px_45px_-20px_rgba(16,185,129,0.9)] hover:from-emerald-400 hover:to-cyan-400
                               active:scale-[0.98] transition-transform">
                    VIEW
                </button>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ecareba2/new.rkmotorsbike.top/resources/views/frontend/statement/form.blade.php ENDPATH**/ ?>