

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-3">

  <style>
    .card-edge{ border:1px solid #e6e8ef; border-radius:16px; background:#fff; box-shadow:0 4px 18px rgba(17,24,39,.06) }
    .table thead th{ font-weight:700; color:#0f172a; border-top:0 }
    .table-hover tbody tr:hover{ background:#fafafa }
    @media (max-width:768px){
      .table thead{ display:none }
      .table tbody tr{ display:block; margin:12px 0; border:1px solid #e5e7eb; border-radius:12px; padding:10px }
      .table td{ display:flex; justify-content:space-between; border:0; padding:.4rem .5rem }
      .table td::before{ content: attr(data-label); font-weight:600; color:#475569 }
    }
  </style>

  <div class="d-flex justify-content-between align-items-center mb-3">
    <h5 class="mb-0"><i class="fa-solid fa-gear me-2"></i> Settings</h5>
  </div>

  <?php if(session('success')): ?>
    <div class="alert alert-success card-edge p-2"><i class="fa-regular fa-circle-check me-1"></i><?php echo e(session('success')); ?></div>
  <?php endif; ?>

  
  <div class="card-edge p-3 mb-3">
    <form class="row g-2 align-items-end" action="<?php echo e(route('admin.settings.store')); ?>" method="POST">
      <?php echo csrf_field(); ?>
      <div class="col-md-3">
        <label class="form-label">Key *</label>
        <input name="key" class="form-control" placeholder="page.notice_bn" value="<?php echo e(old('key')); ?>" required>
      </div>
      <div class="col-md-7">
        <label class="form-label">Value</label>
        <input name="value" class="form-control" placeholder="আপনার বার্তা..." value="<?php echo e(old('value')); ?>">
      </div>
      <div class="col-md-2 d-grid">
        <button class="btn btn-primary"><i class="fa-solid fa-plus me-1"></i> Add</button>
      </div>
    </form>
    <?php $__errorArgs = ['key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="text-danger small mt-1"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
  </div>

  
  <form id="bulk-update-form" class="card-edge p-0" action="<?php echo e(route('admin.settings.update')); ?>" method="POST">
    <?php echo csrf_field(); ?>
    <?php echo method_field('PUT'); ?>

    <div class="table-responsive">
      <table class="table table-hover align-middle mb-0">
        <thead class="table-light">
          <tr>
            <th>#</th>
            <th>Key</th>
            <th>Value</th>
            <th class="text-end">Actions</th>
          </tr>
        </thead>
        <tbody>
          <?php $__empty_1 = true; $__currentLoopData = $settings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
          <tr>
            <td data-label="#" class="text-muted"><?php echo e($s->id); ?></td>
            <td data-label="Key" style="min-width:220px;">
              <input name="items[<?php echo e($s->id); ?>][key]" class="form-control" value="<?php echo e(old('items.'.$s->id.'.key', $s->key)); ?>">
            </td>
            <td data-label="Value">
              <input name="items[<?php echo e($s->id); ?>][value]" class="form-control" value="<?php echo e(old('items.'.$s->id.'.value', $s->value)); ?>">
            </td>
            <td data-label="Actions" class="text-end">
              
              <button
                type="submit"
                form="delete-form-<?php echo e($s->id); ?>"
                class="btn btn-danger btn-sm"
                onclick="return confirm('Delete this setting?')"
              >
                <i class="fa-regular fa-trash-can"></i> Delete
              </button>
            </td>
          </tr>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <tr><td colspan="4" class="text-center text-muted py-4"><i class="fa-regular fa-folder-open me-1"></i>No settings</td></tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>

    <div class="p-3 border-top d-flex justify-content-end">
      <button class="btn btn-success"><i class="fa-regular fa-circle-check me-1"></i> Save Changes</button>
    </div>
  </form>

  
  <?php $__currentLoopData = $settings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <form id="delete-form-<?php echo e($s->id); ?>" action="<?php echo e(route('admin.settings.destroy', $s->id)); ?>" method="POST" class="d-none">
      <?php echo csrf_field(); ?>
      <?php echo method_field('DELETE'); ?>
    </form>
  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ecareba2/new.rkmotorsbike.top/resources/views/backend/settings/index.blade.php ENDPATH**/ ?>