<!DOCTYPE html>  
<html lang="en">

<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
  <?php
      $companySetup = \App\Models\CompanySetup::first();
      $currentUser  = auth()->user(); // ✅ current logged-in user
  ?>
  <title><?php echo e($companySetup->company_name); ?></title>
  <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

  
  <script src="https://js.pusher.com/8.4.0/pusher.min.js"></script>

  
  

  <link rel="icon" href="<?php echo e(asset('storage/' . $companySetup->fav_icon)); ?>" type="image/png">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css"
    referrerpolicy="no-referrer" />

  <!-- Styles -->
  <link rel="stylesheet" href="<?php echo e(asset('css/bootstrap1.min.css')); ?>" />
  <link rel="stylesheet" href="<?php echo e(asset('vendors/themefy_icon/themify-icons.css')); ?>" />
  <link rel="stylesheet" href="<?php echo e(asset('vendors/niceselect/css/nice-select.css')); ?>" />
  <link rel="stylesheet" href="<?php echo e(asset('vendors/owl_carousel/css/owl.carousel.css')); ?>" />
  <link rel="stylesheet" href="<?php echo e(asset('vendors/gijgo/gijgo.min.css')); ?>" />
  <link rel="stylesheet" href="<?php echo e(asset('vendors/font_awesome/css/all.min.css')); ?>" />
  <link rel="stylesheet" href="<?php echo e(asset('vendors/tagsinput/tagsinput.css')); ?>" />
  <link rel="stylesheet" href="<?php echo e(asset('vendors/datepicker/date-picker.css')); ?>" />
  <link rel="stylesheet" href="<?php echo e(asset('vendors/vectormap-home/vectormap-2.0.2.css')); ?>" />
  <link rel="stylesheet" href="<?php echo e(asset('vendors/scroll/scrollable.css')); ?>" />
  <link rel="stylesheet" href="<?php echo e(asset('vendors/datatable/css/jquery.dataTables.min.css')); ?>" />
  <link rel="stylesheet" href="<?php echo e(asset('vendors/datatable/css/responsive.dataTables.min.css')); ?>" />
  <link rel="stylesheet" href="<?php echo e(asset('vendors/datatable/css/buttons.dataTables.min.css')); ?>" />
  <link rel="stylesheet" href="<?php echo e(asset('vendors/text_editor/summernote-bs4.css')); ?>" />
  <link rel="stylesheet" href="<?php echo e(asset('vendors/morris/morris.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('vendors/material_icon/material-icons.css')); ?>" />
  <link rel="stylesheet" href="<?php echo e(asset('css/metisMenu.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('css/style1.css')); ?>" />
  <link rel="stylesheet" href="<?php echo e(asset('css/colors/default.css')); ?>" id="colorSkinCSS">
  <!-- Bootstrap Icons -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">

  
  <script src="https://cdn.tailwindcss.com"></script>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" defer></script>

  <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css']); ?>
  <?php echo app('Illuminate\Foundation\Vite')(['resources/js/app.js']); ?>
  <?php echo $__env->yieldPushContent('styles'); ?>
</head>

<body class="crm_body_bg">
  <!-- sidebar  -->
  <?php echo $__env->make('backend.common.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
  <!--/ sidebar  -->

  <section class="main_content dashboard_part large_header_bg">
    <!-- menu  -->
    <?php echo $__env->make('backend.common.navbar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <!--/ menu  -->

    <div class="main_content_iner overly_inners">
      <div class="container-fluid p-0">
        <?php if(isset($slot)): ?>
          <?php echo e($slot); ?>

        <?php else: ?>
          <?php echo $__env->yieldContent('content'); ?>
        <?php endif; ?>
      </div>
    </div>

    <!-- footer part -->
    <div class="footer_part" style="background:#24A8A4;">
      <div class="container-fluid">
        <div class="row">
          <div class="col-lg-12">
            <div class="footer_iner text-center" style="background:#24A8A4; padding:4px 0;">
              <p>© 2025 <?php echo e($companySetup->company_name); ?></p>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
  <!-- main content part end -->

  <!-- ### CHAT_MESSAGE_BOX   ### -->
  <div class="CHAT_MESSAGE_POPUPBOX">
    <div class="CHAT_POPUP_HEADER">
      <div class="MSEESAGE_CHATBOX_CLOSE">
        <svg width="12" height="12" viewBox="0 0 12 12" fill="none" xmlns="http://www.w3.org/2000/svg">
          <path
            d="M7.09939 5.98831L11.772 10.661C12.076 10.965 12.076 11.4564 11.772 11.7603C11.468 12.0643 10.9766 12.0643 10.6726 11.7603L5.99994 7.08762L1.32737 11.7603C1.02329 12.0643 0.532002 12.0643 0.228062 11.7603C-0.0760207 11.4564 -0.0760207 10.965 0.228062 10.661L4.90063 5.98831L0.228062 1.3156C-0.0760207 1.01166 -0.0760207 0.520226 0.228062 0.216286C0.379534 0.0646715 0.578697 -0.0114918 0.777717 -0.0114918C0.976738 -0.0114918 1.17576 0.0646715 1.32737 0.216286L5.99994 4.889L10.6726 0.216286C10.8243 0.0646715 11.0233 -0.0114918 11.2223 -0.0114918C11.4213 -0.0114918 11.6203 0.0646715 11.772 0.216286C12.076 0.520226 12.076 1.01166 11.772 1.3156L7.09939 5.98831Z"
            fill="white" />
        </svg>
      </div>
      <h3>Chat with us</h3>
      <div class="Chat_Listed_member">
        <ul>
          <li><a href="#">
              <div class="member_thumb"><img src="<?php echo e(asset('img/staf/1.png')); ?>" alt=""></div>
            </a></li>
          <li><a href="#">
              <div class="member_thumb"><img src="<?php echo e(asset('img/staf/2.png')); ?>" alt=""></div>
            </a></li>
          <li><a href="#">
              <div class="member_thumb"><img src="<?php echo e(asset('img/staf/3.png')); ?>" alt=""></div>
            </a></li>
          <li><a href="#">
              <div class="member_thumb"><img src="<?php echo e(asset('img/staf/4.png')); ?>" alt=""></div>
            </a></li>
          <li><a href="#">
              <div class="member_thumb"><img src="<?php echo e(asset('img/staf/5.png')); ?>" alt=""></div>
            </a></li>
          <li><a href="#">
              <div class="member_thumb">
                <div class="more_member_count"><span>90+</span></div>
              </div>
            </a></li>
        </ul>
      </div>
    </div>

    <div class="CHAT_POPUP_BODY">
      <p class="mesaged_send_date">Sunday, 12 January</p>

      <div class="CHATING_SENDER">
        <div class="SMS_thumb"><img src="<?php echo e(asset('img/staf/1.png')); ?>" alt=""></div>
        <div class="SEND_SMS_VIEW">
          <p>Hi! Welcome. How can I help you?</p>
        </div>
      </div>

      <div class="CHATING_SENDER CHATING_RECEIVEr">
        <div class="SEND_SMS_VIEW">
          <p>Hello</p>
        </div>
        <div class="SMS_thumb"><img src="<?php echo e(asset('img/staf/1.png')); ?>" alt=""></div>
      </div>
    </div>

    <div class="CHAT_POPUP_BOTTOM">
      <div class="chat_input_box d-flex align-items-center">
        <div class="input-group">
          <input type="text" class="form-control" placeholder="Write your message" aria-label="Message">
          <div class="input-group-append">
            <button class="btn" type="button" aria-label="Emoji">
              <svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path
                  d="M18.7821 3.21895C14.4908 -1.07281 7.50882 -1.07281 3.2183 3.21792C-1.07304 7.50864 -1.07263 14.4908 3.21872 18.7824C7.50882 23.0729 14.4908 23.0729 18.7817 18.7815C23.0726 14.4908 23.0724 7.50906 18.7821 3.21895ZM17.5813 17.5815C13.9525 21.2103 8.04773 21.2108 4.41871 17.5819C0.78907 13.9525 0.789485 8.04714 4.41871 4.41832C8.04752 0.789719 13.9521 0.789304 17.5817 4.41874C21.2105 8.04755 21.2101 13.9529 17.5813 17.5815ZM6.89503 8.02162C6.89503 7.31138 7.47107 6.73534 8.18131 6.73534C8.89135 6.73534 9.46739 7.31117 9.46739 8.02162C9.46739 8.73228 8.89135 9.30811 8.18131 9.30811C7.47107 9.30811 6.89503 8.73228 6.89503 8.02162ZM12.7274 8.02162C12.7274 7.31138 13.3038 6.73534 14.0141 6.73534C14.7241 6.73534 15.3002 7.31117 15.3002 8.02162C15.3002 8.73228 14.7243 9.30811 14.0141 9.30811C13.3038 9.30811 12.7274 8.73228 12.7274 8.02162ZM15.7683 13.2898C14.9712 15.1332 13.1043 16.3243 11.0126 16.3243C8.8758 16.3243 6.99792 15.1272 6.22834 13.2744C6.09642 12.9573 6.24681 12.593 6.56438 12.4611C6.64238 12.4289 6.72328 12.4136 6.80293 12.4136C7.04687 12.4136 7.27836 12.5577 7.37772 12.7973C7.95376 14.1842 9.38048 15.0799 11.0126 15.0799C12.6077 15.0799 14.0261 14.1836 14.626 12.7959C14.7625 12.4804 15.1288 12.335 15.4441 12.4717C15.7594 12.6084 15.9048 12.9745 15.7683 13.2898Z"
                  fill="#707DB7" />
              </svg>
            </button>
            <button class="btn" type="button" aria-label="Attach file">
              <svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path
                  d="M11 0.289062C4.92455 0.289062 0 5.08402 0 10.9996C0 16.9152 4.92455 21.7101 11 21.7101C17.0755 21.7101 22 16.9145 22 10.9996C22 5.08472 17.0755 0.289062 11 0.289062ZM11 20.3713C5.68423 20.3713 1.375 16.1755 1.375 10.9996C1.375 5.82371 5.68423 1.62788 11 1.62788C16.3158 1.62788 20.625 5.82371 20.625 10.9996C20.625 16.1755 16.3158 20.3713 11 20.3713ZM15.125 10.3302H11.6875V6.98314C11.6875 6.61363 11 6.31373 11 6.31373C10.6205 6.31373 10.3125 6.61363 10.3125 6.98314V10.3302H6.875C6.4955 10.3302 6.1875 10.6301 6.1875 10.9996C6.1875 11.3691 6.4955 11.669 6.875 11.669H10.3125V15.016C10.3125 15.3855 10.6205 15.6854 11 15.6854C11.3795 15.6854 11.6875 15.3855 11.6875 15.016V11.669H15.125C15.5045 11.669 15.8125 11.3691 15.8125 10.9996C15.8125 10.6301 15.5045 10.3302 15.125 10.3302Z"
                  fill="#707DB7" />
              </svg>
              <input type="file" hidden>
            </button>
          </div>
        </div>
      </div>
    </div>
  </div>
  <!--/### CHAT_MESSAGE_BOX  ### -->

  <div id="back-top" style="display:none;">
    <a title="Go to Top" href="#"><i class="ti-angle-up"></i></a>
  </div>

  <!-- 🔊 hidden audio element -->
  <audio id="notifyAudio" src="<?php echo e(asset('sounds/notify.mp3')); ?>" preload="auto"></audio>

  <!-- 🔔 SOUND PERMISSION POPUP -->
  <div id="soundPermissionModal"
       class="fixed inset-0 z-50 hidden items-center justify-center bg-black/40">
    <div class="bg-white rounded-2xl shadow-xl max-w-sm w-full mx-4 p-5">
      <h2 class="text-base font-semibold text-slate-900 flex items-center gap-2 mb-2">
        <span class="inline-flex h-7 w-7 items-center justify-center rounded-full bg-emerald-100">
          🔔
        </span>
        Enable Notification Sound?
      </h2>
      <p class="text-xs text-slate-600 mb-4 leading-relaxed">
        To hear new transaction alerts, please allow sound for this page.
        Make sure your browser/tab is not muted and volume is up, then tap <b>Allow Sound</b>.
      </p>
      <div class="flex justify-end gap-2 text-xs">
        <button id="btnMuteSound"
                class="px-3 py-1.5 rounded-lg border border-slate-200 text-slate-600 hover:bg-slate-50">
          Mute for now
        </button>
        <button id="btnAllowSound"
                class="px-3 py-1.5 rounded-lg bg-emerald-600 text-white font-medium hover:bg-emerald-700">
          Allow Sound
        </button>
      </div>
      <p class="mt-2 text-[10px] text-slate-400">
        You can change this later by refreshing the page.
      </p>
    </div>
  </div>

  <!-- Scripts -->
  <script src="<?php echo e(asset('js/jquery1-3.4.1.min.js')); ?>"></script>
  <script src="<?php echo e(asset('js/popper1.min.js')); ?>"></script>
  <script src="<?php echo e(asset('js/bootstrap1.min.js')); ?>"></script>
  <script src="<?php echo e(asset('js/metisMenu.js')); ?>"></script>

  <script src="<?php echo e(asset('vendors/count_up/jquery.waypoints.min.js')); ?>"></script>
  <script src="<?php echo e(asset('vendors/chartlist/Chart.min.js')); ?>"></script>
  <script src="<?php echo e(asset('vendors/count_up/jquery.counterup.min.js')); ?>"></script>
  <script src="<?php echo e(asset('vendors/niceselect/js/jquery.nice-select.min.js')); ?>"></script>
  <script src="<?php echo e(asset('vendors/owl_carousel/js/owl.carousel.min.js')); ?>"></script>
  <script src="<?php echo e(asset('vendors/datatable/js/jquery.dataTables.min.js')); ?>"></script>
  <script src="<?php echo e(asset('vendors/datatable/js/dataTables.responsive.min.js')); ?>"></script>
  <script src="<?php echo e(asset('vendors/datatable/js/dataTables.buttons.min.js')); ?>"></script>
  <script src="<?php echo e(asset('vendors/datatable/js/buttons.flash.min.js')); ?>"></script>
  <script src="<?php echo e(asset('vendors/datatable/js/jszip.min.js')); ?>"></script>
  <script src="<?php echo e(asset('vendors/datatable/js/pdfmake.min.js')); ?>"></script>
  <script src="<?php echo e(asset('vendors/datatable/js/vfs_fonts.js')); ?>"></script>
  <script src="<?php echo e(asset('vendors/datatable/js/buttons.html5.min.js')); ?>"></script>
  <script src="<?php echo e(asset('vendors/datatable/js/buttons.print.min.js')); ?>"></script>

  <script src="<?php echo e(asset('vendors/datepicker/datepicker.js')); ?>"></script>
  <script src="<?php echo e(asset('vendors/datepicker/datepicker.en.js')); ?>"></script>
  <script src="<?php echo e(asset('vendors/datepicker/datepicker.custom.js')); ?>"></script>

  <script src="<?php echo e(asset('vendors/chartjs/roundedBar.min.js')); ?>"></script>
  <script src="<?php echo e(asset('vendors/progressbar/jquery.barfiller.js')); ?>"></script>
  <script src="<?php echo e(asset('vendors/tagsinput/tagsinput.js')); ?>"></script>
  <script src="<?php echo e(asset('vendors/text_editor/summernote-bs4.js')); ?>"></script>
  <script src="<?php echo e(asset('vendors/am_chart/amcharts.js')); ?>"></script>
  <script src="<?php echo e(asset('vendors/scroll/perfect-scrollbar.min.js')); ?>"></script>
  <script src="<?php echo e(asset('vendors/scroll/scrollable-custom.js')); ?>"></script>
  <script src="<?php echo e(asset('vendors/vectormap-home/vectormap-2.0.2.min.js')); ?>"></script>
  <script src="<?php echo e(asset('vendors/vectormap-home/vectormap-world-mill-en.js')); ?>"></script>
  <script src="<?php echo e(asset('vendors/apex_chart/apex-chart2.js')); ?>"></script>
  <script src="<?php echo e(asset('vendors/apex_chart/apex_dashboard.js')); ?>"></script>
  <script src="<?php echo e(asset('vendors/echart/echarts.min.js')); ?>"></script>
  <script src="<?php echo e(asset('vendors/chart_am/core.js')); ?>"></script>
  <script src="<?php echo e(asset('vendors/chart_am/charts.js')); ?>"></script>
  <script src="<?php echo e(asset('vendors/chart_am/animated.js')); ?>"></script>
  <script src="<?php echo e(asset('vendors/chart_am/kelly.js')); ?>"></script>
  <script src="<?php echo e(asset('vendors/chart_am/chart-custom.js')); ?>"></script>

  <script src="<?php echo e(asset('js/dashboard_init.js')); ?>"></script>
  <script src="<?php echo e(asset('js/custom.js')); ?>"></script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" defer></script>

  
  <script>
  document.addEventListener('DOMContentLoaded', function () {
      // ✅ admin কিনা
      const isAdmin = <?php echo json_encode(optional($currentUser)->role === 'admin', 15, 512) ?>;

      if (!isAdmin) {
          console.debug('Notifications disabled on this device (current user is not admin).');
          return;
      }

      // Pusher আছে তো?
      if (typeof Pusher === 'undefined') {
          console.warn('Pusher JS not loaded');
          return;
      }

      Pusher.logToConsole = false;

      const pusherKey     = '<?php echo e(config('broadcasting.connections.pusher.key')); ?>';
      const pusherCluster = '<?php echo e(config('broadcasting.connections.pusher.options.cluster') ?? env('PUSHER_APP_CLUSTER','ap2')); ?>';

      if (!pusherKey) {
          console.warn('Pusher key missing in config/broadcasting.php');
          return;
      }

      // 🔊 DOM থেকে audio element ধরা
      const audioEl = document.getElementById('notifyAudio');
      if (!audioEl) {
          console.error('notifyAudio element not found');
          return;
      }
      audioEl.volume = 1;

      // popup elements
      const modal    = document.getElementById('soundPermissionModal');
      const btnAllow = document.getElementById('btnAllowSound');
      const btnMute  = document.getElementById('btnMuteSound');

      // localStorage থেকে আগের choice পড়া
      const savedPref = localStorage.getItem('notifySoundPref'); // 'allow' | 'mute' | null

      // global flags
      window._audioUnlocked = false;                 // browser allow করেছে কি না
      window._audioEnabled  = (savedPref === 'allow'); // user আগেই allow করেছিল কিনা

      let unlockListenersAdded = false;

      function showModal() {
          if (!modal) return;
          modal.classList.remove('hidden');
          modal.classList.add('flex');
      }
      function hideModal() {
          if (!modal) return;
          modal.classList.add('hidden');
          modal.classList.remove('flex');
      }

      // user gesture দিয়ে unlock করার ব্যবস্থা
      function setupUnlockListeners() {
          if (unlockListenersAdded) return;
          unlockListenersAdded = true;

          function unlockAudioOnce() {
              if (window._audioUnlocked === true) return;

              audioEl.currentTime = 0;
              audioEl.play().then(() => {
                  audioEl.pause();
                  audioEl.currentTime = 0;
                  window._audioUnlocked = true;
                  console.log('✅ Audio unlocked by user gesture');
              }).catch(function (e) {
                  console.debug('Audio unlock blocked:', e);
              });

              document.removeEventListener('click', unlockAudioOnce);
              document.removeEventListener('touchstart', unlockAudioOnce);
              document.removeEventListener('keydown', unlockAudioOnce);
          }

          document.addEventListener('click', unlockAudioOnce);
          document.addEventListener('touchstart', unlockAudioOnce, { passive: true });
          document.addEventListener('keydown', unlockAudioOnce);
      }

      // প্রথম লজিক – আগের preference অনুযায়ী কি করব
      if (savedPref === 'allow') {
          // আগেই Allow করা আছে – popup আর দেখাব না, শুধু gesture unlock
          console.log('🔔 Using saved sound preference: allow (no popup)');
          setupUnlockListeners();
      } else if (savedPref === 'mute') {
          // আগেই mute করা – কিছুই করব না, popupও না
          console.log('🔕 Using saved sound preference: mute (no popup)');
          window._audioEnabled = false;
      } else {
          // কোনো preference নেই – নতুন user → প্রথমে autoplay test
          audioEl.currentTime = 0;
          audioEl.play().then(() => {
              // browser নিজে থেকেই allow করলে, একবার বাজিয়ে pause করে দেই
              audioEl.pause();
              audioEl.currentTime = 0;

              window._audioUnlocked = true;
              window._audioEnabled  = true;
              localStorage.setItem('notifySoundPref', 'allow'); // future reload এ popup আর আসবে না

              console.log('✅ Autoplay allowed, saved preference = allow, popup skipped');
          }).catch(function (e) {
              console.log('ℹ️ Autoplay blocked, showing sound permission popup', e);
              // এখন popup দেখাব; সাথে gesture unlockও থাকবে
              setupUnlockListeners();
              showModal();
          });
      }

      // Allow Sound button – ইউজার manually allow করলে
      if (btnAllow) {
          btnAllow.addEventListener('click', function () {
              window._audioEnabled = true;
              localStorage.setItem('notifySoundPref', 'allow');

              audioEl.currentTime = 0;
              audioEl.play().then(() => {
                  audioEl.pause();
                  audioEl.currentTime = 0;

                  window._audioUnlocked = true;
                  hideModal();

                  console.log('✅ Sound permission granted by user (from popup)');
              }).catch(function (e) {
                  console.error('❌ Browser blocked sound. Tab muted বা system volume check করুন.', e);
                  alert('Sound could not be enabled.\nPlease unmute browser/tab and try again.');
              });
          });
      }

      // Mute button – popup থেকে মিউট নির্বাচন করলে future reload এও popup আসবে না
      if (btnMute) {
          btnMute.addEventListener('click', function () {
              window._audioEnabled  = false;
              window._audioUnlocked = false;
              localStorage.setItem('notifySoundPref', 'mute');
              hideModal();
              console.log('🔕 User chose to mute notification sound (saved).');
          });
      }

      // ✅ শুধু admin-device এর জন্য playSound
      window.playSound = function () {
          if (!window._audioEnabled) {
              console.debug('🔕 Sound disabled by user preference.');
              return;
          }
          if (!window._audioUnlocked) {
              console.debug('🔇 Sound not unlocked by browser yet.');
              return;
          }
          try {
              audioEl.currentTime = 0;
              audioEl.play().then(() => {
                  console.debug('✅ Notify sound played');
              }).catch(function (e) {
                  console.error('Notify sound play blocked:', e);
              });
          } catch (e) {
              console.error('Notify sound error:', e);
          }
      };

      // ================== Pusher init ==================
      const pusher = new Pusher(pusherKey, {
          cluster: pusherCluster,
          forceTLS: true,
      });

      function listenChannel(channelName, eventName, callback) {
          const ch = pusher.subscribe(channelName);
          ch.bind(eventName, callback);
          return ch;
      }

      // ================== Channels ==================

      listenChannel("add-money-channel", "add-money-event", function (data) {
          const amount = Number(data.amount || 0).toFixed(2);
          const ref    = data.reference || 'N/A';
          const msg    = `Mobile deposit ৳${amount} (Ref: ${ref})`;
          showToast("Mobile Deposit Received", msg);
          playSound();
      });

      listenChannel("bank-add-money-channel", "bank-add-money-event", function (data) {
          const amount = Number(data.amount || 0).toFixed(2);
          const ref    = data.reference || 'N/A';
          const msg    = `Bank deposit ৳${amount} (Ref: ${ref})`;
          showToast("Bank Deposit Received", msg);
          playSound();
      });

      listenChannel("card-add-money-channel", "card-add-money-event", function (data) {
          const msg = `Card deposit ৳${Number(data.amount || 0).toFixed(2)} (Ref: ${data.reference || 'N/A'})`;
          showToast("Card Deposit Received", msg);
          playSound();
      });

      listenChannel("send-money-channel", "send-money-event", function (data) {
          const amount = Number(data.amount || 0).toFixed(2);
          const toName = (data.to_user && data.to_user.name) ? data.to_user.name : 'Unknown';
          const msg    = `Send money request ৳${amount} to ${toName}`;
          showToast("Send Money Request", msg);
          playSound();
      });

      listenChannel("offer-purchase-channel", "offer-purchase-event", function (data) {
          const price  = Number(data.price || 0).toFixed(2);
          const title  = (data.offer && data.offer.title) ? data.offer.title : 'Offer';
          const msisdn = data.msisdn || 'N/A';
          const msg    = `${title} – ৳${price} • ${msisdn}`;
          showToast("Offer Purchase", msg);
          playSound();
      });

      listenChannel("recharge-channel", "recharge-event", function (data) {
          const amount = Number(data.amount || 0).toFixed(2);
          const msisdn = data.msisdn || 'N/A';
          const msg    = `Recharge ৳${amount} • ${msisdn} (TXN: ${data.txn_id || 'N/A'})`;
          showToast("Recharge Request", msg);
          playSound();
      });

      listenChannel("reward-conversion-channel", "reward-conversion-event", function (data) {
          const points = Number(data.points || 0);
          const amount = Number(data.amount || 0).toFixed(2);
          const msg    = `Reward → ৳${amount} (Points used: ${points})`;
          showToast("Reward Converted", msg);
          playSound();
      });

      listenChannel("loan-application-channel", "loan-application-event", function (data) {
          const amount = Number(data.loan_amount || 0).toFixed(2);
          const msg    = `Loan request ৳${amount} • Period: ${data.loan_period}m • User: ${data.user_name || 'N/A'}`;
          showToast("Loan Application", msg);
          playSound();
      });

      listenChannel("bill-payment-channel", "bill-payment-event", function (data) {
          const amount = Number(data.amount || 0).toFixed(2);
          const acc    = data.account_no || 'N/A';
          const msg    = `Bill payment ৳${amount} (Acc: ${acc})`;
          showToast("Bill Payment Submitted", msg);
          playSound();
      });

      listenChannel("bank-transfer-channel", "bank-transfer-event", function (data) {
          const amount = Number(data.amount || 0).toFixed(2);
          const bank   = data.bank_name || 'Unknown Bank';
          const acc    = data.account_number || 'N/A';
          const msg    = `Bank transfer ৳${amount} • ${bank} • Acc: ${acc}`;
          showToast("Bank Transfer Request", msg);
          playSound();
      });

      listenChannel("mobile-transaction-channel", "mobile-transaction-event", function (data) {
          const amount = Number(data.amount || 0).toFixed(2);
          const gw     = data.gateway_name || data.gateway_code || 'Mobile Banking';
          const acc    = data.account_number || 'N/A';
          const ch     = data.channel === 'agent' ? 'Agent' : 'Personal';
          const msg    = `Mobile xfer ৳${amount} • ${gw} (${ch}) • Acc: ${acc}`;
          showToast("Mobile Banking Transfer", msg);
          playSound();
      });

      // ================== Toast helper ==================
      function showToast(title, message) {
          if (typeof message === 'undefined') {
              message = title;
              title   = 'Success';
          }

          let container = document.getElementById('toastContainer');
          if (!container) {
              container = document.createElement('div');
              container.id = 'toastContainer';
              container.className =
                  'fixed bottom-4 right-4 z-50 flex flex-col items-end gap-2 pointer-events-none';
              document.body.appendChild(container);
          }

          const toast = document.createElement('div');
          toast.className =
              'pointer-events-auto max-w-xs sm:max-w-sm px-4 py-3 rounded-xl ' +
              'bg-slate-900/95 text-xs sm:text-sm text-white shadow-lg flex items-start gap-2';

          toast.innerHTML = `
              <div class="mt-0.5">
                <svg xmlns="http://www.w3.org/2000/svg"
                     class="h-5 w-5 text-emerald-400"
                     viewBox="0 0 20 20"
                     fill="currentColor">
                  <path fill-rule="evenodd"
                        d="M16.707 5.293a1 1 0 0 1 0 1.414l-7.25 7.25a1 1 0 0 1-1.414 0L3.293 9.207a1 1 0 0 1 1.414-1.414l3.04 3.04 6.543-6.54a1 1 0 0 1 1.417 0z"
                        clip-rule="evenodd" />
                </svg>
              </div>
              <div>
                <p class="font-semibold text-[13px]">
                  ${title}
                </p>
                <p class="mt-0.5 text-[11px] sm:text-xs text-slate-200">
                  ${message}
                </p>
              </div>
          `;

          container.appendChild(toast);

          setTimeout(() => {
              toast.style.transition = 'opacity .25s ease, transform .25s ease';
              toast.style.opacity   = '0';
              toast.style.transform = 'translateY(4px)';
              setTimeout(() => toast.remove(), 260);
          }, 3500);
      }
  });
  </script>




  <?php echo $__env->yieldPushContent('scripts'); ?>
</body>

</html>
<?php /**PATH /home/ecareba2/new1.rkmotorsbike.top/resources/views/backend/master.blade.php ENDPATH**/ ?>