

<?php $__env->startSection('title', 'Company Setups'); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-4">
    <?php if(session('status')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?php echo e(session('status')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <div class="d-flex align-items-center justify-content-between mb-3">
        <h1 class="h4 mb-0">Company Setups</h1>
        <a href="<?php echo e(route('company-setups.create')); ?>" class="btn btn-primary">
            <i class="bi bi-plus-lg me-1"></i> Create
        </a>
    </div>

    <div class="card shadow-sm">
        <div class="table-responsive">
            <table class="table align-middle mb-0">
                <thead class="table-light">
                    <tr>
                        <th>#</th>
                        <th>Name</th>
                        <th>About</th>
                        <th>Phone</th>
                        <th>WhatsApp</th>
                        <th>Email</th>
                        <th>Telegram</th>
                        <th>Facebook</th>
                        <th>Address</th>
                        <th>Favicon</th>
                        <th>Logo</th>
                        <th>Created</th>
                        <th>Updated</th>
                        <th class="text-end">Actions</th>
                    </tr>
                </thead>
                <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $companySetups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $setup): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><?php echo e($setup->id); ?></td>
                        <td><?php echo e($setup->company_name ?? '—'); ?></td>

                        
                        <td style="max-width: 260px;">
                            <span class="d-inline-block text-truncate" style="max-width: 260px;"
                                  title="<?php echo e($setup->about_company); ?>">
                                <?php echo e(\Illuminate\Support\Str::limit($setup->about_company, 80) ?: '—'); ?>

                            </span>
                        </td>

                        <td><?php echo e($setup->phone_number ?? '—'); ?></td>
                        <td><?php echo e($setup->whatsapp_number ?? '—'); ?></td>
                        <td><?php echo e($setup->email ?? '—'); ?></td>

                        
                        <td>
                            <?php if($setup->telegram_link): ?>
                                <a href="<?php echo e($setup->telegram_link); ?>" target="_blank" rel="noopener" class="link-primary text-decoration-none">
                                    <?php echo e(\Illuminate\Support\Str::limit($setup->telegram_link, 24)); ?>

                                </a>
                            <?php else: ?>
                                —
                            <?php endif; ?>
                        </td>

                        
                        <td>
                            <?php if($setup->facebook_link): ?>
                                <a href="<?php echo e($setup->facebook_link); ?>" target="_blank" rel="noopener" class="link-primary text-decoration-none">
                                    <?php echo e(\Illuminate\Support\Str::limit($setup->facebook_link, 24)); ?>

                                </a>
                            <?php else: ?>
                                —
                            <?php endif; ?>
                        </td>

                        
                        <td style="max-width: 220px;">
                            <span class="d-inline-block text-truncate" style="max-width: 220px;"
                                  title="<?php echo e($setup->address); ?>">
                                <?php echo e(\Illuminate\Support\Str::limit($setup->address, 50) ?: '—'); ?>

                            </span>
                        </td>

                        
                        <td>
                            <?php if($setup->fav_icon): ?>
                                <img src="<?php echo e(asset('storage/'.$setup->fav_icon)); ?>" alt="favicon"
                                     class="img-thumbnail" style="height:28px; width:28px; object-fit:cover">
                            <?php else: ?>
                                —
                            <?php endif; ?>
                        </td>

                        
                        <td>
                            <?php if($setup->logo): ?>
                                <img src="<?php echo e(asset('storage/'.$setup->logo)); ?>" alt="logo"
                                     class="img-fluid border rounded" style="height:32px; object-fit:contain">
                            <?php else: ?>
                                —
                            <?php endif; ?>
                        </td>

                        <td><span class="text-muted"><?php echo e(optional($setup->created_at)->format('d M Y, h:i A')); ?></span></td>
                        <td><span class="text-muted"><?php echo e(optional($setup->updated_at)->format('d M Y, h:i A')); ?></span></td>

                        <td class="text-end">
                            <div class="btn-group">
                                <a href="<?php echo e(route('company-setups.edit', $setup)); ?>" class="btn btn-sm btn-outline-primary">
                                    Edit
                                </a>

                                
                                <form action="<?php echo e(route('company-setups.destroy', $setup->id)); ?>" method="POST" class="d-inline"
                                      onsubmit="return confirm('Delete <?php echo e($setup->company_name ?? 'this company'); ?>?');">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-sm btn-outline-danger">Delete</button>
                                </form>

                                
                            </div>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="14" class="text-center text-muted py-5">No records found.</td>
                    </tr>
                <?php endif; ?>
                </tbody>
            </table>
        </div>

        <?php if($companySetups->hasPages()): ?>
        <div class="card-footer">
            <?php echo e($companySetups->links()); ?>

        </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ecareba2/new1.rkmotorsbike.top/resources/views/admin/company_setups/index.blade.php ENDPATH**/ ?>