

<?php $__env->startSection('title', 'Notifications'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row mb-3">
        <div class="col-md-6">
            <h4>Notifications</h4>
        </div>
        <div class="col-md-6 text-end">
            <span class="badge bg-primary">Unread: <?php echo e($unreadCount); ?></span>
        </div>
    </div>

    <div class="card">
        <div class="card-body p-0">
            <?php if($notifications->count()): ?>
                <div class="table-responsive">
                    <table class="table table-striped mb-0">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Title</th>
                                <th>Message</th>
                                <th>Amount</th>
                                <th>Type</th>
                                <th>Status</th>
                                <th>Created At</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class="<?php echo e($notification->read_at ? '' : 'table-warning'); ?>">
                                    <td><?php echo e($notification->id); ?></td>
                                    <td><?php echo e($notification->title ?? 'Notification'); ?></td>
                                    <td><?php echo e($notification->message ?? 'N/A'); ?></td>
                                    <td>
                                        <?php if(!is_null($notification->amount)): ?>
                                            <?php echo e(number_format($notification->amount, 2)); ?> TK
                                        <?php else: ?>
                                            -
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($notification->type ?? '-'); ?></td>
                                    <td>
                                        <?php if(is_null($notification->read_at)): ?>
                                            <span class="badge bg-warning text-dark">Unread</span>
                                        <?php else: ?>
                                            <span class="badge bg-success">Read</span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($notification->created_at->format('d M Y, h:i A')); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>

                <div class="p-3">
                    <?php echo e($notifications->links()); ?>

                </div>
            <?php else: ?>
                <div class="p-4 text-center text-muted">
                    No notifications found.
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\new-development-re-banking\re_banking_1\resources\views/admin/notifications/index.blade.php ENDPATH**/ ?>