
<?php $__env->startSection('title','পে-বিল'); ?>

<?php $__env->startPush('styles'); ?>
    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@400;500;600;700&family=Poppins:wght@400;500;600&display=swap" rel="stylesheet">

    <style>
        body {
            font-family: "Hind Siliguri", system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
        }

        @keyframes blobFloat {
            0%   { transform: translate3d(-10%, -10%, 0) scale(1); }
            50%  { transform: translate3d(15%, 10%, 0) scale(1.08); }
            100% { transform: translate3d(40%, -5%, 0) scale(1); }
        }

        @keyframes blobFloat2 {
            0%   { transform: translate3d(40%, 20%, 0) scale(1); }
            50%  { transform: translate3d(5%, 0, 0) scale(1.04); }
            100% { transform: translate3d(-20%, 10, 0) scale(1); }
        }

        .biller-avatar {
            @apply flex items-center justify-center rounded-2xl text-sm font-semibold;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-gradient-to-b from-slate-950 via-slate-900 to-slate-950 flex justify-center items-start px-3 sm:px-4 py-8 relative overflow-hidden">

    
    <svg class="pointer-events-none absolute -top-32 -left-32 w-80 h-80 text-emerald-500/20"
         viewBox="0 0 200 200" xmlns="http://www.w3.org/2000/svg"
         style="animation: blobFloat 18s ease-in-out infinite alternate;">
        <path fill="currentColor"
              d="M45.1,-62C58.8,-54.8,69.1,-39.4,73.4,-22.5C77.7,-5.7,75.9,12.7,67.4,26.8C58.8,40.9,43.4,50.7,27.2,58.2C11,65.7,-6,70.9,-20.4,66.3C-34.7,61.6,-46.4,47.1,-55.3,31.5C-64.3,15.9,-70.4,-0.7,-68.1,-16.7C-65.8,-32.7,-55.1,-48.1,-41.2,-55.6C-27.3,-63.1,-10.1,-62.6,5.7,-69C21.5,-75.3,43,-88.4,45.1,-62Z"/>
    </svg>

    <svg class="pointer-events-none absolute bottom-0 -right-24 w-72 h-72 text-cyan-400/10"
         viewBox="0 0 200 200" xmlns="http://www.w3.org/2000/svg"
         style="animation: blobFloat2 22s ease-in-out infinite alternate;">
        <path fill="currentColor"
              d="M35.8,-54.7C46.3,-47.4,54,-38,60.9,-27.1C67.7,-16.2,73.7,-4.1,71.9,6.8C70.1,17.7,60.5,27.3,50.4,36.6C40.4,46,29.9,55.3,17.3,60.4C4.6,65.6,-10.1,66.6,-24.4,62.4C-38.7,58.3,-52.6,49.1,-59.8,36.3C-66.9,23.4,-67.3,7,-64.6,-8.3C-61.9,-23.6,-56.1,-37.9,-45.7,-45.9C-35.2,-53.9,-20.1,-55.7,-5.2,-49.9C9.7,-44,19.3,-30.5,35.8,-54.7Z"/>
    </svg>

    <main class="mx-auto w-full max-w-[420px] relative z-10">

        
        <div class="mb-4 flex items-center justify-between text-xs text-slate-300">
            <button type="button"
                    onclick="window.history.back()"
                    class="inline-flex items-center gap-1 text-slate-300 hover:text-emerald-400 transition">
                <svg class="h-4 w-4" viewBox="0 0 24 24" fill="currentColor">
                    <path d="M15.75 4.75 9.5 11l6.25 6.25-1.5 1.5L6.5 11l7.75-7.75 1.5 1.5Z"/>
                </svg>
                Back
            </button>
            <span class="tracking-[0.18em] uppercase text-emerald-400 font-semibold text-[11px]">
                Pay Bill
            </span>
        </div>

        
        <div class="rounded-3xl bg-slate-900/80 border border-emerald-500/25 shadow-[0_25px_70px_-35px_rgba(16,185,129,0.7)] backdrop-blur-sm p-5 sm:p-6">

            
            <div class="text-center mb-4">
                <h2 class="text-lg sm:text-xl font-extrabold text-slate-50">বিল পেমেন্ট সার্ভিস</h2>
                <div class="mx-auto mt-2 h-1.5 w-36 rounded-full bg-gradient-to-r from-emerald-500 via-cyan-500 to-teal-500 shadow-[0_8px_24px_-10px_rgba(45,212,191,.7)]"></div>
                <p class="mt-2 text-[11px] text-slate-400">
                    বিদ্যুৎ, গ্যাস, পানি, ইন্টারনেট সহ সব ধরনের বিল এক জায়গায় পেমেন্ট করুন।
                </p>
            </div>

            
            <form method="get" class="mt-2">
                <div class="relative">
                    <span class="pointer-events-none absolute left-3 top-1/2 -translate-y-1/2 text-emerald-400">
                        <svg class="h-4 w-4" viewBox="0 0 24 24" fill="none">
                            <circle cx="11" cy="11" r="6" stroke="currentColor" stroke-width="1.6"/>
                            <path d="M16 16l3.5 3.5" stroke="currentColor" stroke-width="1.6" stroke-linecap="round"/>
                        </svg>
                    </span>
                    <input
                      name="q"
                      value="<?php echo e($q); ?>"
                      placeholder="বিলার খুঁজুন…"
                      class="w-full rounded-2xl border-2 border-slate-700 bg-slate-950/70 pl-9 pr-20 py-2.5 text-sm text-slate-100 outline-none transition
                             placeholder-slate-500 focus:border-emerald-400 focus:ring-2 focus:ring-emerald-500/30">
                    <?php if($q): ?>
                        <button type="button"
                                onclick="location.href='<?php echo e(route('paybills.index')); ?>'"
                                class="absolute right-2 top-1/2 -translate-y-1/2 rounded-xl bg-slate-800 px-2 py-1 text-[11px] text-slate-200 hover:bg-slate-700">
                            ক্লিয়ার
                        </button>
                    <?php endif; ?>
                </div>
                <?php if($q): ?>
                    <div class="mt-2 text-[11px] text-slate-400">
                        সার্চ করা হয়েছে: <b class="text-emerald-300"><?php echo e(e($q)); ?></b>
                    </div>
                <?php endif; ?>
            </form>

            
            <div class="mt-5 space-y-3">
                <?php $__empty_1 = true; $__currentLoopData = $billers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $b): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <a href="<?php echo e(route('paybills.show', $b)); ?>"
                       class="flex items-center justify-between rounded-2xl border border-slate-700/80 bg-slate-900/70 px-3 py-3
                              shadow-sm hover:shadow-[0_18px_45px_-28px_rgba(16,185,129,0.8)] hover:border-emerald-500/50 transition">
                        <div class="flex min-w-0 items-center gap-3">
                            <?php if($b->logo): ?>
                                <div class="h-11 w-11 rounded-2xl overflow-hidden ring-2 ring-emerald-500/40 bg-slate-900 shadow-[0_6px_16px_-10px_rgba(0,0,0,.8)]">
                                    <img src="<?php echo e(asset('storage/'.$b->logo)); ?>"
                                         class="h-full w-full object-cover"
                                         alt="<?php echo e($b->name); ?>">
                                </div>
                            <?php else: ?>
                                <?php $initial = mb_substr($b->name ?? 'B', 0, 1); ?>
                                <div class="h-11 w-11 rounded-2xl bg-emerald-500 flex items-center justify-center text-slate-950 text-base font-bold shadow-[0_10px_25px_-18px_rgba(16,185,129,0.9)]">
                                    <?php echo e($initial); ?>

                                </div>
                            <?php endif; ?>

                            <div class="min-w-0">
                                <div class="truncate text-[14px] font-semibold text-slate-50">
                                    <?php echo e($b->name); ?>

                                </div>
                                <div class="mt-0.5 truncate text-[11px] text-slate-400 flex items-center gap-1">
                                    <span class="inline-block h-1.5 w-1.5 rounded-full bg-emerald-400"></span>
                                    <span><?php echo e($b->provider ?: ($b->category?->name ?? 'অজানা')); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="shrink-0 rounded-full bg-emerald-500/10 px-2 py-1 text-[11px] font-semibold text-emerald-300 flex items-center gap-1">
                            বিস্তারিত
                            <svg class="h-3 w-3" viewBox="0 0 24 24" fill="none">
                                <path d="M9 5l7 7-7 7" stroke="currentColor" stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                        </div>
                    </a>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="rounded-2xl border border-slate-700 bg-slate-900/80 p-5 text-center text-sm text-slate-400 shadow-sm">
                        কোনো বিলার পাওয়া যায়নি।
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </main>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ecareba2/new.rkmotorsbike.top/resources/views/frontend/paybills/index.blade.php ENDPATH**/ ?>