
<?php $__env->startSection('title', $bank->name); ?>

<?php $__env->startPush('styles'); ?>
  
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@400;500;600;700&display=swap" rel="stylesheet">
  <style>
    body{
      font-family: "Hind Siliguri", system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
    }
    @keyframes blobFloat {
      0%   { transform: translate3d(-10%, -10%, 0) scale(1); }
      50%  { transform: translate3d(15%, 10%, 0) scale(1.08); }
      100% { transform: translate3d(40%, -5%, 0) scale(1); }
    }
    @keyframes blobFloat2 {
      0%   { transform: translate3d(40%, 20, 0) scale(1); }
      50%  { transform: translate3d(5, 0, 0) scale(1.04); }
      100% { transform: translate3d(-20, 10, 0) scale(1); }
    }
  </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-gradient-to-b from-slate-950 via-slate-900 to-slate-950 flex justify-center items-start px-3 sm:px-4 py-8 relative overflow-hidden">

  
  <svg class="pointer-events-none absolute -top-32 -left-32 w-80 h-80 text-emerald-500/20"
       viewBox="0 0 200 200" xmlns="http://www.w3.org/2000/svg"
       style="animation: blobFloat 18s ease-in-out infinite alternate;">
    <path fill="currentColor"
          d="M45.1,-62C58.8,-54.8,69.1,-39.4,73.4,-22.5C77.7,-5.7,75.9,12.7,67.4,26.8C58.8,40.9,43.4,50.7,27.2,58.2C11,65.7,-6,70.9,-20.4,66.3C-34.7,61.6,-46.4,47.1,-55.3,31.5C-64.3,15.9,-70.4,-0.7,-68.1,-16.7C-65.8,-32.7,-55.1,-48.1,-41.2,-55.6C-27.3,-63.1,-10.1,-62.6,5.7,-69C21.5,-75.3,43,-88.4,45.1,-62Z"/>
  </svg>

  <svg class="pointer-events-none absolute bottom-0 -right-24 w-72 h-72 text-cyan-400/10"
       viewBox="0 0 200 200" xmlns="http://www.w3.org/2000/svg"
       style="animation: blobFloat2 22s ease-in-out infinite alternate;">
    <path fill="currentColor"
          d="M35.8,-54.7C46.3,-47.4,54,-38,60.9,-27.1C67.7,-16.2,73.7,-4.1,71.9,6.8C70.1,17.7,60.5,27.3,50.4,36.6C40.4,46,29.9,55.3,17.3,60.4C4.6,65.6,-10.1,66.6,-24.4,62.4C-38.7,58.3,-52.6,49.1,-59.8,36.3C-66.9,23.4,-67.3,7,-64.6,-8.3C-61.9,-23.6,-56.1,-37.9,-45.7,-45.9C-35.2,-53.9,-20.1,-55.7,-5.2,-49.9C9.7,-44,19.3,-30.5,35.8,-54.7Z"/>
  </svg>

  <main class="mx-auto w-full max-w-[980px] p-0 mb-24 relative z-10">

    
    <div class="flex items-center justify-between mb-4 text-xs text-slate-300">
      <button type="button"
              onclick="window.history.back()"
              class="inline-flex items-center gap-1 text-slate-300 hover:text-emerald-400 transition">
        <svg class="h-4 w-4" viewBox="0 0 24 24" fill="currentColor">
          <path d="M15.75 4.75 9.5 11l6.25 6.25-1.5 1.5L6.5 11l7.75-7.75 1.5 1.5Z"/>
        </svg>
        Back
      </button>
      <span class="tracking-[0.18em] uppercase text-emerald-400 font-semibold text-[11px]">
        Bank Transfer
      </span>
    </div>

    
    <div class="rounded-3xl bg-slate-900/85 border border-emerald-500/25 shadow-[0_25px_70px_-35px_rgba(16,185,129,0.7)] backdrop-blur-sm p-4 sm:p-6">

      
      <div class="mb-4 rounded-2xl border border-amber-400/40 bg-amber-500/10 px-4 py-3 text-xs sm:text-sm text-amber-100 shadow-sm">
        <div class="flex items-start gap-3">
          <div class="grid h-8 w-8 place-items-center rounded-full bg-amber-400/20 text-lg">📣</div>
          <div>
            ব্যাংকে টাকা পাঠানোর পূর্বে <b>অ্যাকাউন্ট নাম/নম্বর</b> ভালো করে মিলিয়ে নিন।<br>
            মিনিমাম লেনদেন: <b>৳<?php echo e(number_format($bank->min_transaction,0)); ?></b>
          </div>
          <button type="button"
                  class="ml-auto text-amber-100/70 hover:text-amber-100"
                  onclick="this.closest('div').remove()">✕</button>
        </div>
      </div>

      
      <section class="mb-4 overflow-hidden rounded-2xl border border-slate-800 bg-slate-950/60 shadow-[0_22px_60px_-30px_rgba(15,23,42,0.9)]">
        <div class="bg-gradient-to-r from-[#2FAAA6] to-[#1f8f8b] px-5 py-3 text-white">
          <div class="flex items-center gap-3">
            <div class="h-10 w-10 rounded-xl bg-white/10 ring-2 ring-white/30 overflow-hidden grid place-items-center">
              <?php if($bank->logo_url): ?>
                <img src="<?php echo e($bank->logo_url); ?>"
                     class="h-9 w-9 object-cover rounded-lg"
                     alt="<?php echo e($bank->name); ?>">
              <?php else: ?>
                <?php $initial = strtoupper(mb_substr($bank->name ?? 'B',0,1)); ?>
                <span class="font-bold text-lg"><?php echo e($initial); ?></span>
              <?php endif; ?>
            </div>
            <div class="min-w-0">
              <h1 class="truncate text-base font-semibold"><?php echo e($bank->name); ?></h1>
              <p class="text-xs/5 opacity-90">
                Minimum Transaction: ৳<?php echo e(number_format($bank->min_transaction,0)); ?>

              </p>
            </div>
            <?php if($bank->reward_percent > 0): ?>
              <span class="ml-auto inline-flex items-center gap-1 rounded-full border border-sky-200/70 bg-sky-500/20 px-2 py-0.5 text-[11px] font-semibold text-sky-50">
                Reward <?php echo e(rtrim(rtrim(number_format($bank->reward_percent,2),'0'),'.')); ?>%
              </span>
            <?php endif; ?>
          </div>
        </div>
        <div class="p-4 text-xs sm:text-sm text-slate-200">
          নিরাপদ লেনদেনের জন্য সব তথ্য সঠিকভাবে পূরণ করুন।
        </div>
      </section>

      
      <?php if(session('success')): ?>
        <div class="mb-4 rounded-2xl border border-emerald-500/40 bg-emerald-500/10 px-4 py-3 text-emerald-100 shadow-sm text-xs sm:text-sm">
          <?php echo e(session('success')); ?>

        </div>
      <?php endif; ?>
      <?php if($errors->any()): ?>
        <div class="mb-4 rounded-2xl border border-rose-500/40 bg-rose-500/10 px-4 py-3 text-rose-100 shadow-sm text-xs sm:text-sm">
          <?php echo e(implode(' ', $errors->all())); ?>

        </div>
      <?php endif; ?>

      
      <section class="overflow-hidden rounded-2xl border border-slate-800 bg-slate-950/70 shadow-[0_22px_60px_-30px_rgba(15,23,42,0.9)]">
        <div class="bg-gradient-to-r from-[#2FAAA6] to-[#1f8f8b] px-5 py-3 text-center text-sm font-semibold text-white">
          ব্যাংক ট্রান্সফার ফর্ম
        </div>

        <div class="p-4 sm:p-5">
          <form method="POST" action="<?php echo e(route('user.bank.store', $bank)); ?>" class="space-y-4" autocomplete="off">
            <?php echo csrf_field(); ?>

            
            <label class="block text-xs sm:text-sm">
              <span class="mb-1 block font-medium text-slate-100">অ্যাকাউন্ট হোল্ডারের নাম</span>
              <div class="relative">
                <span class="pointer-events-none absolute left-3 top-1/2 -translate-y-1/2 text-slate-500">👤</span>
                <input
                  name="account_name"
                  value="<?php echo e(old('account_name')); ?>"
                  placeholder="যেমন: Md. Rahim"
                  class="h-11 w-full rounded-2xl border-2 border-slate-700 bg-slate-900/80 pl-9 pr-3 text-sm text-slate-100 placeholder-slate-500 outline-none
                         focus:border-emerald-400 focus:ring-2 focus:ring-emerald-400/40 <?php $__errorArgs = ['account_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-rose-400 ring-rose-400/60 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
              </div>
              <?php $__errorArgs = ['account_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="mt-1 block text-[11px] text-rose-400"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </label>

            
            <label class="block text-xs sm:text-sm">
              <span class="mb-1 block font-medium text-slate-100">অ্যাকাউন্ট নম্বর</span>
              <div class="relative">
                <span class="pointer-events-none absolute left-3 top-1/2 -translate-y-1/2 text-slate-500">🏦</span>
                <input
                  name="account_number"
                  value="<?php echo e(old('account_number')); ?>"
                  placeholder="অ্যাকাউন্ট নম্বর লিখুন"
                  class="h-11 w-full rounded-2xl border-2 border-slate-700 bg-slate-900/80 pl-9 pr-3 text-sm text-slate-100 placeholder-slate-500 outline-none
                         focus:border-emerald-400 focus:ring-2 focus:ring-emerald-400/40 <?php $__errorArgs = ['account_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-rose-400 ring-rose-400/60 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
              </div>
              <?php $__errorArgs = ['account_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="mt-1 block text-[11px] text-rose-400"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </label>

            
            <label class="block text-xs sm:text-sm">
              <span class="mb-1 block font-medium text-slate-100">পরিমাণ</span>
              <div class="relative">
                <span class="pointer-events-none absolute left-3 top-1/2 -translate-y-1/2 text-slate-500">💳</span>
                <input
                  type="number" step="0.01" min="<?php echo e($bank->min_transaction); ?>"
                  name="amount"
                  value="<?php echo e(old('amount')); ?>"
                  placeholder="পরিমাণ লিখুন"
                  class="h-11 w-full rounded-2xl border-2 border-slate-700 bg-slate-900/80 pl-9 pr-3 text-sm text-slate-100 placeholder-slate-500 outline-none
                         focus:border-emerald-400 focus:ring-2 focus:ring-emerald-400/40 <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-rose-400 ring-rose-400/60 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
              </div>
              <span class="mt-1 block text-[11px] text-slate-400">
                ন্যূনতম: ৳<?php echo e(number_format($bank->min_transaction,0)); ?>

              </span>
              <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="mt-1 block text-[11px] text-rose-400"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </label>

            
            <label class="block text-xs sm:text-sm">
              <span class="mb-1 block font-medium text-slate-100">ব্রাঞ্চের নাম</span>
              <div class="relative">
                <span class="pointer-events-none absolute left-3 top-1/2 -translate-y-1/2 text-slate-500">📍</span>
                <input
                  name="branch_name"
                  value="<?php echo e(old('branch_name')); ?>"
                  placeholder="যেমন: Motijheel Branch"
                  class="h-11 w-full rounded-2xl border-2 border-slate-700 bg-slate-900/80 pl-9 pr-3 text-sm text-slate-100 placeholder-slate-500 outline-none
                         focus:border-emerald-400 focus:ring-2 focus:ring-emerald-400/40 <?php $__errorArgs = ['branch_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-rose-400 ring-rose-400/60 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
              </div>
              <?php $__errorArgs = ['branch_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="mt-1 block text-[11px] text-rose-400"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </label>

            
            <label class="block text-xs sm:text-sm">
              <span class="mb-1 block font-medium text-slate-100">PIN (৪ ডিজিট)</span>
              <div class="relative">
                <span class="pointer-events-none absolute left-3 top-1/2 -translate-y-1/2 text-slate-500">
                  <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" viewBox="0 0 24 24" fill="currentColor">
                    <path d="M12 2a5 5 0 0 0-5 5v2H6.5A2.5 2.5 0 0 0 4 11.5v7A2.5 2.5 0 0 0 6.5 21h11a2.5 2.5 0 0 0 2.5-2.5v-7A2.5 2.5 0 0 0 17.5 9H17V7a5 5 0 0 0-5-5Zm-3 7V7a3 3 0 0 1 6 0v2Z"/>
                  </svg>
                </span>
                <input
                  type="password"
                  name="login_pin"
                  maxlength="4"
                  inputmode="numeric"
                  pattern="\d*"
                  class="h-11 w-full rounded-2xl border-2 border-slate-700 bg-slate-900/80 pl-9 pr-3 text-sm text-slate-100 placeholder-slate-500 outline-none
                         focus:border-emerald-400 focus:ring-2 focus:ring-emerald-400/40 text-center tracking-[0.35em]"
                  placeholder="••••"
                  autocomplete="off"
                  required>
              </div>
              <?php $__errorArgs = ['login_pin'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="mt-1 block text-[11px] text-rose-400"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </label>

            
            <button
              class="w-full rounded-2xl bg-gradient-to-r from-[#2FAAA6] to-[#1f8f8b] px-5 py-3 text-center text-sm font-semibold text-white
                     shadow-[0_26px_70px_-28px_rgba(16,185,129,0.6)] hover:from-[#2FAAA6] hover:to-[#197c78]">
              সাবমিট করুন
            </button>

            <p class="mt-2 text-center text-[11px] text-slate-400">
              সাবমিট করার আগে সব তথ্য একবার যাচাই করুন।
            </p>
          </form>
        </div>
      </section>

    </div>
  </main>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ecareba2/new.rkmotorsbike.top/resources/views/frontend/bank/form.blade.php ENDPATH**/ ?>