
<?php $__env->startSection('content'); ?>
<div class="container py-4">
  <div class="d-flex flex-wrap gap-2 align-items-center mb-3">
    <h4 class="m-0">Contact Inbox</h4>
    <div class="ms-auto d-flex gap-2">
      <a href="<?php echo e(route('admin.contact.index',['status'=>'unread'])); ?>" class="btn btn-sm btn-outline-danger">Unread (<?php echo e($counts['unread']); ?>)</a>
      <a href="<?php echo e(route('admin.contact.index',['status'=>'read'])); ?>" class="btn btn-sm btn-outline-success">Read (<?php echo e($counts['read']); ?>)</a>
      <a href="<?php echo e(route('admin.contact.index',['status'=>'archived'])); ?>" class="btn btn-sm btn-outline-secondary">Archived (<?php echo e($counts['archived']); ?>)</a>
    </div>
  </div>

  <form method="GET" class="mb-3">
    <div class="input-group">
      <input type="text" class="form-control" placeholder="Search name/email/subject" name="q" value="<?php echo e($q); ?>">
      <button class="btn btn-outline-secondary">Search</button>
    </div>
  </form>

  <div class="card border-0 shadow-sm">
    <div class="table-responsive">
      <table class="table align-middle mb-0">
        <thead>
          <tr>
            <th>#</th>
            <th>Subject</th>
            <th>From</th>
            <th>WhatsApp</th>
            <th>Status</th>
            <th>Received</th>
            <th></th>
          </tr>
        </thead>
        <tbody>
          <?php $__empty_1 = true; $__currentLoopData = $messages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
          <tr class="<?php echo e($m->status==='unread' ? 'table-warning' : ''); ?>">
            <td><?php echo e($m->id); ?></td>
            <td><a href="<?php echo e(route('admin.contact.show',$m)); ?>" class="fw-semibold text-decoration-none"><?php echo e(Str::limit($m->subject, 60)); ?></a></td>
            <td><?php echo e($m->name); ?><br><small class="text-muted"><?php echo e($m->email); ?></small></td>
            <td><?php echo e($m->whatsapp); ?></td>
            <td><span class="badge bg-<?php echo e($m->status==='unread'?'danger':($m->status==='read'?'success':'secondary')); ?>"><?php echo e(ucfirst($m->status)); ?></span></td>
            <td><?php echo e($m->created_at->diffForHumans()); ?></td>
            <td class="text-end">
              <div class="btn-group">
                <form method="POST" action="<?php echo e(route('admin.contact.read',$m)); ?>"><?php echo csrf_field(); ?><button class="btn btn-sm btn-outline-success">Read</button></form>
                <form method="POST" action="<?php echo e(route('admin.contact.unread',$m)); ?>" class="ms-1"><?php echo csrf_field(); ?><button class="btn btn-sm btn-outline-warning">Unread</button></form>
                <form method="POST" action="<?php echo e(route('admin.contact.archive',$m)); ?>" class="ms-1"><?php echo csrf_field(); ?><button class="btn btn-sm btn-outline-secondary">Archive</button></form>
                <form method="POST" action="<?php echo e(route('admin.contact.destroy',$m)); ?>" class="ms-1" onsubmit="return confirm('Delete this message?')"><?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?><button class="btn btn-sm btn-outline-danger">Delete</button></form>
              </div>
            </td>
          </tr>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <tr><td colspan="7" class="text-center text-muted p-4">No messages</td></tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>

  <div class="mt-3"><?php echo e($messages->links()); ?></div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('backend.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ecareba2/new.rkmotorsbike.top/resources/views/admin/contact/index.blade.php ENDPATH**/ ?>