<?php
    use Illuminate\Support\Str;
?>

<style>
    .notify-item {
        padding: 12px 14px;
        border-radius: 10px;
        margin-bottom: 8px;
        display: flex;
        align-items: flex-start;
        gap: 10px;
        transition: background-color 0.2s ease, transform 0.1s ease, box-shadow 0.2s ease;
        cursor: pointer;
    }

    .notify-item:hover {
        background: #f3f6ff;
        transform: translateY(-1px);
        box-shadow: 0 2px 8px rgba(15, 23, 42, 0.06);
    }

    .notify-icon {
        width: 34px;
        height: 34px;
        border-radius: 999px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 18px;
        flex-shrink: 0;
    }

    /* UNREAD */
    .notify-unread .notify-icon {
        background: #e0ecff;
        color: #0d6efd;
    }
    .notify-unread {
        background: #eef4ff;
        border-left: 3px solid #0d6efd;
    }
    .notify-unread .notify-title {
        font-weight: 600;
        color: #111827;
    }

    /* READ */
    .notify-read .notify-icon {
        background: #f1f3f5;
        color: #6c757d;
    }
    .notify-read {
        background: #ffffff;
        border-left: 3px solid transparent;
        opacity: 0.95;
    }
    .notify-read .notify-title {
        font-weight: 500;
        color: #374151;
    }

    .notify-content {
        display: flex;
        flex-direction: column;
        gap: 4px;
    }

    .notify-title-row {
        display: flex;
        align-items: center;
        justify-content: space-between;
        gap: 6px;
    }

    .notify-title {
        font-size: 14px;
        margin: 0;
    }

    .notify-message {
        font-size: 13px;
        color: #4b5563;
        margin: 0;
    }

    .notify-footer {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-top: 4px;
    }

    .notify-time {
        font-size: 11px;
        color: #9ca3af;
    }

    .notify-status-pill {
        font-size: 10px;
        padding: 2px 6px;
        border-radius: 999px;
        text-transform: uppercase;
        letter-spacing: .03em;
    }

    .notify-unread .notify-status-pill {
        background: #dbeafe;
        color: #1d4ed8;
    }

    .notify-read .notify-status-pill {
        background: #e5e7eb;
        color: #4b5563;
    }
</style>

<?php $__empty_1 = true; $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notify): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
    <div class="notify-item <?php echo e($notify->read_at ? 'notify-read' : 'notify-unread'); ?>"
         data-id="<?php echo e($notify->id); ?>">

        <div class="notify-icon">
            <i class="bi <?php echo e($notify->read_at ? 'bi-check2' : 'bi-bell-fill'); ?>"></i>
        </div>

        <div class="notify-content flex-grow-1">
            <div class="notify-title-row">
                <h6 class="notify-title">
                    <?php echo e($notify->title ?? 'Notification'); ?>

                </h6>
                <span class="notify-status-pill">
                    <?php echo e($notify->read_at ? 'Read' : 'New'); ?>

                </span>
            </div>

            <p class="notify-message">
                <?php echo e(Str::limit($notify->message, 80)); ?>

            </p>

            <div class="notify-footer">
                <small class="notify-time">
                    <?php echo e($notify->created_at->diffForHumans()); ?>

                </small>
            </div>
        </div>
    </div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
    <p class="text-center text-muted mb-0">No notifications</p>
<?php endif; ?>


<script>
    // CSRF token
    const csrfToken = document.querySelector('meta[name="csrf-token"]')
        ? document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        : '';

    // Base URL (Blade থেকে একবারই আসবে)
    const markReadBaseUrl = "<?php echo e(url('/notifications')); ?>";

    function updateBadge(count) {
        const countEl = document.getElementById('notify-count');
        if (!countEl) return;

        countEl.textContent = count;
        countEl.style.display = count > 0 ? 'flex' : 'none';
    }

    function attachSingleClickHandlers() {
        const items = document.querySelectorAll('#notify-list .notify-item');
        if (!items.length) return;

        items.forEach(item => {
            item.addEventListener('click', function () {
                const id = this.getAttribute('data-id');
                if (!id || !csrfToken) return;

                fetch(`${markReadBaseUrl}/${id}/read`, {
                    method: 'POST',
                    headers: {
                        'X-Requested-With': 'XMLHttpRequest',
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': csrfToken,
                        'Accept': 'application/json',
                    },
                    body: JSON.stringify({})
                })
                .then(response => {
                    // যদি JSON না হয় (যেমন 419 / login page) তাহলে error ধরবো
                    if (!response.ok) {
                        throw new Error('HTTP error ' + response.status);
                    }
                    return response.json();
                })
                .then(data => {
                    if (!data || !data.success) return;

                    // UI update: unread -> read
                    this.classList.remove('notify-unread');
                    this.classList.add('notify-read');

                    const icon = this.querySelector('.notify-icon i');
                    const pill = this.querySelector('.notify-status-pill');

                    if (icon) {
                        icon.classList.remove('bi-bell-fill');
                        icon.classList.add('bi-check2');
                    }
                    if (pill) {
                        pill.textContent = 'Read';
                    }

                    // badge count update
                    if (typeof data.count !== 'undefined') {
                        updateBadge(data.count);
                    }
                })
                .catch(err => {
                    console.error('Mark read error:', err);
                });
            });
        });
    }

    document.addEventListener('DOMContentLoaded', function () {
        attachSingleClickHandlers();
    });
</script>
<?php /**PATH /home/ecareba2/new.rkmotorsbike.top/resources/views/admin/partials/notifications-list.blade.php ENDPATH**/ ?>