

<?php $__env->startSection('title','Add Money - Bank'); ?>

<?php $__env->startPush('styles'); ?>
    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@400;500;600;700&family=Poppins:wght@400;500;600&display=swap" rel="stylesheet">

    <style>
        body {
            font-family: "Hind Siliguri", system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
        }

        @keyframes blobFloat {
            0%   { transform: translate3d(-10%, -10%, 0) scale(1); }
            50%  { transform: translate3d(15%, 10%, 0) scale(1.08); }
            100% { transform: translate3d(40%, -5%, 0) scale(1); }
        }

        @keyframes blobFloat2 {
            0%   { transform: translate3d(40%, 20%, 0) scale(1); }
            50%  { transform: translate3d(5%, 0, 0) scale(1.04); }
            100% { transform: translate3d(-20%, 10%, 0) scale(1); }
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<?php
  // ------- Base data -------
  $name   = $method->bank_name ?? $method->name ?? '';
  $logo   = $method->bank_logo ?? $method->logo ?? null;
  $accNo  = $method->account_number ?? $method->account_no ?? null;
  $holder = $method->account_holder ?? null;
  $type   = strtolower($method->type ?? $method->slug ?? $name);

  // ------- Brand color set (for buttons, toast etc.) -------
  $brand = [
      'color' => '#2FAAA6',
  ];
  if(str_contains($type,'bkash'))   { $brand['color'] = '#E2136E'; }
  elseif(str_contains($type,'nagad'))  { $brand['color'] = '#F7931A'; }
  elseif(str_contains($type,'rocket')) { $brand['color'] = '#7A1FA2'; }
  elseif(str_contains($type,'bank'))   { $brand['color'] = '#0F766E'; }

  // ------- Card gradient palette -------
  $palette = ['from'=>'#20B2AA','via'=>'#2FAAA6','to'=>'#0EA5A3']; // default teal
  if(str_contains($type,'bkash'))   $palette = ['from'=>'#F51D7A','via'=>'#E2136E','to'=>'#B40E58'];
  if(str_contains($type,'nagad'))   $palette = ['from'=>'#FF9F1C','via'=>'#F7931A','to'=>'#E76F00'];
  if(str_contains($type,'rocket'))  $palette = ['from'=>'#8B5CF6','via'=>'#7C3AED','to'=>'#5B21B6'];
  if(str_contains($type,'bank'))    $palette = ['from'=>'#14B8A6','via'=>'#0EA5A3','to'=>'#0F766E'];

  // ------- Mask & group account number -------
  $accRaw  = preg_replace('/\D+/', '', (string)($accNo ?? ''));
  $grouped = trim(chunk_split($accRaw, 4, ' ')); // 1234 5678 9012 3456
  $masked  = $grouped ? preg_replace('/\d(?=(?:\D*\d){4})/u', '•', $grouped) : ($accNo ?? '');
?>

<div class="min-h-screen bg-gradient-to-b from-slate-950 via-slate-900 to-slate-950 flex justify-center items-start px-3 sm:px-4 py-8 relative overflow-hidden">

    
    <svg class="pointer-events-none absolute -top-32 -left-32 w-80 h-80 text-emerald-500/20"
         viewBox="0 0 200 200" xmlns="http://www.w3.org/2000/svg"
         style="animation: blobFloat 18s ease-in-out infinite alternate;">
        <path fill="currentColor"
              d="M45.1,-62C58.8,-54.8,69.1,-39.4,73.4,-22.5C77.7,-5.7,75.9,12.7,67.4,26.8C58.8,40.9,43.4,50.7,27.2,58.2C11,65.7,-6,70.9,-20.4,66.3C-34.7,61.6,-46.4,47.1,-55.3,31.5C-64.3,15.9,-70.4,-0.7,-68.1,-16.7C-65.8,-32.7,-55.1,-48.1,-41.2,-55.6C-27.3,-63.1,-10.1,-62.6,5.7,-69C21.5,-75.3,43,-88.4,45.1,-62Z"/>
    </svg>

    <svg class="pointer-events-none absolute bottom-0 -right-24 w-72 h-72 text-cyan-400/10"
         viewBox="0 0 200 200" xmlns="http://www.w3.org/2000/svg"
         style="animation: blobFloat2 22s ease-in-out infinite alternate;">
        <path fill="currentColor"
              d="M35.8,-54.7C46.3,-47.4,54,-38,60.9,-27.1C67.7,-16.2,73.7,-4.1,71.9,6.8C70.1,17.7,60.5,27.3,50.4,36.6C40.4,46,29.9,55.3,17.3,60.4C4.6,65.6,-10.1,66.6,-24.4,62.4C-38.7,58.3,-52.6,49.1,-59.8,36.3C-66.9,23.4,-67.3,7,-64.6,-8.3C-61.9,-23.6,-56.1,-37.9,-45.7,-45.9C-35.2,-53.9,-20.1,-55.7,-5.2,-49.9C9.7,-44,19.3,-30.5,35.8,-54.7Z"/>
    </svg>

    <div class="w-full max-w-2xl relative z-10 pb-24">

        
        <div class="mb-4 flex items-center justify-between text-xs text-slate-300">
            <button type="button"
                    onclick="window.history.back()"
                    class="inline-flex items-center gap-1 text-slate-300 hover:text-emerald-400 transition">
                <svg class="h-4 w-4" viewBox="0 0 24 24" fill="currentColor">
                    <path d="M15.75 4.75 9.5 11l6.25 6.25-1.5 1.5L6.5 11l7.75-7.75 1.5 1.5Z"/>
                </svg>
                Back
            </button>
            <span class="tracking-[0.18em] uppercase text-emerald-400 font-semibold text-[11px]">
                Bank Add Money
            </span>
        </div>

        
        <div class="rounded-3xl bg-slate-900/85 border border-emerald-500/25 shadow-[0_25px_70px_-35px_rgba(16,185,129,0.7)] backdrop-blur-sm p-4 sm:p-6">

            
            <div class="mb-4 rounded-2xl border border-amber-400/40 bg-amber-500/10 px-4 py-3 text-xs sm:text-sm text-amber-100 shadow-sm">
                নিজের অ্যাকাউন্টে ব্যালেন্স এড করার আগে অবশ্যই কোম্পানির ডিপোজিট নম্বরগুলো চেক দিয়ে টাকা পাঠাবেন। সর্বনিম্ন এড মানি ৫০ টাকা।
            </div>

            
            <div class="rounded-2xl shadow-[0_22px_60px_-30px_rgba(15,23,42,0.8)] overflow-hidden mb-5">
                <div class="relative p-5 text-white">
                    
                    <div class="absolute inset-0"
                         style="background: radial-gradient(120% 100% at 0% 0%, <?php echo e($palette['from']); ?> 0%, <?php echo e($palette['via']); ?> 45%, <?php echo e($palette['to']); ?> 100%);">
                    </div>

                    
                    <svg class="absolute inset-0 w-full h-full opacity-15 mix-blend-soft-light pointer-events-none" viewBox="0 0 400 250" preserveAspectRatio="none" aria-hidden="true">
                        <defs>
                            <linearGradient id="g1" x1="0" y1="0" x2="1" y2="1">
                                <stop offset="0%" stop-color="#FFFFFF"/>
                                <stop offset="100%" stop-color="#FFFFFF" stop-opacity="0"/>
                            </linearGradient>
                        </defs>
                        <path d="M0,220 C80,180 120,260 200,220 C280,180 320,260 400,220 L400,250 L0,250 Z" fill="url(#g1)"/>
                    </svg>

                    <div class="relative">
                        
                        <div class="flex items-start justify-between">
                            <div class="flex items-center gap-2">
                                <span class="inline-flex h-8 w-8 items-center justify-center rounded-lg bg-white/15 backdrop-blur">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" viewBox="0 0 24 24" fill="currentColor">
                                        <path d="M3 7a3 3 0 0 1 3-3h12a3 3 0 0 1 3 3v2H3Zm0 4h18v7a3 3 0 0 1-3 3H6a3 3 0 0 1-3-3Z"/>
                                    </svg>
                                </span>
                                <div class="font-semibold text-sm sm:text-base"><?php echo e($name ?: 'Payment Method'); ?></div>
                            </div>

                            <div class="flex items-center gap-2">
                                <?php if(!empty($logo)): ?>
                                    <img src="<?php echo e(asset('storage/'.$logo)); ?>" alt="<?php echo e($name); ?> logo"
                                         class="h-7 w-7 object-contain bg-white/10 rounded-md p-1">
                                <?php else: ?>
                                    <?php $initial = strtoupper(mb_substr($name ?: 'B', 0, 1)); ?>
                                    <div class="h-7 w-7 rounded-md bg-white/15 flex items-center justify-center font-bold text-xs">
                                        <?php echo e($initial); ?>

                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>

                        
                        <div class="mt-5 flex items-center gap-3">
                            <div class="h-8 w-11 rounded-md bg-gradient-to-br from-white/70 to-white/30 border border-white/40 shadow-sm"></div>
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 opacity-80" viewBox="0 0 24 24" fill="none">
                                <path d="M7 8a7 7 0 0 1 0 8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"/>
                                <path d="M11 5a12 12 0 0 1 0 14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"/>
                            </svg>
                        </div>

                        
                        <div class="mt-4 font-mono tracking-[0.25em] text-lg sm:text-xl">
                            <?php echo e($masked ?: '•••• •••• •••• ••••'); ?>

                        </div>

                        
                        <div class="mt-3 flex items-end justify-between gap-3">
                            <div class="min-w-0">
                                <div class="text-[11px] uppercase tracking-wide text-white/70">Account Holder</div>
                                <div class="text-sm font-medium truncate max-w-[240px]" title="<?php echo e($holder); ?>"><?php echo e($holder ?: '—'); ?></div>

                                <?php if(!empty($method->location)): ?>
                                    <div class="mt-1 inline-flex items-center gap-1 text-[11px] text-white/90 bg-white/10 px-2 py-1 rounded-md backdrop-blur border border-white/20 max-w-[260px]">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-3.5 w-3.5" viewBox="0 0 24 24" fill="currentColor">
                                            <path d="M12 2a7 7 0 0 0-7 7c0 5.25 7 13 7 13s7-7.75 7-13a7 7 0 0 0-7-7Zm0 9a2 2 0 1 1 0-4 2 2 0 0 1 0 4Z"/>
                                        </svg>
                                        <span class="truncate" title="<?php echo e($method->location); ?>"><?php echo e($method->location); ?></span>
                                    </div>
                                <?php endif; ?>
                            </div>

                            <?php if(!empty($accNo)): ?>
                                <button type="button"
                                        onclick="copyAcc('<?php echo e($accNo); ?>')"
                                        class="shrink-0 inline-flex items-center gap-2 text-[11px] sm:text-xs px-3 py-1.5 rounded-md bg-white/15 hover:bg-white/20 backdrop-blur border border-white/25">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-3.5 w-3.5" viewBox="0 0 24 24" fill="currentColor">
                                        <path d="M8 7a2 2 0 0 1 2-2h8a2 2 0 0 1 2 2v10a2 2 0 0 1-2 2h-8a2 2 0 0 1-2-2Zm-3 3V6a2 2 0 0 1 2-2h9v2H7v9H5a2 2 0 0 1-2-2Z"/>
                                    </svg>
                                    Copy
                                </button>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            
            <form class="bg-slate-950/70 border border-slate-800 rounded-2xl shadow-[0_18px_55px_-30px_rgba(15,23,42,0.9)] p-4 sm:p-5"
                  method="post" enctype="multipart/form-data"
                  action="<?php echo e(url('/add-money-bank/'.$method->slug)); ?>">
                <?php echo csrf_field(); ?>

                <h3 class="text-slate-100 font-semibold mb-4 flex items-center gap-2 text-sm sm:text-base">
                  <span class="inline-flex h-8 w-8 items-center justify-center rounded-xl bg-emerald-500/10 text-emerald-300">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" viewBox="0 0 24 24" fill="none">
                      <path d="M4 4h16v14l-4-3H4z" stroke="currentColor" stroke-width="1.6" stroke-linejoin="round"/>
                    </svg>
                  </span>
                  Payment Details
                </h3>

                
                <label class="block mb-3 text-xs sm:text-sm">
                  <span class="text-slate-200 flex items-center gap-1">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 text-slate-400" viewBox="0 0 24 24" fill="currentColor">
                      <path d="M3 21V3h8v6h10v12h-6v-6H9v6H3Zm6-8h6V9H9v4Z"/>
                    </svg>
                    প্রেরক শাখা (ঐচ্ছিক)
                  </span>
                  <input name="sender_branch" value="<?php echo e(old('sender_branch')); ?>"
                         class="mt-1 w-full rounded-2xl border-2 border-slate-700 bg-slate-900/70 px-3 py-2.5 text-sm text-slate-100 placeholder-slate-500 outline-none focus:border-emerald-400 focus:ring-2 focus:ring-emerald-400/40 <?php $__errorArgs = ['sender_branch'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-rose-400 ring-rose-400/60 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                         placeholder="উদাহরণ: Motijheel Branch">
                  <?php $__errorArgs = ['sender_branch'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-[11px] text-rose-400 mt-1 block"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </label>

                
                <label class="block mb-3 text-xs sm:text-sm">
                  <span class="text-slate-200 flex items-center gap-1">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 text-slate-400" viewBox="0 0 24 24" fill="currentColor">
                      <path d="M4 6a3 3 0 1 1 4 2.65V11h8a3 3 0 1 1 0 2H8v2.35A3 3 0 1 1 4 18a3 3 0 0 1 3-3V9.65A3 3 0 0 1 4 6Z"/>
                    </svg>
                    রাউটিং নম্বর (ঐচ্ছিক)
                  </span>
                  <input name="routing_number" value="<?php echo e(old('routing_number')); ?>"
                         class="mt-1 w-full rounded-2xl border-2 border-slate-700 bg-slate-900/70 px-3 py-2.5 text-sm text-slate-100 placeholder-slate-500 outline-none focus:border-emerald-400 focus:ring-2 focus:ring-emerald-400/40 <?php $__errorArgs = ['routing_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-rose-400 ring-rose-400/60 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                         placeholder="উদাহরণ: 090123456">
                  <?php $__errorArgs = ['routing_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-[11px] text-rose-400 mt-1 block"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </label>

                
                <label class="block mb-3 text-xs sm:text-sm">
                  <span class="text-slate-200 flex items-center gap-1">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 text-slate-400" viewBox="0 0 24 24" fill="currentColor">
                      <path d="M10 3h2l-.5 4H15l.5-4h2l-.5 4H20v2h-3.2l-.6 6H20v2h-3.9l-.5 4h-2l.5-4H9.5l-.5 4h-2l.5-4H4v-2h3.2l.6-6H4V7h3.9l.5-4Zm3.7 6H9.7l-.6 6h4.1l.5-6Z"/>
                    </svg>
                    অ্যাকাউন্ট নম্বর *
                  </span>
                  <input name="account_number" value="<?php echo e(old('account_number')); ?>" required
                         class="mt-1 w-full rounded-2xl border-2 border-slate-700 bg-slate-900/70 px-3 py-2.5 text-sm text-slate-100 placeholder-slate-500 outline-none focus:border-emerald-400 focus:ring-2 focus:ring-emerald-400/40 <?php $__errorArgs = ['account_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-rose-400 ring-rose-400/60 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                         inputmode="numeric" autocomplete="off" placeholder="উদাহরণ: 1234567890123">
                  <?php $__errorArgs = ['account_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-[11px] text-rose-400 mt-1 block"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </label>

                
                <label class="block mb-3 text-xs sm:text-sm">
                  <span class="text-slate-200 flex items-center gap-1">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 text-slate-400" viewBox="0 0 24 24" fill="currentColor">
                      <path d="M12 12a5 5 0 1 0-5-5 5 5 0 0 0 5 5Zm0 2c-4.33 0-8 2.17-8 5v1h16v-1c0-2.83-3.67-5-8-5Z"/>
                    </svg>
                    অ্যাকাউন্ট হোল্ডার *
                  </span>
                  <input name="account_holder" value="<?php echo e(old('account_holder')); ?>" required
                         class="mt-1 w-full rounded-2xl border-2 border-slate-700 bg-slate-900/70 px-3 py-2.5 text-sm text-slate-100 placeholder-slate-500 outline-none focus:border-emerald-400 focus:ring-2 focus:ring-emerald-400/40 <?php $__errorArgs = ['account_holder'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-rose-400 ring-rose-400/60 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                         placeholder="উদাহরণ: Md. Rahim">
                  <?php $__errorArgs = ['account_holder'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-[11px] text-rose-400 mt-1 block"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </label>

                
                <label class="block mb-3 text-xs sm:text-sm">
                  <span class="text-slate-200 flex items-center gap-1">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 text-slate-400" viewBox="0 0 24 24" fill="currentColor">
                      <path d="M12 2a7 7 0 0 0-7 7c0 5.25 7 13 7 13s7-7.75 7-13a7 7 0 0 0-7-7Zm0 9a2 2 0 1 1 0-4 2 2 0 0 1 0 4Z"/>
                    </svg>
                    লোকেশন/ব্রাঞ্চ (ঐচ্ছিক)
                  </span>
                  <input name="location" value="<?php echo e(old('location')); ?>"
                         class="mt-1 w-full rounded-2xl border-2 border-slate-700 bg-slate-900/70 px-3 py-2.5 text-sm text-slate-100 placeholder-slate-500 outline-none focus:border-emerald-400 focus:ring-2 focus:ring-emerald-400/40 <?php $__errorArgs = ['location'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-rose-400 ring-rose-400/60 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                         placeholder="উদাহরণ: Dhanmondi, Dhaka">
                  <?php $__errorArgs = ['location'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-[11px] text-rose-400 mt-1 block"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </label>

                
                <label class="block mb-3 text-xs sm:text-sm">
                  <span class="text-slate-200 flex items-center gap-1">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 text-slate-400" viewBox="0 0 24 24" fill="currentColor">
                      <path d="M6 4h12v2h-7.35c.9.77 1.35 1.86 1.35 3.27C12 12.07 9.76 14 6.5 14H5v-2h1.5C8.43 12 10 10.91 10 9.27S8.43 6.5 6.5 6.5H6V4Z"/>
                    </svg>
                    টাকার পরিমাণ *
                  </span>
                  <input name="amount" type="number" step="0.01" min="1" value="<?php echo e(old('amount')); ?>" required
                         class="mt-1 w-full rounded-2xl border-2 border-slate-700 bg-slate-900/70 px-3 py-2.5 text-sm text-slate-100 placeholder-slate-500 outline-none focus:border-emerald-400 focus:ring-2 focus:ring-emerald-400/40 <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-rose-400 ring-rose-400/60 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                         placeholder="উদাহরণ: 500.00">
                  <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-[11px] text-rose-400 mt-1 block"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                  <?php if(($method->daily_min ?? null) !== null || ($method->daily_max ?? null) !== null): ?>
                    <span class="text-[11px] text-slate-400 mt-1 block">
                      মিনিমাম: <?php echo e($method->daily_min ?? 0); ?> | ম্যাক্সিমাম: <?php echo e($method->daily_max ?? '∞'); ?>

                    </span>
                  <?php endif; ?>
                </label>

                
                <label class="block mb-4 text-xs sm:text-sm">
                  <span class="text-slate-200 flex items-center gap-1">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 text-slate-400" viewBox="0 0 24 24" fill="currentColor">
                      <path d="M4 5a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V7a2 2 0 0 0-2-2H4Zm3 3a2 2 0 1 1 0 4 2 2 0 0 1 0-4Zm12 9H5l3.5-4.5 2.5 3L14.5 12 19 17Z"/>
                    </svg>
                    প্রুফ/স্ক্রিনশট (optional)
                  </span>
                  <input type="file" name="proof_screenshot" id="proofInput" accept="image/*"
                         class="mt-1 block w-full text-xs sm:text-sm text-emerald-200 file:mr-4 file:rounded-xl file:border-0 file:bg-emerald-500/15 file:px-4 file:py-2 file:text-emerald-100 hover:file:bg-emerald-500/25 cursor-pointer">
                  <?php $__errorArgs = ['proof_screenshot'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-[11px] text-rose-400 mt-1 block"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </label>

                
                <div class="mb-4">
                  <div class="aspect-video w-full rounded-2xl border border-dashed border-slate-700 flex items-center justify-center overflow-hidden bg-slate-900/80" id="proofPreviewWrap">
                    <img id="proofPreview" src="#" alt="Preview" class="hidden w-full h-full object-contain">
                    <div id="proofPlaceholder" class="text-slate-500 text-xs sm:text-sm flex items-center gap-2">
                      <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor">
                        <path d="M4 3a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2হ12a2 2 0 0 0 2-2V5a2 2 0 0 0-2-2H4zm1 3a2 2 0 1 1 0 4 2 2 0 0 1 0-4zm11 9H4l3.5-4.5 2.5 3 3.5-4.5L16 15z"/>
                      </svg>
                      ইমেজ সিলেক্ট করলে প্রিভিউ দেখাবে
                    </div>
                  </div>
                </div>

                <div class="flex flex-col sm:flex-row gap-3">
                  <a href="<?php echo e(url('/add-money-bank/methods')); ?>"
                     class="inline-flex justify-center items-center flex-1 h-11 rounded-2xl border border-slate-700 text-slate-200 hover:bg-slate-800/80 shadow-sm text-sm font-medium" style="padding:  10px 20px">
                    Back
                  </a>
                  <button class="flex-1 h-11 rounded-2xl text-white text-sm font-semibold shadow-lg hover:opacity-95"
                          style="background: <?php echo e($brand['color']); ?>; padding:  10px 20px"  >
                    Submit Payment
                  </button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
function copyAcc(text){
  if(!text) return;
  navigator.clipboard.writeText(text).then(() => {
    const toast = document.createElement('div');
    toast.textContent = 'Account number copied';
    toast.className = 'fixed bottom-6 left-1/2 -translate-x-1/2 px-3 py-2 rounded-lg text-white text-xs sm:text-sm shadow-lg z-50';
    toast.style.background = '<?php echo e($brand['color']); ?>';
    document.body.appendChild(toast);
    setTimeout(()=> toast.remove(), 1300);
  });
}

document.getElementById('proofInput')?.addEventListener('change', function (e) {
  const [file] = e.target.files || [];
  const img = document.getElementById('proofPreview');
  const ph  = document.getElementById('proofPlaceholder');
  if (file && file.type.startsWith('image/')) {
      img.src = URL.createObjectURL(file);
      img.classList.remove('hidden');
      ph.classList.add('hidden');
  } else {
      img.src = '#';
      img.classList.add('hidden');
      ph.classList.remove('hidden');
  }
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\production_re_banking\resources\views/frontend/add-money-bank/create.blade.php ENDPATH**/ ?>