

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-3">

    <div class="d-flex flex-wrap justify-content-between align-items-center mb-3 gap-2">
        <h5 class="mb-0"><i class="fa-regular fa-credit-card me-1"></i> Add Money Cards</h5>
        <a href="<?php echo e(route('admin.add-money-cards.create')); ?>" class="btn btn-success">
            <i class="fa-solid fa-plus me-1"></i> Add New Card
        </a>
    </div>

    <?php if(session('success')): ?>
        <div class="alert alert-success py-2"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <form class="mb-3 d-flex flex-wrap gap-2" method="GET" action="<?php echo e(route('admin.add-money-cards.index')); ?>">
        <input type="text"
               name="search"
               value="<?php echo e(request('search')); ?>"
               class="form-control"
               placeholder="Search brand / holder name / card number">
        <button class="btn btn-outline-secondary">
            <i class="fa-solid fa-magnifying-glass"></i>
        </button>
    </form>

    <div class="card">
        <div class="table-responsive">
            <table class="table table-striped align-middle mb-0">
                <thead class="table-light">
                    <tr>
                        <th>#</th>
                        <th>Logo</th>
                        <th>Brand</th>
                        <th>Holder Name</th>
                        <th>Card Number</th>
                        <th>Expire</th>
                        <th>Status</th>
                        <th class="text-end">Actions</th>
                    </tr>
                </thead>
                <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $cards; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $card): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><?php echo e($card->id); ?></td>
                        <td>
                            <?php if($card->logo): ?>
                                <img src="<?php echo e(asset('storage/' . $card->logo)); ?>"
                                     style="width:40px;height:26px;object-fit:contain;"
                                     alt="">
                            <?php else: ?>
                                <span class="text-muted">No logo</span>
                            <?php endif; ?>
                        </td>
                        <td><?php echo e($card->brand); ?></td>
                        <td><?php echo e($card->holder_name); ?></td>
                        <td>
                            <span class="text-monospace">
                                <?php echo e(Str::limit($card->card_number, 8, '••••')); ?>

                            </span>
                        </td>
                        <td><?php echo e($card->expire_date); ?></td>
                        <td>
                            <?php if($card->is_active): ?>
                                <span class="badge bg-success">Active</span>
                            <?php else: ?>
                                <span class="badge bg-secondary">Inactive</span>
                            <?php endif; ?>
                        </td>
                        <td class="text-end">
                            <a href="<?php echo e(route('admin.add-money-cards.edit', $card)); ?>"
                               class="btn btn-sm btn-outline-info">
                                <i class="fa-regular fa-pen-to-square"></i>
                            </a>

                            <form action="<?php echo e(route('admin.add-money-cards.destroy', $card)); ?>"
                                  method="POST"
                                  class="d-inline"
                                  onsubmit="return confirm('Delete this card?');">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button class="btn btn-sm btn-outline-danger">
                                    <i class="fa-regular fa-trash-can"></i>
                                </button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="8" class="text-center text-muted py-4">
                            No cards found.
                        </td>
                    </tr>
                <?php endif; ?>
                </tbody>
            </table>
        </div>

        <div class="card-footer">
            <?php echo e($cards->links()); ?>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ecareba2/new.rkmotorsbike.top/resources/views/backend/add_money_cards/index.blade.php ENDPATH**/ ?>