

<?php $__env->startSection('title', 'প্রোফাইল'); ?>

<?php $__env->startSection('content'); ?>
<div class="w-full px-3 sm:px-6 lg:px-10 py-6" style="--brand:#4F46E5; --brand-dark:#4338CA; --brand-50:#EEF2FF; --brand-100:#E0E7FF;">

    
    <?php if(session('status_info') || session('status_avatar') || session('status_password')): ?>
        <div class="mb-6 rounded-lg border border-emerald-200 bg-emerald-50 px-4 py-3 text-emerald-800 dark:bg-emerald-900/20 dark:text-emerald-200" style="color: #000!important">
            <?php echo e(session('status_info') ?? session('status_avatar') ?? session('status_password')); ?>

        </div>
    <?php endif; ?>

    
    <div class="relative overflow-hidden rounded-2xl border bg-gradient-to-br from-[var(--brand-50)] via-white to-[var(--brand-100)] dark:from-slate-900 dark:via-slate-900 dark:to-slate-800">
        <div class="absolute inset-0 opacity-10 pointer-events-none select-none">
            <svg class="h-full w-full" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="none">
                <defs>
                    <pattern id="grid" width="32" height="32" patternUnits="userSpaceOnUse">
                        <path d="M 32 0 L 0 0 0 32" fill="none" stroke="currentColor" stroke-width="0.5"/>
                    </pattern>
                </defs>
                <rect width="100%" height="100%" fill="url(#grid)" />
            </svg>
        </div>

        <div class="relative px-4 sm:px-8 py-8">
            <div class="flex flex-col sm:flex-row sm:items-end gap-6">
                
                <div class="relative shrink-0">
                    <div class="h-28 w-28 sm:h-32 sm:w-32 rounded-full ring-4 ring-white overflow-hidden bg-white shadow-md border dark:ring-slate-900">
                        <?php if($user->avatar): ?>
                            <img src="<?php echo e(asset('storage/'.$user->avatar)); ?>" alt="Avatar" class="h-full w-full object-cover" id="avatar-preview">
                        <?php else: ?>
                            <img src="<?php echo e(asset('images/default-avatar.png')); ?>" alt="Default" class="h-full w-full object-cover" id="avatar-preview" onerror="this.style.display='none'">
                        <?php endif; ?>
                    </div>

                    
                    <form id="avatar-form" method="POST" action="<?php echo e(route('admin.profile.avatar.update')); ?>" enctype="multipart/form-data" class="absolute -bottom-3 left-1/2 -translate-x-1/2">
                        <?php echo csrf_field(); ?>
                        <label for="avatar-input" class="inline-flex items-center gap-1 rounded-full bg-[var(--brand)] px-3 py-1.5 text-xs font-medium text-white shadow hover:bg-[var(--brand-dark)] cursor-pointer">
                            <svg class="h-4 w-4" viewBox="0 0 24 24" fill="none" stroke="currentColor">
                                <path stroke-width="1.5" d="M3 8.5A2.5 2.5 0 0 1 5.5 6H8l1-2h6l1 2h2.5A2.5 2.5 0 0 1 21 8.5v8A2.5 2.5 0 0 1 18.5 19h-13A2.5 2.5 0 0 1 3 16.5v-8Z"/>
                                <circle cx="12" cy="13" r="4" stroke-width="1.5"/>
                            </svg>
                            ছবি বদলান
                        </label>
                        <input type="file" name="avatar" id="avatar-input" accept="image/*" class="hidden" />
                    </form>
                    <?php $__errorArgs = ['avatar'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="mt-4 text-xs text-red-600"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                
                <div class="flex-1">
                    <div class="flex flex-col sm:flex-row sm:items-end sm:justify-between gap-4">
                        <div>
                            <h1 class="text-2xl sm:text-3xl font-semibold tracking-tight text-slate-900 dark:text-slate-100">
                                <?php echo e($user->name); ?>

                            </h1>
                            <p class="mt-1 text-sm text-slate-600 dark:text-slate-300">
                                <?php echo e($user->email); ?>

                                <?php if(is_null($user->email_verified_at)): ?>
                                    <span class="ml-2 inline-flex items-center gap-1 rounded-full bg-amber-100 px-2 py-0.5 text-amber-700 text-xs dark:bg-amber-900/30 dark:text-amber-200">
                                        <svg class="h-3.5 w-3.5" viewBox="0 0 24 24" fill="none" stroke="currentColor">
                                            <path stroke-width="1.5" d="M12 9v4m0 4h.01M10.29 3.86 1.82 18a2 2 0 0 0 1.71 3h16.94a2 2 0 0 0 1.71-3L13.71 3.86a2 2 0 0 0-3.42 0Z"/>
                                        </svg>
                                        ভেরিফাইড নয়
                                    </span>
                                <?php else: ?>
                                    <span class="ml-2 inline-flex items-center gap-1 rounded-full bg-emerald-100 px-2 py-0.5 text-emerald-700 text-xs dark:bg-emerald-900/30 dark:text-emerald-200">
                                        <svg class="h-3.5 w-3.5" viewBox="0 0 24 24" fill="none" stroke="currentColor">
                                            <path stroke-width="1.5" d="M20 6 9 17l-5-5"/>
                                        </svg>
                                        ভেরিফাইড
                                    </span>
                                <?php endif; ?>
                            </p>
                        </div>

                        <div class="grid grid-cols-3 divide-x rounded-xl border bg-white/70 backdrop-blur px-3 py-2 text-center text-xs text-slate-600 dark:bg-slate-900/40 dark:text-slate-300 overflow-hidden">
                            <div class="px-3">
                                <div class="font-semibold text-slate-900 dark:text-slate-100"><?php echo e($user->created_at?->format('d M Y')); ?></div>
                                <div>Joined</div>
                            </div>
                            <div class="px-3">
                                <div class="font-semibold text-slate-900 dark:text-slate-100"><?php echo e($user->phone ? 'Yes' : 'No'); ?></div>
                                <div>Phone</div>
                            </div>
                            <div class="px-3">
                                <div class="font-semibold text-slate-900 dark:text-slate-100"><?php echo e($user->bio ? 'Yes' : 'No'); ?></div>
                                <div>Bio</div>
                            </div>
                        </div>
                    </div>

                    
                    <div class="mt-4 flex flex-wrap items-center gap-2">
                        <form method="POST" action="<?php echo e(route('admin.profile.avatar.destroy')); ?>" class="w-full sm:w-auto">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="w-full sm:w-auto inline-flex items-center justify-center gap-2 rounded-lg border border-red-200 bg-white px-3 py-2 text-sm text-red-700 hover:bg-red-50 dark:bg-slate-900 dark:border-red-700/40 dark:text-red-300">
                                <svg class="h-4 w-4" viewBox="0 0 24 24" fill="none" stroke="currentColor">
                                    <path stroke-width="1.5" d="M4 7h16M9 7V5a2 2 0 0 1 2-2h2a2 2 0 0 1 2 2v2m-9 0 1 13a2 2 0 0 0 2 2h6a2 2 0 0 0 2-2l1-13M10 11v6m4-6v6"/>
                                </svg>
                                ছবি মুছুন
                            </button>
                        </form>
                       
                    </div>
                </div>
            </div>
        </div>
    </div>

    
    <div class="mt-8 grid grid-cols-1 gap-6 md:grid-cols-5">

        
        <div class="space-y-6 md:col-span-2">
            
            <div class="rounded-xl border bg-white p-6 shadow-sm dark:bg-slate-900/60 dark:border-slate-700">
                <div class="mb-4 flex items-center justify-between">
                    <h2 class="text-base font-semibold text-slate-900 dark:text-slate-100" style="color: #000!important;">প্রোফাইল ডাটা</h2>
                </div>
                <dl class="divide-y divide-slate-200 dark:divide-slate-700">
                    <div class="grid grid-cols-3 gap-4 py-3">
                        <dt class="text-sm text-slate-500">নাম</dt>
                        <dd class="col-span-2 text-sm text-slate-900 dark:text-slate-100" style="color: #000!important;"><?php echo e($user->name); ?></dd>
                    </div>
                    <div class="grid grid-cols-3 gap-4 py-3">
                        <dt class="text-sm text-slate-500">ইমেইল</dt>
                        <dd class="col-span-2 text-sm text-slate-900 dark:text-slate-100" style="color: #000!important;"><?php echo e($user->email); ?></dd>
                    </div>
                    <div class="grid grid-cols-3 gap-4 py-3">
                        <dt class="text-sm text-slate-500">ভেরিফিকেশন</dt>
                        <dd class="col-span-2 text-sm"><?php echo e($user->email_verified_at ? 'ভেরিফাইড' : 'ভেরিফাইড নয়'); ?></dd>
                    </div>
                    <div class="grid grid-cols-3 gap-4 py-3">
                        <dt class="text-sm text-slate-500">যোগদান</dt>
                        <dd class="col-span-2 text-sm"><?php echo e($user->created_at?->format('d M Y, h:i A')); ?></dd>
                    </div>
                    <?php if(!empty($user->phone)): ?>
                    <div class="grid grid-cols-3 gap-4 py-3">
                        <dt class="text-sm text-slate-500">ফোন</dt>
                        <dd class="col-span-2 text-sm"><?php echo e($user->phone); ?></dd>
                    </div>
                    <?php endif; ?>
                    <?php if(!empty($user->bio)): ?>
                    <div class="grid grid-cols-3 gap-4 py-3">
                        <dt class="text-sm text-slate-500">বায়ো</dt>
                        <dd class="col-span-2 text-sm"><?php echo e($user->bio); ?></dd>
                    </div>
                    <?php endif; ?>
                </dl>
            </div>

            
            <div class="rounded-xl border bg-white p-6 shadow-sm dark:bg-slate-900/60 dark:border-slate-700">
                <div class="mb-5 flex items-center gap-2">
                    <svg class="h-5 w-5 text-[var(--brand)]" viewBox="0 0 24 24" fill="none" stroke="currentColor">
                        <path stroke-width="1.5" d="M15 7a5 5 0 1 1-7.9 4l-3.6 3.6a2 2 0 0 0 0 2.8l.5.5a2 2 0 0 0 2.8 0l1.2-1.2 1.2 1.2 1.4-1.4-1.2-1.2 1.2-1.2A5 5 0 0 1 15 7Z"/>
                    </svg>
                    <h2 class="text-base font-semibold text-slate-900 dark:text-slate-100" style="color: #000!important;">পাসওয়ার্ড পরিবর্তন</h2>
                </div>

                <form method="POST" action="<?php echo e(route('admin.profile.password.update')); ?>" class="space-y-4">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>

                    <div>
                        <label for="old_password" class="mb-1 block text-sm font-medium text-slate-700 dark:text-slate-300">পুরনো পাসওয়ার্ড</label>
                        <input id="old_password" name="old_password" type="password" autocomplete="current-password"
                               class="w-full rounded-lg border-slate-300 px-3 py-2 focus:border-[var(--brand)] focus:ring-2 focus:ring-[var(--brand)] dark:bg-slate-300 dark:border-slate-700" required>
                        <?php $__errorArgs = ['old_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="mt-1 text-xs text-red-600"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div>
                        <label for="password" class="mb-1 block text-sm font-medium text-slate-300 dark:text-slate-300">নতুন পাসওয়ার্ড</label>
                        <input id="password" name="password" type="password" autocomplete="new-password"
                               class="w-full rounded-lg border-slate-300 px-3 py-2 focus:border-[var(--brand)] focus:ring-2 focus:ring-[var(--brand)] dark:bg-slate-300 dark:border-slate-700" required>
                        <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="mt-1 text-xs text-red-600"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div>
                        <label for="password_confirmation" class="mb-1 block text-sm font-medium text-slate-700 dark:text-slate-300">কনফার্ম পাসওয়ার্ড</label>
                        <input id="password_confirmation" name="password_confirmation" type="password" autocomplete="new-password"
                               class="w-full rounded-lg border-slate-300 px-3 py-2 focus:border-[var(--brand)] focus:ring-2 focus:ring-[var(--brand)] dark:bg-slate-300 dark:border-slate-700" required>
                    </div>

                    <div class="pt-2">
                        <button type="submit" class="w-full sm:w-auto inline-flex items-center justify-center gap-2 rounded-lg bg-[var(--brand)] px-5 py-2.5 text-white shadow hover:bg-[var(--brand-dark)] focus:outline-none focus:ring-2 focus:ring-[var(--brand)]">
                            <svg class="h-4 w-4" viewBox="0 0 24 24" fill="none" stroke="currentColor">
                                <path stroke-width="1.5" d="M3 12a9 9 0 1 0 9-9M3 4v6h6"/>
                            </svg>
                            আপডেট করুন
                        </button>
                    </div>

                    <?php if(session('status_password')): ?>
                        <p class="text-sm text-emerald-700 mt-2"><?php echo e(session('status_password')); ?></p>
                    <?php endif; ?>
                </form>
            </div>
        </div>

        
        <div class="space-y-6 md:col-span-3">
            
            <div class="rounded-xl border bg-white p-6 shadow-sm dark:bg-slate-900/60 dark:border-slate-700">
                <div class="mb-5 flex items-center gap-2">
                    <svg class="h-5 w-5 text-[var(--brand)]" viewBox="0 0 24 24" fill="none" stroke="currentColor">
                        <path stroke-width="1.5" d="M12 12a5 5 0 1 0-5-5 5 5 0 0 0 5 5Zm7 9a7 7 0 0 0-14 0"/>
                    </svg>
                    <h2 class="text-base font-semibold text-slate-900 dark:text-slate-100" style="color: #000!important;">প্রোফাইল তথ্য</h2>
                </div>

                <form method="POST" action="<?php echo e(route('admin.profile.info.update')); ?>" class="space-y-4">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>

                    <div>
                        <label for="name" class="mb-1 block text-sm font-medium text-slate-700 dark:text-slate-300">নাম</label>
                        <input id="name" name="name" type="text" value="<?php echo e(old('name', $user->name)); ?>"
                               class="w-full rounded-lg border-slate-300 px-3 py-2 focus:border-[var(--brand)] focus:ring-2 focus:ring-[var(--brand)] dark:bg-slate-200 dark:border-slate-700" required>
                        <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="mt-1 text-xs text-red-600"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div>
                        <label for="email" class="mb-1 block text-sm font-medium text-slate-700 dark:text-slate-300">ইমেইল</label>
                        <div class="relative">
                            <input id="email" name="email" type="email" value="<?php echo e(old('email', $user->email)); ?>"
                                   class="w-full rounded-lg border-slate-300 pl-10 pr-3 py-2 focus:border-[var(--brand)] focus:ring-2 focus:ring-[var(--brand)] dark:bg-slate-200 dark:border-slate-700" required>
                            <span class="pointer-events-none absolute inset-y-0 left-0 flex items-center pl-3 text-slate-400">
                                <svg class="h-4.5 w-4.5" viewBox="0 0 24 24" fill="none" stroke="currentColor">
                                    <path stroke-width="1.5" d="M4 6h16v12H4zM4 6l8 6 8-6"/>
                                </svg>
                            </span>
                        </div>
                        <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="mt-1 text-xs text-red-600"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        <?php if(is_null($user->email_verified_at)): ?>
                            <p class="text-xs text-amber-600 mt-1">ইমেইল এখনও ভেরিফাই হয়নি।</p>
                        <?php endif; ?>
                    </div>

                    <div>
                        <label for="phone" class="mb-1 block text-sm font-medium text-slate-700 dark:text-slate-300">ফোন (ঐচ্ছিক)</label>
                        <div class="relative">
                            <input id="phone" name="phone" type="text" value="<?php echo e(old('phone', $user->phone ?? '')); ?>"
                                   class="w-full rounded-lg border-slate-300 pl-10 pr-3 py-2 focus:border-[var(--brand)] focus:ring-2 focus:ring-[var(--brand)] dark:bg-slate-200 dark:border-slate-700">
                            <span class="pointer-events-none absolute inset-y-0 left-0 flex items-center pl-3 text-slate-400">
                                <svg class="h-4.5 w-4.5" viewBox="0 0 24 24" fill="none" stroke="currentColor">
                                    <path stroke-width="1.5" d="M21 15v3a2 2 0 0 1-2 2h-1c-7.18 0-13-5.82-13-13V4a2 2 0 0 1 2-2h3l1.5 4-2 2a12 12 0 0 0 6.5 6.5l2-2L19 16l-4 1.5"/>
                                </svg>
                            </span>
                        </div>
                        <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="mt-1 text-xs text-red-600"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div>
                        <label for="bio" class="mb-1 block text-sm font-medium text-slate-700 dark:text-slate-300">বায়ো (ঐচ্ছিক)</label>
                        <textarea disabled id="bio" name="bio" rows="4"
                                  class="w-full rounded-lg border-slate-300 px-3 py-2 focus:border-[var(--brand)] focus:ring-2 focus:ring-[var(--brand)] dark:bg-slate-200 dark:border-slate-700"
                                  placeholder="নিজের সম্পর্কে সংক্ষিপ্ত পরিচিতি লিখুন..."><?php echo e(old('bio', $user->bio ?? '')); ?></textarea>
                        <?php $__errorArgs = ['bio'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="mt-1 text-xs text-red-600"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="pt-2">
                        <button type="submit"  class=" sm:w-auto inline-flex items-center justify-center gap-2 rounded-lg bg-[var(--brand)] px-6 py-2.5 text-white shadow hover:bg-[var(--brand-dark)] focus:outline-none focus:ring-2 focus:ring-[var(--brand)]">
                            <svg class="h-4.5 w-4.5" viewBox="0 0 24 24" fill="none" stroke="currentColor">
                                <path stroke-width="1.5" d="M4 7a2 2 0 0 1 2-2h9l5 5v9a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2V7Z"/>
                                <path stroke-width="1.5" d="M8 7v6হ8"/>
                            </svg>
                            সেভ করুন
                        </button>
                        <?php if(session('status_info')): ?>
                            <p class="text-sm text-emerald-700 mt-2"><?php echo e(session('status_info')); ?></p>
                        <?php endif; ?>
                    </div>
                </form>
            </div>

            
            <div class="rounded-xl border bg-white p-5 text-sm text-slate-600 shadow-sm dark:bg-slate-900/60 dark:border-slate-700 dark:text-slate-300">
                <div class="flex items-start gap-3">
                    <svg class="mt-0.5 h-5 w-5 flex-none text-[var(--brand)]" viewBox="0 0 24 24" fill="none" stroke="currentColor">
                        <circle cx="12" cy="12" r="9" stroke-width="1.5"/>
                        <path stroke-width="1.5" d="M12 8h.01M11 12h1v4h1"/>
                    </svg>
                    <div>
                        <p class="font-medium text-slate-900 dark:text-slate-500" style="color: #000!important;">টিপস</p>
                        <ul class="mt-1 list-disc pl-5 space-y-1">
                            <li style="color: #8f8e8e;">স্পষ্ট নাম ও বৈধ ইমেইল রাখুন—সিস্টেম নোটিফিকেশন পেতে সুবিধা হবে।</li>
                            <li style="color: #8f8e8e;">প্রোফাইল ছবি 1:1 অনুপাত হলে ভালো দেখায় (512×512 প্রেফার্ড)।</li>
                        </ul>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>


<script>
    const avatarInput = document.getElementById('avatar-input');
    const avatarForm  = document.getElementById('avatar-form');
    const avatarImg   = document.getElementById('avatar-preview');

    if (avatarInput && avatarForm) {
        avatarInput.addEventListener('change', (e) => {
            const file = e.target.files && e.target.files[0];
            if (!file) return;

            const reader = new FileReader();
            reader.onload = (ev) => {
                if (avatarImg) {
                    avatarImg.style.display = 'block';
                    avatarImg.src = ev.target.result;
                }
            };
            reader.readAsDataURL(file);
            avatarForm.submit();
        });
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ecareba2/new1.rkmotorsbike.top/resources/views/backend/profile/edit.blade.php ENDPATH**/ ?>