
<?php $__env->startSection('title','এড মানি'); ?>

<?php $__env->startPush('styles'); ?>
    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@400;500;600;700&family=Poppins:wght@400;500;600&display=swap" rel="stylesheet">

    <style>
        body {
            font-family: "Hind Siliguri", system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
        }

        @keyframes blobFloat {
            0%   { transform: translate3d(-10%, -10%, 0) scale(1); }
            50%  { transform: translate3d(15%, 10%, 0) scale(1.06); }
            100% { transform: translate3d(35%, -5%, 0) scale(1); }
        }

        @keyframes blobFloat2 {
            0%   { transform: translate3d(40%, 20%, 0) scale(1); }
            50%  { transform: translate3d(0, 0, 0) scale(1.04); }
            100% { transform: translate3d(-25%, 5%, 0) scale(1); }
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-gradient-to-b from-slate-950 via-slate-900 to-slate-950 flex justify-center items-start px-3 sm:px-4 py-8 relative overflow-hidden">

    
    <svg class="pointer-events-none absolute -top-32 -left-32 w-80 h-80 text-sky-500/16"
         viewBox="0 0 200 200" xmlns="http://www.w3.org/2000/svg"
         style="animation: blobFloat 20s ease-in-out infinite alternate;">
        <path fill="currentColor"
              d="M45.1,-62C58.8,-54.8,69.1,-39.4,73.4,-22.5C77.7,-5.7,75.9,12.7,67.4,26.8C58.8,40.9,43.4,50.7,27.2,58.2C11,65.7,-6,70.9,-20.4,66.3C-34.7,61.6,-46.4,47.1,-55.3,31.5C-64.3,15.9,-70.4,-0.7,-68.1,-16.7C-65.8,-32.7,-55.1,-48.1,-41.2,-55.6C-27.3,-63.1,-10.1,-62.6,5.7,-69C21.5,-75.3,43,-88.4,45.1,-62Z"/>
    </svg>

    <svg class="pointer-events-none absolute bottom-0 -right-24 w-72 h-72 text-emerald-400/12"
         viewBox="0 0 200 200" xmlns="http://www.w3.org/2000/svg"
         style="animation: blobFloat2 22s ease-in-out infinite alternate;">
        <path fill="currentColor"
              d="M35.8,-54.7C46.3,-47.4,54,-38,60.9,-27.1C67.7,-16.2,73.7,-4.1,71.9,6.8C70.1,17.7,60.5,27.3,50.4,36.6C40.4,46,29.9,55.3,17.3,60.4C4.6,65.6,-10.1,66.6,-24.4,62.4C-38.7,58.3,-52.6,49.1,-59.8,36.3C-66.9,23.4,-67.3,7,-64.6,-8.3C-61.9,-23.6,-56.1,-37.9,-45.7,-45.9C-35.2,-53.9,-20.1,-55.7,-5.2,-49.9C9.7,-44,19.3,-30.5,35.8,-54.7Z"/>
    </svg>

    <div class="w-full max-w-2xl relative z-10">

        
        <div class="mb-4 flex items-center justify-between text-xs text-slate-300">
            <button type="button"
                    onclick="window.history.back()"
                    class="inline-flex items-center gap-1 text-slate-300 hover:text-emerald-400 transition">
                <svg class="h-4 w-4" viewBox="0 0 24 24" fill="currentColor">
                    <path d="M15.75 4.75 9.5 11l6.25 6.25-1.5 1.5L6.5 11l7.75-7.75 1.5 1.5Z"/>
                </svg>
                Back
            </button>
            <span class="tracking-[0.18em] uppercase text-emerald-400 font-semibold text-[11px]">
                Add Money
            </span>
        </div>

        
        <div class="rounded-3xl bg-slate-900/85 border border-emerald-500/30 shadow-[0_25px_70px_-35px_rgba(16,185,129,0.75)] backdrop-blur-sm px-4 sm:px-6 py-5">

            
            <div class="mb-4 rounded-2xl border border-amber-400/40 bg-amber-400/10 px-4 py-3 text-[12px] sm:text-[13px] text-amber-100">
                নিজের অ্যাকাউন্টে ব্যালেন্স এড করার আগে অবশ্যই কোম্পানির ডিপোজিট নম্বরগুলো চেক দিয়ে টাকা পাঠাবেন।
                সর্বনিম্ন এড মানি <b>৫০ টাকা</b>।
            </div>

            
            <div class="rounded-2xl border border-slate-700/80 bg-slate-900/70 px-4 py-3 shadow-[0_18px_45px_-30px_rgba(15,118,110,0.8)] mb-4">
                <h3 class="text-[13px] font-semibold text-slate-200 mb-3 flex items-center gap-2">
                    <span class="inline-flex h-6 w-6 items-center justify-center rounded-full bg-emerald-500/15 text-emerald-300 text-xs">
                        💳
                    </span>
                    Payment Method
                </h3>

                <div class="flex items-center gap-3">
                    
                    <div class="h-11 w-11 rounded-xl border border-slate-700 bg-slate-900 overflow-hidden grid place-items-center">
                        <?php if(!empty($method->logo)): ?>
                            <img
                                src="<?php echo e(asset('storage/'.$method->logo)); ?>"
                                alt="<?php echo e($method->name); ?> logo"
                                loading="lazy"
                                class="h-full w-full object-contain p-1.5"
                            >
                        <?php else: ?>
                            <?php $initial = strtoupper(mb_substr($method->name ?? 'P', 0, 1)); ?>
                            <div class="h-full w-full rounded-xl bg-emerald-500/10 text-emerald-300 flex items-center justify-center font-bold text-sm">
                                <?php echo e($initial); ?>

                            </div>
                        <?php endif; ?>
                    </div>

                    <div class="min-w-0">
                        <p class="font-medium text-sm text-slate-50 truncate"><?php echo e($method->name); ?></p>
                        <?php if($method->account_no): ?>
                            <p class="mt-0.5 text-[11px] text-slate-400 font-mono break-all">
                                <?php echo e($method->account_no); ?>

                            </p>
                        <?php endif; ?>
                    </div>

                    <?php if(!empty($method->account_no)): ?>
                        <button type="button"
                                onclick="copyAccount('<?php echo e($method->account_no); ?>')"
                                class="ml-auto inline-flex items-center gap-1.5 text-[11px] rounded-full border border-emerald-500/40 bg-emerald-500/10 px-3 py-1.5 text-emerald-200 hover:bg-emerald-500/20 shadow-sm">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-3.5 w-3.5" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M8 7a2 2 0 0 1 2-2h8a2 2 0 0 1 2 2v10a2 2 0 0 1-2 2h-8a2 2 0 0 1-2-2Zm-3 3V6a2 2 0 0 1 2-2h9v2H7v9H5a2 2 0 0 1-2-2Z"/>
                            </svg>
                            Copy
                        </button>
                    <?php endif; ?>
                </div>
            </div>

            
            <form class="rounded-2xl border border-slate-700/80 bg-slate-900/70 px-4 py-4 sm:py-5 shadow-[0_22px_55px_-28px_rgba(15,118,110,0.85)]"
                  method="post" enctype="multipart/form-data"
                  action="<?php echo e(url('/add-money/'.$method->slug)); ?>">
                <?php echo csrf_field(); ?>

                <h3 class="text-[13px] font-semibold text-slate-200 mb-3 flex items-center gap-2">
                    <span class="inline-flex h-6 w-6 items-center justify-center rounded-full bg-sky-500/15 text-sky-300 text-xs">
                        🧾
                    </span>
                    Payment Details
                </h3>

                
                <label class="block mb-3">
                    <span class="text-[12px] text-slate-300">পেমেন্ট নাম্বার</span>
                    <input name="payer_phone" value="<?php echo e(old('payer_phone')); ?>"
                           class="mt-1 w-full rounded-2xl border-2 border-slate-700 bg-slate-900 px-3 py-2.5 text-sm text-slate-100
                                  outline-none focus:border-emerald-500 focus:ring-2 focus:ring-emerald-500/30
                                  <?php $__errorArgs = ['payer_phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-rose-400 ring-rose-400/40 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                    <?php $__errorArgs = ['payer_phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-xs text-rose-400 mt-1 block"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </label>

                
                <label class="block mb-3">
                    <span class="text-[12px] text-slate-300">টাকার পরিমান</span>
                    <div class="relative mt-1">
                        <span class="pointer-events-none absolute left-3 top-1/2 -translate-y-1/2 text-slate-500 text-xs">৳</span>
                        <input name="amount" type="number" step="0.01" value="<?php echo e(old('amount')); ?>"
                               class="w-full rounded-2xl border-2 border-slate-700 bg-slate-900 pl-7 pr-3 py-2.5 text-sm text-slate-100
                                      outline-none focus:border-emerald-500 focus:ring-2 focus:ring-emerald-500/30
                                      <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-rose-400 ring-rose-400/40 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                    </div>
                    <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-xs text-rose-400 mt-1 block"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </label>

                
                <label class="block mb-4">
                    <span class="text-[12px] text-slate-300">প্রুফ/স্ক্রিনশট (optional)</span>
                    <input type="file" name="proof"
                           class="mt-1 block w-full text-xs text-slate-300
                                  file:mr-4 file:rounded-xl file:border-0 file:bg-emerald-500/10 file:py-2 file:px-4
                                  file:text-emerald-200 hover:file:bg-emerald-500/20">
                    <?php $__errorArgs = ['proof'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-xs text-rose-400 mt-1 block"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </label>

                <div class="flex flex-col sm:flex-row gap-3 mt-2">
                    <a style="padding: 10px 20px"  href="<?php echo e(url('/add-money/methods')); ?>"
                       class="inline-flex justify-center items-center flex-1 h-12 rounded-2xl border border-slate-600 text-[13px] font-medium text-slate-200
                              bg-slate-900 hover:bg-slate-800 shadow-[0_14px_30px_-22px_rgba(15,23,42,0.9)]">
                        Back
                    </a>
                    <button style="padding: 10px 20px" 
                        class="flex-1 h-12 rounded-2xl bg-gradient-to-r from-emerald-500 to-cyan-500 text-[13px] font-semibold text-slate-950
                               shadow-[0_18px_40px_-22px_rgba(16,185,129,0.9)] hover:from-emerald-400 hover:to-cyan-400 transition">
                        Submit Payment
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    function copyAccount(text) {
        if (!text) return;
        navigator.clipboard.writeText(text).then(function () {
            const toast = document.createElement('div');
            toast.textContent = 'Account number copied';
            toast.className =
                'fixed bottom-6 left-1/2 -translate-x-1/2 px-3 py-2 rounded-lg text-white text-xs sm:text-sm shadow-lg z-50';
            toast.style.background = 'rgba(16,185,129,0.95)';
            document.body.appendChild(toast);
            setTimeout(() => toast.remove(), 1300);
        });
    }
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\production_re_banking\resources\views/frontend/add-money/create.blade.php ENDPATH**/ ?>