
<?php $__env->startSection('content'); ?>
<div class="container-fluid py-3">

  <style>
    .card-edge{ border:1px solid #e6e8ef; border-radius:16px; background:#fff; box-shadow:0 4px 18px rgba(17,24,39,.06) }
    .section-title{ font-size:.95rem; font-weight:700; color:#334155 }
    .logo-preview{ height:56px; width:56px; border-radius:12px; object-fit:contain; border:1px solid #e5e7eb; background:#fff; padding:6px }
    @media (max-width:576px){ .btn-wide{ width:100% } }
  </style>

  <div class="d-flex align-items-center gap-2 mb-3">
    <a href="<?php echo e(url('/admin/biller-categories')); ?>" class="btn btn-light border"><i class="fa-solid fa-arrow-left"></i></a>
    <h5 class="mb-0"><i class="fa-solid fa-plus me-2"></i>Create Category</h5>
  </div>

  <form action="<?php echo e(url('/admin/biller-categories')); ?>" method="POST" enctype="multipart/form-data" class="card-edge p-3">
    <?php echo csrf_field(); ?>

    <?php if($errors->any()): ?>
      <div class="alert alert-danger"><ul class="mb-0"><?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $e): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><li><?php echo e($e); ?></li><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?></ul></div>
    <?php endif; ?>

    <div class="section-title mb-2"><i class="fa-regular fa-rectangle-list me-1"></i> Basics</div>
    <div class="row g-3 mb-3">
      <div class="col-md-6">
        <label class="form-label">Name *</label>
        <input name="name" class="form-control" value="<?php echo e(old('name')); ?>" required>
      </div>
      <div class="col-md-6">
        <label class="form-label">Slug</label>
        <input name="slug" class="form-control" value="<?php echo e(old('slug')); ?>" placeholder="auto from name if empty">
      </div>
      <div class="col-md-4">
        <label class="form-label">Status *</label>
        <select name="status" class="form-select" required>
          <option value="active" <?php if(old('status','active')==='active'): echo 'selected'; endif; ?>>Active</option>
          <option value="inactive" <?php if(old('status')==='inactive'): echo 'selected'; endif; ?>>Inactive</option>
        </select>
      </div>
      <div class="col-md-4">
        <label class="form-label">Sort Order</label>
        <input type="number" name="sort_order" class="form-control" value="<?php echo e(old('sort_order',0)); ?>" min="0">
      </div>
    </div>

    <div class="section-title mb-2"><i class="fa-regular fa-image me-1"></i> Icon</div>
    <div class="row g-3 mb-3">
      <div class="col-md-6">
        <label class="form-label">Icon Text / Emoji / Image URL</label>
        <input name="icon" class="form-control" value="<?php echo e(old('icon')); ?>" placeholder="e.g. ⚡ or https://.../icon.png">
        <div class="form-text">ফাইল দিলে এটি ইগনোর হবে।</div>
      </div>
      <div class="col-md-6">
        <label class="form-label">Upload Image</label>
        <input type="file" id="iconFile" name="icon_file" class="form-control" accept="image/*">
        <div class="mt-2 d-none" id="previewWrap">
          <img id="iconPreview" class="logo-preview" src="#" alt="preview">
        </div>
      </div>
    </div>

    <div class="d-flex gap-2 flex-wrap">
      <button class="btn btn-primary btn-wide"><i class="fa-solid fa-floppy-disk me-1"></i> Save</button>
      <a class="btn btn-outline-secondary btn-wide" href="<?php echo e(url('/admin/biller-categories')); ?>">Cancel</a>
    </div>
  </form>
</div>

<script>
  document.getElementById('iconFile')?.addEventListener('change', e=>{
    const f = e.target.files?.[0]; if(!f) return;
    const url = URL.createObjectURL(f);
    const img = document.getElementById('iconPreview');
    img.src = url; document.getElementById('previewWrap').classList.remove('d-none');
  });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ecareba2/new.rkmotorsbike.top/resources/views/backend/billers/categories/create.blade.php ENDPATH**/ ?>