<!doctype html>
<html lang="bn">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" />
     <?php
    $companySetup = \App\Models\CompanySetup::first();
  ?>
    <title><?php echo $__env->yieldContent('title', $companySetup->company_name); ?></title>
 <link rel="icon" href="<?php echo e(asset('storage/'.$companySetup->fav_icon)); ?>" type="image/png">

    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link
        href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@400;600;700&family=Inter:wght@500;600;700&display=swap"
        rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/remixicon@3.5.0/fonts/remixicon.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" />



    <style>
        :root {
            --brand: #22b3af;
            /* main brand */
            --brand-dark: #199591;
            /* darker shade */
            --ink: #0f172a;
            /* slate-900 */
            --muted: #6b7280;
            /* gray-500 */
            --panel: #ffffff;
            /* white panel */
            --ring: #e5e7eb;
            /* gray-200 */
            --shadow: 0 14px 34px rgba(2, 6, 23, 0.12);
        }

        * {
            box-sizing: border-box;
        }

        html,
        body {
            height: 100%;
        }

        body {
            margin: 0;
            font-family: "Inter", "Hind Siliguri", system-ui, -apple-system, "Segoe UI",
                Roboto, Helvetica, Arial, sans-serif;
            color: var(--ink);
            display: flex;
            /* justify-content: center; */
            background: #f6fffe;
            flex-direction: column;

            /* ✅ FIX: one-line, URL-encoded inline SVG background */
            background-image: url("data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg' width='360' height='720' viewBox='0 0 360 720'><defs><linearGradient id='g' x1='0' y1='0' x2='1' y2='1'><stop offset='0' stop-color='%2322B3AF' stop-opacity='.12'/><stop offset='1' stop-color='%23199591' stop-opacity='.08'/></linearGradient></defs><rect width='360' height='720' fill='url(%23g)'/><circle cx='60' cy='80' r='60' fill='%2322B3AF' opacity='.08'/><circle cx='320' cy='120' r='44' fill='%2322B3AF' opacity='.08'/><circle cx='300' cy='620' r='80' fill='%23199591' opacity='.07'/></svg>");
            background-size: cover;
            background-attachment: fixed;

        
           
        }







        .details {
            position: absolute;
            right: 6px;
            top: 6px;
            bottom: 6px;
            padding: 0 12px;
            border-radius: 999px;
            background: #0ea99f;
            border: 1px solid rgba(255, 255, 255, 0.55);
            color: #fff;
            font-weight: 700;
            display: none;
            align-items: center;
        }

        .balance-pill.active .details {
            display: flex;
        }

        .hint {
            font-size: 11px;
            opacity: 0.9;
            margin-top: 6px;
        }


        .sidebar.open {
            display: block;
        }


        .side-btn {
            display: flex;
            align-items: center;
            gap: 10px;
            padding: 12px 12px;
            border-radius: 12px;
            color: #0f172a;
            border: 1px solid transparent;
        }

        .side-btn i {
            color: var(--brand);
        }

        .side-btn:active {
            background: #f1f5f9;
        }

        /* ===== Quick Actions grid ===== */
        .grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 14px;
            padding: 14px;
        }

        .qi {
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 8px;
            text-decoration: none !important;
            color: #003f3d;
            font-size: 17px;
            font-weight: 700;
        }

        a {
            text-decoration: none !important;
        }

        .qi .round {
            width: 65px;
            height: 65px;
            border-radius: 50%;
            background: #ffffff;
            border: 1px solid var(--ring);
            display: grid;
            place-items: center;
            box-shadow: 1px 2px 10px 0px #8d8d8d91;
            padding: 8px;
        }

        /* ===== Bottom bar (simple) ===== */
        .tabbar {
            position: fixed;
            left: 0;
            right: 0;
            bottom: 0;
            z-index: 50;
            display: flex;
            justify-content: center;
            padding: 0 10px env(safe-area-inset-bottom);
            pointer-events: none;
        }

        .tab {
            pointer-events: auto;
            height: 76px;
            background: #fff;
            border: 1px solid var(--ring);
            box-shadow: var(--shadow);
            border-radius: 22px;
            width: min(560px, 96vw);
            display: flex;
            align-items: center;
            justify-content: space-around;
        }

        .tab a {
            display: grid;
            place-items: center;
            gap: 4px;
            text-decoration: none;
            color: #475569;
        }

        .tab a i {
            font-size: 22px;
        }

        .tab small {
            font-size: 12px;
            font-weight: 700;
        }

        .tab .scan {
            width: 56px;
            height: 56px;
            border-radius: 999px;
            background: linear-gradient(145deg, var(--brand), var(--brand-dark));
            color: #fff;
            display: grid;
            place-items: center;
            margin-top: -28px;
            box-shadow: 0 16px 30px rgba(34, 179, 175, 0.35);
        }

        /* mobile only helpers */
        @media (min-width: 768px) {
            body {
                max-width: 480px;
                margin: auto;
            }
        }
    </style>
    <script src="https://cdn.tailwindcss.com"></script>
</head>

<body>
    <!-- Top App Bar -->
    <div style="margin-bottom: 300px!important; display: inline-block; padding-bottom: 200px!important;">



        <!-- Top App Bar -->
        <header
            class="relative overflow-hidden   bg-gradient-to-r from-[#199993] via-[#1FA8A4] to-[#30c3bd] text-white">
            <!-- ডেকোরেটিভ বuble -->
            <div class="pointer-events-none absolute -left-20 -top-24 h-64 w-64 rounded-full bg-white/10 blur-2xl">
            </div>
            <div class="pointer-events-none absolute -right-16 -bottom-24 h-56 w-56 rounded-full bg-black/10 blur-2xl">
            </div>

            <div class="mx-auto max-w-5xl px-4 py-3">
                <div class="flex items-center justify-between">
                    <!-- Back button -->
                    <a href="javascript:history.back()"
                        class="inline-flex h-9 w-9 items-center justify-center rounded-full bg-white/15 hover:bg-white/25 transition shadow-sm">
                        <svg class="h-5 w-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M15 19l-7-7 7-7" />
                        </svg>
                    </a>

               

                    <!-- Title -->
                    <h1 class="text-lg font-extrabold tracking-wide drop-shadow-sm">
                        <?php echo $__env->yieldContent('title'); ?>
                    </h1>

                    <!-- Wallet pill -->
                    <div
                        class="flex items-center gap-2 rounded-full bg-white/25 px-3 py-1.5 shadow-sm backdrop-blur-sm">
                        <span
                            class="inline-flex h-6 w-6 items-center justify-center rounded-md bg-amber-400 text-teal-900">
                            <!-- wallet icon -->
                            <svg class="h-4 w-4" viewBox="0 0 24 24" fill="currentColor">
                                <path
                                    d="M2 7a3 3 0 013-3h11a1 1 0 010 2H5a1 1 0 00-1 1v1h16a2 2 0 012 2v6a2 2 0 01-2 2H4a2 2 0 01-2-2V7z" />
                                <path d="M17 12h3v3h-3a1.5 1.5 0 110-3z" />
                            </svg>
                        </span>
                        <span class="text-sm font-semibold">৳<?php echo e(auth()->user()->balance ?? 0.00); ?></span>
                    </div>
                </div>
            </div>
        </header>



        <?php if(isset($slot)): ?>
            <?php echo e($slot); ?>

        <?php else: ?>
            <?php echo $__env->yieldContent('content'); ?>
        <?php endif; ?>
        <?php echo $__env->make('frontend.common.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    </div>
    </nav>
    <script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
    <script src="<?php echo e(asset('frontend/js/app.js')); ?>"></script>

    <script>
        window.csrf = document.querySelector('meta[name="csrf-token"]').getAttribute('content');

        async function fetchUnreadCount() {
            try {
                const res = await fetch(`<?php echo e(url('/notices/unread-count')); ?>`, { headers: { 'X-Requested-With': 'XMLHttpRequest' } });
                const { count } = await res.json();
                const el = document.getElementById('notice-count');
                if (el) el.textContent = count;
            } catch (e) { }
        }
        // প্রথম লোডে ও নির্দিষ্ট বিরতিতে রিফ্রেশ
        fetchUnreadCount();
        setInterval(fetchUnreadCount, 15000);
    </script>

    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>

</html><?php /**PATH C:\xampp\htdocs\production_re_banking\resources\views/layouts/app.blade.php ENDPATH**/ ?>