 
<?php $__env->startSection('title','অফারগুলো'); ?>

<?php $__env->startPush('styles'); ?>
    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@400;500;600;700&family=Poppins:wght@400;500;600&display=swap" rel="stylesheet">

    <style>
        body {
            font-family: "Hind Siliguri", system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
        }

        @keyframes blobFloat {
            0%   { transform: translate3d(-10%, -10%, 0) scale(1); }
            50%  { transform: translate3d(15%, 10%, 0) scale(1.08); }
            100% { transform: translate3d(40%, -5%, 0) scale(1); }
        }

        @keyframes blobFloat2 {
            0%   { transform: translate3d(40%, 20%, 0) scale(1); }
            50%  { transform: translate3d(5%, 0, 0) scale(1.04); }
            100% { transform: translate3d(-20%, 10%, 0) scale(1); }
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-gradient-to-b from-slate-950 via-slate-900 to-slate-950 flex justify-center items-start px-3 sm:px-4 py-8 relative overflow-hidden">

    
    <svg class="pointer-events-none absolute -top-32 -left-32 w-80 h-80 text-emerald-500/20"
         viewBox="0 0 200 200" xmlns="http://www.w3.org/2000/svg"
         style="animation: blobFloat 18s ease-in-out infinite alternate;">
        <path fill="currentColor"
              d="M45.1,-62C58.8,-54.8,69.1,-39.4,73.4,-22.5C77.7,-5.7,75.9,12.7,67.4,26.8C58.8,40.9,43.4,50.7,27.2,58.2C11,65.7,-6,70.9,-20.4,66.3C-34.7,61.6,-46.4,47.1,-55.3,31.5C-64.3,15.9,-70.4,-0.7,-68.1,-16.7C-65.8,-32.7,-55.1,-48.1,-41.2,-55.6C-27.3,-63.1,-10.1,-62.6,5.7,-69C21.5,-75.3,43,-88.4,45.1,-62Z"/>
    </svg>

    <svg class="pointer-events-none absolute bottom-0 -right-24 w-72 h-72 text-cyan-400/10"
         viewBox="0 0 200 200" xmlns="http://www.w3.org/2000/svg"
         style="animation: blobFloat2 22s ease-in-out infinite alternate;">
        <path fill="currentColor"
              d="M35.8,-54.7C46.3,-47.4,54,-38,60.9,-27.1C67.7,-16.2,73.7,-4.1,71.9,6.8C70.1,17.7,60.5,27.3,50.4,36.6C40.4,46,29.9,55.3,17.3,60.4C4.6,65.6,-10.1,66.6,-24.4,62.4C-38.7,58.3,-52.6,49.1,-59.8,36.3C-66.9,23.4,-67.3,7,-64.6,-8.3C-61.9,-23.6,-56.1,-37.9,-45.7,-45.9C-35.2,-53.9,-20.1,-55.7,-5.2,-49.9C9.7,-44,19.3,-30.5,35.8,-54.7Z"/>
    </svg>

    <div class="w-full max-w-3xl relative z-10">

        
        <div class="mb-4 flex items-center justify-between text-xs text-slate-300">
            <button type="button"
                    onclick="window.history.back()"
                    class="inline-flex items-center gap-1 text-slate-300 hover:text-emerald-400 transition">
                <svg class="h-4 w-4" viewBox="0 0 24 24" fill="currentColor">
                    <path d="M15.75 4.75 9.5 11l6.25 6.25-1.5 1.5L6.5 11l7.75-7.75 1.5 1.5Z"/>
                </svg>
                Back
            </button>
            <span class="tracking-[0.18em] uppercase text-emerald-400 font-semibold text-[11px]">
                Offers
            </span>
        </div>

        
        <div class="rounded-3xl bg-slate-900/80 border border-emerald-500/25 shadow-[0_25px_70px_-35px_rgba(16,185,129,0.7)] backdrop-blur-sm p-4 sm:p-6">

            
            <div class="mb-4 flex items-center gap-3">
                <div class="h-10 w-10 rounded-2xl bg-gradient-to-br from-emerald-500 to-cyan-500 flex items-center justify-center text-white shadow-lg shadow-emerald-500/40">
                    <svg class="h-5 w-5" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M4 7a3 3 0 0 1 3-3h13v2a3 3 0 0 1-3 3H7a3 3 0 0 1-3-3Zm0 6a3 3 0 0 1 3-3h13v7a3 3 0 0 1-3 3H7a3 3 0 0 1-3-3Z"/>
                    </svg>
                </div>
                <div class="flex-1 min-w-0">
                    <div class="text-sm font-semibold text-slate-50 truncate">
                        অফারগুলো
                        <?php if($current): ?>
                            <span class="text-[11px] text-emerald-300/90 ml-1">
                                (<?php echo e($current->name); ?>)
                            </span>
                        <?php endif; ?>
                    </div>
                    <p class="text-[11px] text-slate-400 mt-0.5">
                        আপনার পছন্দের অপারেটর বেছে নিয়ে দ্রুত রিচার্জ অফার অ্যাক্টিভ করুন।
                    </p>
                </div>
            </div>

            
            <?php if(session('success')): ?>
                <div class="mb-3 rounded-2xl border border-emerald-500/40 bg-emerald-500/10 px-3 py-2 text-[11px] text-emerald-100">
                    <?php echo e(session('success')); ?>

                </div>
            <?php endif; ?>
            <?php if($errors->any()): ?>
                <div class="mb-3 rounded-2xl border border-rose-500/40 bg-rose-500/10 px-3 py-2 text-[11px] text-rose-100">
                    <ul class="list-disc list-inside space-y-0.5">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $e): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($e); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>

            <?php if($operators->isEmpty()): ?>
                <div class="mt-2 rounded-2xl border border-slate-700 bg-slate-900/80 px-4 py-5 text-center text-sm text-slate-400">
                    কোনো অ্যাকটিভ অপারেটর নেই।
                </div>
            <?php else: ?>
                
                <div class="mb-4 flex gap-3 overflow-x-auto pb-1">
                    <?php $__currentLoopData = $operators; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $op): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php 
                            $active  = ($current && $op->id === $current->id);
                            $initial = mb_strtoupper(mb_substr($op->name ?? 'O', 0, 1, 'UTF-8'), 'UTF-8');
                        ?>
                        <a href="<?php echo e(route('offers.index', ['op' => $op->code])); ?>"
                           class="flex min-w-[130px] items-center gap-3 rounded-2xl border px-3 py-2 text-xs shadow-sm transition
                                  <?php echo e($active
                                      ? 'border-emerald-500/60 bg-emerald-500/10 shadow-[0_0_0_1px_rgba(16,185,129,0.35)]'
                                      : 'border-slate-700/80 bg-slate-900/70 hover:bg-slate-800/80 hover:border-emerald-500/40'); ?>">
                            
                            <div class="h-8 w-8 rounded-2xl bg-emerald-500/90 flex items-center justify-center text-[13px] font-bold text-slate-950 shadow-[0_3px_10px_-6px_rgba(0,0,0,.9)]">
                                <?php echo e($initial); ?>

                            </div>
                            <div class="truncate text-[12px] font-medium <?php echo e($active ? 'text-emerald-300' : 'text-slate-200'); ?>">
                                <?php echo e($op->name); ?>

                            </div>
                        </a>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>

                
                <div class="space-y-3">
                    <?php $__empty_1 = true; $__currentLoopData = $offers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $offer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <?php
                            $opName   = $offer->operator->name ?? ($current->name ?? 'Offer');
                            $opInitial = mb_strtoupper(mb_substr($opName, 0, 1, 'UTF-8'), 'UTF-8');
                        ?>
                        <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-3 rounded-2xl border border-slate-700/80 bg-slate-900/70 px-4 py-3 shadow-sm hover:shadow-[0_18px_45px_-30px_rgba(16,185,129,0.7)] hover:border-emerald-500/40 transition">
                            <div class="flex items-start gap-3">
                                
                                <div class="mt-0.5 h-8 w-8 rounded-2xl bg-cyan-500/90 flex items-center justify-center text-[13px] font-bold text-slate-950 shadow-[0_3px_10px_-6px_rgba(0,0,0,.9)]">
                                    <?php echo e($opInitial); ?>

                                </div>
                                <div class="min-w-0">
                                    <div class="truncate text-sm font-semibold text-slate-50">
                                        <?php echo e($offer->title); ?>

                                    </div>
                                    <div class="mt-1 text-[11px] text-slate-400 space-x-1">
                                        <?php if($offer->validity_days): ?>
                                            <span>মেয়াদ: <?php echo e($offer->validity_days); ?> দিন</span>
                                        <?php endif; ?>
                                        <?php if($offer->data_gb): ?>
                                            <span>• ডাটা: <?php echo e($offer->data_gb); ?>GB</span>
                                        <?php endif; ?>
                                        <?php if($offer->minutes): ?>
                                            <span>• মিনিট: <?php echo e($offer->minutes); ?></span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>

                            <div class="shrink-0 text-right">
                                <div class="text-lg font-bold text-emerald-300 leading-tight">
                                    ৳<?php echo e(number_format($offer->sale_price ?: $offer->regular_price, 2)); ?>

                                </div>
                                <?php if($offer->sale_price > 0): ?>
                                    <div class="text-[11px] text-slate-500 line-through">
                                        ৳<?php echo e(number_format($offer->regular_price,2)); ?>

                                    </div>
                                <?php endif; ?>

                                <a href="<?php echo e(route('offers.show', $offer)); ?>"
                                   class="mt-2 inline-flex items-center rounded-full bg-gradient-to-r from-emerald-500 to-cyan-500 px-3 py-1.5 text-[11px] font-semibold text-slate-950
                                          shadow-[0_10px_30px_-18px_rgba(16,185,129,0.9)] hover:from-emerald-400 hover:to-cyan-400 transition">
                                    কিনুন
                                </a>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <div class="mt-2 rounded-2xl border border-slate-700 bg-slate-900/80 px-4 py-5 text-center text-sm text-slate-400">
                            এই অপারেটরে কোনো অফার নেই।
                        </div>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ecareba2/new.rkmotorsbike.top/resources/views/frontend/offers/index.blade.php ENDPATH**/ ?>