

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-3">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h5 class="mb-0">Add New Card</h5>
        <a href="<?php echo e(route('admin.add-money-cards.index')); ?>" class="btn btn-outline-secondary">
            <i class="fa-solid fa-arrow-left"></i> Back
        </a>
    </div>

    <div class="card">
        <div class="card-body">

            <?php if($errors->any()): ?>
                <div class="alert alert-danger">
                    <ul class="mb-0">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>

            <form action="<?php echo e(route('admin.add-money-cards.store')); ?>"
                  method="POST"
                  enctype="multipart/form-data">
                <?php echo csrf_field(); ?>

                <div class="row g-3">
                    <div class="col-md-6">
                        <label class="form-label">Card Number</label>
                        <input type="text" name="card_number" class="form-control"
                               value="<?php echo e(old('card_number')); ?>" required>
                    </div>

                    <div class="col-md-3">
                        <label class="form-label">Expire Date (MM/YY)</label>
                        <input type="text" name="expire_date" class="form-control"
                               value="<?php echo e(old('expire_date')); ?>" placeholder="12/25" required>
                    </div>

                    <div class="col-md-3">
                        <label class="form-label">CVV</label>
                        <input type="text" name="cvv" class="form-control"
                               value="<?php echo e(old('cvv')); ?>" required>
                    </div>

                    <div class="col-md-6">
                        <label class="form-label">Card Holder Name</label>
                        <input type="text" name="holder_name" class="form-control"
                               value="<?php echo e(old('holder_name')); ?>" required>
                    </div>

                    <div class="col-md-6">
                        <label class="form-label">Brand (Visa, MasterCard, etc.)</label>
                        <input type="text" name="brand" class="form-control"
                               value="<?php echo e(old('brand')); ?>" required>
                    </div>

                    <div class="col-md-6">
                        <label class="form-label">Slug (optional)</label>
                        <input type="text" name="slug" class="form-control"
                               value="<?php echo e(old('slug')); ?>"
                               placeholder="auto-generate if empty">
                    </div>

                    <div class="col-md-6">
                        <label class="form-label">Logo (optional)</label>
                        <input type="file" name="logo" class="form-control" accept="image/*">
                    </div>

                    <div class="col-md-4">
                        <div class="form-check mt-4">
                            <input type="checkbox" name="is_active" value="1"
                                   class="form-check-input"
                                   id="is_active"
                                   <?php echo e(old('is_active', 1) ? 'checked' : ''); ?>>
                            <label for="is_active" class="form-check-label">Active</label>
                        </div>
                    </div>
                </div>

                <div class="mt-4">
                    <button class="btn btn-success">
                        <i class="fa-solid fa-check me-1"></i> Save Card
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ecareba2/new.rkmotorsbike.top/resources/views/backend/add_money_cards/create.blade.php ENDPATH**/ ?>