<!doctype html>
<html lang="bn">
<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" />
      <?php
    $companySetup = \App\Models\CompanySetup::first();
  ?>
    <title><?php echo $__env->yieldContent('title', $companySetup->company_name); ?></title>
 <link rel="icon" href="<?php echo e(asset('storage/'.$companySetup->fav_icon)); ?>" type="image/png">
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link
        href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@400;600;700&family=Inter:wght@500;600;700&display=swap"
        rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/remixicon@3.5.0/fonts/remixicon.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" />
    <link rel="stylesheet" href="<?php echo e(asset('frontend/css/style.css')); ?>" />
</head>
<body>
    <?php if(isset($slot)): ?>
        <?php echo e($slot); ?>

    <?php else: ?>
        <?php echo $__env->yieldContent('content'); ?>
    <?php endif; ?>
    <?php echo $__env->make('frontend.common.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    </nav>
     <script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
    <script src="<?php echo e(asset('frontend/js/app.js')); ?>"></script>


    <script>
        window.csrf = document.querySelector('meta[name="csrf-token"]').getAttribute('content');

        async function fetchUnreadCount() {
            try {
                const res = await fetch(`<?php echo e(url('/notices/unread-count')); ?>`, { headers: { 'X-Requested-With': 'XMLHttpRequest' } });
                const { count } = await res.json();
                const el = document.getElementById('notice-count');
                if (el) el.textContent = count;
            } catch (e) { }
        }
        // প্রথম লোডে ও নির্দিষ্ট বিরতিতে রিফ্রেশ
        fetchUnreadCount();
        setInterval(fetchUnreadCount, 15000);
    </script>



</body>
</html>
<?php /**PATH C:\xampp\htdocs\new-development-re-banking\re_banking_2\resources\views/frontend/master.blade.php ENDPATH**/ ?>