<?php $__env->startSection('content'); ?>
<div class="w-full px-4 sm:px-6 lg:px-8 py-6">
    <div class="flex items-center justify-between mb-6">
        <h1 class="text-2xl font-bold tracking-tight">Admin Dashboard</h1>
    </div>

    
    <?php
        $items = [
            ['title' => 'Total Deposits',         'value' => number_format($cards['total_deposits_count'])],
            ['title' => 'Pending Deposits',       'value' => number_format($cards['pending_deposits_count'])],
            ['title' => 'Approved Deposit Sum',   'value' => number_format($cards['approved_deposits_sum'], 2)],
            ['title' => 'Transfers Count',        'value' => number_format($cards['transfers_count'])],
            ['title' => 'Transfers Sum',          'value' => number_format($cards['transfers_sum'], 2)],
            ['title' => 'Purchases Pending',      'value' => number_format($cards['purchases_pending'])],
            ['title' => 'Recharges Pending',      'value' => number_format($cards['recharges_pending'])],
            ['title' => 'Bills Pending',          'value' => number_format($cards['bill_payments_pending'])],
            ['title' => 'Loan Apps Pending',      'value' => number_format($cards['loan_applications_pending'])],
            ['title' => 'Loan Repayments Due',    'value' => number_format($cards['loan_repayments_due'])],
            ['title' => 'Mobile Txn Pending',     'value' => number_format($cards['mobile_txn_pending'])],
            ['title' => 'Bank Transfers Pending', 'value' => number_format($cards['bank_transfers_pending'])],
        ];

        // 12 distinct color palettes (purge-safe static classes)
        $palettes = [
            ['bg'=>'bg-blue-50',     'border'=>'border-blue-200',    'text'=>'text-blue-700',     'bar'=>'bg-blue-500'],
            ['bg'=>'bg-indigo-50',   'border'=>'border-indigo-200',  'text'=>'text-indigo-700',   'bar'=>'bg-indigo-500'],
            ['bg'=>'bg-violet-50',   'border'=>'border-violet-200',  'text'=>'text-violet-700',   'bar'=>'bg-violet-500'],
            ['bg'=>'bg-fuchsia-50',  'border'=>'border-fuchsia-200', 'text'=>'text-fuchsia-700',  'bar'=>'bg-fuchsia-500'],
            ['bg'=>'bg-pink-50',     'border'=>'border-pink-200',    'text'=>'text-pink-700',     'bar'=>'bg-pink-500'],
            ['bg'=>'bg-rose-50',     'border'=>'border-rose-200',    'text'=>'text-rose-700',     'bar'=>'bg-rose-500'],
            ['bg'=>'bg-red-50',      'border'=>'border-red-200',     'text'=>'text-red-700',      'bar'=>'bg-red-500'],
            ['bg'=>'bg-orange-50',   'border'=>'border-orange-200',  'text'=>'text-orange-700',   'bar'=>'bg-orange-500'],
            ['bg'=>'bg-amber-50',    'border'=>'border-amber-200',   'text'=>'text-amber-700',    'bar'=>'bg-amber-500'],
            ['bg'=>'bg-lime-50',     'border'=>'border-lime-200',    'text'=>'text-lime-700',     'bar'=>'bg-lime-500'],
            ['bg'=>'bg-emerald-50',  'border'=>'border-emerald-200', 'text'=>'text-emerald-700',  'bar'=>'bg-emerald-500'],
            ['bg'=>'bg-cyan-50',     'border'=>'border-cyan-200',    'text'=>'text-cyan-700',     'bar'=>'bg-cyan-500'],
        ];
    ?>

    <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 xl:grid-cols-4 gap-4">
        <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $card): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php $p = $palettes[$i % count($palettes)]; ?>
            <div class="relative overflow-hidden rounded-2xl border <?php echo e($p['border']); ?> <?php echo e($p['bg']); ?> shadow-sm hover:shadow transition-shadow">
                
                <div class="absolute inset-y-0 left-0 w-1.5 <?php echo e($p['bar']); ?>"></div>
                <div class="p-4 pl-5">
                    <div class="text-sm text-gray-600"><?php echo e($card['title']); ?></div>
                    <div class="mt-1 text-2xl font-semibold <?php echo e($p['text']); ?>"><?php echo e($card['value']); ?></div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 mt-8">
        <div class="rounded-2xl border border-gray-200 bg-white shadow-sm p-4">
            <div class="flex items-center justify-between mb-3">
                <h2 class="font-semibold">14-Day Total Amount (All Modules)</h2>
            </div>
            <div class="relative h-72 sm:h-80 md:h-96">
                <canvas id="lineChart" aria-label="Total amounts over last 14 days" role="img"></canvas>
            </div>
        </div>

        <div class="rounded-2xl border border-gray-200 bg-white shadow-sm p-4">
            <div class="flex items-center justify-between mb-3">
                <h2 class="font-semibold">Amount by Module (Overall)</h2>
            </div>
            <div class="relative h-72 sm:h-80 md:h-96">
                <canvas id="barChart" aria-label="Overall amounts by module" role="img"></canvas>
            </div>
        </div>
    </div>
</div>


<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    // Blade -> JS data
    const labels        = <?php echo json_encode($labels, 15, 512) ?>;
    const dailyTotals   = <?php echo json_encode($dailyTotals, 15, 512) ?>;
    const moduleTotals  = <?php echo json_encode(array_values($moduleTotals), 15, 512) ?>;
    const moduleLabels  = <?php echo json_encode(array_keys($moduleTotals), 15, 512) ?>;

    // Fallback to zeros so Chart.js renders cleanly if dataset is empty
    const safeDailyTotals  = (Array.isArray(dailyTotals) && dailyTotals.length) ? dailyTotals : Array(14).fill(0);
    const safeModuleTotals = (Array.isArray(moduleTotals) && moduleTotals.length) ? moduleTotals : Array(moduleLabels.length).fill(0);

    // Line Chart (14 days total)
    const lineCtx = document.getElementById('lineChart').getContext('2d');
    const lineChart = new Chart(lineCtx, {
        type: 'line',
        data: {
            labels: labels,
            datasets: [{
                label: 'Total Amount',
                data: safeDailyTotals,
                fill: false,
                tension: 0.3,
                pointRadius: 3,
                pointHoverRadius: 5,
                borderWidth: 2,
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            interaction: { intersect: false, mode: 'index' },
            scales: {
                y: { beginAtZero: true, ticks: { precision: 0 } },
                x: { ticks: { maxRotation: 0 } }
            },
            plugins: {
                legend: { display: true },
                tooltip: { callbacks: { label: ctx => ` ${ctx.dataset.label}: ${Number(ctx.parsed.y).toLocaleString()}` } }
            }
        }
    });

    // Bar Chart (module totals)
    const barCtx = document.getElementById('barChart').getContext('2d');
    const barChart = new Chart(barCtx, {
        type: 'bar',
        data: {
            labels: moduleLabels,
            datasets: [{
                label: 'Total Amount',
                data: safeModuleTotals,
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                x: { ticks: { autoSkip: false } },
                y: { beginAtZero: true }
            },
            plugins: {
                legend: { display: true },
                tooltip: { callbacks: { label: ctx => ` ${ctx.dataset.label}: ${Number(ctx.parsed.y).toLocaleString()}` } }
            }
        }
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ecareba2/new.rkmotorsbike.top/resources/views/backend/dashboard.blade.php ENDPATH**/ ?>