<?php $__env->startSection('title','Offer Details'); ?>

<?php $__env->startPush('styles'); ?>
    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@400;500;600;700&family=Poppins:wght@400;500;600&display=swap" rel="stylesheet">

    <style>
        body {
            font-family: "Hind Siliguri", system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
        }

        @keyframes blobFloat {
            0%   { transform: translate3d(-10%, -10%, 0) scale(1); }
            50%  { transform: translate3d(15%, 10%, 0) scale(1.08); }
            100% { transform: translate3d(40%, -5%, 0) scale(1); }
        }

        @keyframes blobFloat2 {
            0%   { transform: translate3d(40%, 20%, 0) scale(1); }
            50%  { transform: translate3d(5%, 0, 0) scale(1.04); }
            100% { transform: translate3d(-20%, 10%, 0) scale(1); }
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<?php
    $user = auth()->user();
?>
<div class="min-h-screen bg-gradient-to-b from-slate-950 via-slate-900 to-slate-950 flex justify-center items-start px-3 sm:px-4 py-8 relative overflow-hidden">

    
    <svg class="pointer-events-none absolute -top-32 -left-32 w-80 h-80 text-emerald-500/20"
         viewBox="0 0 200 200" xmlns="http://www.w3.org/2000/svg"
         style="animation: blobFloat 18s ease-in-out infinite alternate;">
        <path fill="currentColor"
              d="M45.1,-62C58.8,-54.8,69.1,-39.4,73.4,-22.5C77.7,-5.7,75.9,12.7,67.4,26.8C58.8,40.9,43.4,50.7,27.2,58.2C11,65.7,-6,70.9,-20.4,66.3C-34.7,61.6,-46.4,47.1,-55.3,31.5C-64.3,15.9,-70.4,-0.7,-68.1,-16.7C-65.8,-32.7,-55.1,-48.1,-41.2,-55.6C-27.3,-63.1,-10.1,-62.6,5.7,-69C21.5,-75.3,43,-88.4,45.1,-62Z"/>
    </svg>

    <svg class="pointer-events-none absolute bottom-0 -right-24 w-72 h-72 text-cyan-400/10"
         viewBox="0 0 200 200" xmlns="http://www.w3.org/2000/svg"
         style="animation: blobFloat2 22s ease-in-out infinite alternate;">
        <path fill="currentColor"
              d="M35.8,-54.7C46.3,-47.4,54,-38,60.9,-27.1C67.7,-16.2,73.7,-4.1,71.9,6.8C70.1,17.7,60.5,27.3,50.4,36.6C40.4,46,29.9,55.3,17.3,60.4C4.6,65.6,-10.1,66.6,-24.4,62.4C-38.7,58.3,-52.6,49.1,-59.8,36.3C-66.9,23.4,-67.3,7,-64.6,-8.3C-61.9,-23.6,-56.1,-37.9,-45.7,-45.9C-35.2,-53.9,-20.1,-55.7,-5.2,-49.9C9.7,-44,19.3,-30.5,35.8,-54.7Z"/>
    </svg>

    <div class="w-full max-w-md relative z-10">

        
        <div class="mb-4 flex items-center justify-between text-xs text-slate-300">
            <a href="<?php echo e(route('offers.index', ['op' => $offer->operator?->code])); ?>"
               class="inline-flex items-center gap-1 text-slate-300 hover:text-emerald-400 transition">
                <svg class="h-4 w-4" viewBox="0 0 24 24" fill="currentColor">
                    <path d="M15.75 4.75 9.5 11l6.25 6.25-1.5 1.5L6.5 11l7.75-7.75 1.5 1.5Z"/>
                </svg>
                Other offers
            </a>
            <span class="tracking-[0.18em] uppercase text-emerald-400 font-semibold text-[11px]">
                Offer Details
            </span>
        </div>

        
        <div class="rounded-3xl bg-slate-900/80 border border-emerald-500/25 shadow-[0_25px_70px_-35px_rgba(16,185,129,0.7)] backdrop-blur-sm p-5 sm:p-6">

            
            <?php if(session('success')): ?>
                <div class="mb-3 rounded-2xl border border-emerald-500/40 bg-emerald-500/10 px-3 py-2 text-[11px] text-emerald-100">
                    <?php echo e(session('success')); ?>

                </div>
            <?php endif; ?>

            
            <div class="mb-4 rounded-2xl border border-slate-700/80 bg-slate-900/70 p-4 shadow-sm">
                <div class="mb-3 flex items-center gap-3">
                    <?php if($offer->operator?->logo): ?>
                        <img src="<?php echo e(asset('storage/'.$offer->operator->logo)); ?>"
                             alt="<?php echo e($offer->operator?->name); ?>"
                             class="h-9 w-9 rounded-xl shadow-[0_3px_10px_-6px_rgba(0,0,0,.75)] object-cover bg-slate-800">
                    <?php else: ?>
                        <div class="h-9 w-9 rounded-xl bg-slate-800/80 flex items-center justify-center text-xs text-slate-200">
                            <?php echo e(Str::limit($offer->operator?->name, 2, '')); ?>

                        </div>
                    <?php endif; ?>

                    <div class="text-[12px] text-slate-300">
                        <?php echo e($offer->operator?->name ?? 'Operator'); ?>

                    </div>

                    <span class="ml-auto inline-flex items-center rounded-full border px-2.5 py-1 text-[10px] font-semibold
                                 <?php echo e($offer->status === 'active'
                                    ? 'border-emerald-500/40 bg-emerald-500/10 text-emerald-200'
                                    : 'border-rose-500/40 bg-rose-500/10 text-rose-100'); ?>">
                        <?php echo e($offer->status === 'active' ? 'Active' : 'Inactive'); ?>

                    </span>
                </div>

                <h1 class="text-lg sm:text-xl font-bold text-slate-50 leading-snug">
                    <?php echo e($offer->title); ?>

                </h1>

                <div class="mt-3 flex items-end justify-between gap-4">
                    <div>
                        <div class="text-2xl font-extrabold text-emerald-300">
                            ৳<?php echo e(number_format($offer->sale_price ?: $offer->regular_price, 2)); ?>

                        </div>
                        <?php if($offer->sale_price > 0): ?>
                            <div class="text-[11px] text-slate-500 line-through">
                                ৳<?php echo e(number_format($offer->regular_price,2)); ?>

                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="text-right text-[11px] text-slate-400 leading-relaxed">
                        <?php if($offer->validity_days): ?> Validity: <?php echo e($offer->validity_days); ?> days<br><?php endif; ?>
                        <?php if($offer->data_gb): ?> Data: <?php echo e($offer->data_gb); ?> GB<br><?php endif; ?>
                        <?php if($offer->minutes): ?> Minutes: <?php echo e($offer->minutes); ?> <?php endif; ?>
                    </div>
                </div>
            </div>

            
            <form method="POST" action="<?php echo e(route('offers.purchase', $offer)); ?>" class="space-y-4">
                <?php echo csrf_field(); ?>

                
                <div class="space-y-1">
                    <label class="text-[11px] font-semibold tracking-wide text-slate-300 uppercase">
                        Mobile Number (MSISDN)
                    </label>
                    <div class="relative">
                        <span class="pointer-events-none absolute inset-y-0 left-3 flex items-center text-emerald-400">
                            <svg class="h-4 w-4" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M6.62 10.79a15.05 15.05 0 0 0 6.59 6.59l2.2-2.2a1 1 0 0 1 1-.24 11.36 11.36 0 0 0 3.56.57 1 1 0 0 1 1 1V20a2 2 0 0 1-2 2A17.62 17.62 0 0 1 2 4a2 2 0 0 1 2-2h3.5a1 1 0 0 1 1 1 11.36 11.36 0 0 0 .57 3.56 1 1 0 0 1-.24 1Z"/>
                            </svg>
                        </span>
                        <input type="text"
                               name="msisdn"
                               value="<?php echo e(old('msisdn')); ?>"
                               class="w-full rounded-2xl border-2 bg-slate-950/70 pl-9 pr-4 py-2.5 text-sm text-slate-100 outline-none transition
                                      border-slate-700 focus:border-emerald-400 focus:ring-2 focus:ring-emerald-500/30 placeholder-slate-500
                                      <?php $__errorArgs = ['msisdn'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-rose-500 focus:ring-rose-500/30 focus:border-rose-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                               placeholder="+8801XXXXXXXXX"
                               required>
                    </div>
                    <?php $__errorArgs = ['msisdn'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="mt-0.5 text-[11px] text-rose-300"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                
                <div class="space-y-1">
                    <label class="text-[11px] font-semibold tracking-wide text-slate-300 uppercase">
                        Reference (optional)
                    </label>
                    <div class="relative">
                        <input type="text"
                               name="reference"
                               value="<?php echo e(old('reference')); ?>"
                               class="w-full rounded-2xl border-2 bg-slate-950/70 px-4 py-2.5 text-sm text-slate-100 outline-none transition
                                      border-slate-700 focus:border-emerald-400 focus:ring-2 focus:ring-emerald-500/30 placeholder-slate-500
                                      <?php $__errorArgs = ['reference'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-rose-500 focus:ring-rose-500/30 focus:border-rose-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                               placeholder="Your own note / reference">
                    </div>
                    <?php $__errorArgs = ['reference'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="mt-0.5 text-[11px] text-rose-300"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                
                <div class="space-y-1">
                    <label class="text-[11px] font-semibold tracking-wide text-slate-300 uppercase">
                        PIN (4 digits) <span class="text-rose-400">*</span>
                    </label>
                    <div class="relative">
                        <span class="pointer-events-none absolute inset-y-0 left-3 flex items-center text-slate-400">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M12 2a5 5 0 0 0-5 5v2H6.5A2.5 2.5 0 0 0 4 11.5v7A2.5 2.5 0 0 0 6.5 21h11a2.5 2.5 0 0 0 2.5-2.5v-7A2.5 2.5 0 0 0 17.5 9H17V7a5 5 0 0 0-5-5Zm-3 7V7a3 3 0 0 1 6 0v2Z"/>
                            </svg>
                        </span>
                        <input type="password"
                               name="login_pin"
                               maxlength="4"
                               inputmode="numeric"
                               pattern="\d*"
                               class="w-full rounded-2xl border-2 bg-slate-950/70 pl-9 pr-4 py-2.5 text-sm text-slate-100 outline-none transition
                                      border-slate-700 focus:border-emerald-400 focus:ring-2 focus:ring-emerald-500/30 placeholder-slate-500
                                      text-center tracking-[0.3em]
                                      <?php $__errorArgs = ['login_pin'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-rose-500 focus:ring-rose-500/30 focus:border-rose-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                               placeholder="••••"
                               autocomplete="off">
                    </div>
                    <?php $__errorArgs = ['login_pin'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="mt-0.5 text-[11px] text-rose-300"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                
                <?php if($errors->any() && !$errors->has('msisdn') && !$errors->has('reference') && !$errors->has('login_pin')): ?>
                    <div class="rounded-2xl border border-rose-500/40 bg-rose-500/10 px-3 py-2 text-[11px] text-rose-100">
                        Please check the form and try again.
                    </div>
                <?php endif; ?>

                
                <button
                    class="mt-1 w-full rounded-2xl bg-gradient-to-r from-emerald-500 to-cyan-500 px-5 py-2.5 text-center text-sm font-semibold text-slate-950
                           shadow-[0_18px_45px_-20px_rgba(16,185,129,0.9)] hover:from-emerald-400 hover:to-cyan-400 active:scale-[0.98] transition-transform">
                    Confirm Purchase
                </button>

                <div class="mt-2 text-center text-[11px] text-slate-400">
                    Your current balance:
                    <b class="text-emerald-300">৳<?php echo e(number_format($user->balance ?? 0, 2)); ?></b>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\new-development-re-banking\re_banking_1\resources\views/frontend/offers/show.blade.php ENDPATH**/ ?>