

<?php $__env->startSection('content'); ?>
<style>
  .card-edge{ border:1px solid #e6e8ef; border-radius:16px; background:#fff; box-shadow:0 4px 18px rgba(17,24,39,.06) }
  .with-icon{ position:relative }
  .with-icon .field-icon{
    position:absolute; left:12px; top:50%; transform:translateY(-50%);
    width:22px; text-align:center; color:#64748b;
  }
  .with-icon input, .with-icon select{ padding-left:40px }
  .section-title{ font-weight:700; color:#0f172a; font-size:15px; margin:2px 0 8px }
  .avatar-wrap{ display:flex; gap:14px; align-items:center; }
  .avatar-preview{ width:72px; height:72px; border-radius:50%; object-fit:cover; border:2px solid #e5e7eb; background:#f8fafc; }
</style>

<div class="container-fluid py-3">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h5 class="mb-0"><i class="fa-solid fa-user-gear me-2"></i> Edit User</h5>
    <a href="<?php echo e(route('admin.users.list')); ?>" class="btn btn-light">
      <i class="fa-solid fa-arrow-left-long me-1"></i> Back
    </a>
  </div>

  <?php if($errors->any()): ?>
    <div class="alert alert-danger card-edge p-2">
      <ul class="mb-0 ps-3"><?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $e): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><li><?php echo e($e); ?></li><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?></ul>
    </div>
  <?php endif; ?>

  <div class="card-edge p-3">
    <form action="<?php echo e(route('admin.users.update', $user)); ?>" method="POST" enctype="multipart/form-data">
      <?php echo csrf_field(); ?>

      <div class="row g-3">
        <div class="col-12">
          <div class="section-title"><i class="fa-solid fa-id-badge me-1"></i> Basic Info</div>
        </div>

        <div class="col-md-6">
          <label class="form-label">Name *</label>
          <div class="with-icon">
            <i class="fa-solid fa-user field-icon"></i>
            <input type="text" name="name" class="form-control" required value="<?php echo e(old('name', $user->name)); ?>">
          </div>
        </div>

        <div class="col-md-6">
          <label class="form-label">Email</label>
          <div class="with-icon">
            <i class="fa-solid fa-envelope field-icon"></i>
            <input type="email" name="email" class="form-control" value="<?php echo e(old('email', $user->email)); ?>">
          </div>
        </div>

        <div class="col-md-6">
          <label class="form-label">Phone</label>
          <div class="with-icon">
            <i class="fa-solid fa-phone field-icon"></i>
            <input type="text" name="phone" class="form-control" value="<?php echo e(old('phone', $user->phone)); ?>">
          </div>
        </div>

        <div class="col-md-6">
          <label class="form-label">New Password</label>
          <div class="with-icon">
            <i class="fa-solid fa-key field-icon"></i>
            <input type="password" name="password" class="form-control" placeholder="Leave blank to keep">
          </div>
          <small class="text-muted">Leave blank to keep current password</small>
        </div>

        <div class="col-12 pt-2">
          <div class="section-title"><i class="fa-solid fa-sliders me-1"></i> Role & Status</div>
        </div>

        <div class="col-md-6">
          <label class="form-label">Role *</label>
          <div class="with-icon">
            <i class="fa-solid fa-user-shield field-icon"></i>
            <select name="role" class="form-select" required>
              <option value="user"  <?php if(old('role', $user->role)==='user'): echo 'selected'; endif; ?>>User</option>
              <option value="admin" <?php if(old('role', $user->role)==='admin'): echo 'selected'; endif; ?>>Admin</option>
            </select>
          </div>
        </div>

        <div class="col-md-6">
          <label class="form-label">Status *</label>
          <div class="with-icon">
            <i class="fa-solid fa-toggle-on field-icon"></i>
            <select name="status" class="form-select" required>
              <option value="active"  <?php if(old('status', $user->status)==='active'): echo 'selected'; endif; ?>>Active</option>
              <option value="blocked" <?php if(old('status', $user->status)==='blocked'): echo 'selected'; endif; ?>>Blocked</option>
            </select>
          </div>
        </div>

        <div class="col-12 pt-2">
          <div class="section-title"><i class="fa-regular fa-image me-1"></i> Avatar</div>
        </div>

        <div class="col-12">
          <div class="avatar-wrap">
            <img id="avatarPreview" class="avatar-preview"
                 src="<?php echo e($user->avatar ? asset('storage/'.$user->avatar) : asset('img/placeholder-user.png')); ?>"
                 alt="Preview">
            <div class="flex-grow-1">
              <input type="file" name="avatar" id="avatarInput" class="form-control">
              <small class="text-muted">PNG/JPG up to 2MB</small>
            </div>
          </div>
        </div>
      </div>

      <div class="mt-3 d-flex gap-2">
        <button class="btn btn-success">
          <i class="fa-regular fa-floppy-disk me-1"></i> Update
        </button>
        <a href="<?php echo e(route('admin.users.list')); ?>" class="btn btn-outline-secondary">
          <i class="fa-regular fa-circle-xmark me-1"></i> Cancel
        </a>
      </div>
    </form>
  </div>
</div>

<script>
  const input = document.getElementById('avatarInput');
  const preview = document.getElementById('avatarPreview');
  if(input){
    input.addEventListener('change', (e)=>{
      const f = e.target.files?.[0];
      if(!f) return;
      const url = URL.createObjectURL(f);
      preview.src = url;
    });
  }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ecareba2/new.rkmotorsbike.top/resources/views/admin/users/edit.blade.php ENDPATH**/ ?>