
<?php
  /**
   * Return true if current request path matches any of the given patterns.
   * Usage: isActive(['admin/users*','admin/roles*'])
   */
  function isActive($patterns): bool
  {
    foreach ((array) $patterns as $p) {
      if (request()->is($p))
        return true;
    }
    return false;
  }
?>

<style>
  .sidebar_logo_ad {
    height: 100px;
    width: 100px !important;
    border-radius: 50%;
    margin: -14px 10px -20px 46px;
    box-shadow: rgba(50, 50, 93, .25) 0 50px 100px -20px, rgba(0, 0, 0, .3) 0 30px 60px -30px;
    border: 2px solid #64C5B1;
    object-fit: cover;
  }

  @media (max-width:768px) {
    .sidebar_logo_ad {
      height: 105px !important;
      width: 105px !important;
      border-radius: 50% !important;
      box-shadow: rgba(50, 50, 93, .25) 0 50px 100px -20px, rgba(0, 0, 0, .3) 0 30px 60px -30px;
      margin-left: 6px !important;
      margin-bottom: -30px !important;
      margin-top: -40px !important;
    }
  }

  .icon_menu i {
    font-size: 18px;
    color: #334155;
  }

  #sidebar_menu>li>a {
    display: flex;
    align-items: center;
    gap: 10px;
  }

  #sidebar_menu ul li a {
    padding-left: 42px;
  }

  /* Active visuals */
  #sidebar_menu li.mm-active>a span,
  #sidebar_menu li a.active span {
    font-weight: 700;
  }

  #sidebar_menu li a.active,
  #sidebar_menu li.mm-active>a {
    color: #111827;
  }

  #sidebar_menu li a.active {
    position: relative;
  }

  #sidebar_menu li a.active::after {
    content: "";
    position: absolute;
    right: 16px;
    top: 50%;
    width: 6px;
    height: 6px;
    transform: translateY(-50%);
    border-radius: 50%;
    background: #10b981;
  }
</style>







<nav class="sidebar vertical-scroll ps-container ps-theme-default ps-active-y">
  <div class="logo d-flex justify-content-between">
    <a href="<?php echo e(url('/admin/dashboard')); ?>">
      <?php $companySetup = \App\Models\CompanySetup::first(); ?>
      <img class="sidebar_logo_ad"
        src="<?php echo e($companySetup?->logo ? asset('storage/' . $companySetup->logo) : asset('images/default-logo.png')); ?>"
        alt="Logo">
    </a>
    <div class="sidebar_close_icon d-lg-none">
      
      <i class="fa-solid fa-xmark"></i>
    </div>
  </div>

  <ul id="sidebar_menu">
    
    <li class="<?php echo e(request()->is('admin/dashboard') ? 'mm-active' : ''); ?>">
      <a href="<?php echo e(url('/admin/dashboard')); ?>" class="<?php echo e(request()->is('admin/dashboard') ? 'active' : ''); ?>"
        aria-current="<?php echo e(request()->is('admin/dashboard') ? 'page' : 'false'); ?>">
        <div class="icon_menu"><i class="fa-solid fa-gauge"></i></div>
        <span>Dashboard</span>
      </a>
    </li>

    
    <?php
      $allManagerOpen = isActive([
        'admin/deposits*',
        'add-money*',
        'admin/transfers*',
        'admin/purchases*',
        'admin/recharges*',
        'admin/reward-conversions*',
        'admin/bill-payments*',
        'admin/loans*',
        'admin/mobile-transactions*',
        'admin/bank-transfers*',
        'admin/contact-inbox*'
      ]);
    ?>

    <li class="<?php echo e($allManagerOpen ? 'mm-active' : ''); ?>">
      <a class="has-arrow" href="#" aria-expanded="<?php echo e($allManagerOpen ? 'true' : 'false'); ?>">
        <div class="icon_menu"><i class="fa-solid fa-clock-rotate-left"></i></div>
        <span>All History</span>
      </a>

      <ul class="<?php echo e($allManagerOpen ? 'mm-show' : ''); ?>">

        
        <li>
          <a href="<?php echo e(url('/admin/deposits')); ?>"
            class="flex items-center justify-between gap-2 text-[13px] <?php echo e(request()->is('admin/deposits*') ? 'active' : ''); ?>">
            <span>Mobile Deposits</span>
            <span
              class="ml-2 inline-flex h-4 min-w-[1.2rem] shrink-0 items-center justify-center rounded-full bg-emerald-500 px-1.5 text-[10px] font-semibold leading-none text-white">
              <?php echo e(App\Models\Deposit::where('status', 'pending')->count() ?? 0); ?>

            </span>
          </a>
        </li>

        
        <li>
          <a href="<?php echo e(url('/admin/bank-deposits')); ?>"
            class="flex items-center justify-between gap-2 text-[13px] <?php echo e(request()->is('admin/bank-deposits*') ? 'active' : ''); ?>">
            <span>Bank Deposits</span>
            <span
              class="ml-2 inline-flex h-4 min-w-[1.2rem] shrink-0 items-center justify-center rounded-full bg-sky-500 px-1.5 text-[10px] font-semibold leading-none text-white">
              <?php echo e(App\Models\AddmoneyBank::where('status', 'pending')->count() ?? 0); ?>

            </span>
          </a>
        </li>

        
        <li>
          <a href="<?php echo e(url('/admin/card-deposits')); ?>"
            class="flex items-center justify-between gap-2 text-[13px] <?php echo e(request()->is('admin/card-deposits*') ? 'active' : ''); ?>">
            <span>Card Deposits</span>
            <span
              class="ml-2 inline-flex h-4 min-w-[1.2rem] shrink-0 items-center justify-center rounded-full bg-fuchsia-500 px-1.5 text-[10px] font-semibold leading-none text-white">
              <?php echo e(App\Models\AddMoneyCardSubmit::where('status', 'pending')->count() ?? 0); ?>

            </span>
          </a>
        </li>

        
        <li>
          <a href="<?php echo e(url('/admin/transfers')); ?>"
            class="flex items-center justify-between gap-2 text-[13px] <?php echo e(request()->is('admin/transfers*') ? 'active' : ''); ?>">
            <span>Send Money Req.</span>
            <span
              class="ml-2 inline-flex h-4 min-w-[1.2rem] shrink-0 items-center justify-center rounded-full bg-amber-500 px-1.5 text-[10px] font-semibold leading-none text-white">
              <?php echo e(App\Models\Transfer::where('status', 'pending')->count() ?? 0); ?>

            </span>
          </a>
        </li>

        
        <li>
          <a href="<?php echo e(url('/admin/purchases')); ?>"
            class="flex items-center justify-between gap-2 text-[13px] <?php echo e(request()->is('admin/purchases*') ? 'active' : ''); ?>">
            <span>Offer Purchases</span>
            <span
              class="ml-2 inline-flex h-4 min-w-[1.2rem] shrink-0 items-center justify-center rounded-full bg-rose-500 px-1.5 text-[10px] font-semibold leading-none text-white">
              <?php echo e(App\Models\Purchase::where('status', 'pending')->count() ?? 0); ?>

            </span>
          </a>
        </li>

        
        <li>
          <a href="<?php echo e(url('/admin/recharges')); ?>"
            class="flex items-center justify-between gap-2 text-[13px] <?php echo e(request()->is('admin/recharges*') ? 'active' : ''); ?>">
            <span>Mobile Recharges</span>
            <span
              class="ml-2 inline-flex h-4 min-w-[1.2rem] shrink-0 items-center justify-center rounded-full bg-indigo-500 px-1.5 text-[10px] font-semibold leading-none text-white">
              <?php echo e(App\Models\Recharge::where('status', 'pending')->count() ?? 0); ?>

            </span>
          </a>
        </li>

        
        <li>
          <a href="<?php echo e(url('/admin/reward-conversions')); ?>"
            class="flex items-center justify-between gap-2 text-[13px] <?php echo e(request()->is('admin/reward-conversions*') ? 'active' : ''); ?>">
            <span>Reward Conversions</span>
            <span
              class="ml-2 inline-flex h-4 min-w-[1.2rem] shrink-0 items-center justify-center rounded-full bg-teal-500 px-1.5 text-[10px] font-semibold leading-none text-white">
              <?php echo e(App\Models\RewardConversion::count() ?? 0); ?>

            </span>
          </a>
        </li>

        
        <li>
          <a href="<?php echo e(url('/admin/bill-payments')); ?>"
            class="flex items-center justify-between gap-2 text-[13px] <?php echo e(request()->is('admin/bill-payments*') ? 'active' : ''); ?>">
            <span>Bill Payments</span>
            <span
              class="ml-2 inline-flex h-4 min-w-[1.2rem] shrink-0 items-center justify-center rounded-full bg-lime-500 px-1.5 text-[10px] font-semibold leading-none text-white">
              <?php echo e(App\Models\BillPayment::where('status', 'pending')->count() ?? 0); ?>

            </span>
          </a>
        </li>

        
        <li>
          <a href="<?php echo e(url('/admin/loans')); ?>"
            class="flex items-center justify-between gap-2 text-[13px] <?php echo e(request()->is('admin/loans*') ? 'active' : ''); ?>">
            <span>Loan Requests</span>
            <span
              class="ml-2 inline-flex h-4 min-w-[1.2rem] shrink-0 items-center justify-center rounded-full bg-orange-500 px-1.5 text-[10px] font-semibold leading-none text-white">
              <?php echo e(App\Models\LoanApplication::where('status', 'pending')->count() ?? 0); ?>

            </span>
          </a>
        </li>

        
        <li>
          <a href="<?php echo e(url('/admin/mobile-transactions')); ?>"
            class="flex items-center justify-between gap-2 text-[13px] <?php echo e(request()->is('admin/mobile-transactions*') ? 'active' : ''); ?>">
            <span>Mobile Transfers</span>
            <span
              class="ml-2 inline-flex h-4 min-w-[1.2rem] shrink-0 items-center justify-center rounded-full bg-cyan-500 px-1.5 text-[10px] font-semibold leading-none text-white">
              <?php echo e(App\Models\MobileTransaction::where('status', 'pending')->count() ?? 0); ?>

            </span>
          </a>
        </li>

        
        <li>
          <a href="<?php echo e(url('/admin/bank-transfers')); ?>"
            class="flex items-center justify-between gap-2 text-[13px] <?php echo e(request()->is('admin/bank-transfers*') ? 'active' : ''); ?>">
            <span>Bank Transfers</span>
            <span
              class="ml-2 inline-flex h-4 min-w-[1.2rem] shrink-0 items-center justify-center rounded-full bg-pink-500 px-1.5 text-[10px] font-semibold leading-none text-white">
              <?php echo e(App\Models\BankTransfer::where('status', 'pending')->count() ?? 0); ?>

            </span>
          </a>
        </li>

      </ul>
    </li>



    
    <?php $pmOpen = isActive(['admin/users/balance*']); ?>
    <li class="<?php echo e($pmOpen ? 'mm-active' : ''); ?>">
      <a class="has-arrow" href="#" aria-expanded="<?php echo e($pmOpen ? 'true' : 'false'); ?>">
        <div class="icon_menu">
          <i class="fa-solid fa-scale-balanced"></i>
        </div>
        <span>Balance Adjust</span>
      </a>
      <ul class="<?php echo e($pmOpen ? 'mm-show' : ''); ?>">
        <li>
          <a href="<?php echo e(url('/admin/users/balance')); ?>"
            class="<?php echo e(request()->is('admin/users/balance') ? 'active' : ''); ?>">
            Balance Add/Return
          </a>
        </li>
      </ul>
    </li>


    
    <?php $pmOpen = isActive(['admin/payment-methods*']); ?>
    <li class="<?php echo e($pmOpen ? 'mm-active' : ''); ?>">
      <a class="has-arrow" href="#" aria-expanded="<?php echo e($pmOpen ? 'true' : 'false'); ?>">
        <div class="icon_menu"><i class="fa-solid fa-credit-card"></i></div>
        <span>Pmt. Method</span>
      </a>
      <ul class="<?php echo e($pmOpen ? 'mm-show' : ''); ?>">
        <li><a href="<?php echo e(url('/admin/payment-methods')); ?>"
            class="<?php echo e(request()->is('admin/payment-methods') ? 'active' : ''); ?>">All Methods</a></li>
        <li><a href="<?php echo e(url('/admin/payment-methods/create')); ?>"
            class="<?php echo e(request()->is('admin/payment-methods/create') ? 'active' : ''); ?>">Add Method</a></li>
        <li><a href="<?php echo e(url('/bank-methods')); ?>"
            class="<?php echo e(request()->is('admin/payment-methods') ? 'active' : ''); ?>">bank List</a></li>
        <li><a href="<?php echo e(url('/bank-methods/create')); ?>"
            class="<?php echo e(request()->is('admin/payment-methods/create') ? 'active' : ''); ?>">Add bank</a></li>

        <li><a href="<?php echo e(url('/admin/add-money-cards')); ?>"
            class="<?php echo e(request()->is('admin/add-money-cards') ? 'active' : ''); ?>">Card List</a></li>
        <li><a href="<?php echo e(url('/admin/add-money-cards/create')); ?>"
            class="<?php echo e(request()->is('admin/add-money-cards/create') ? 'active' : ''); ?>">Add Card</a></li>
      </ul>
    </li>

    
    <?php $opOpen = isActive(['admin/operators*']); ?>
    <li class="<?php echo e($opOpen ? 'mm-active' : ''); ?>">
      <a class="has-arrow" href="#" aria-expanded="<?php echo e($opOpen ? 'true' : 'false'); ?>">
        
        <div class="icon_menu"><i class="fa-solid fa-sim-card"></i></div>
        <span>Operators</span>
      </a>
      <ul class="<?php echo e($opOpen ? 'mm-show' : ''); ?>">
        <li><a href="<?php echo e(url('/admin/operators')); ?>" class="<?php echo e(request()->is('admin/operators') ? 'active' : ''); ?>">All
            Operators</a></li>
        <li><a href="<?php echo e(url('/admin/operators/create')); ?>"
            class="<?php echo e(request()->is('admin/operators/create') ? 'active' : ''); ?>">Add Operator</a></li>
      </ul>
    </li>

    <?php $opOpen = isActive(['admin/offers*']); ?>
    <li class="<?php echo e($opOpen ? 'mm-active' : ''); ?>">
      <a class="has-arrow" href="#" aria-expanded="<?php echo e($opOpen ? 'true' : 'false'); ?>">
        
        <div class="icon_menu"><i class="fa-solid fa-sim-card"></i></div>
        <span>Drive Offer</span>
      </a>
      <ul class="<?php echo e($opOpen ? 'mm-show' : ''); ?>">
        <li><a href="<?php echo e(url('admin/offers')); ?>" class="<?php echo e(request()->is('admin/offers') ? 'active' : ''); ?>">All Drive
            Offers</a></li>
        <li><a href="<?php echo e(url('admin/offers/create')); ?>"
            class="<?php echo e(request()->is('admin/offers/create') ? 'active' : ''); ?>">Add Drive Offer</a></li>
      </ul>
    </li>

    
    <?php $promoOpen = isActive(['admin/deposit-packages*', 'admin/settings']); ?>
    <li class="<?php echo e($promoOpen ? 'mm-active' : ''); ?>">
      <a class="has-arrow" href="#" aria-expanded="<?php echo e($promoOpen ? 'true' : 'false'); ?>">
        <div class="icon_menu"><i class="fa-solid fa-tags"></i></div>
        <span>Promotions</span>
      </a>
      <ul class="<?php echo e($promoOpen ? 'mm-show' : ''); ?>">
        <li><a href="<?php echo e(url('/admin/deposit-packages')); ?>"
            class="<?php echo e(request()->is('admin/deposit-packages') ? 'active' : ''); ?>">All Deals</a></li>
        <li><a href="<?php echo e(url('/admin/deposit-packages/create')); ?>"
            class="<?php echo e(request()->is('admin/deposit-packages/create') ? 'active' : ''); ?>">Add Deal</a></li>
        <li><a href="<?php echo e(url('/admin/settings')); ?>" class="<?php echo e(request()->is('admin/settings') ? 'active' : ''); ?>">Promo
            Settings</a></li>
      </ul>
    </li>

    
    <?php $catOpen = isActive(['admin/biller-categories*']); ?>
    <li class="<?php echo e($catOpen ? 'mm-active' : ''); ?>">
      <a class="has-arrow" href="#" aria-expanded="<?php echo e($catOpen ? 'true' : 'false'); ?>">
        <div class="icon_menu"><i class="fa-solid fa-layer-group"></i></div>
        <span>Bill Category</span>
      </a>
      <ul class="<?php echo e($catOpen ? 'mm-show' : ''); ?>">
        <li><a href="<?php echo e(url('/admin/biller-categories')); ?>"
            class="<?php echo e(request()->is('admin/biller-categories') ? 'active' : ''); ?>">All Category</a></li>
        <li><a href="<?php echo e(url('/admin/biller-categories/create')); ?>"
            class="<?php echo e(request()->is('admin/biller-categories/create') ? 'active' : ''); ?>">Add Category</a></li>
      </ul>
    </li>

    
    <?php $billersOpen = isActive(['admin/billers*']); ?>
    <li class="<?php echo e($billersOpen ? 'mm-active' : ''); ?>">
      <a class="has-arrow" href="#" aria-expanded="<?php echo e($billersOpen ? 'true' : 'false'); ?>">
        <div class="icon_menu"><i class="fa-solid fa-file-invoice"></i></div>
        <span>Billers</span>
      </a>
      <ul class="<?php echo e($billersOpen ? 'mm-show' : ''); ?>">
        <li><a href="<?php echo e(url('/admin/billers')); ?>" class="<?php echo e(request()->is('admin/billers') ? 'active' : ''); ?>">All
            Billers</a></li>
        <li><a href="<?php echo e(url('/admin/billers/create')); ?>"
            class="<?php echo e(request()->is('admin/billers/create') ? 'active' : ''); ?>">Add Biller</a></li>
      </ul>
    </li>

    
    <?php $loanOpen = isActive(['admin/loan-settings*']); ?>
    <li class="<?php echo e($loanOpen ? 'mm-active' : ''); ?>">
      <a class="has-arrow" href="#" aria-expanded="<?php echo e($loanOpen ? 'true' : 'false'); ?>">
        <div class="icon_menu"><i class="fa-solid fa-sliders"></i></div>
        <span>Loan Config</span>
      </a>
      <ul class="<?php echo e($loanOpen ? 'mm-show' : ''); ?>">
        <li><a href="<?php echo e(url('/admin/loan-settings')); ?>"
            class="<?php echo e(request()->is('admin/loan-settings') ? 'active' : ''); ?>">All Settings</a></li>
        <li><a href="<?php echo e(url('/admin/loan-settings/create')); ?>"
            class="<?php echo e(request()->is('admin/loan-settings/create') ? 'active' : ''); ?>">Add Setting</a></li>
      </ul>
    </li>

    
    <?php $mobOpen = isActive(['admin/mobile-gateways*']); ?>
    <li class="<?php echo e($mobOpen ? 'mm-active' : ''); ?>">
      <a class="has-arrow" href="#" aria-expanded="<?php echo e($mobOpen ? 'true' : 'false'); ?>">
        <div class="icon_menu"><i class="fa-solid fa-mobile-screen-button"></i></div>
        <span>Mobile Banking</span>
      </a>
      <ul class="<?php echo e($mobOpen ? 'mm-show' : ''); ?>">
        <li><a href="<?php echo e(url('/admin/mobile-gateways')); ?>"
            class="<?php echo e(request()->is('admin/mobile-gateways') ? 'active' : ''); ?>">All Method</a></li>
        <li><a href="<?php echo e(url('/admin/mobile-gateways/create')); ?>"
            class="<?php echo e(request()->is('admin/mobile-gateways/create') ? 'active' : ''); ?>">Add Methods</a></li>
      </ul>
    </li>

    
    <?php $banksOpen = isActive(['admin/banks*']); ?>
    <li class="<?php echo e($banksOpen ? 'mm-active' : ''); ?>">
      <a class="has-arrow" href="#" aria-expanded="<?php echo e($banksOpen ? 'true' : 'false'); ?>">
        <div class="icon_menu"><i class="fa-solid fa-building-columns"></i></div>
        <span>Bank Config</span>
      </a>
      <ul class="<?php echo e($banksOpen ? 'mm-show' : ''); ?>">
        <li><a href="<?php echo e(url('/admin/banks')); ?>" class="<?php echo e(request()->is('admin/banks') ? 'active' : ''); ?>">All Banks</a>
        </li>
        <li><a href="<?php echo e(url('/admin/banks/create')); ?>"
            class="<?php echo e(request()->is('admin/banks/create') ? 'active' : ''); ?>">Add Bank</a></li>
      </ul>
    </li>

    
    <?php $fxOpen = isActive(['admin/exchange-countries*']); ?>
    <li class="<?php echo e($fxOpen ? 'mm-active' : ''); ?>">
      <a class="has-arrow" href="#" aria-expanded="<?php echo e($fxOpen ? 'true' : 'false'); ?>">
        <div class="icon_menu"><i class="fa-solid fa-globe"></i></div>
        <span>FX Country</span>
      </a>
      <ul class="<?php echo e($fxOpen ? 'mm-show' : ''); ?>">
        <li><a href="<?php echo e(url('/admin/exchange-countries')); ?>"
            class="<?php echo e(request()->is('admin/exchange-countries') ? 'active' : ''); ?>">All Country</a></li>
        <li><a href="<?php echo e(url('/admin/exchange-countries/create')); ?>"
            class="<?php echo e(request()->is('admin/exchange-countries/create') ? 'active' : ''); ?>">Add Country</a></li>
      </ul>
    </li>

    
    <?php $banOpen = isActive(['admin/banners*']); ?>
    <li class="<?php echo e($banOpen ? 'mm-active' : ''); ?>">
      <a class="has-arrow" href="#" aria-expanded="<?php echo e($banOpen ? 'true' : 'false'); ?>">
        <div class="icon_menu"><i class="fa-solid fa-image"></i></div>
        <span>Banner Setup</span>
      </a>
      <ul class="<?php echo e($banOpen ? 'mm-show' : ''); ?>">
        <li><a href="<?php echo e(url('/admin/banners')); ?>" class="<?php echo e(request()->is('admin/banners') ? 'active' : ''); ?>">All
            Banners</a></li>
        <li><a href="<?php echo e(url('/admin/banners/create')); ?>"
            class="<?php echo e(request()->is('admin/banners/create') ? 'active' : ''); ?>">Add Banner</a></li>
      </ul>
    </li>

    
    <?php $notOpen = isActive(['admin/notices*']); ?>
    <li class="<?php echo e($notOpen ? 'mm-active' : ''); ?>">
      <a class="has-arrow" href="#" aria-expanded="<?php echo e($notOpen ? 'true' : 'false'); ?>">
        <div class="icon_menu"><i class="fa-solid fa-bell"></i></div>
        <span>Notices</span>
      </a>
      <ul class="<?php echo e($notOpen ? 'mm-show' : ''); ?>">
        <li><a href="<?php echo e(url('/admin/notices')); ?>" class="<?php echo e(request()->is('admin/notices') ? 'active' : ''); ?>">All
            Notices</a></li>
        <li><a href="<?php echo e(url('/admin/notices/create')); ?>"
            class="<?php echo e(request()->is('admin/notices/create') ? 'active' : ''); ?>">Add Notice</a></li>
      </ul>
    </li>

    
    <?php $rwOpen = isActive(['reward-settings*']); ?>
    <li class="<?php echo e($rwOpen ? 'mm-active' : ''); ?>">
      <a class="has-arrow" href="#" aria-expanded="<?php echo e($rwOpen ? 'true' : 'false'); ?>">
        <div class="icon_menu"><i class="fa-solid fa-gift"></i></div>
        <span>Reward Settings</span>
      </a>
      <ul class="<?php echo e($rwOpen ? 'mm-show' : ''); ?>">
        <li><a href="<?php echo e(url('/reward-settings')); ?>"
            class="<?php echo e(request()->is('reward-settings') ? 'active' : ''); ?>">Reward Settings</a></li>
      </ul>
    </li>

    
    <?php $msgOpen = isActive(['admin/contact-inbox*']); ?>
    <li class="<?php echo e($msgOpen ? 'mm-active' : ''); ?>">
      <a class="has-arrow" href="#" aria-expanded="<?php echo e($msgOpen ? 'true' : 'false'); ?>">
        <div class="icon_menu"><i class="fa-solid fa-envelope"></i></div>
        <span>Messages</span>
      </a>
      <ul class="<?php echo e($msgOpen ? 'mm-show' : ''); ?>">
        <li><a href="<?php echo e(url('/admin/contact-inbox')); ?>"
            class="<?php echo e(request()->is('admin/contact-inbox*') ? 'active' : ''); ?>">Manage Inbox</a></li>
      </ul>
    </li>

    
    <?php $usersOpen = isActive(['admin/users*']); ?>
    <li class="<?php echo e($usersOpen ? 'mm-active' : ''); ?>">
      <a class="has-arrow" href="#" aria-expanded="<?php echo e($usersOpen ? 'true' : 'false'); ?>">
        <div class="icon_menu"><i class="fa-solid fa-users"></i></div>
        <span>Manage Users</span>
      </a>
      <ul class="<?php echo e($usersOpen ? 'mm-show' : ''); ?>">
        <li><a href="<?php echo e(url('/admin/users')); ?>" class="<?php echo e(request()->is('admin/users*') ? 'active' : ''); ?>">All
            Users</a></li>
      </ul>
    </li>

    
    <?php $companyOpen = isActive(['company-setups*']); ?>
    <li class="<?php echo e($companyOpen ? 'mm-active' : ''); ?>">
      <a class="has-arrow" href="#" aria-expanded="<?php echo e($companyOpen ? 'true' : 'false'); ?>">
        <div class="icon_menu"><i class="fa-solid fa-building"></i></div>
        <span>Company Setup</span>
      </a>
      <ul class="<?php echo e($companyOpen ? 'mm-show' : ''); ?>">
        <li><a href="<?php echo e(url('/company-setups')); ?>" class="<?php echo e(request()->is('company-setups*') ? 'active' : ''); ?>">Manage
            Company</a></li>
      </ul>
    </li>

    
    <?php $headlineOpen = isActive(['headlines*']); ?>
    <li class="<?php echo e($headlineOpen ? 'mm-active' : ''); ?>">
      <a class="has-arrow" href="#" aria-expanded="<?php echo e($headlineOpen ? 'true' : 'false'); ?>">
        <div class="icon_menu"><i class="fa-solid fa-heading"></i></div>
        <span>Headline Setup</span>
      </a>
      <ul class="<?php echo e($headlineOpen ? 'mm-show' : ''); ?>">
        <li><a href="<?php echo e(url('/headlines')); ?>" class="<?php echo e(request()->is('headlines*') ? 'active' : ''); ?>">Manage
            Headline</a></li>
      </ul>
    </li>


    <?php $headlineOpen = isActive(['admin/upload-apps*']); ?>
    <li class="<?php echo e($headlineOpen ? 'mm-active' : ''); ?>">
      <a class="has-arrow" href="#" aria-expanded="<?php echo e($headlineOpen ? 'true' : 'false'); ?>">
        <div class="icon_menu">
          <i class="fa-solid fa-cloud-arrow-up"></i>
        </div>
        <span>Upload App</span>
      </a>
      <ul class="<?php echo e($headlineOpen ? 'mm-show' : ''); ?>">
        <li>
          <a href="<?php echo e(url('admin/upload-apps')); ?>" class="<?php echo e(request()->is('admin/upload-apps*') ? 'active' : ''); ?>">
            Manage upload-apps
          </a>
        </li>
      </ul>
    </li>


    <?php 
      $artisanActive = isActive(['storage-link*']); 
    ?>

    <li class="nav-item <?php echo e($artisanActive ? 'mm-active' : ''); ?>">
      <a class="has-arrow d-flex align-items-center" href="#" aria-expanded="<?php echo e($artisanActive ? 'true' : 'false'); ?>">
        <div class="icon_menu me-2">
          <i class="fa-solid fa-terminal"></i>
        </div>
        <span>Artisan Call</span>
      </a>
      <ul class="nav flex-column <?php echo e($artisanActive ? 'mm-show' : ''); ?>">
        <li>
          <a href="<?php echo e(url('/storage-link')); ?>" class="<?php echo e(request()->is('storage-link*') ? 'active' : ''); ?>">
            <i class="fa-solid fa-link me-1"></i> Storage Link
          </a>
        </li>
      </ul>
    </li>




  </ul>
</nav><?php /**PATH /home/ecareba2/new.rkmotorsbike.top/resources/views/backend/common/sidebar.blade.php ENDPATH**/ ?>