

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-3">

  
  <style>
    .pm-card { border:1px solid #e6e8ef; border-radius:16px; background:#fff; box-shadow:0 4px 18px rgba(17,24,39,.06) }
    .toolbar { gap:.75rem }
    .badge-soft {background:#eef2ff;color:#3730a3;border-radius:999px;padding:.35rem .6rem;font-weight:600}
    .badge-soft.gray { background:#f1f5f9; color:#334155 }
    .badge-soft.green { background:#dcfce7; color:#166534 }
    .badge-soft.red   { background:#fee2e2; color:#991b1b }
    .logo_pm { height:42px;width:42px;border-radius:10px;object-fit:cover;border:1px solid #e5e7eb }
    .table thead th{font-weight:700;color:#0f172a;border-top:0}
    .table-hover tbody tr:hover{background:#fafafa}
    .btn-icon { display:inline-flex;align-items:center;gap:.5rem }
    .btn-soft { background:#f8fafc;border:1px solid #e5e7eb }
    .btn-create { background:#5b21b6; border-color:#5b21b6 }
    .btn-create:hover{ background:#4c1d95; border-color:#4c1d95 }
    .actions-wrap { gap:.4rem }
    /* Mobile: table → cards */
    @media (max-width: 768px){
      .table thead{ display:none }
      .table tbody tr{ display:block; margin:12px 0; border:1px solid #e5e7eb; border-radius:12px; padding:10px }
      .table td{ display:flex; justify-content:space-between; border:0; padding:.4rem .5rem }
      .table td::before{ content: attr(data-label); font-weight:600; color:#475569 }
      .actions-wrap{ flex-wrap:wrap }
    }
  </style>

  
  <div class="d-flex justify-content-between align-items-center toolbar mb-3">
    <div class="d-flex align-items-center gap-2">
      <span class="badge-soft gray"><i class="fa-solid fa-wallet me-1"></i> Payment Methods</span>
    </div>
    <a href="<?php echo e(url('/admin/payment-methods/create')); ?>" class="btn btn-create text-white btn-icon">
      <i class="fa-solid fa-plus"></i> Create
    </a>
  </div>

  
  <form method="GET" action="<?php echo e(url('/admin/payment-methods')); ?>" class="pm-card p-3 mb-3">
    <div class="row g-2">
      <div class="col-12 col-md-6">
        <div class="input-group">
          <span class="input-group-text bg-white"><i class="fa-solid fa-magnifying-glass"></i></span>
          <input name="q" value="<?php echo e(request('q')); ?>" class="form-control" placeholder="Search name / slug / type">
        </div>
      </div>
      <div class="col-8 col-md-3">
        <select name="active" class="form-select">
          <option value="">All statuses</option>
          <option value="1" <?php if(request('active')==='1'): echo 'selected'; endif; ?>>Active</option>
          <option value="0" <?php if(request('active')==='0'): echo 'selected'; endif; ?>>Inactive</option>
        </select>
      </div>
      <div class="col-4 col-md-3 d-grid">
        <button class="btn btn-soft"><i class="fa-solid fa-filter me-1"></i> Filter</button>
      </div>
    </div>
  </form>

  <?php if(session('success')): ?>
    <div class="alert alert-success pm-card p-2"><i class="fa-regular fa-circle-check me-1"></i><?php echo e(session('success')); ?></div>
  <?php endif; ?>

  
  <div class="table-responsive pm-card p-0">
    <table class="table table-hover align-middle mb-0">
      <thead class="table-light">
        <tr>
          <th style="width:56px">#</th>
          <th style="width:72px">Logo</th>
          <th>Name</th>
          <th>Slug</th>
          <th>Type</th>
          <th>Daily Min — Max</th>
          <th>Status</th>
          <th class="text-end">Actions</th>
        </tr>
      </thead>
      <tbody>
        <?php $__empty_1 = true; $__currentLoopData = $methods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <tr>
          <td data-label="#" class="text-muted"><?php echo e($pm->id); ?></td>
          <td data-label="Logo">
            <?php if($pm->logo): ?>
              <img class="logo_pm" src="<?php echo e(asset('storage/'.$pm->logo)); ?>" alt="logo">
            <?php else: ?>
              <span class="badge-soft gray"><i class="fa-regular fa-image me-1"></i>None</span>
            <?php endif; ?>
          </td>
          <td data-label="Name">
            <a class="text-decoration-none fw-semibold" href="<?php echo e(url('/admin/payment-methods/'.$pm->id)); ?>">
              <i class="fa-regular fa-credit-card me-1 text-secondary"></i><?php echo e($pm->name); ?>

            </a>
          </td>
          <td data-label="Slug"><span class="badge-soft gray"><?php echo e($pm->slug); ?></span></td>
          <td data-label="Type"><span class="badge-soft"><?php echo e($pm->type); ?></span></td>
          <td data-label="Daily Min — Max" class="text-nowrap">
            <?php echo e($pm->daily_min !== null ? number_format($pm->daily_min) : '—'); ?> — <?php echo e($pm->daily_max !== null ? number_format($pm->daily_max) : '—'); ?>

          </td>
          <td data-label="Status">
            <span class="badge-soft <?php echo e($pm->is_active ? 'green' : 'red'); ?>">
              <i class="fa-solid <?php echo e($pm->is_active ? 'fa-toggle-on' : 'fa-toggle-off'); ?> me-1"></i>
              <?php echo e($pm->is_active ? 'Active' : 'Inactive'); ?>

            </span>
          </td>
          <td data-label="Actions" class="text-end">
            <div class="d-flex justify-content-end actions-wrap">
              <form action="<?php echo e(url('/admin/payment-methods/'.$pm->id.'/toggle')); ?>" method="POST">
                <?php echo csrf_field(); ?> <?php echo method_field('PATCH'); ?>
                <button class="btn btn-warning btn-sm btn-icon"><i class="fa-solid fa-arrows-rotate"></i> Toggle</button>
              </form>
              <div class="btn-group">
                <a class="btn btn-primary btn-sm" href="<?php echo e(url('/admin/payment-methods/'.$pm->id.'/edit')); ?>">
                  <i class="fa-regular fa-pen-to-square"></i> Edit
                </a>
                <button class="btn btn-primary btn-sm d-md-none dropdown-toggle dropdown-toggle-split" data-bs-toggle="dropdown"></button>
                <ul class="dropdown-menu dropdown-menu-end d-md-none">
                  <li>
                    <form action="<?php echo e(url('/admin/payment-methods/'.$pm->id)); ?>" method="POST" onsubmit="return confirm('Delete this item?')">
                      <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                      <button class="dropdown-item text-danger"><i class="fa-regular fa-trash-can me-2"></i>Delete</button>
                    </form>
                  </li>
                </ul>
              </div>
              <form class="d-none d-md-inline" action="<?php echo e(url('/admin/payment-methods/'.$pm->id)); ?>" method="POST" onsubmit="return confirm('Delete this item?')">
                <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                <button class="btn btn-danger btn-sm btn-icon"><i class="fa-regular fa-trash-can"></i> Delete</button>
              </form>
            </div>
          </td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <tr>
          <td colspan="8" class="text-center text-muted py-4"><i class="fa-regular fa-folder-open me-1"></i>No data found</td>
        </tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>

  <div class="mt-3"><?php echo e($methods->links()); ?></div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ecareba2/new.rkmotorsbike.top/resources/views/backend/payment_methods/index.blade.php ENDPATH**/ ?>