

<?php $__env->startSection('title', 'Headlines'); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-4">
    <?php if(session('status')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?php echo e(session('status')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <div class="row g-4">
        
        <div class="col-lg-5">
            <div class="card shadow-sm">
                <div class="card-header d-flex align-items-center justify-content-between">
                    <h5 class="mb-0"><?php echo e($editing ? 'Edit Headline' : 'Create Headline'); ?></h5>
                    <?php if($editing): ?>
                        <a href="<?php echo e(route('headlines.index')); ?>" class="btn btn-sm btn-outline-secondary">+ New</a>
                    <?php endif; ?>
                </div>

                <div class="card-body">
                    <?php if($editing && $current): ?>
                        <form action="<?php echo e(route('headlines.update', $current->id)); ?>" method="POST" class="row g-3">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>
                            <div class="col-12">
                                <label class="form-label">Headline</label>
                                <textarea name="headline" rows="4"
                                    class="form-control <?php $__errorArgs = ['headline'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                ><?php echo e(old('headline', $current->headline)); ?></textarea>
                                <?php $__errorArgs = ['headline'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-12 d-flex gap-2">
                                <button class="btn btn-primary">Update</button>
                                <a href="<?php echo e(route('headlines.index')); ?>" class="btn btn-light">Cancel</a>
                            </div>
                        </form>
                    <?php else: ?>
                        <form action="<?php echo e(route('headlines.store')); ?>" method="POST" class="row g-3">
                            <?php echo csrf_field(); ?>
                            <div class="col-12">
                                <label class="form-label">Headline</label>
                                <textarea name="headline" rows="4"
                                    class="form-control <?php $__errorArgs = ['headline'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    placeholder="Write a headline..."
                                ><?php echo e(old('headline')); ?></textarea>
                                <?php $__errorArgs = ['headline'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-12">
                                <button class="btn btn-primary">Save</button>
                            </div>
                        </form>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        
        <div class="col-lg-7">
            <div class="card shadow-sm">
                <div class="card-header">
                    <h5 class="mb-0">All Headlines</h5>
                </div>
                <div class="table-responsive">
                    <table class="table align-middle mb-0">
                        <thead class="table-light">
                            <tr>
                                <th style="width:72px">#</th>
                                <th>Headline</th>
                                <th style="width:160px">Created</th>
                                <th style="width:160px">Updated</th>
                                <th class="text-end" style="width:160px">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $headlines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $h): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($h->id); ?></td>
                                <td>
                                    <div class="text-truncate" style="max-width: 520px;" title="<?php echo e($h->headline); ?>">
                                        <?php echo e(\Illuminate\Support\Str::limit($h->headline, 140)); ?>

                                    </div>
                                </td>
                                <td><span class="text-muted"><?php echo e(optional($h->created_at)->format('d M Y, h:i A')); ?></span></td>
                                <td><span class="text-muted"><?php echo e(optional($h->updated_at)->format('d M Y, h:i A')); ?></span></td>
                                <td class="text-end">
                                    <div class="btn-group">
                                        <a href="<?php echo e(route('headlines.edit', $h->id)); ?>" class="btn btn-sm btn-outline-primary">Edit</a>

                                        
                                        <form action="<?php echo e(route('headlines.destroy', $h->id)); ?>" method="POST" class="d-inline"
                                              onsubmit="return confirm('Delete this headline?');">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-sm btn-outline-danger">Delete</button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="5" class="text-center text-muted py-5">No headlines found.</td>
                            </tr>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>

                <?php if($headlines->hasPages()): ?>
                <div class="card-footer">
                    <?php echo e($headlines->links()); ?>

                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ecareba2/new.rkmotorsbike.top/resources/views/admin/headlines/index.blade.php ENDPATH**/ ?>