

<?php $__env->startSection('content'); ?>
<?php $companySetup = \App\Models\CompanySetup::first(); ?>
  <!-- Bootstrap 5 -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <!-- Bootstrap Icons -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
  <!-- Bangla Font -->
  <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@400;600;700&display=swap" rel="stylesheet">

  <style>
    :root{
      --wa: #25D366;
      --bg1: #e8f7ff;
      --bg2: #cfeffd;
      --glass: rgba(255, 255, 255, .65);
      --border: rgba(12, 26, 75, .08);
      --shadow: 0 20px 40px rgba(0,0,0,.12);
    }

    body{ font-family: 'Hind Siliguri', system-ui, -apple-system, Segoe UI, Roboto, 'Helvetica Neue', Arial, 'Noto Sans', 'Apple Color Emoji', 'Segoe UI Emoji', 'Noto Color Emoji', sans-serif; }

    /* Background */
    .support-bg{
      position: relative;
      background: linear-gradient(145deg, var(--bg1), var(--bg2));
      overflow: hidden;
      border-radius: 24px;
    }
    .bg-blob{
      position: absolute;
      border-radius: 999px;
      filter: blur(40px);
      opacity: .35;
      will-change: transform;
      animation: float 10s ease-in-out infinite;
    }
    .bg-blob.blob-1{ width: 220px; height: 220px; background: #a7f3d0; top: -40px; left: -40px; animation-delay: .2s; }
    .bg-blob.blob-2{ width: 260px; height: 260px; background: #93c5fd; bottom: -60px; right: -40px; animation-delay: .8s; }

    /* Card */
    .support-card{
      max-width: 560px;
      margin: 0 auto;
      border: 1px solid var(--border);
      border-radius: 22px;
      background: var(--glass);
      box-shadow: var(--shadow);
      backdrop-filter: saturate(160%) blur(10px);
      transform: translateY(18px);
      opacity: 0;
      animation: fadeUp .8s cubic-bezier(.16,.84,.44,1) .25s forwards;
    }

    /* Icon */
    .wa-icon{
      width:70px; height:70px; border-radius:50%;
      display:grid; place-items:center;
      color: var(--wa); background: rgba(37,211,102,.12);
      font-size: 34px; position: relative; margin-inline:auto;
    }
    .wa-icon::after{
      content: ""; position:absolute; inset:0;
      border-radius: inherit; outline: 2px solid rgba(37,211,102,.18);
      animation: pulseRing 1.8s ease-out infinite;
    }

    /* Buttons */
    .rounded-14{ border-radius:16px; }
    .btn-wa{
      background: var(--wa); border-color: var(--wa); color:#fff;
      box-shadow: 0 16px 38px rgba(37,211,102,.35), 0 2px 0 rgba(0,0,0,.05) inset;
      transform: translateZ(0);
      transition: transform .18s ease, filter .18s ease;
    }
    .btn-wa:hover{ filter: brightness(.95); transform: translateY(-1px); }

    .btn-phone{
      background: #f8fafc; color: #0b5e3b; border: 1px solid #e6eef4;
      transition: transform .18s ease, box-shadow .18s ease;
    }
    .btn-phone:hover{ transform: translateY(-1px); box-shadow: 0 10px 22px rgba(10, 120, 78, .15); }

    /* Tiny helper text */
    .trust-badges i { opacity:.9 }

    /* Motion */
    @keyframes fadeUp{ from{ opacity:0; transform: translateY(18px) } to{ opacity:1; transform: translateY(0) } }
    @keyframes float{ 0%,100%{ transform: translateY(0) } 50%{ transform: translateY(-18px) } }
    @keyframes pulseRing{ 0%{ transform: scale(1); opacity:.65 } 100%{ transform: scale(1.5); opacity: 0 } }

    /* 3D hover tilt */
    .tilt{ transition: transform .12s linear; transform-style: preserve-3d; }
    .tilt:hover .tilt-child{ transform: translateZ(6px); }

    /* Accessibility: reduce motion */
    @media (prefers-reduced-motion: reduce){
      .bg-blob, .support-card{ animation: none !important }
      .wa-icon::after{ display:none }
    }
  </style>

  <section class="container py-5">
    <div class="support-bg p-4 p-md-5">
      <span class="bg-blob blob-1"></span>
      <span class="bg-blob blob-2"></span>

      <div class="card support-card tilt">
        <div class="card-body p-4 p-md-5 tilt-child">
          <div class="text-center">
            <div class="wa-icon mb-3"><i class="bi bi-whatsapp"></i></div>
            <h2 class="fw-bold text-success mb-1" style="letter-spacing:.5px">সহায়তা কেন্দ্র</h2>
            <p class="text-secondary mb-4">আমরা ২৪/৭ আপনার সেবায় প্রস্তুত</p>

            <div class="d-grid gap-3">
              <a class="btn btn-wa btn-lg rounded-14 fw-semibold" href="https://wa.me/<?php echo e($companySetup->whatsapp_number); ?>" target="_blank" rel="noopener">
                <i class="bi bi-whatsapp me-2"></i> এখনই চ্যাট করুন
              </a>
              <a class="btn btn-phone btn-lg rounded-14 fw-semibold" href="tel:<?php echo e($companySetup->phone_number); ?>">
                <i class="bi bi-telephone-outbound me-2"></i> <?php echo e($companySetup->phone_number); ?>

              </a>
            </div>

            <!-- small social proof / badges -->
            <div class="trust-badges d-flex justify-content-center align-items-center gap-3 mt-4 text-muted small">
              <span class="d-inline-flex align-items-center gap-1"><i class="bi bi-shield-check"></i> নিরাপদ</span>
              <span>·</span>
              <span class="d-inline-flex align-items-center gap-1"><i class="bi bi-clock-history"></i> ২৪/৭ সাপোর্ট</span>
              <span>·</span>
              <span class="d-inline-flex align-items-center gap-1"><i class="bi bi-lightning-charge"></i> দ্রুত রেসপন্স</span>
            </div>
          </div>
        </div>
      </div>

    </div>
  </section>

  <!-- Scripts -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
  <script>
    // Lightweight tilt effect
    (function(){
      const tilt = document.querySelector('.tilt');
      if(!tilt) return;
      tilt.addEventListener('mousemove', (e) => {
        const r = tilt.getBoundingClientRect();
        const px = (e.clientX - r.left) / r.width;   // 0..1
        const py = (e.clientY - r.top)  / r.height;  // 0..1
        const rx = (py - .5) * 6; // tilt X
        const ry = (px - .5) * -6; // tilt Y
        tilt.style.transform = `rotateX(${rx}deg) rotateY(${ry}deg)`;
      });
      tilt.addEventListener('mouseleave', () => {
        tilt.style.transform = 'rotateX(0) rotateY(0)';
      });
    })();
  </script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ecareba2/new1.rkmotorsbike.top/resources/views/frontend/help/index.blade.php ENDPATH**/ ?>