
<?php $__env->startSection('title','কমিশন'); ?>

<?php $__env->startPush('styles'); ?>
    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@400;500;600;700&family=Poppins:wght@400;500;600&display=swap" rel="stylesheet">

    <style>
        body {
            font-family: "Hind Siliguri", system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
        }

        @keyframes blobFloat {
            0%   { transform: translate3d(-10%, -10%, 0) scale(1); }
            50%  { transform: translate3d(15%, 10, 0) scale(1.08); }
            100% { transform: translate3d(40%, -5%, 0) scale(1); }
        }

        @keyframes blobFloat2 {
            0%   { transform: translate3d(40%, 20%, 0) scale(1); }
            50%  { transform: translate3d(5%, 0, 0) scale(1.04); }
            100% { transform: translate3d(-20%, 10%, 0) scale(1); }
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-gradient-to-b from-slate-950 via-slate-900 to-slate-950 flex justify-center items-start px-3 sm:px-4 py-8 relative overflow-hidden">

    
    <svg class="pointer-events-none absolute -top-32 -left-32 w-80 h-80 text-emerald-500/20"
         viewBox="0 0 200 200" xmlns="http://www.w3.org/2000/svg"
         style="animation: blobFloat 18s ease-in-out infinite alternate;">
        <path fill="currentColor"
              d="M45.1,-62C58.8,-54.8,69.1,-39.4,73.4,-22.5C77.7,-5.7,75.9,12.7,67.4,26.8C58.8,40.9,43.4,50.7,27.2,58.2C11,65.7,-6,70.9,-20.4,66.3C-34.7,61.6,-46.4,47.1,-55.3,31.5C-64.3,15.9,-70.4,-0.7,-68.1,-16.7C-65.8,-32.7,-55.1,-48.1,-41.2,-55.6C-27.3,-63.1,-10.1,-62.6,5.7,-69C21.5,-75.3,43,-88.4,45.1,-62Z"/>
    </svg>

    <svg class="pointer-events-none absolute bottom-0 -right-24 w-72 h-72 text-cyan-400/10"
         viewBox="0 0 200 200" xmlns="http://www.w3.org/2000/svg"
         style="animation: blobFloat2 22s ease-in-out infinite alternate;">
        <path fill="currentColor"
              d="M35.8,-54.7C46.3,-47.4,54,-38,60.9,-27.1C67.7,-16.2,73.7,-4.1,71.9,6.8C70.1,17.7,60.5,27.3,50.4,36.6C40.4,46,29.9,55.3,17.3,60.4C4.6,65.6,-10.1,66.6,-24.4,62.4C-38.7,58.3,-52.6,49.1,-59.8,36.3C-66.9,23.4,-67.3,7,-64.6,-8.3C-61.9,-23.6,-56.1,-37.9,-45.7,-45.9C-35.2,-53.9,-20.1,-55.7,-5.2,-49.9C9.7,-44,19.3,-30.5,35.8,-54.7Z"/>
    </svg>

    <main class="w-full max-w-xl relative z-10">

        
        <div class="mb-4 flex items-center justify-between text-xs text-slate-300">
            <button type="button"
                    onclick="window.history.back()"
                    class="inline-flex items-center gap-1 text-slate-300 hover:text-emerald-400 transition">
                <svg class="h-4 w-4" viewBox="0 0 24 24" fill="currentColor">
                    <path d="M15.75 4.75 9.5 11l6.25 6.25-1.5 1.5L6.5 11l7.75-7.75 1.5 1.5Z"/>
                </svg>
                Back
            </button>
            <span class="tracking-[0.18em] uppercase text-emerald-400 font-semibold text-[11px]">
                Commission
            </span>
        </div>

        
        <div class="w-full rounded-3xl bg-slate-900/80 border border-emerald-500/25 shadow-[0_25px_70px_-35px_rgba(16,185,129,.7)] backdrop-blur-sm">

            
            <div class="h-1.5 w-full rounded-t-3xl bg-gradient-to-r from-emerald-500 via-cyan-500 to-teal-500"></div>

            <div class="p-6 sm:p-7">
                <h1 class="text-xl sm:text-2xl font-extrabold text-emerald-300 text-center">
                    Reward Conversion
                </h1>
                <div class="mt-1 text-center text-[11px] text-slate-400">
                    আপনার রিওয়ার্ড পয়েন্ট ব্যালেন্সে কনভার্ট করুন
                </div>

                
                <div class="mt-6 grid grid-cols-1 gap-4 sm:grid-cols-2">
                    <div class="rounded-2xl bg-gradient-to-br from-emerald-500 to-cyan-500 p-4 text-white shadow-[0_16px_40px_-22px_rgba(16,185,129,1)]">
                        <div class="text-[11px] uppercase tracking-wide text-emerald-100/90">Current Balance</div>
                        <div class="mt-1 text-2xl font-extrabold">
                            ৳<?php echo e(number_format($user->balance ?? 0, 2)); ?>

                        </div>
                    </div>
                    <div class="rounded-2xl bg-gradient-to-br from-amber-400 to-amber-500 p-4 text-slate-900 shadow-[0_16px_40px_-22px_rgba(245,158,11,1)]">
                        <div class="text-[11px] uppercase tracking-wide text-amber-100/90">Reward Points</div>
                        <div class="mt-1 text-2xl font-extrabold">
                            <?php echo e(number_format($user->reward_points ?? 0)); ?>

                        </div>
                    </div>
                </div>

                
                <?php if(session('success')): ?>
                    <div class="mt-4 rounded-2xl border border-emerald-500/40 bg-emerald-500/10 px-4 py-3 text-[11px] text-emerald-100 shadow-sm">
                        <?php echo e(session('success')); ?>

                    </div>
                <?php endif; ?>
                <?php if($errors->any()): ?>
                    <div class="mt-4 rounded-2xl border border-rose-500/40 bg-rose-500/10 px-4 py-3 text-[11px] text-rose-100 shadow-sm">
                        <ul class="list-disc list-inside space-y-0.5">
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $e): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <li><?php echo e($e); ?></li> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                <?php endif; ?>

                
                <div class="mt-6 rounded-2xl border border-slate-700 bg-slate-900/80 p-5 shadow-sm">
                    <div class="mb-3 flex items-center gap-2 font-semibold text-emerald-300 text-sm">
                        <span>🔁</span>
                        <span>Convert Points to Balance</span>
                    </div>

                    <form method="POST" action="<?php echo e(route('rewards.convert.store')); ?>" class="space-y-3" id="convert-form" autocomplete="off">
                        <?php echo csrf_field(); ?>

                        
                        <label class="block">
                            <span class="text-[11px] font-semibold text-slate-200 tracking-wide uppercase">
                                Points to Convert
                            </span>
                            <div class="relative mt-1">
                                <span class="absolute left-3 top-1/2 -translate-y-1/2 text-amber-300 text-sm">🪙</span>
                                <input
                                  type="number"
                                  name="points"
                                  min="<?php echo e($ratePoints); ?>"
                                  step="<?php echo e($ratePoints); ?>"
                                  class="w-full rounded-2xl border-2 border-slate-700 bg-slate-950/70 pl-10 pr-4 py-2.5 text-sm text-slate-100 outline-none transition
                                         placeholder-slate-500 focus:border-emerald-400 focus:ring-2 focus:ring-emerald-500/30 <?php $__errorArgs = ['points'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-rose-500 ring-rose-500/40 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                  placeholder="কনভার্ট করার পয়েন্ট লিখুন"
                                  value="<?php echo e(old('points')); ?>">
                            </div>
                            <?php $__errorArgs = ['points'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="mt-1 text-[11px] text-rose-300"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </label>

                        
                        <label class="block">
                            <span class="text-[11px] font-semibold text-slate-200 tracking-wide uppercase">
                                Reference (ঐচ্ছিক)
                            </span>
                            <input
                              type="text"
                              name="ref"
                              maxlength="80"
                              class="mt-1 w-full rounded-2xl border-2 border-slate-700 bg-slate-950/70 px-4 py-2.5 text-sm text-slate-100 outline-none transition
                                     placeholder-slate-500 focus:border-emerald-400 focus:ring-2 focus:ring-emerald-500/30 <?php $__errorArgs = ['ref'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-rose-500 ring-rose-500/40 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                              placeholder="নিজের জন্য ছোট নোট লিখতে পারেন"
                              value="<?php echo e(old('ref')); ?>">
                            <?php $__errorArgs = ['ref'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="mt-1 text-[11px] text-rose-300"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </label>

                        <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-2 rounded-2xl border border-slate-700 bg-slate-900/80 px-4 py-2.5 text-[11px] text-slate-300 shadow-sm">
                            <div>
                                Conversion Rate:
                                <b class="text-emerald-200"><?php echo e($ratePoints); ?> Points</b>
                                =
                                <b class="text-emerald-200">৳<?php echo e(number_format($rateAmount,2)); ?></b>
                            </div>
                            <div>
                                You'll get:
                                <b class="text-emerald-300">৳<span id="will-get">0.00</span></b>
                            </div>
                        </div>

                        
                        <label class="block">
                            <span class="text-[11px] font-semibold text-slate-200 tracking-wide uppercase">
                                PIN (৪ ডিজিট)
                            </span>
                            <div class="relative mt-1">
                                <span class="pointer-events-none absolute left-3 top-1/2 -translate-y-1/2 text-slate-500">
                                  <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" viewBox="0 0 24 24" fill="currentColor">
                                    <path d="M12 2a5 5 0 0 0-5 5v2H6.5A2.5 2.5 0 0 0 4 11.5v7A2.5 2.5 0 0 0 6.5 21h11a2.5 2.5 0 0 0 2.5-2.5v-7A2.5 2.5 0 0 0 17.5 9H17V7a5 5 0 0 0-5-5Zm-3 7V7a3 3 0 0 1 6 0v2Z"/>
                                  </svg>
                                </span>
                                <input
                                  type="password"
                                  name="login_pin"
                                  maxlength="4"
                                  inputmode="numeric"
                                  pattern="\d*"
                                  class="h-11 w-full rounded-2xl border-2 border-slate-700 bg-slate-950/70 pl-9 pr-3 text-sm text-slate-100 placeholder-slate-500 outline-none
                                         focus:border-emerald-400 focus:ring-2 focus:ring-emerald-500/30 text-center tracking-[0.35em] <?php $__errorArgs = ['login_pin'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-rose-500 ring-rose-500/40 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                  placeholder="••••"
                                  autocomplete="off"
                                  required>
                            </div>
                            <?php $__errorArgs = ['login_pin'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="mt-1 text-[11px] text-rose-300"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </label>

                        <button
                          class="w-full rounded-2xl bg-gradient-to-r from-emerald-500 to-cyan-500 px-5 py-2.5 text-center text-sm font-semibold text-slate-950
                                 shadow-[0_18px_45px_-20px_rgba(16,185,129,.9)] hover:from-emerald-400 hover:to-cyan-400 active:scale-[0.98] transition-transform">
                          🔁 Convert Points
                        </button>
                    </form>
                </div>

                <div class="mt-5 text-center">
                    <a href="<?php echo e(url('/profile')); ?>"
                       class="text-[12px] text-slate-300 hover:text-emerald-300 hover:underline inline-flex items-center gap-1">
                        <svg class="h-3.5 w-3.5" viewBox="0 0 24 24" fill="none">
                            <path d="M15 18l-6-6 6-6" stroke="currentColor" stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>
                        Back to Profile
                    </a>
                </div>
            </div>
        </div>
    </main>
</div>

<script>
  (function(){
    const ratePoints = <?php echo e($ratePoints); ?>;
    const rateAmount = <?php echo e(json_encode($rateAmount)); ?>;
    const input = document.querySelector('input[name="points"]');
    const out = document.getElementById('will-get');

    function recalc() {
      const p = parseInt(input.value || '0', 10);
      if (!Number.isFinite(p) || p < ratePoints) {
        out.textContent = '0.00';
        return;
      }
      const steps = Math.floor(p / ratePoints);
      const amount = steps * rateAmount;
      out.textContent = (Math.round(amount * 100) / 100).toFixed(2);
    }
    input && input.addEventListener('input', recalc);
    recalc();
  })();
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ecareba2/new.rkmotorsbike.top/resources/views/frontend/rewards/convert.blade.php ENDPATH**/ ?>