

<?php $__env->startSection('content'); ?>
    <style>
        .status-pill {
            display: inline-flex;
            align-items: center;
            gap: 6px;
            font-weight: 600;
            font-size: .82rem;
            padding: 4px 10px;
            border-radius: 999px;
        }

        .status-pill .dot {
            width: 8px;
            height: 8px;
            border-radius: 50%;
            display: inline-block;
        }

        .status-active {
            background: #ecfdf5;
            color: #065f46;
            border: 1px solid #a7f3d0;
        }

        .status-active .dot {
            background: #10b981;
        }

        .status-blocked {
            background: #fef2f2;
            color: #7f1d1d;
            border: 1px solid #fecaca;
        }

        .status-blocked .dot {
            background: #ef4444;
        }

        .btn-icon {
            display: inline-flex;
            align-items: center;
            gap: 6px;
        }

        /* ---------- MOBILE RESPONSIVE STYLES ---------- */
        @media (max-width: 576px) {
            .users-header {
                flex-direction: column;
                align-items: flex-start !important;
                gap: .5rem;
            }

            .users-header h5 {
                margin-bottom: .25rem !important;
            }

            .users-header a.btn {
                width: 100%;
                justify-content: center;
            }

            .users-search {
                flex-direction: column;
            }

            .users-search input[type="text"] {
                width: 100%;
            }

            .users-search button {
                width: 100%;
            }

            .table-users-wrapper {
                border-radius: .5rem;
                overflow: hidden;
            }

            /* Table as cards */
            .table-users {
                border-collapse: separate;
                border-spacing: 0 0.75rem;
            }

            .table-users thead {
                display: none;
            }

            .table-users tbody tr {
                display: block;
                background: #ffffff;
                border-radius: .75rem;
                box-shadow: 0 2px 6px rgba(15, 23, 42, 0.06);
                padding: .5rem .5rem .35rem;
                margin: 0 .25rem .75rem;
            }

            .table-users tbody td {
                display: flex;
                justify-content: space-between;
                align-items: center;
                padding: .3rem .5rem;
                font-size: .84rem;
                border-top: none !重要;
            }

            .table-users tbody td[data-label]::before {
                content: attr(data-label);
                font-weight: 600;
                color: #6b7280;
                margin-right: .75rem;
                text-transform: uppercase;
                letter-spacing: .03em;
            }

            .table-users tbody td:first-child {
                border-top: none;
            }

            .table-users tbody td.actions-cell {
                flex-direction: column;
                align-items: stretch;
                gap: .35rem;
                margin-top: .35rem;
            }

            .table-users tbody td.actions-cell > div {
                width: 100%;
                justify-content: flex-start !important;
                flex-wrap: wrap;
                gap: .35rem;
            }

            .table-users tbody td.actions-cell .btn,
            .table-users tbody td.actions-cell form button {
                width: 100%;
                justify-content: center;
            }

            .table-users tbody td[data-label="Avatar"] {
                justify-content: flex-start;
            }

            .table-users tbody td[data-label="Avatar"]::before {
                margin-right: .5rem;
            }

            .status-pill {
                font-size: .78rem;
                padding: 3px 8px;
            }
        }
    </style>

    <div class="container-fluid py-3">
        <div class="d-flex justify-content-between align-items-center mb-3 users-header">
            <h5 class="mb-0"><i class="fa-solid fa-users me-2"></i> Users</h5>
            <a href="<?php echo e(route('admin.users.create')); ?>" class="btn btn-primary">
                <i class="fa-solid fa-user-plus me-1"></i> Add User
            </a>
        </div>

        <?php if(session('success')): ?>
            <div class="alert alert-success"><?php echo e(session('success')); ?></div>
        <?php endif; ?>

        <form class="mb-3 d-flex gap-2 users-search" method="GET" action="<?php echo e(route('admin.users.list')); ?>">
            <input type="text" name="search" value="<?php echo e(request('search')); ?>" class="form-control"
                   placeholder="Search name/email/phone">
            <button class="btn btn-outline-secondary"><i class="fa-solid fa-magnifying-glass"></i></button>
        </form>

        <div class="table-responsive card card-body p-0 table-users-wrapper">
            <table class="table align-middle mb-0 table-users">
                <thead class="table-light">
                <tr>
                    <th>#</th>
                    <th>Avatar</th>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Phone</th>
                    <th>Role</th>
                    <th>Status</th>
                    <th class="text-end">Actions</th>
                </tr>
                </thead>
                <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $u): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr id="row-<?php echo e($u->id); ?>">
                        <td data-label="#">
                            <?php echo e($u->id); ?>

                        </td>

                        <td data-label="Avatar">
                            <?php if($u->avatar): ?>
                                <img src="<?php echo e(asset('storage/' . $u->avatar)); ?>" alt=""
                                     style="width:36px;height:36px;border-radius:50%;object-fit:cover">
                            <?php else: ?>
                                <i class="fa-regular fa-circle-user fa-2x text-muted"></i>
                            <?php endif; ?>
                        </td>

                        <td data-label="Name">
                            <?php echo e($u->name); ?>

                        </td>

                        <td data-label="Email">
                            <?php echo e($u->email); ?>

                        </td>

                        <td data-label="Phone">
                            <?php echo e($u->phone); ?>

                        </td>

                        <td data-label="Role">
                            <span class="badge <?php echo e($u->role === 'admin' ? 'bg-primary' : 'bg-secondary'); ?>">
                                <?php echo e(strtoupper($u->role)); ?>

                            </span>
                        </td>

                        
                        <td data-label="Status">
                            <span id="status-pill-<?php echo e($u->id); ?>"
                                  class="status-pill <?php echo e($u->status === 'active' ? 'status-active' : 'status-blocked'); ?>"
                                  title="Current status">
                                <span class="dot"></span>
                                <span class="status-text"><?php echo e(ucfirst($u->status)); ?></span>
                            </span>
                        </td>

                        <td class="text-end actions-cell" data-label="Actions">
                            <div class="d-flex justify-content-end align-items-start gap-2 flex-wrap">

                                
                                <button type="button"
                                        class="btn btn-sm btn-icon js-toggle-status <?php echo e($u->status === 'active' ? 'btn-outline-warning' : 'btn-outline-success'); ?>"
                                        data-url="<?php echo e(route('admin.users.toggle-status', $u)); ?>"
                                        data-id="<?php echo e($u->id); ?>"
                                        data-status="<?php echo e($u->status); ?>" 
                                        title="<?php echo e($u->status === 'active' ? 'Block this user' : 'Unblock this user'); ?>">
                                    <?php if($u->status === 'active'): ?>
                                        <i class="fa-solid fa-user-lock"></i> Block
                                    <?php else: ?>
                                        <i class="fa-solid fa-unlock-keyhole"></i> Unblock
                                    <?php endif; ?>
                                </button>

                                
                                <div class="d-flex flex-column align-items-start" style="min-width:200px;">
                                    <div class="form-check form-switch mb-1">
                                        <input type="checkbox"
                                               class="form-check-input device-lock-toggle"
                                               id="device-lock-<?php echo e($u->id); ?>"
                                               data-user-id="<?php echo e($u->id); ?>"
                                            <?php echo e($u->device_lock ? '' : 'checked'); ?>>
                                        <label class="form-check-label small" for="device-lock-<?php echo e($u->id); ?>">
                                            নতুন ডিভাইসে একবার লগইনের অনুমতি দিন
                                        </label>
                                    </div>
                                    <small id="device-lock-status-<?php echo e($u->id); ?>" class="d-block small text-muted">
                                        <?php if($u->device_lock): ?>
                                            বর্তমানে একাউন্ট একটি ডিভাইসে লক করা আছে।
                                        <?php else: ?>
                                            নতুন ডিভাইস থেকে একবার লগইন করা যাবে (পরের লগইনে আবার লক হবে)।
                                        <?php endif; ?>
                                    </small>
                                </div>

                                
                                <a class="btn btn-sm btn-outline-info btn-icon"
                                   href="<?php echo e(route('admin.users.edit', $u)); ?>"
                                   title="Edit">
                                    <i class="fa-regular fa-pen-to-square"></i> Edit
                                </a>

                                
                                <form action="<?php echo e(route('admin.users.delete', $u)); ?>" method="POST" class="d-inline"
                                      onsubmit="return confirm('Delete this user?')">
                                    <?php echo csrf_field(); ?>
                                    <button class="btn btn-sm btn-outline-danger btn-icon" title="Delete">
                                        <i class="fa-regular fa-trash-can"></i> Delete
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="8" class="text-center text-muted py-4">No users</td>
                    </tr>
                <?php endif; ?>
                </tbody>
            </table>
        </div>

        <div class="mt-3">
            <?php echo e($users->links()); ?>

        </div>
    </div>

    
    <script>
        (function () {
            const csrf =
                document.querySelector('meta[name="csrf-token"]')?.getAttribute('content') ||
                document.querySelector('input[name="_token"]')?.value ||
                '';

            function setLoading(btn, loading = true) {
                if (loading) {
                    btn.dataset.prevHtml = btn.innerHTML;
                    btn.disabled = true;
                    btn.innerHTML =
                        '<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>';
                } else {
                    btn.disabled = false;
                    if (btn.dataset.prevHtml) {
                        btn.innerHTML = btn.dataset.prevHtml;
                    }
                }
            }

            async function toggleStatus(e) {
                const btn = e.currentTarget;
                const url = btn.dataset.url;
                const id  = btn.dataset.id;

                // current status (data-status থেকে)
                const currentStatus = btn.dataset.status === 'blocked' ? 'blocked' : 'active';
                // next status নির্ধারণ
                const nextStatus    = currentStatus === 'active' ? 'blocked' : 'active';

                try {
                    setLoading(btn, true);

                    const res = await fetch(url, {
                        method: 'POST',
                        credentials: 'same-origin',
                        headers: {
                            'X-Requested-With': 'XMLHttpRequest',
                            'X-CSRF-TOKEN': csrf,
                            'Accept': 'application/json',
                            'Content-Type': 'application/json',
                        },
                        body: JSON.stringify({
                            status: nextStatus   // ✅ backend এ exact status পাঠালাম
                        }),
                    });

                    if (!res.ok) throw new Error('HTTP ' + res.status);
                    const data = await res.json();
                    if (!data.ok || !data.status) throw new Error('Server returned error');

                    const finalStatus = data.status === 'blocked' ? 'blocked' : 'active';
                    btn.dataset.status = finalStatus;

                    // Pill update
                    const pill = document.getElementById('status-pill-' + id);
                    const text = pill?.querySelector('.status-text');
                    if (pill) {
                        pill.classList.remove('status-active', 'status-blocked');
                        if (finalStatus === 'active') {
                            pill.classList.add('status-active');
                            if (text) text.textContent = 'Active';
                        } else {
                            pill.classList.add('status-blocked');
                            if (text) text.textContent = 'Blocked';
                        }
                    }

                    // Button style + text update
                    btn.classList.remove('btn-outline-warning', 'btn-outline-success');

                    if (finalStatus === 'active') {
                        btn.classList.add('btn-outline-warning');
                        btn.title = 'Block this user';
                        btn.innerHTML = '<i class="fa-solid fa-user-lock"></i> Block';
                    } else {
                        btn.classList.add('btn-outline-success');
                        btn.title = 'Unblock this user';
                        btn.innerHTML = '<i class="fa-solid fa-unlock-keyhole"></i> Unblock';
                    }

                } catch (err) {
                    console.error(err);
                    alert('Failed to update status. Please try again.');
                    if (btn.dataset.prevHtml) {
                        btn.innerHTML = btn.dataset.prevHtml;
                    }
                } finally {
                    setLoading(btn, false);
                }
            }

            document.querySelectorAll('.js-toggle-status').forEach(btn => {
                btn.addEventListener('click', toggleStatus);
            });
        })();
    </script>

    
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const csrfToken =
                document.querySelector('meta[name="csrf-token"]')?.getAttribute('content') ||
                document.querySelector('input[name="_token"]')?.value ||
                '';

            document.querySelectorAll('.device-lock-toggle').forEach(function (input) {
                input.addEventListener('change', function () {
                    const userId = this.dataset.userId;
                    const allowNewDevice = this.checked; // checked = allow new once (unlock)
                    const statusEl = document.getElementById('device-lock-status-' + userId);

                    if (statusEl) {
                        statusEl.innerText = 'আপডেট হচ্ছে...';
                    }

                    fetch("<?php echo e(route('admin.users.device-lock', ':id')); ?>".replace(':id', userId), {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': csrfToken,
                            'Accept': 'application/json'
                        },
                        body: JSON.stringify({
                            allow_new_device: allowNewDevice ? 1 : 0
                        })
                    })
                        .then(response => {
                            if (!response.ok) {
                                throw new Error('Network response was not ok');
                            }
                            return response.json();
                        })
                        .then(data => {
                            if (data.success) {
                                if (statusEl) {
                                    statusEl.innerText = data.message;
                                }
                            } else {
                                input.checked = !allowNewDevice;
                                if (statusEl) {
                                    statusEl.innerText = 'আপডেট করতে সমস্যা হয়েছে।';
                                }
                            }
                        })
                        .catch(error => {
                            console.error(error);
                            input.checked = !allowNewDevice;
                            if (statusEl) {
                                statusEl.innerText = 'সার্ভারের সাথে সংযোগ হয়নি, পরে আবার চেষ্টা করুন।';
                            }
                            alert('আপডেট করতে সমস্যা হয়েছে।');
                        });
                });
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ecareba2/new.rkmotorsbike.top/resources/views/admin/users/users_list.blade.php ENDPATH**/ ?>