
<?php $__env->startSection('title','Card D. Success'); ?>

<?php $__env->startSection('content'); ?>
<?php
    $isSuccess = in_array($submit->status, ['approved','success','completed']);
    $isFailed  = in_array($submit->status, ['rejected','failed','canceled']);

    if ($isSuccess) {
        $statusLabel = 'অনুমোদিত';
        $statusColor = 'text-green-500';
    } elseif ($isFailed) {
        $statusLabel = 'বাতিল / ব্যর্থ';
        $statusColor = 'text-rose-500';
    } else {
        $statusLabel = 'অপেক্ষমান';
        $statusColor = 'text-orange-500';
    }

    $brand   = $card?->brand ?? 'Card';
    $created = optional($submit->created_at)->format('d-m-Y');
?>

<div class="min-h-screen bg-[#f5f7fb] flex items-center justify-center px-4 py-10">
    <div class="w-full max-w-sm">

        
        <div class="bg-white rounded-3xl shadow-[0_14px_40px_rgba(0,0,0,0.08)] px-6 py-7 text-center">

            
            <div class="flex justify-center mb-4">
                <div class="h-16 w-16 rounded-full bg-emerald-500 flex items-center justify-center">
                    <svg class="h-8 w-8 text-white" viewBox="0 0 24 24" fill="none">
                        <path d="M5 13l4 4L19 7"
                              stroke="currentColor"
                              stroke-width="2.5"
                              stroke-linecap="round"
                              stroke-linejoin="round" />
                    </svg>
                </div>
            </div>

            
            <h1 class="text-[18px] font-extrabold text-gray-800 leading-tight">
                কার্ড অ্যাড মানি রিকোয়েস্ট সাবমিট হয়েছে
            </h1>
            <p class="text-sm text-sky-600 mt-1">
                Add Money (<?php echo e($brand); ?>)
            </p>

            
            <div class="mt-5 bg-white rounded-2xl border border-gray-200 overflow-hidden text-sm text-gray-700">

                
                <div class="flex items-center justify-between px-4 py-2 border-b border-gray-200">
                    <span class="text-gray-600">পরিমাণঃ</span>
                    <span class="font-semibold text-gray-800">
                        ৳<?php echo e(number_format($submit->amount, 2)); ?>

                    </span>
                </div>

                
                <div class="flex items-center justify-between px-4 py-2 border-b border-gray-200">
                    <span class="text-gray-600">কার্ড ব্র্যান্ডঃ</span>
                    <span class="font-semibold text-gray-800">
                        <?php echo e($brand); ?>

                    </span>
                </div>

                
                <div class="flex items-center justify-between px-4 py-2 border-b border-gray-200">
                    <span class="text-gray-600">শেষ ৪ ডিজিটঃ</span>
                    <span class="font-semibold text-gray-800">
                        <?php echo e($lastDigits ? '****'.$lastDigits : 'N/A'); ?>

                    </span>
                </div>

                
                <div class="flex items-center justify-between px-4 py-2 border-b border-gray-200">
                    <span class="text-gray-600">রেফারেন্সঃ</span>
                    <span class="font-semibold text-gray-800">
                        <?php echo e($submit->reference_code); ?>

                    </span>
                </div>

                
                <div class="flex items-center justify-between px-4 py-2 border-b border-gray-200">
                    <span class="text-gray-600">অবস্থাঃ</span>
                    <span class="font-semibold <?php echo e($statusColor); ?>">
                        <?php echo e($statusLabel); ?>

                    </span>
                </div>

                
                <div class="flex items-center justify-between px-4 py-2">
                    <span class="text-gray-600">তারিখঃ</span>
                    <span class="font-semibold text-gray-800">
                        <?php echo e($created); ?>

                    </span>
                </div>
            </div>
        </div>

        
        <a href="<?php echo e(route('add-money.cards.index')); ?>"
           class="mt-5 block w-full text-center bg-emerald-500 hover:bg-emerald-600 text-white font-semibold text-sm py-3 rounded-full shadow-md transition">
            আবার কার্ড সিলেক্ট করুন
        </a>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\new-development-re-banking\re_banking_1\resources\views/frontend/add_money/cards/success.blade.php ENDPATH**/ ?>