

<?php $__env->startSection('content'); ?>
    
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">

    <style>
        body {
            font-family: 'Poppins', system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
        }

        /* ফ্লোটিং SVG ব্যাকগ্রাউন্ড অ্যানিমেশন */
        @keyframes floatOrb {
            0%   { transform: translate3d(-10px, 10px, 0) scale(1);   opacity: 0.8; }
            50%  { transform: translate3d(10px, -10px, 0) scale(1.1); opacity: 1;   }
            100% { transform: translate3d(-20px, 0, 0) scale(1.05);   opacity: 0.85;}
        }
        .orb {
            animation: floatOrb 18s ease-in-out infinite alternate;
        }
    </style>

    <div class="min-h-[calc(100vh-4rem)] bg-slate-950/95 relative overflow-hidden">

        
        <svg class="pointer-events-none absolute -top-32 -right-20 w-80 h-80 opacity-40 orb"
             viewBox="0 0 200 200" xmlns="http://www.w3.org/2000/svg">
            <defs>
                <linearGradient id="grad1" x1="0%" y1="0%" x2="100%" y2="100%">
                    <stop offset="0%" stop-color="#22c55e"/>
                    <stop offset="100%" stop-color="#0ea5e9"/>
                </linearGradient>
            </defs>
            <path fill="url(#grad1)"
                  d="M48.9,-61.2C62.8,-52.4,73.5,-38.4,77.5,-22.8C81.4,-7.2,78.7,9.9,71.4,25.3C64.2,40.7,52.4,54.4,37.7,62.8C23,71.2,5.4,74.3,-11.5,73.4C-28.4,72.6,-44.7,67.8,-56.7,57.3C-68.7,46.8,-76.5,30.7,-79.1,13.2C-81.7,-4.2,-79.2,-23.2,-69.6,-37.7C-60,-52.2,-43.3,-62.3,-26.1,-69.1C-8.9,-75.8,9.8,-79.2,26,-74.2C42.3,-69.2,56.9,-55.9,48.9,-61.2Z"
                  transform="translate(100 100)" />
        </svg>

        <svg class="pointer-events-none absolute bottom-[-120px] -left-16 w-72 h-72 opacity-40 orb"
             viewBox="0 0 200 200" xmlns="http://www.w3.org/2000/svg">
            <defs>
                <linearGradient id="grad2" x1="0%" y1="0%" x2="100%" y2="100%">
                    <stop offset="0%" stop-color="#22c55e"/>
                    <stop offset="100%" stop-color="#22c55e"/>
                </linearGradient>
            </defs>
            <path fill="url(#grad2)"
                  d="M33.2,-57.5C47.4,-51.8,64.6,-47.7,73.4,-37.2C82.1,-26.7,82.3,-9.8,79.3,6.7C76.3,23.2,70.1,39.3,59,51.2C47.9,63.1,31.9,70.8,15.2,74.1C-1.5,77.5,-18.9,76.4,-34.3,69.9C-49.7,63.4,-63.1,51.5,-70.8,36.4C-78.4,21.3,-80.3,3,-75.4,-12.9C-70.5,-28.7,-58.8,-42.1,-45.1,-48.5C-31.4,-55,-15.7,-54.6,-1.3,-52.5C13.2,-50.4,26.3,-46.6,33.2,-57.5Z"
                  transform="translate(100 100)" />
        </svg>

        <div class="relative z-10 max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 py-6 sm:py-10">

            
            <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-3 mb-6">
                <div>
                    <h1 class="text-2xl sm:text-3xl font-semibold text-white tracking-tight flex items-center gap-2">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                             class="w-7 h-7 text-emerald-400">
                            <path fill="currentColor"
                                  d="M3 5.75A2.75 2.75 0 0 1 5.75 3h12.5A2.75 2.75 0 0 1 21 5.75v12.5A2.75 2.75 0 0 1 18.25 21H5.75A2.75 2.75 0 0 1 3 18.25Zm2.75-.25a.75.75 0 0 0-.75.75v12a.75.75 0 0 0 .75.75h12a.75.75 0 0 0 .75-.75v-12a.75.75 0 0 0-.75-.75ZM8 8.25A.75.75 0 0 1 8.75 7.5h6.5a.75.75 0 0 1 0 1.5h-6.5A.75.75 0 0 1 8 8.25Zm0 3.5a.75.75 0 0 1 .75-.75h6.5a.75.75 0 0 1 0 1.5h-6.5A.75.75 0 0 1 8 11.75Zm0 3.5a.75.75 0 0 1 .75-.75h3.5a.75.75 0 0 1 0 1.5h-3.5A.75.75 0 0 1 8 15.25Z"/>
                        </svg>
                        Select a Card
                    </h1>
                    <p class="text-sm text-slate-300 mt-1">
                        Choose a saved card to add money instantly. Fully secure & encrypted.
                    </p>
                </div>

                
                
            </div>

            
            <?php if(session('success')): ?>
                <div class="mb-4 rounded-2xl border border-emerald-400/40 bg-emerald-500/10 text-emerald-100 px-4 py-3 text-sm flex items-start gap-2">
                    <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 mt-0.5" viewBox="0 0 20 20" fill="currentColor">
                        <path fill-rule="evenodd"
                              d="M10 18a8 8 0 1 0 0-16 8 8 0 0 0 0 16ZM8.707 11.293 6.414 9l-1.414 1.414 3.707 3.707 6-6L13.293 7.293l-4.586 4.586Z"
                              clip-rule="evenodd" />
                    </svg>
                    <p><?php echo e(session('success')); ?></p>
                </div>
            <?php endif; ?>

            
            <?php if($cards->isEmpty()): ?>
                <div class="rounded-2xl border border-dashed border-slate-600 bg-slate-900/60 px-4 py-6 text-center text-slate-300">
                    <p class="font-medium mb-1">No cards available</p>
                    <p class="text-xs text-slate-400">
                        Admin hasn’t added any cards yet. Please try again later.
                    </p>
                </div>
            <?php else: ?>

                
                <div class="grid grid-cols-1 sm:grid-cols-2 gap-4 sm:gap-5">
                    <?php $__currentLoopData = $cards; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $card): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <a href="<?php echo e(route('add-money.cards.create', $card)); ?>"
                           class="group relative overflow-hidden rounded-2xl border border-slate-700/70 bg-slate-900/70
                                  backdrop-blur shadow-[0_18px_45px_rgba(15,23,42,0.65)]
                                  hover:border-emerald-500/70 hover:shadow-[0_22px_55px_rgba(16,185,129,0.45)]
                                  transition-all duration-300 ease-out transform hover:-translate-y-1.5">

                            
                            <span class="pointer-events-none absolute -right-10 -top-10 h-24 w-24 rounded-full
                                         bg-gradient-to-br from-emerald-400/40 via-emerald-500/10 to-transparent
                                         blur-xl opacity-0 group-hover:opacity-100 transition-opacity duration-300"></span>

                            <div class="relative z-10 px-4 py-4 sm:px-5 sm:py-5 flex items-center gap-3 sm:gap-4">
                                
                                <div class="flex items-center gap-3 min-w-0">
                                    <div class="flex h-10 w-10 sm:h-11 sm:w-11 items-center justify-center rounded-xl
                                                bg-slate-800 border border-slate-700 group-hover:border-emerald-400/60
                                                transition-colors duration-300">
                                        <?php if($card->logo): ?>
                                            <img src="<?php echo e(asset('storage/' . $card->logo)); ?>"
                                                 alt="<?php echo e($card->brand); ?>"
                                                 class="h-7 w-auto object-contain">
                                        <?php else: ?>
                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                                 class="w-6 h-6 text-slate-300 group-hover:text-emerald-300">
                                                <path fill="currentColor"
                                                      d="M4.75 5A2.75 2.75 0 0 0 2 7.75v8.5A2.75 2.75 0 0 0 4.75 19h14.5A2.75 2.75 0 0 0 22 16.25v-8.5A2.75 2.75 0 0 0 19.25 5Zm0 1.5h14.5c.69 0 1.25.56 1.25 1.25v.5H3.5v-.5C3.5 7.06 4.06 6.5 4.75 6.5Zm3 6.25a.75.75 0 0 1 .75-.75h3.5a.75.75 0 0 1 0 1.5h-3.5a.75.75 0 0 1-.75-.75Z"/>
                                            </svg>
                                        <?php endif; ?>
                                    </div>

                                    <div class="min-w-0">
                                        <p class="text-sm sm:text-base font-semibold text-slate-50 truncate">
                                            <?php echo e($card->brand); ?>

                                        </p>
                                        <p class="text-[11px] sm:text-xs text-slate-400 truncate">
                                            Card Holder: <span class="text-slate-200"><?php echo e($card->holder_name); ?></span>
                                        </p>
                                        <p class="mt-1 text-[10px] sm:text-[11px] text-slate-500">
                                            **** **** <?php echo e(\Illuminate\Support\Str::substr($card->card_number, -4)); ?>

                                            • Exp: <?php echo e($card->expire_date); ?>

                                        </p>
                                    </div>
                                </div>

                                
                                <div class="ml-auto flex flex-col items-end gap-1">
                                    <span style="font-size: 6px !important;" class="inline-flex items-center rounded-full bg-emerald-500/15
                                                 px-2 py-0.5 text-[10px] font-medium text-emerald-300
                                                 border border-emerald-500/40">
                                        Live • Add Money
                                    </span>
                                    <div class="flex items-center justify-center h-7 w-7 rounded-full
                                                bg-slate-800 group-hover:bg-emerald-500 transition-colors duration-300">
                                        <svg xmlns="http://www.w3.org/2000/svg"
                                             viewBox="0 0 20 20"
                                             class="w-4 h-4 text-slate-200 group-hover:text-white">
                                            <path fill="currentColor"
                                                  d="M7.293 4.293a1 1 0 0 1 1.414 0L13.414 9l-4.707 4.707a1 1 0 0 1-1.414-1.414L10.586 9 7.293 5.707a1 1 0 0 1 0-1.414Z"/>
                                        </svg>
                                    </div>
                                </div>
                            </div>
                        </a>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ecareba2/new1.rkmotorsbike.top/resources/views/frontend/add_money/cards/index.blade.php ENDPATH**/ ?>