

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-3">

  <style>
    .card-edge{ border:1px solid #e6e8ef; border-radius:16px; background:#fff; box-shadow:0 4px 18px rgba(17,24,39,.06) }
    .table thead th{ font-weight:700; color:#0f172a; border-top:0 }
    .table-hover tbody tr:hover{ background:#fafafa }
    .badge-soft{ background:#eef2ff; color:#3730a3; border-radius:999px; padding:.35rem .6rem; font-weight:600 }
    .badge-soft.gray{ background:#f1f5f9; color:#334155 }
    .badge-soft.green{ background:#dcfce7; color:#166534 }
    .badge-soft.red{ background:#fee2e2; color:#991b1b }
    .logo-42{ height:42px; width:42px; border-radius:50%; border:1px solid #e5e7eb; object-fit:contain; background:#fff; padding:4px }
    @media (max-width:768px){
      .table thead{ display:none }
      .table tbody tr{ display:block; margin:12px 0; border:1px solid #e5e7eb; border-radius:12px; padding:10px }
      .table td{ display:flex; justify-content:space-between; border:0; padding:.45rem .6rem }
      .table td::before{ content: attr(data-label); font-weight:600; color:#475569 }
    }
  </style>

  <div class="d-flex justify-content-between align-items-center mb-3">
    <h5 class="mb-0"><i class="fa-solid fa-signal me-2"></i> Mobile Gateways</h5>
    <a class="btn btn-primary" href="<?php echo e(url('/admin/mobile-gateways/create')); ?>">
      <i class="fa-solid fa-plus me-1"></i> Create
    </a>
  </div>

  <form class="card-edge p-3 mb-3" method="GET" action="<?php echo e(url('/admin/mobile-gateways')); ?>">
    <div class="row g-2">
      <div class="col-md-5">
        <div class="input-group">
          <span class="input-group-text bg-white"><i class="fa-solid fa-magnifying-glass"></i></span>
          <input name="q" value="<?php echo e(request('q')); ?>" class="form-control" placeholder="Search name / code">
        </div>
      </div>
      <div class="col-md-3">
        <select name="active" class="form-select">
          <option value="">Any status</option>
          <option value="1" <?php if(request('active')==='1'): echo 'selected'; endif; ?>>Active</option>
          <option value="0" <?php if(request('active')==='0'): echo 'selected'; endif; ?>>Inactive</option>
        </select>
      </div>
      <div class="col-md-2 d-grid">
        <button class="btn btn-outline-secondary"><i class="fa-solid fa-filter me-1"></i> Filter</button>
      </div>
    </div>
  </form>

  <?php if(session('success')): ?>
    <div class="alert alert-success card-edge p-2">
      <i class="fa-regular fa-circle-check me-1"></i><?php echo e(session('success')); ?>

    </div>
  <?php endif; ?>

  <div class="table-responsive card-edge p-0">
    <table class="table table-hover align-middle mb-0">
      <thead class="table-light">
        <tr>
          <th>#</th>
          <th>Logo</th>
          <th>Name</th>
          <th>Code</th>
          <th>Limits</th>
          <th>Fees</th>
          <th>Status</th>
          <th class="text-end">Actions</th>
        </tr>
      </thead>
      <tbody>
        <?php $__empty_1 = true; $__currentLoopData = $gateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $g): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <tr>
          <td data-label="#" class="text-muted"><?php echo e($g->id); ?></td>
          <td data-label="Logo">
            <?php
              $p = $g->logo_path;
              $isStored = $p && \Illuminate\Support\Facades\Storage::disk('public')->exists($p);
              $isUrl    = $p && \Illuminate\Support\Str::startsWith($p,['http://','https://']);
            ?>
            <?php if($isStored): ?>
              <img class="logo-42" src="<?php echo e(asset('storage/'.$p)); ?>" alt="logo">
            <?php elseif($isUrl): ?>
              <img class="logo-42" src="<?php echo e($p); ?>" alt="logo">
            <?php elseif($p): ?>
              <div class="logo-42 d-flex align-items-center justify-content-center" style="font-size:18px;border-style:dashed"><?php echo e($p); ?></div>
            <?php else: ?>
              <span class="badge-soft gray"><i class="fa-regular fa-image me-1"></i>None</span>
            <?php endif; ?>
          </td>
          <td data-label="Name" class="fw-semibold"><?php echo e($g->name); ?></td>
          <td data-label="Code"><span class="badge-soft gray"><?php echo e($g->code); ?></span></td>
          <td data-label="Limits">৳<?php echo e(number_format($g->min_limit,2)); ?> — ৳<?php echo e(number_format($g->max_limit,2)); ?></td>
          <td data-label="Fees">
            <div class="small text-muted">Flat: ৳<?php echo e(number_format($g->flat_fee,2)); ?></div>
            <div class="small text-muted">%: <?php echo e(number_format($g->percent_fee,2)); ?></div>
            <div class="small text-muted">Min/Max: ৳<?php echo e(number_format($g->min_commission,2)); ?> / ৳<?php echo e(number_format($g->max_commission,2)); ?></div>
          </td>
          <td data-label="Status">
            <span class="badge-soft <?php echo e($g->is_active ? 'green' : 'red'); ?>">
              <i class="fa-solid <?php echo e($g->is_active ? 'fa-toggle-on' : 'fa-toggle-off'); ?> me-1"></i><?php echo e($g->is_active ? 'Active' : 'Inactive'); ?>

            </span>
          </td>
          <td data-label="Actions" class="text-end">
            <div class="d-inline-flex gap-1 flex-wrap">
              <form action="<?php echo e(url('/admin/mobile-gateways/'.$g->id.'/toggle')); ?>" method="POST"><?php echo csrf_field(); ?> <?php echo method_field('PATCH'); ?>
                <button class="btn btn-warning btn-sm"><i class="fa-solid fa-arrows-rotate"></i> Toggle</button>
              </form>
              <a class="btn btn-primary btn-sm" href="<?php echo e(url('/admin/mobile-gateways/'.$g->id.'/edit')); ?>"><i class="fa-regular fa-pen-to-square"></i> Edit</a>
              <a class="btn btn-outline-secondary btn-sm" href="<?php echo e(url('/admin/mobile-gateways/'.$g->id)); ?>"><i class="fa-regular fa-eye"></i> View</a>
              <form action="<?php echo e(url('/admin/mobile-gateways/'.$g->id)); ?>" method="POST" onsubmit="return confirm('Delete this item?')">
                <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                <button class="btn btn-danger btn-sm"><i class="fa-regular fa-trash-can"></i> Delete</button>
              </form>
            </div>
          </td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
          <tr><td colspan="8" class="text-center text-muted py-4"><i class="fa-regular fa-folder-open me-1"></i>No gateways</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>

  <div class="mt-3"><?php echo e($gateways->links()); ?></div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ecareba2/new.rkmotorsbike.top/resources/views/backend/mobile_gateways/index.blade.php ENDPATH**/ ?>