
<?php $__env->startSection('title','পে-বিল'); ?>

<?php $__env->startPush('styles'); ?>
    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@400;500;600;700&family=Poppins:wght@400;500;600&display=swap" rel="stylesheet">

    <style>
        body {
            font-family: "Hind Siliguri", system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
        }

        @keyframes blobFloat {
            0%   { transform: translate3d(-10%, -10%, 0) scale(1); }
            50%  { transform: translate3d(15%, 10%, 0) scale(1.08); }
            100% { transform: translate3d(40%, -5%, 0) scale(1); }
        }

        @keyframes blobFloat2 {
            0%   { transform: translate3d(40%, 20%, 0) scale(1); }
            50%  { transform: translate3d(5%, 0, 0) scale(1.04); }
            100% { transform: translate3d(-20%, 10%, 0) scale(1); }
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-gradient-to-b from-slate-950 via-slate-900 to-slate-950 flex justify-center items-start px-3 sm:px-4 py-8 relative overflow-hidden">

    
    <svg class="pointer-events-none absolute -top-32 -left-32 w-80 h-80 text-emerald-500/20"
         viewBox="0 0 200 200" xmlns="http://www.w3.org/2000/svg"
         style="animation: blobFloat 18s ease-in-out infinite alternate;">
        <path fill="currentColor"
              d="M45.1,-62C58.8,-54.8,69.1,-39.4,73.4,-22.5C77.7,-5.7,75.9,12.7,67.4,26.8C58.8,40.9,43.4,50.7,27.2,58.2C11,65.7,-6,70.9,-20.4,66.3C-34.7,61.6,-46.4,47.1,-55.3,31.5C-64.3,15.9,-70.4,-0.7,-68.1,-16.7C-65.8,-32.7,-55.1,-48.1,-41.2,-55.6C-27.3,-63.1,-10.1,-62.6,5.7,-69C21.5,-75.3,43,-88.4,45.1,-62Z"/>
    </svg>

    <svg class="pointer-events-none absolute bottom-0 -right-24 w-72 h-72 text-cyan-400/10"
         viewBox="0 0 200 200" xmlns="http://www.w3.org/2000/svg"
         style="animation: blobFloat2 22s ease-in-out infinite alternate;">
        <path fill="currentColor"
              d="M35.8,-54.7C46.3,-47.4,54,-38,60.9,-27.1C67.7,-16.2,73.7,-4.1,71.9,6.8C70.1,17.7,60.5,27.3,50.4,36.6C40.4,46,29.9,55.3,17.3,60.4C4.6,65.6,-10.1,66.6,-24.4,62.4C-38.7,58.3,-52.6,49.1,-59.8,36.3C-66.9,23.4,-67.3,7,-64.6,-8.3C-61.9,-23.6,-56.1,-37.9,-45.7,-45.9C-35.2,-53.9,-20.1,-55.7,-5.2,-49.9C9.7,-44,19.3,-30.5,35.8,-54.7Z"/>
    </svg>

    <main class="mx-auto max-w-[420px] w-full relative z-10">

        
        <div class="mb-4 flex items-center justify-between text-xs text-slate-300">
            <button type="button"
                    onclick="window.history.back()"
                    class="inline-flex items-center gap-1 text-slate-300 hover:text-emerald-400 transition">
                <svg class="h-4 w-4" viewBox="0 0 24 24" fill="currentColor">
                    <path d="M15.75 4.75 9.5 11l6.25 6.25-1.5 1.5L6.5 11l7.75-7.75 1.5 1.5Z"/>
                </svg>
                Back
            </button>
            <span class="tracking-[0.18em] uppercase text-emerald-400 font-semibold text-[11px]">
                Pay Bill
            </span>
        </div>

        
        <div class="rounded-3xl bg-slate-900/80 border border-emerald-500/25 shadow-[0_25px_70px_-35px_rgba(16,185,129,0.7)] backdrop-blur-sm p-5 sm:p-6">

            
            <div class="rounded-2xl border border-rose-500/40 bg-rose-500/10 p-4 text-sm text-rose-100 shadow-sm">
                📣 বিল পরিশোধের আগে তথ্য সঠিকভাবে প্রদান করুন!
                <span class="mt-1 block text-[11px] text-rose-100/80">৳১০০০-এর বেশি বিল পেমেন্টে <b>৮% ক্যাশব্যাক</b>।</span>
            </div>

            
            <?php
                $logo = $biller->logo;
                $isStored = $logo && \Illuminate\Support\Facades\Storage::disk('public')->exists($logo);
                $isUrl    = $logo && \Illuminate\Support\Str::startsWith($logo, ['http://','https://']);
                $initial  = mb_substr($biller->name ?? 'B', 0, 1);
            ?>

            <div class="mt-4 rounded-2xl border border-slate-700 bg-slate-900/80 p-4 text-center shadow-sm">
                <div class="flex items-center gap-3 justify-center">
                    
                    <div class="h-12 w-12 rounded-2xl overflow-hidden ring-2 ring-emerald-500/35 bg-slate-900 shadow-[0_10px_30px_-18px_rgba(0,0,0,.9)] flex items-center justify-center">
                        <?php if($isStored): ?>
                            <img src="<?php echo e(asset('storage/'.$logo)); ?>" alt="logo" class="h-full w-full object-contain p-1.5" loading="lazy">
                        <?php elseif($isUrl): ?>
                            <img src="<?php echo e($logo); ?>" alt="logo" class="h-full w-full object-contain p-1.5" loading="lazy">
                        <?php elseif($logo): ?>
                            <span class="text-base font-bold text-emerald-300"><?php echo e(mb_substr($logo,0,1)); ?></span>
                        <?php else: ?>
                            <span class="text-base font-bold text-emerald-300"><?php echo e($initial); ?></span>
                        <?php endif; ?>
                    </div>

                    <div class="text-left min-w-0">
                        <div class="text-[15px] font-extrabold text-slate-50 leading-5 truncate">
                            <?php echo e($biller->name); ?>

                        </div>
                        <div class="text-[11px] text-slate-400 truncate">
                            <?php echo e($biller->provider ?: ($biller->category->name ?? '')); ?>

                        </div>
                    </div>

                    <?php if($biller->type): ?>
                        <span class="ml-auto inline-flex items-center rounded-full bg-emerald-500/10 px-2.5 py-1 text-[11px] font-semibold text-emerald-300">
                            <?php echo e(ucfirst($biller->type)); ?>

                        </span>
                    <?php endif; ?>
                </div>
            </div>

            
            <?php if(session('success')): ?>
                <div class="mt-3 rounded-2xl border border-emerald-500/40 bg-emerald-500/10 px-4 py-3 text-[11px] text-emerald-100 shadow-sm">
                    <?php echo e(session('success')); ?>

                </div>
            <?php endif; ?>
            <?php if($errors->any()): ?>
                <div class="mt-3 rounded-2xl border border-rose-500/40 bg-rose-500/10 px-4 py-3 text-[11px] text-rose-100 shadow-sm">
                    <ul class="list-disc list-inside space-y-0.5">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $e): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <li><?php echo e($e); ?></li> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>

            
            <form method="POST" action="<?php echo e(route('paybills.pay', $biller)); ?>" class="mt-4 space-y-4" id="bill-form">
                <?php echo csrf_field(); ?>

                <div class="rounded-3xl border border-slate-700 bg-slate-900/80 p-4 shadow-sm space-y-4">

                    
                    <label class="block text-[11px] font-semibold text-slate-200 tracking-wide uppercase">
                        অ্যাকাউন্ট নাম
                        <input
                            name="account_name"
                            value="<?php echo e(old('account_name')); ?>"
                            class="mt-1 w-full rounded-2xl border-2 border-slate-700 bg-slate-950/70 px-4 py-2.5 text-sm text-slate-100 outline-none transition
                                   placeholder-slate-500 focus:border-emerald-400 focus:ring-2 focus:ring-emerald-500/30"
                            required>
                    </label>

                    
                    <label class="block text-[11px] font-semibold text-slate-200 tracking-wide uppercase">
                        বিলার নম্বর
                        <input
                            name="account_no"
                            value="<?php echo e(old('account_no')); ?>"
                            class="mt-1 w-full rounded-2xl border-2 border-slate-700 bg-slate-950/70 px-4 py-2.5 text-sm text-slate-100 outline-none transition
                                   placeholder-slate-500 focus:border-emerald-400 focus:ring-2 focus:ring-emerald-500/30"
                            required>
                    </label>

                    
                    <label class="block text-[11px] font-semibold text-slate-200 tracking-wide uppercase">
                        পরিমাণ লিখুন
                        <div class="relative mt-1">
                            <span class="pointer-events-none absolute left-3 top-1/2 -translate-y-1/2 text-emerald-400 text-xs">৳</span>
                            <input
                                type="number" step="1"
                                min="<?php echo e($biller->min_amount); ?>" max="<?php echo e($biller->max_amount); ?>"
                                name="amount" value="<?php echo e(old('amount')); ?>"
                                class="w-full rounded-2xl border-2 border-slate-700 bg-slate-950/70 pl-8 pr-4 py-2.5 text-sm text-slate-100 outline-none transition
                                       placeholder-slate-500 focus:border-emerald-400 focus:ring-2 focus:ring-emerald-500/30"
                                required>
                        </div>
                        <div class="mt-1 text-[10px] text-slate-400">
                            ন্যূনতম: ৳<?php echo e(number_format($biller->min_amount,2)); ?> • সর্বোচ্চ: ৳<?php echo e(number_format($biller->max_amount,2)); ?>

                        </div>
                    </label>

                    
                    <label class="block text-[11px] font-semibold text-slate-200 tracking-wide uppercase">
                        রেফারেন্স (ঐচ্ছিক)
                        <input
                            name="reference"
                            value="<?php echo e(old('reference')); ?>"
                            class="mt-1 w-full rounded-2xl border-2 border-slate-700 bg-slate-950/70 px-4 py-2.5 text-sm text-slate-100 outline-none transition
                                   placeholder-slate-500 focus:border-emerald-400 focus:ring-2 focus:ring-emerald-500/30">
                    </label>

                    
                    <div id="cashbackCard" class="mt-2 rounded-2xl border border-slate-700 bg-slate-900/90 p-3 shadow-sm text-sm text-slate-100">
                        <div class="mb-2 font-semibold text-slate-50 text-sm">ক্যালকুলেশন</div>
                        <div class="grid grid-cols-2 gap-3">
                            <div class="rounded-xl bg-slate-900 p-3 border border-slate-800">
                                <div class="text-[11px] text-slate-400">অ্যামাউন্ট</div>
                                <div class="mt-0.5 text-lg font-extrabold text-slate-50">৳<span id="amt">0</span></div>
                            </div>
                            <div class="rounded-xl bg-emerald-500/10 p-3 border border-emerald-500/40">
                                <div class="text-[11px] text-emerald-200 font-semibold">আনুমানিক ক্যাশব্যাক</div>
                                <div class="mt-0.5 text-lg font-extrabold text-emerald-300">৳<span id="cb">0</span></div>
                                <div class="mt-0.5 text-[10px] text-slate-300">(৳১০০০-এর বেশি হলে ৮%)</div>
                            </div>
                        </div>
                    </div>

                    
                    <button
                        class="mt-3 w-full rounded-2xl bg-gradient-to-r from-emerald-500 to-cyan-500 px-5 py-2.5 text-center text-sm font-semibold text-slate-950
                               shadow-[0_18px_45px_-20px_rgba(16,185,129,0.9)] hover:from-emerald-400 hover:to-cyan-400 active:scale-[0.98] transition-transform">
                        পেমেন্ট সাবমিট করুন
                    </button>
                </div>
            </form>
        </div>
    </main>
</div>


<script>
  (function(){
    const amountInput = document.querySelector('input[name="amount"]');
    const amtEl = document.getElementById('amt');
    const cbEl  = document.getElementById('cb');

    function fmt(n){ return (Math.round((+n||0)*100)/100).toFixed(0); }

    function recalc(){
      let a = parseFloat(amountInput.value || '0');
      amtEl.textContent = fmt(a);
      const cashback = a > 1000 ? a * 0.08 : 0;
      cbEl.textContent = fmt(cashback);
    }

    amountInput && amountInput.addEventListener('input', recalc);
    recalc();
  })();
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\production_re_banking\resources\views/frontend/paybills/show.blade.php ENDPATH**/ ?>