
<?php $__env->startSection('title','পেমেন্ট মেথড'); ?>

<?php $__env->startPush('styles'); ?>
    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@400;500;600;700&family=Poppins:wght@400;500;600&display=swap" rel="stylesheet">

    <style>
        body {
            font-family: "Hind Siliguri", system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
        }

        @keyframes blobFloat {
            0%   { transform: translate3d(-10%, -10%, 0) scale(1); }
            50%  { transform: translate3d(15%, 10%, 0) scale(1.06); }
            100% { transform: translate3d(35%, -5%, 0) scale(1); }
        }

        @keyframes blobFloat2 {
            0%   { transform: translate3d(40%, 20%, 0) scale(1); }
            50%  { transform: translate3d(0, 0, 0) scale(1.04); }
            100% { transform: translate3d(-25%, 5%, 0) scale(1); }
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-gradient-to-b from-slate-950 via-slate-900 to-slate-950 flex justify-center items-start px-3 sm:px-4 py-8 relative overflow-hidden">

    
    <svg class="pointer-events-none absolute -top-32 -left-32 w-80 h-80 text-sky-500/16"
         viewBox="0 0 200 200" xmlns="http://www.w3.org/2000/svg"
         style="animation: blobFloat 20s ease-in-out infinite alternate;">
        <path fill="currentColor"
              d="M45.1,-62C58.8,-54.8,69.1,-39.4,73.4,-22.5C77.7,-5.7,75.9,12.7,67.4,26.8C58.8,40.9,43.4,50.7,27.2,58.2C11,65.7,-6,70.9,-20.4,66.3C-34.7,61.6,-46.4,47.1,-55.3,31.5C-64.3,15.9,-70.4,-0.7,-68.1,-16.7C-65.8,-32.7,-55.1,-48.1,-41.2,-55.6C-27.3,-63.1,-10.1,-62.6,5.7,-69C21.5,-75.3,43,-88.4,45.1,-62Z"/>
    </svg>

    <svg class="pointer-events-none absolute bottom-0 -right-24 w-72 h-72 text-emerald-400/12"
         viewBox="0 0 200 200" xmlns="http://www.w3.org/2000/svg"
         style="animation: blobFloat2 22s ease-in-out infinite alternate;">
        <path fill="currentColor"
              d="M35.8,-54.7C46.3,-47.4,54,-38,60.9,-27.1C67.7,-16.2,73.7,-4.1,71.9,6.8C70.1,17.7,60.5,27.3,50.4,36.6C40.4,46,29.9,55.3,17.3,60.4C4.6,65.6,-10.1,66.6,-24.4,62.4C-38.7,58.3,-52.6,49.1,-59.8,36.3C-66.9,23.4,-67.3,7,-64.6,-8.3C-61.9,-23.6,-56.1,-37.9,-45.7,-45.9C-35.2,-53.9,-20.1,-55.7,-5.2,-49.9C9.7,-44,19.3,-30.5,35.8,-54.7Z"/>
    </svg>

    <div class="w-full max-w-3xl relative z-10">

        
        <div class="mb-4 flex items-center justify-between text-xs text-slate-300">
            <button type="button"
                    onclick="window.history.back()"
                    class="inline-flex items-center gap-1 text-slate-300 hover:text-emerald-400 transition">
                <svg class="h-4 w-4" viewBox="0 0 24 24" fill="currentColor">
                    <path d="M15.75 4.75 9.5 11l6.25 6.25-1.5 1.5L6.5 11l7.75-7.75 1.5 1.5Z"/>
                </svg>
                Back
            </button>
            <span class="tracking-[0.18em] uppercase text-emerald-400 font-semibold text-[11px]">
                Payment Methods
            </span>
        </div>

        
        <div class="rounded-3xl bg-slate-900/80 border border-emerald-500/30 shadow-[0_25px_70px_-35px_rgba(16,185,129,0.75)] backdrop-blur-sm px-4 sm:px-6 py-5">

            
            <div class="mb-4 text-center">
                <h1 class="text-lg sm:text-xl font-semibold text-slate-50">
                    পেমেন্ট মেথড নির্বাচন করুন
                </h1>
                <p class="mt-1 text-[11px] text-slate-400">
                    যেকোনো একটি মেথড সিলেক্ট করে ব্যালেন্স এড করুন।
                </p>
            </div>

            
            <div class="space-y-3">
                <?php $__empty_1 = true; $__currentLoopData = $methods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <?php
                        $name      = $m->name ?? '';
                        $logo      = $m->logo ?? null;
                        $accountNo = $m->account_no ?? null;
                        $dailyMin  = $m->daily_min;
                        $dailyMax  = $m->daily_max;
                        $initial   = strtoupper(mb_substr($name ?: 'P', 0, 1));
                    ?>

                    <a href="<?php echo e(url('/add-money/'.$m->slug)); ?>"
                       class="group flex items-center justify-between gap-3 rounded-2xl border border-slate-700/80 bg-slate-900/70 px-4 py-3
                              shadow-[0_18px_45px_-30px_rgba(15,118,110,0.9)] hover:border-emerald-500/50 hover:bg-slate-900/90 transition">

                        <div class="flex items-center gap-3 min-w-0">
                            
                            <div class="h-11 w-11 rounded-2xl bg-slate-800/90 ring-1 ring-emerald-500/30 overflow-hidden grid place-items-center">
                                <?php if(!empty($logo)): ?>
                                    <img src="<?php echo e(asset('storage/'.$logo)); ?>"
                                         alt="<?php echo e($name); ?> logo"
                                         loading="lazy"
                                         class="h-full w-full object-cover">
                                <?php else: ?>
                                    <span class="text-sm font-semibold text-emerald-300">
                                        <?php echo e($initial); ?>

                                    </span>
                                <?php endif; ?>
                            </div>

                            <div class="min-w-0">
                                <div class="truncate text-[14px] font-semibold text-slate-50">
                                    <?php echo e($name); ?>

                                </div>
                                <div class="mt-0.5 truncate text-[11px] text-slate-400">
                                    দৈনিক লিমিটঃ
                                    <?php echo e($dailyMin !== null ? number_format($dailyMin) : 0); ?>

                                    -
                                    <?php echo e($dailyMax !== null ? number_format($dailyMax) : '∞'); ?>

                                </div>
                                <?php if($accountNo): ?>
                                    <div class="mt-0.5 truncate text-[11px] text-slate-500">
                                        অ্যাকাউন্ট:
                                        <span class="font-mono tracking-tight"><?php echo e($accountNo); ?></span>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="shrink-0 flex items-center">
                            <span class="mr-2 rounded-full bg-emerald-500/10 px-2 py-0.5 text-[10px] font-semibold text-emerald-300 border border-emerald-500/30 group-hover:bg-emerald-500/20">
                                Continue
                            </span>
                            <svg xmlns="http://www.w3.org/2000/svg"
                                 class="h-4 w-4 text-emerald-300 group-hover:translate-x-0.5 transition-transform"
                                 viewBox="0 0 24 24" fill="none" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                      d="M9 5l7 7-7 7" />
                            </svg>
                        </div>
                    </a>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="rounded-2xl border border-slate-700 bg-slate-900/70 px-4 py-5 text-center text-sm text-slate-400">
                        কোনো মেথড সেট করা নেই।
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\new-development-re-banking\re_banking_1\resources\views/frontend/add-money/methods.blade.php ENDPATH**/ ?>