

<?php $__env->startSection('title','Statement'); ?>

<?php $__env->startPush('styles'); ?>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@400;500;600;700&family=Poppins:wght@400;500;600&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: "Hind Siliguri", system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
        }
        [x-cloak] { display:none !important; }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
    
    <script src="https://unpkg.com/alpinejs" defer></script>
    <script>
        document.addEventListener('alpine:init', () => {
            Alpine.data('statementSheet', () => ({
                show: false,
                tx: {},

                open(data) {
                    this.tx = data;
                    this.show = true;
                },
                close() {
                    this.show = false;
                }
            }));
        });
    </script>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div x-data="statementSheet()"
     class="min-h-screen bg-gradient-to-b from-slate-950 via-slate-900 to-slate-950 flex justify-center items-start px-3 sm:px-4 py-8">

    <div class="w-full max-w-4xl space-y-4">

        
        <div class="flex items-center justify-between text-xs text-slate-300 mb-1">
            <button onclick="window.location='<?php echo e(route('statement.form')); ?>'"
                    class="inline-flex items-center gap-1 text-slate-300 hover:text-emerald-400 transition">
                <svg class="h-4 w-4" viewBox="0 0 24 24" fill="currentColor">
                    <path d="M15.75 4.75 9.5 11l6.25 6.25-1.5 1.5L6.5 11l7.75-7.75 1.5 1.5Z"/>
                </svg>
                Back
            </button>
            <span class="tracking-[0.18em] uppercase text-emerald-400 font-semibold text-[11px]">
                Statement
            </span>
        </div>

        
        <div class="rounded-3xl bg-slate-900/85 border border-emerald-500/25 shadow-[0_25px_70px_-35px_rgba(16,185,129,0.7)] px-4 py-4 sm:px-6 sm:py-5">
            <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4">
                <div class="flex items-center gap-3">
                    <div class="h-11 w-11 rounded-2xl bg-gradient-to-br from-emerald-500 to-cyan-500 flex items-center justify-center text-white shadow-lg">
                        <svg class="h-5 w-5" viewBox="0 0 24 24" fill="currentColor">
                            <path d="M12 12a4 4 0 1 0-4-4 4.01 4.01 0 0 0 4 4Zm0 2c-3.33 0-6 1.34-6 3v1a1 1 0 0 0 1 1h10a1 1 0 0 0 1-1v-1c0-1.66-2.67-3-6-3Z"/>
                        </svg>
                    </div>
                    <div>
                        <div class="text-sm font-semibold text-slate-50"><?php echo e($user->name); ?></div>
                        <div class="flex items-center gap-1 text-[11px] text-slate-400">
                            <svg class="h-3.5 w-3.5" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M6.62 10.79a15.05 15.05 0 0 0 6.59 6.59l2.2-2.2a1 1 0 0 1 1-.24 11.36 11.36 0 0 0 3.56.57 1 1 0 0 1 1 1V20a2 2 0 0 1-2 2A17.62 17.62 0 0 1 2 4a2 2 0 0 1 2-2h3.5a1 1 0 0 1 1 1 11.36 11.36 0 0 0 .57 3.56 1 1 0 0 1-.24 1Z"/>
                            </svg>
                            <span><?php echo e($user->phone ?? $user->email); ?></span>
                        </div>
                    </div>
                </div>
                <div class="text-xs text-slate-300 text-left sm:text-right">
                    <div class="uppercase tracking-wide text-slate-400">Period</div>
                    <div class="font-semibold text-slate-50">
                        <?php echo e($from->timezone('Asia/Dhaka')->format('d M Y')); ?> – <?php echo e($to->timezone('Asia/Dhaka')->format('d M Y')); ?>

                    </div>
                    <div class="mt-1 text-[11px] text-emerald-300">
                        Opening Balance:
                        <span class="font-semibold">৳<?php echo e(number_format($openingBalance, 2)); ?></span>
                    </div>
                </div>
            </div>
        </div>

        
        <div class="hidden sm:block rounded-3xl bg-slate-900/80 border border-slate-800 shadow-[0_22px_60px_-35px_rgba(15,23,42,0.9)] overflow-hidden">
            <table class="min-w-full text-xs sm:text-sm text-slate-200">
                <thead class="bg-slate-800/90 text-[11px] uppercase tracking-wide text-slate-400">
                    <tr>
                        <th class="px-4 py-2 text-left">Date &amp; Time</th>
                        <th class="px-3 py-2 text-left">Type</th>
                        <th class="px-3 py-2 text-right">Amount</th>
                        <th class="px-3 py-2 text-right">Balance</th>
                        <th class="px-4 py-2 text-left">Reference</th>
                        <th class="px-3 py-2 text-right">Action</th>
                    </tr>
                </thead>
                <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <?php
                        // ✅ Dhaka timezone
                        $createdAtDhaka = $t->created_at->timezone('Asia/Dhaka');

                        $meta = $t->meta;
                        if (!is_array($meta)) {
                            $meta = json_decode($meta ?? '[]', true) ?? [];
                        }

                        $ref        = $meta['reference_code'] ?? ('TX-'.$t->id);
                        $status     = $meta['status'] ?? 'Success';
                        $truType    = $meta['trx_type'] ?? ucfirst($t->type);
                        $isCredit   = $t->type === 'credit';
                        $oldBalance = $isCredit
                            ? $t->balance_after - $t->amount
                            : $t->balance_after + $t->amount;

                        $details    = $meta['details']    ?? $truType;
                        $adminNote  = $meta['admin_note'] ?? '';   // ⬅️ এখানে admin note
                        $account    = $user->phone ?? $user->email;

                        $item = [
                            'id'          => $t->id,
                            'title'       => $truType,
                            'account'     => $account,
                            'amount'      => number_format($t->amount, 2),
                            'balance'     => number_format($t->balance_after, 2),
                            'old_balance' => number_format($oldBalance, 2),
                            'ref'         => $ref,
                            'status'      => ucfirst($status),
                            'type'        => ucfirst($t->type),
                            'date'        => $createdAtDhaka->format('d M Y'),
                            'time'        => $createdAtDhaka->format('h:i A'),
                            'details'     => $details,
                            'admin_note'  => $adminNote,
                        ];
                    ?>
                    <tr class="border-t border-slate-800/80">
                        <td class="px-4 py-2 align-top whitespace-nowrap text-slate-200">
                            <?php echo e($createdAtDhaka->format('d M Y')); ?>

                            <div class="text-[11px] text-slate-400">
                                <?php echo e($createdAtDhaka->format('h:i A')); ?>

                            </div>
                        </td>
                        <td class="px-3 py-2 align-top">
                            <div class="text-[11px] text-slate-300"><?php echo e($truType); ?></div>
                            <span class="inline-flex mt-1 items-center rounded-full px-2 py-0.5 text-[10px] font-semibold
                                         <?php echo e($isCredit ? 'bg-emerald-500/10 text-emerald-300' : 'bg-rose-500/10 text-rose-300'); ?>">
                                <span class="h-1.5 w-1.5 rounded-full mr-1 <?php echo e($isCredit ? 'bg-emerald-400' : 'bg-rose-400'); ?>"></span>
                                <?php echo e(ucfirst($t->type)); ?>

                            </span>
                        </td>
                        <td class="px-3 py-2 align-top text-right font-semibold <?php echo e($isCredit ? 'text-emerald-300' : 'text-rose-300'); ?>">
                            <?php echo e($isCredit ? '+' : '-'); ?>৳<?php echo e(number_format($t->amount, 2)); ?>

                        </td>
                        <td class="px-3 py-2 align-top text-right text-slate-200">
                            ৳<?php echo e(number_format($t->balance_after, 2)); ?>

                        </td>
                        <td class="px-4 py-2 align-top text-[11px] text-slate-400">
                            <div>Ref: <?php echo e($ref); ?></div>
                            <div>Status: <?php echo e(ucfirst($status)); ?></div>
                        </td>
                        <td class="px-3 py-2 align-top text-right">
                            <div class="flex items-center justify-end gap-2">
                                <button type="button"
                                        @click="open(<?php echo \Illuminate\Support\Js::from($item)->toHtml() ?>)"
                                        class="rounded-2xl border border-emerald-500/40 px-3 py-1 text-[10px] text-emerald-300 hover:bg-emerald-500/10">
                                    View
                                </button>
                                <a href="<?php echo e(route('statement.pdf', $t->id)); ?>"
                                   class="rounded-2xl border border-slate-500/60 px-3 py-1 text-[10px] text-slate-200 hover:bg-slate-700/60"
                                   @click.stop>
                                    PDF
                                </a>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="6" class="px-4 py-6 text-center text-slate-400">
                            এই তারিখ রেঞ্জে কোনো ট্রানজেকশন পাওয়া যায়নি।
                        </td>
                    </tr>
                <?php endif; ?>
                </tbody>
            </table>
        </div>

        
        <div class="sm:hidden space-y-3">
            <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <?php
                    $createdAtDhaka = $t->created_at->timezone('Asia/Dhaka');

                    $meta = $t->meta;
                    if (!is_array($meta)) {
                        $meta = json_decode($meta ?? '[]', true) ?? [];
                    }
                    $ref        = $meta['reference_code'] ?? ('TX-'.$t->id);
                    $status     = $meta['status'] ?? 'Success';
                    $truType    = $meta['trx_type'] ?? ucfirst($t->type);
                    $isCredit   = $t->type === 'credit';
                    $oldBalance = $isCredit
                        ? $t->balance_after - $t->amount
                        : $t->balance_after + $t->amount;

                    $details    = $meta['details']    ?? $truType;
                    $adminNote  = $meta['admin_note'] ?? '';
                    $account    = $user->phone ?? $user->email;

                    $item = [
                        'id'          => $t->id,
                        'title'       => $truType,
                        'account'     => $account,
                        'amount'      => number_format($t->amount, 2),
                        'balance'     => number_format($t->balance_after, 2),
                        'old_balance' => number_format($oldBalance, 2),
                        'ref'         => $ref,
                        'status'      => ucfirst($status),
                        'type'        => ucfirst($t->type),
                        'date'        => $createdAtDhaka->format('d M Y'),
                        'time'        => $createdAtDhaka->format('h:i A'),
                        'details'     => $details,
                        'admin_note'  => $adminNote,
                    ];
                ?>

                <div class="rounded-3xl bg-slate-900/90 border border-slate-800 shadow-[0_18px_40px_-28px_rgba(15,23,42,1)] px-3 py-3">
                    <div class="flex items-center justify-between">
                        <div>
                            <div class="text-[11px] text-slate-400">
                                <?php echo e($createdAtDhaka->format('d M Y')); ?>

                            </div>
                            <div class="text-[10px] text-slate-500">
                                <?php echo e($createdAtDhaka->format('h:i A')); ?>

                            </div>
                            <div class="mt-1 text-[11px] font-semibold text-slate-50">
                                <?php echo e($truType); ?>

                            </div>
                        </div>

                        <div class="text-right">
                            <div class="text-xs font-bold <?php echo e($isCredit ? 'text-emerald-300' : 'text-rose-300'); ?>">
                                <?php echo e($isCredit ? '+' : '-'); ?>৳<?php echo e(number_format($t->amount, 2)); ?>

                            </div>
                            <div class="text-[10px] text-slate-400">
                                Bal: ৳<?php echo e(number_format($t->balance_after, 2)); ?>

                            </div>
                            <span class="mt-1 inline-flex items-center justify-end rounded-full px-2 py-0.5 text-[10px] font-semibold
                                         <?php echo e($isCredit ? 'bg-emerald-500/10 text-emerald-300' : 'bg-rose-500/10 text-rose-300'); ?>">
                                <?php echo e(ucfirst($t->type)); ?>

                            </span>
                        </div>
                    </div>

                    <div class="mt-2 border-t border-slate-800/70 pt-2 flex items-center justify-between text-[10px] text-slate-400">
                        <div>
                            <div>Ref: <?php echo e($ref); ?></div>
                            <div>Status: <?php echo e(ucfirst($status)); ?></div>
                        </div>
                        <div class="flex gap-2">
                            <button type="button"
                                    @click="open(<?php echo \Illuminate\Support\Js::from($item)->toHtml() ?>)"
                                    class="rounded-2xl border border-emerald-500/40 px-3 py-1 text-[10px] text-emerald-300 hover:bg-emerald-500/10">
                                View
                            </button>
                            <a href="<?php echo e(route('statement.pdf', $t->id)); ?>"
                               class="rounded-2xl border border-slate-500/60 px-3 py-1 text-[10px] text-slate-200 hover:bg-slate-700/60"
                               @click.stop>
                                PDF
                            </a>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="rounded-3xl bg-slate-900/90 border border-slate-800 px-4 py-4 text-center text-slate-400">
                    এই তারিখ রেঞ্জে কোনো ট্রানজেকশন পাওয়া যায়নি।
                </div>
            <?php endif; ?>
        </div>
    </div>

    
    <div x-cloak
         x-show="show"
         class="fixed inset-0 z-40 flex items-end sm:items-center justify-center px-2 sm:px-0">
        
        <div class="absolute inset-0 bg-black/50 backdrop-blur-sm" @click="close()"></div>

        
        <div style="margin-bottom: 76px;" x-transition
             class="relative z-50 w-full max-w-md bg-slate-50 text-slate-800 shadow-2xl rounded-t-3xl sm:rounded-3xl max-h-[85vh] overflow-y-auto">
            <div class="flex items-center justify-between px-4 pt-3 pb-2 border-b border-slate-200 sticky top-0 bg-slate-50">
                <div class="text-sm font-semibold" x-text="tx.title || 'Transaction'"></div>
                <button class="text-sm text-emerald-600 font-semibold" @click="close()">Close</button>
            </div>

            <div class="px-4 py-3 text-xs">
                <div class="grid grid-cols-2 gap-4">

                    <div>
                        <div class="text-[11px] text-slate-500">Account</div>
                        <div class="font-semibold text-slate-800" x-text="tx.account"></div>
                    </div>
                    <div class="text-right">
                        <div class="text-[11px] text-slate-500">Balance</div>
                        <div class="font-semibold text-slate-800" x-text="'৳'+(tx.balance || '0.00')"></div>
                    </div>

                    <div>
                        <div class="text-[11px] text-slate-500">Transaction ID</div>
                        <div class="font-semibold text-slate-800" x-text="tx.ref"></div>
                    </div>
                    <div class="text-right">
                        <div class="text-[11px] text-slate-500">Old Balance</div>
                        <div class="font-semibold text-slate-800" x-text="'৳'+(tx.old_balance || '0.00')"></div>
                    </div>

                    <div>
                        <div class="text-[11px] text-slate-500">Time</div>
                        <div class="font-semibold text-slate-800" x-text="(tx.date || '') + ' ' + (tx.time || '')"></div>
                    </div>
                    <div class="text-right">
                        <div class="text-[11px] text-slate-500">Charge</div>
                        <div class="font-semibold text-slate-800">৳0.00</div>
                    </div>

                    
                    <div class="col-span-2">
                        <div class="text-[11px] text-slate-500">Admin Note</div>
                        <div class="font-semibold text-slate-800 whitespace-pre-line"
                             x-text="tx.admin_note && tx.admin_note.trim() !== '' ? tx.admin_note : 'N/A'"></div>
                    </div>

                    <div>
                        <div class="text-[11px] text-slate-500">New Balance</div>
                        <div class="font-semibold text-slate-800" x-text="'৳'+(tx.balance || '0.00')"></div>
                    </div>

                    <div>
                        <div class="text-[11px] text-slate-500">Details</div>
                        <div class="font-semibold text-slate-800" x-text="tx.details || 'N/A'"></div>
                    </div>
                    <div class="text-right">
                        <div class="text-[11px] text-slate-500">Status</div>
                        <div class="font-semibold"
                             :class="(tx.status || '').toLowerCase() === 'success' || (tx.status || '').toLowerCase() === 'approved'
                                      ? 'text-emerald-600'
                                      : ( (tx.status || '').toLowerCase() === 'pending' ? 'text-amber-500' : 'text-rose-500')"
                             x-text="tx.status || 'Success'"></div>
                    </div>

                </div>

                
                <a class="mt-4 mb-2 inline-flex w-full items-center justify-center gap-2 rounded-2xl bg-emerald-600 py-2 text-xs font-semibold text-white shadow-md hover:bg-emerald-700"
                   :href="'<?php echo e(url('/statement/pdf')); ?>/' + (tx.id || '')">
                    <svg class="h-4 w-4" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M12 3a1 1 0 0 1 1 1v9.59l2.3-2.3a1 1 0 0 1 1.4 1.42l-4 4a1 1 0 0 1-1.4 0l-4-4a1 1 0 1 1 1.4-1.42L11 13.59V4a1 1 0 0 1 1-1Z"/>
                        <path d="M5 19a1 1 0 0 1 1-1h12a1 1 0 1 1 0 2H6a1 1 0 0 1-1-1Z"/>
                    </svg>
                    Download PDF
                </a>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ecareba2/new.rkmotorsbike.top/resources/views/frontend/statement/view.blade.php ENDPATH**/ ?>