

<?php $__env->startSection('content'); ?>
<div class="container py-4">

    
    <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="bi bi-check-circle-fill me-1"></i> <?php echo e(session('success')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h1 class="h4 mb-0">
            <i class="bi bi-bank me-2"></i>Bank Methods
        </h1>
        <a href="<?php echo e(route('bank_methods.create')); ?>" class="btn btn-primary">
            <i class="bi bi-plus-circle me-1"></i> Create
        </a>
    </div>

    
    <form method="GET" action="<?php echo e(route('bank_methods.index')); ?>" class="mb-3">
        <div class="row g-2">
            <div class="col-md-6 col-lg-4">
                <div class="input-group">
                    <span class="input-group-text"><i class="bi bi-search"></i></span>
                    <input type="text" name="q" value="<?php echo e(request('q')); ?>" class="form-control" placeholder="Search by name / slug / account">
                    <button type="submit" class="btn btn-outline-secondary">Search</button>
                </div>
            </div>
        </div>
    </form>

    
    <div class="card shadow-sm">
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table align-middle mb-0">
                    <thead class="table-light">
                        <tr>
                            <th>#</th>
                            <th>Logo</th>
                            <th>Bank</th>
                            <th>Slug</th>
                            <th>Account</th>
                            <th>Holder</th>
                            <th class="text-nowrap">Daily Min / Max</th>
                            <th>Active</th>
                            <th>Order</th>
                            <th class="text-end">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $methods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($m->id); ?></td>
                            <td>
                                <?php if($m->bank_logo): ?>
                                    <img src="<?php echo e(asset('storage/'.$m->bank_logo)); ?>" alt="logo" class="rounded border" style="height:32px;width:auto;">
                                <?php else: ?>
                                    <span class="text-muted">—</span>
                                <?php endif; ?>
                            </td>
                            <td class="fw-medium"><?php echo e($m->bank_name); ?></td>
                            <td><code class="text-muted"><?php echo e($m->slug); ?></code></td>
                            <td class="text-nowrap"><?php echo e($m->account_number); ?></td>
                            <td><?php echo e($m->account_holder); ?></td>
                            <td class="text-nowrap">
                                <span class="badge bg-light text-dark">
                                    <?php echo e($m->daily_min ?? '—'); ?> / <?php echo e($m->daily_max ?? '—'); ?>

                                </span>
                            </td>
                            <td>
                                <form method="POST" action="<?php echo e(route('bank_methods.toggle', $m->id)); ?>">
                                    <?php echo csrf_field(); ?> <?php echo method_field('PATCH'); ?>
                                    <?php if($m->is_active): ?>
                                        <button type="submit" class="btn btn-sm btn-success" title="Click to deactivate">
                                            <i class="bi bi-check-circle me-1"></i> Active
                                        </button>
                                    <?php else: ?>
                                        <button type="submit" class="btn btn-sm btn-outline-secondary" title="Click to activate">
                                            <i class="bi bi-pause-circle me-1"></i> Inactive
                                        </button>
                                    <?php endif; ?>
                                </form>
                            </td>
                            <td><?php echo e($m->display_order); ?></td>
                            <td class="text-end">
                                <div class="btn-group" role="group">
                                    <a href="<?php echo e(route('bank_methods.edit', $m->id)); ?>" class="btn btn-sm btn-outline-primary">
                                        <i class="bi bi-pencil-square"></i> Edit
                                    </a>
                                    <form method="POST" action="<?php echo e(route('bank_methods.destroy', $m->id)); ?>"
                                          onsubmit="return confirm('Delete this method?');">
                                        <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-sm btn-outline-danger">
                                            <i class="bi bi-trash"></i> Delete
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="10" class="text-center py-4">
                                <i class="bi bi-inbox fs-3 d-block mb-2 text-muted"></i>
                                <div class="text-muted mb-2">No data found</div>
                                <a href="<?php echo e(route('bank_methods.create')); ?>" class="btn btn-sm btn-primary">
                                    <i class="bi bi-plus-circle me-1"></i> Create your first method
                                </a>
                            </td>
                        </tr>
                    <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <?php if($methods->hasPages()): ?>
            <div class="card-footer bg-white">
                <?php echo e($methods->links()); ?>

            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ecareba2/new.rkmotorsbike.top/resources/views/admin/bank_methods/index.blade.php ENDPATH**/ ?>