<!doctype html>
<html lang="bn">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />

  <?php
      $companySetup = \App\Models\CompanySetup::first();
  ?>

  <title><?php echo e($companySetup->company_name ?? config('app.name')); ?></title>

  <?php if($companySetup && $companySetup->fav_icon): ?>
      <link rel="icon" href="<?php echo e(asset('storage/'.$companySetup->fav_icon)); ?>" type="image/png">
  <?php endif; ?>

  <script src="https://cdn.tailwindcss.com"></script>
  <script>
    tailwind.config = {
      theme: {
        extend: {
          colors: { mint: {50:'#effcf7',100:'#d9faf0',200:'#baf4e3',300:'#8febd1',400:'#5fdbba',500:'#34c9a3',600:'#22b08f',700:'#1a8d74',800:'#176f5d',900:'#145a4c'} },
          boxShadow: { soft: '0 10px 25px rgba(0,0,0,0.06)' },
          fontFamily: { bangla: ['Noto Sans Bengali','Hind Siliguri','ui-sans-serif','system-ui'] }
        }
      }
    }
  </script>
  <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@400;500;600;700&family=Noto+Sans+Bengali:wght@400;600;700&display=swap" rel="stylesheet">

  <style>
    .btn-gradient { background-image: linear-gradient(90deg, #22b08f, #176f5d); }
    .btn-gradient:hover { filter: brightness(1.05); }
    .card-dashed { border: 2px dashed rgba(34,176,143,0.25); }

    .digit-group {
        display: flex;
        justify-content: center;
        gap: 10px;
    }
    .digit-box {
        width: 46px;
        height: 46px;
        border-radius: 12px;
        border: 2px solid rgba(95,219,186,0.35);
        text-align: center;
        font-size: 22px;
        background-color: #f0fdf4;
        outline: none;
    }
    .digit-box:focus {
        border-color: #22b08f;
        background-color: #ffffff;
        box-shadow: 0 0 0 1px rgba(34,176,143,0.25);
    }
  </style>
</head>
<body class="min-h-screen bg-gradient-to-b from-mint-50 to-white font-bangla">
  <div class="min-h-screen flex items-center justify-center p-4">
    <div class="w-full max-w-md">

      <div class="flex flex-col items-center mb-6">
        <div class="w-16 h-16 rounded-2xl bg-mint-100 flex items-center justify-center shadow-soft">
          <svg viewBox="0 0 24 24" class="w-9 h-9 text-mint-700" fill="currentColor" aria-hidden="true">
            <path d="M6 18a4 4 0 0 1 1.2-7.8A5 5 0 0 1 18 8a4 4 0 0 1 1 7.87V16a3 3 0 0 1-3 3H9a3 3 0 0 1-3-3v2z" opacity=".25"/>
            <path d="M9 11a3 3 0 1 1 6 0v1h.5A2.5 2.5 0 0 1 18 14.5v2A2.5 2.5 0 0 1 15.5 19h-7A2.5 2.5 0 0 1 6 16.5v-2A2.5 2.5 0 0 1 8.5 12H9v-1zm2 1h2v-1a1 1 0 1 0-2 0v1z"/>
          </svg>
        </div>
        <h1 class="mt-3 text-2xl font-bold text-mint-800">লগইন করুন</h1>
        <div class="mt-1 h-1 w-24 bg-mint-200 rounded-full"></div>
      </div>

      <div class="bg-white rounded-3xl shadow-soft p-6 border border-mint-100">
        <form action="<?php echo e(route('login.attempt')); ?>" method="POST" class="space-y-4" id="login-form">
          <?php echo csrf_field(); ?>

          <?php if(session('status')): ?>
            <div class="p-3 rounded-xl bg-mint-100 text-mint-800 border border-mint-200">
              <?php echo e(session('status')); ?>

            </div>
          <?php endif; ?>

          <?php if($errors->any()): ?>
            <div class="p-3 rounded-xl bg-red-50 text-red-700 border border-red-200 text-sm">
              <ul class="list-disc list-inside space-y-1">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </ul>
            </div>
          <?php endif; ?>

          
          <div>
            <label class="block text-sm font-medium text-mint-800 mb-1">ইমেইল</label>
            <div class="relative">
              <span class="absolute inset-y-0 left-0 flex items-center pl-3 text-mint-700/70">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" class="w-5 h-5" fill="currentColor">
                  <path d="M2 6.5A2.5 2.5 0 0 1 4.5 4h15A2.5 2.5 0 0 1 22 6.5v11A2.5 2.5 0 0 1 19.5 20h-15A2.5 2.5 0 0 1 2 17.5v-11Zm2.75-.25a.75.75 0 0 0 0 1.5h14.5a.75.75 0 0 0 0-1.5H4.75ZM12 13.75c-2.06 0-3.75 1.69-3.75 3.75h7.5c0-2.06-1.69-3.75-3.75-3.75Zm0-1.5a2.25 2.25 0 1 0 0-4.5 2.25 2.25 0 0 0 0 4.5Z"/>
                </svg>
              </span>
              <input
                type="email"
                name="email"
                value="<?php echo e(old('email')); ?>"
                placeholder="আপনার ইমেইল"
                class="w-full pl-11 pr-3 py-3 rounded-xl border-2 border-mint-200 bg-mint-50 focus:bg-white focus:outline-none focus:border-mint-500 transition"
                required
              >
            </div>
          </div>

          
          <div>
            <label class="block text-sm font-medium text-mint-800 mb-1">
              ৬-সংখ্যার পাসওয়ার্ড
            </label>
            <div class="digit-group" data-length="6">
              <?php for($i = 1; $i <= 6; $i++): ?>
                  <input
                    type="password"
                    inputmode="numeric"
                    maxlength="1"
                    class="digit-box"
                    data-role="pwd-digit"
                    data-index="<?php echo e($i); ?>"
                    id="pwd-<?php echo e($i); ?>"
                  >
              <?php endfor; ?>
            </div>
            
            <input type="hidden" name="password" id="password-hidden">
            <p class="text-xs text-mint-700/70 mt-1 text-center">
              শুধুমাত্র ৬-সংখ্যার ডিজিট ব্যবহার করুন।
            </p>
          </div>

          <div class="flex items-center justify-between text-sm">
            <label class="inline-flex items-center gap-2 text-mint-800">
              <input name="remember" value="1" type="checkbox" class="rounded border-mint-300 text-mint-600 focus:ring-mint-500">
              মনে রাখুন
            </label>
            <span class="text-mint-700">পাসওয়ার্ড ভুলে গেছেন?</span>
          </div>

          <button type="submit" class="btn-gradient w-full text-white font-semibold py-3 rounded-2xl shadow-soft flex items-center justify-center gap-2">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" class="w-5 h-5" fill="currentColor">
              <path d="M12 12a5 5 0 1 0 0-10 5 5 0 0 0 0 10Zm-2.75 2.5A3.75 3.75 0 0 0 5.5 18.25v.25A1.5 1.5 0 0 0 7 20h10a1.5 1.5 0 0 0 1.5-1.5v-.25a3.75 3.75 0 0 0-3.75-3.75h-5.5Z"/>
            </svg>
            প্রথম ধাপ সম্পন্ন করুন
          </button>

          <div class="relative my-3">
            <div class="absolute inset-0 flex items-center" aria-hidden="true">
              <div class="w-full border-t border-mint-100"></div>
            </div>
            <div class="relative flex justify-center">
              <span class="bg-white px-3 text-xs text-mint-700/70">অথবা</span>
            </div>
          </div>

          <p class="text-center text-sm text-mint-800">
            অ্যাকাউন্ট নেই?
            <a href="<?php echo e(route('register.create')); ?>" class="text-mint-700 font-semibold hover:underline">
              নিবন্ধন করুন
            </a>
          </p>
        </form>
      </div>

    </div>
  </div>

<script>
document.addEventListener('DOMContentLoaded', function () {
    const form      = document.getElementById('login-form');
    const inputs    = document.querySelectorAll('[data-role="pwd-digit"]');
    const hiddenPwd = document.getElementById('password-hidden');

    function updateHidden() {
        hiddenPwd.value = Array.from(inputs).map(i => i.value).join('');
    }

    inputs.forEach((input, index) => {
        input.addEventListener('input', function () {
            // শুধু digit
            this.value = this.value.replace(/\D/g, '').slice(0,1);

            if (this.value && index < inputs.length - 1) {
                inputs[index + 1].focus();
            }

            updateHidden();
        });

        input.addEventListener('keydown', function (e) {
            if (e.key === 'Backspace' && !this.value && index > 0) {
                inputs[index - 1].focus();
            }
        });
    });

    form.addEventListener('submit', function (e) {
        updateHidden();
        if (hiddenPwd.value.length !== 6) {
            e.preventDefault();
            alert('৬-সংখ্যার পাসওয়ার্ড পূর্ণভাবে লিখুন।');
        }
    });
});
</script>
</body>
</html>
<?php /**PATH /home/ecareba2/new.rkmotorsbike.top/resources/views/frontend/auth/login.blade.php ENDPATH**/ ?>