

<?php $__env->startSection('content'); ?>
<div class="max-w-3xl mx-auto px-3 mt-6">
  <h3 class="text-slate-800 font-semibold mb-3">Transactions</h3>
  <div class="bg-white rounded-2xl shadow-sm overflow-hidden">
    <table class="min-w-full text-sm">
      <thead class="bg-slate-50 text-slate-600">
        <tr>
          <th class="text-left px-3 py-2">#</th>
          <th class="text-left px-3 py-2">Type</th>
          <th class="text-right px-3 py-2">Amount</th>
          <th class="text-right px-3 py-2">Balance</th>
          <th class="text-left px-3 py-2">Related</th>
          <th class="text-left px-3 py-2">Time</th>
        </tr>
      </thead>
      <tbody>
        <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
          <tr class="border-t">
            <td class="px-3 py-2"><?php echo e($t->id); ?></td>
            <td class="px-3 py-2">
              <span class="px-2 py-0.5 rounded-full text-xs <?php echo e($t->type==='credit'?'bg-emerald-100 text-emerald-700':'bg-rose-100 text-rose-700'); ?>">
                <?php echo e(ucfirst($t->type)); ?>

              </span>
            </td>
            <td class="px-3 py-2 text-right">৳<?php echo e(number_format($t->amount,2)); ?></td>
            <td class="px-3 py-2 text-right">৳<?php echo e(number_format($t->balance_after,2)); ?></td>
            <td class="px-3 py-2"><?php echo e(class_basename($t->related_type)); ?> #<?php echo e($t->related_id); ?></td>
            <td class="px-3 py-2"><?php echo e($t->created_at->format('d M, h:i a')); ?></td>
          </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
          <tr><td colspan="6" class="px-3 py-6 text-center text-slate-500">কোনো ট্রান্সঅ্যাকশন নেই</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
  <div class="mt-4"><?php echo e($transactions->links()); ?></div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ecareba2/new.rkmotorsbike.top/resources/views/frontend/add-money/transactions.blade.php ENDPATH**/ ?>