

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-3">

  <style>
    .card-edge{ border:1px solid #e6e8ef; border-radius:16px; background:#fff; box-shadow:0 4px 18px rgba(17,24,39,.06) }
    .table thead th{ font-weight:700; color:#0f172a; border-top:0 }
    .table-hover tbody tr:hover{ background:#fafafa }
    .chip{ display:inline-flex; align-items:center; gap:6px; background:#f1f5f9; color:#334155; border-radius:999px; padding:.25rem .6rem; font-size:.8rem; margin:.1rem }
    @media (max-width:768px){
      .table thead{ display:none }
      .table tbody tr{ display:block; margin:12px 0; border:1px solid #e5e7eb; border-radius:12px; padding:10px }
      .table td{ display:flex; justify-content:space-between; border:0; padding:.4rem .5rem }
      .table td::before{ content: attr(data-label); font-weight:600; color:#475569 }
    }
  </style>

  <div class="d-flex justify-content-between align-items-center mb-3">
    <h5 class="mb-0"><i class="fa-solid fa-sack-dollar me-2"></i> Loan Settings</h5>
    <a class="btn btn-primary" href="<?php echo e(url('/admin/loan-settings/create')); ?>">
      <i class="fa-solid fa-plus me-1"></i> Create
    </a>
  </div>

  <?php if(session('success')): ?>
    <div class="alert alert-success card-edge p-2">
      <i class="fa-regular fa-circle-check me-1"></i><?php echo e(session('success')); ?>

    </div>
  <?php endif; ?>

  <div class="table-responsive card-edge p-0">
    <table class="table table-hover align-middle mb-0">
      <thead class="table-light">
        <tr>
          <th>#</th>
          <th>Interest Rate (%)</th>
          <th>Min Turnover</th>
          <th>Loan Options</th>
          <th>Periods (months)</th>
          <th class="text-end">Actions</th>
        </tr>
      </thead>
      <tbody>
        <?php $__empty_1 = true; $__currentLoopData = $settings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <tr>
          <td data-label="#" class="text-muted"><?php echo e($s->id); ?></td>
          <td data-label="Interest Rate" class="fw-semibold"><?php echo e(number_format($s->interest_rate,2)); ?></td>
          <td data-label="Min Turnover">৳<?php echo e(number_format($s->eligibility_min_turnover,2)); ?></td>
          <td data-label="Loan Options" style="max-width:300px">
            <?php $__empty_2 = true; $__currentLoopData = ($s->loan_options ?? []); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $opt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_2 = false; ?>
              <span class="chip">৳<?php echo e(number_format($opt,0)); ?></span>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_2): ?> — <?php endif; ?>
          </td>
          <td data-label="Periods" style="max-width:220px">
            <?php $__empty_2 = true; $__currentLoopData = ($s->loan_periods ?? []); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_2 = false; ?>
              <span class="chip"><?php echo e($m); ?>m</span>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_2): ?> — <?php endif; ?>
          </td>
          <td data-label="Actions" class="text-end">
            <div class="d-inline-flex gap-1 flex-wrap">
              <a class="btn btn-primary btn-sm" href="<?php echo e(url('/admin/loan-settings/'.$s->id.'/edit')); ?>">
                <i class="fa-regular fa-pen-to-square"></i> Edit
              </a>
              <a class="btn btn-outline-secondary btn-sm" href="<?php echo e(url('/admin/loan-settings/'.$s->id)); ?>">
                <i class="fa-regular fa-eye"></i> View
              </a>
              <form action="<?php echo e(url('/admin/loan-settings/'.$s->id)); ?>" method="POST" onsubmit="return confirm('Delete this setting?')">
                <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                <button class="btn btn-danger btn-sm"><i class="fa-regular fa-trash-can"></i> Delete</button>
              </form>
            </div>
          </td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
          <tr><td colspan="6" class="text-center text-muted py-4"><i class="fa-regular fa-folder-open me-1"></i>No loan settings</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>

  <div class="mt-3"><?php echo e($settings->links()); ?></div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ecareba2/new.rkmotorsbike.top/resources/views/backend/loan_settings/index.blade.php ENDPATH**/ ?>