
<?php $__env->startSection('title','পেমেন্ট মেথড'); ?>

<?php $__env->startPush('styles'); ?>
    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@400;500;600;700&family=Poppins:wght@400;500;600&display=swap" rel="stylesheet">

    <style>
        body {
            font-family: "Hind Siliguri", system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
        }

        @keyframes blobFloat {
            0%   { transform: translate3d(-10%, -10%, 0) scale(1); }
            50%  { transform: translate3d(15%, 10%, 0) scale(1.08); }
            100% { transform: translate3d(40%, -5%, 0) scale(1); }
        }

        @keyframes blobFloat2 {
            0%   { transform: translate3d(40%, 20%, 0) scale(1); }
            50%  { transform: translate3d(5%, 0, 0) scale(1.04); }
            100% { transform: translate3d(-20%, 10%, 0) scale(1); }
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-gradient-to-b from-slate-950 via-slate-900 to-slate-950 flex justify-center items-start px-3 sm:px-4 py-8 relative overflow-hidden">

    
    <svg class="pointer-events-none absolute -top-32 -left-32 w-80 h-80 text-emerald-500/20"
         viewBox="0 0 200 200" xmlns="http://www.w3.org/2000/svg"
         style="animation: blobFloat 18s ease-in-out infinite alternate;">
        <path fill="currentColor"
              d="M45.1,-62C58.8,-54.8,69.1,-39.4,73.4,-22.5C77.7,-5.7,75.9,12.7,67.4,26.8C58.8,40.9,43.4,50.7,27.2,58.2C11,65.7,-6,70.9,-20.4,66.3C-34.7,61.6,-46.4,47.1,-55.3,31.5C-64.3,15.9,-70.4,-0.7,-68.1,-16.7C-65.8,-32.7,-55.1,-48.1,-41.2,-55.6C-27.3,-63.1,-10.1,-62.6,5.7,-69C21.5,-75.3,43,-88.4,45.1,-62Z"/>
    </svg>

    <svg class="pointer-events-none absolute bottom-0 -right-24 w-72 h-72 text-cyan-400/10"
         viewBox="0 0 200 200" xmlns="http://www.w3.org/2000/svg"
         style="animation: blobFloat2 22s ease-in-out infinite alternate;">
        <path fill="currentColor"
              d="M35.8,-54.7C46.3,-47.4,54,-38,60.9,-27.1C67.7,-16.2,73.7,-4.1,71.9,6.8C70.1,17.7,60.5,27.3,50.4,36.6C40.4,46,29.9,55.3,17.3,60.4C4.6,65.6,-10.1,66.6,-24.4,62.4C-38.7,58.3,-52.6,49.1,-59.8,36.3C-66.9,23.4,-67.3,7,-64.6,-8.3C-61.9,-23.6,-56.1,-37.9,-45.7,-45.9C-35.2,-53.9,-20.1,-55.7,-5.2,-49.9C9.7,-44,19.3,-30.5,35.8,-54.7Z"/>
    </svg>

    <div class="w-full max-w-3xl relative z-10 pb-20">

        
        <div class="mb-4 flex items-center justify-between text-xs text-slate-300">
            <button type="button"
                    onclick="window.history.back()"
                    class="inline-flex items-center gap-1 text-slate-300 hover:text-emerald-400 transition">
                <svg class="h-4 w-4" viewBox="0 0 24 24" fill="currentColor">
                    <path d="M15.75 4.75 9.5 11l6.25 6.25-1.5 1.5L6.5 11l7.75-7.75 1.5 1.5Z"/>
                </svg>
                Back
            </button>
            <span class="tracking-[0.18em] uppercase text-emerald-400 font-semibold text-[11px]">
                Payment Methods
            </span>
        </div>

        
        <div class="rounded-3xl bg-slate-900/80 border border-emerald-500/25 shadow-[0_25px_70px_-35px_rgba(16,185,129,0.7)] backdrop-blur-sm p-5 sm:p-6">

            
            <div class="mb-4 flex items-center gap-3">
                <div class="h-11 w-11 rounded-2xl bg-gradient-to-br from-emerald-500 to-cyan-500 flex items-center justify-center text-slate-950 shadow-lg shadow-emerald-500/40">
                    <svg class="h-5 w-5" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M3 7a3 3 0 0 1 3-3h12a3 3 0 0 1 3 3v2H3Zm0 4h18v6a3 3 0 0 1-3 3H6a3 3 0 0 1-3-3Z"/>
                    </svg>
                </div>
                <div class="flex-1 min-w-0">
                    <div class="text-sm font-semibold text-slate-50">
                        পেমেন্ট মেথড নির্বাচন করুন
                    </div>
                    <p class="text-[11px] text-slate-400 mt-0.5">
                        যে ব্যাংক/মেথড থেকে Add Money করতে চান তা নিচ থেকে বেছে নিন।
                    </p>
                </div>
            </div>

            
            <div class="space-y-3">
                <?php $__empty_1 = true; $__currentLoopData = $methods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <?php
                        $name       = $m->bank_name ?? $m->name ?? '';
                        $logo       = $m->bank_logo ?? $m->logo ?? null;
                        $accountNo  = $m->account_number ?? $m->account_no ?? null;
                        $dailyMin   = $m->daily_min ?? null;
                        $dailyMax   = $m->daily_max ?? null;
                        $initial    = strtoupper(mb_substr($name, 0, 1));
                    ?>

                    <a href="<?php echo e(url('/add-money-bank/'.$m->slug)); ?>"
                       class="flex items-center justify-between gap-3 rounded-2xl border border-slate-800 bg-slate-950/70 px-4 py-3
                              shadow-sm hover:shadow-[0_20px_60px_-30px_rgba(16,185,129,0.9)] hover:border-emerald-500/50 transition">
                        <div class="flex items-center gap-3 min-w-0">
                            
                            <div class="h-11 w-11 rounded-2xl ring-1 ring-emerald-400/40 bg-slate-900/80 overflow-hidden flex items-center justify-center">
                                <?php if(!empty($logo)): ?>
                                    <img
                                        src="<?php echo e(asset('storage/'.$logo)); ?>"
                                        alt="<?php echo e($name); ?> logo"
                                        loading="lazy"
                                        class="h-full w-full object-cover"
                                    >
                                <?php else: ?>
                                    <div class="h-full w-full flex items-center justify-center text-sm font-bold text-emerald-200 bg-gradient-to-br from-emerald-500/40 to-cyan-500/40">
                                        <?php echo e($initial); ?>

                                    </div>
                                <?php endif; ?>
                            </div>

                            <div class="min-w-0">
                                <p class="text-sm font-semibold text-slate-50 truncate">
                                    <?php echo e($name); ?>

                                </p>
                                <p class="mt-0.5 text-[11px] text-slate-400 truncate">
                                    দৈনিক লিমিট:
                                    <?php echo e($dailyMin !== null ? number_format($dailyMin) : 0); ?>

                                    -
                                    <?php echo e($dailyMax !== null ? number_format($dailyMax) : '∞'); ?>

                                </p>
                                <?php if($accountNo): ?>
                                    <p class="mt-0.5 text-[11px] text-slate-500 truncate">
                                        অ্যাকাউন্ট:
                                        <span class="font-mono text-slate-300"><?php echo e($accountNo); ?></span>
                                    </p>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="shrink-0 inline-flex items-center justify-center rounded-full bg-emerald-500/15 px-2 py-1 text-emerald-300 text-xs font-semibold">
                            <span class="hidden sm:inline-block mr-1">Choose</span>
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none"
                                 viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                      d="M9 5l7 7-7 7" />
                            </svg>
                        </div>
                    </a>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="rounded-2xl border border-slate-800 bg-slate-950/70 px-4 py-5 text-center text-sm text-slate-400">
                        কোনো মেথড সেট করা নেই।
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\production_re_banking\resources\views/frontend/add-money-bank/methods.blade.php ENDPATH**/ ?>