

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-3">

  <style>
    .card-edge{ border:1px solid #e6e8ef; border-radius:16px; background:#fff; box-shadow:0 4px 18px rgba(17,24,39,.06) }
    .table thead th{ font-weight:700; color:#0f172a; border-top:0 }
    .table-hover tbody tr:hover{ background:#fafafa }
    .badge-soft{ background:#eef2ff; color:#3730a3; border-radius:999px; padding:.35rem .6rem; font-weight:600 }
    .badge-soft.gray{ background:#f1f5f9; color:#334155 }
    .badge-soft.green{ background:#dcfce7; color:#166534 }
    .badge-soft.red{ background:#fee2e2; color:#991b1b }
    .logo-40{ height:40px; width:40px; border-radius:10px; background:#fff; border:1px solid #e5e7eb; object-fit:contain; padding:5px }
    @media (max-width:768px){
      .table thead{ display:none }
      .table tbody tr{ display:block; margin:12px 0; border:1px solid #e5e7eb; border-radius:12px; padding:10px }
      .table td{ display:flex; justify-content:space-between; border:0; padding:.4rem .5rem }
      .table td::before{ content: attr(data-label); font-weight:600; color:#475569 }
    }
  </style>

  <div class="d-flex justify-content-between align-items-center mb-3">
    <h5 class="mb-0"><i class="fa-solid fa-layer-group me-2"></i> Biller Categories</h5>
    <a class="btn btn-primary" href="<?php echo e(url('/admin/biller-categories/create')); ?>">
      <i class="fa-solid fa-plus me-1"></i> Create
    </a>
  </div>

  <form class="card-edge p-3 mb-3" method="GET" action="<?php echo e(url('/admin/biller-categories')); ?>">
    <div class="row g-2">
      <div class="col-md-5">
        <div class="input-group">
          <span class="input-group-text bg-white"><i class="fa-solid fa-magnifying-glass"></i></span>
          <input name="q" value="<?php echo e(request('q')); ?>" class="form-control" placeholder="Search name/slug">
        </div>
      </div>
      <div class="col-md-3">
        <select name="status" class="form-select">
          <option value="">Any status</option>
          <option value="active"   <?php if(request('status')==='active'): echo 'selected'; endif; ?>>Active</option>
          <option value="inactive" <?php if(request('status')==='inactive'): echo 'selected'; endif; ?>>Inactive</option>
        </select>
      </div>
      <div class="col-md-2 d-grid">
        <button class="btn btn-outline-secondary"><i class="fa-solid fa-filter me-1"></i> Filter</button>
      </div>
    </div>
  </form>

  <?php if(session('success')): ?>
    <div class="alert alert-success card-edge p-2">
      <i class="fa-regular fa-circle-check me-1"></i><?php echo e(session('success')); ?>

    </div>
  <?php endif; ?>

  <div class="table-responsive card-edge p-0">
    <table class="table table-hover align-middle mb-0">
      <thead class="table-light">
        <tr>
          <th>#</th>
          <th>Icon</th>
          <th>Name</th>
          <th>Slug</th>
          <th>Sort</th>
          <th>Status</th>
          <th class="text-end">Actions</th>
        </tr>
      </thead>
      <tbody>
        <?php $__empty_1 = true; $__currentLoopData = $cats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <tr>
          <td data-label="#" class="text-muted"><?php echo e($c->id); ?></td>
          <td data-label="Icon">
            <?php
              $icon = $c->icon;
              $isImg = $icon && (\Illuminate\Support\Str::startsWith($icon, ['http://','https://','uploads/']));
            ?>
            <?php if($icon && $isImg): ?>
              <?php if(\Illuminate\Support\Str::startsWith($icon, 'uploads/')): ?>
                <img class="logo-40" src="<?php echo e(asset('storage/'.$icon)); ?>" alt="icon">
              <?php else: ?>
                <img class="logo-40" src="<?php echo e($icon); ?>" alt="icon">
              <?php endif; ?>
            <?php elseif($icon): ?>
              <div class="logo-40 d-flex align-items-center justify-content-center" style="font-size:18px;border-style:dashed">
                <?php echo e($icon); ?>

              </div>
            <?php else: ?>
              <span class="badge-soft gray"><i class="fa-regular fa-image me-1"></i>None</span>
            <?php endif; ?>
          </td>
          <td data-label="Name" class="fw-semibold">
            <a class="text-decoration-none" href="<?php echo e(url('/admin/biller-categories/'.$c->id)); ?>">
              <i class="fa-solid fa-bolt-lightning text-secondary me-1"></i><?php echo e($c->name); ?>

            </a>
          </td>
          <td data-label="Slug"><span class="badge-soft gray"><?php echo e($c->slug); ?></span></td>
          <td data-label="Sort"><?php echo e($c->sort_order); ?></td>
          <td data-label="Status">
            <span class="badge-soft <?php echo e($c->status==='active' ? 'green' : 'red'); ?>">
              <i class="fa-solid <?php echo e($c->status==='active' ? 'fa-toggle-on' : 'fa-toggle-off'); ?> me-1"></i><?php echo e(ucfirst($c->status)); ?>

            </span>
          </td>
          <td data-label="Actions" class="text-end">
            <div class="d-inline-flex gap-1 flex-wrap">
              <form action="<?php echo e(url('/admin/biller-categories/'.$c->id.'/toggle')); ?>" method="POST">
                <?php echo csrf_field(); ?> <?php echo method_field('PATCH'); ?>
                <button class="btn btn-warning btn-sm"><i class="fa-solid fa-arrows-rotate"></i> Toggle</button>
              </form>
              <a class="btn btn-primary btn-sm" href="<?php echo e(url('/admin/biller-categories/'.$c->id.'/edit')); ?>">
                <i class="fa-regular fa-pen-to-square"></i> Edit
              </a>
              <form action="<?php echo e(url('/admin/biller-categories/'.$c->id)); ?>" method="POST" onsubmit="return confirm('Delete this item?')">
                <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                <button class="btn btn-danger btn-sm"><i class="fa-regular fa-trash-can"></i> Delete</button>
              </form>
            </div>
          </td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
          <tr><td colspan="7" class="text-center text-muted py-4"><i class="fa-regular fa-folder-open me-1"></i>No categories</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>

  <div class="mt-3"><?php echo e($cats->links()); ?></div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ecareba2/new.rkmotorsbike.top/resources/views/backend/billers/categories/index.blade.php ENDPATH**/ ?>