
<?php $__env->startSection('title','Bank List'); ?>

<?php $__env->startPush('styles'); ?>
  
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@400;500;600;700&display=swap" rel="stylesheet">
  <style>
    body{
      font-family: "Hind Siliguri", system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
    }
    @keyframes blobFloat {
      0%   { transform: translate3d(-10%, -10%, 0) scale(1); }
      50%  { transform: translate3d(15%, 10%, 0) scale(1.08); }
      100% { transform: translate3d(40%, -5%, 0) scale(1); }
    }
    @keyframes blobFloat2 {
      0%   { transform: translate3d(40%, 20%, 0) scale(1); }
      50%  { transform: translate3d(5%, 0, 0) scale(1.04); }
      100% { transform: translate3d(-20%, 10%, 0) scale(1); }
    }
  </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-gradient-to-b from-slate-950 via-slate-900 to-slate-950 flex justify-center items-start px-3 sm:px-4 py-8 relative overflow-hidden">

  
  <svg class="pointer-events-none absolute -top-32 -left-32 w-80 h-80 text-emerald-500/20"
       viewBox="0 0 200 200" xmlns="http://www.w3.org/2000/svg"
       style="animation: blobFloat 18s ease-in-out infinite alternate;">
    <path fill="currentColor"
          d="M45.1,-62C58.8,-54.8,69.1,-39.4,73.4,-22.5C77.7,-5.7,75.9,12.7,67.4,26.8C58.8,40.9,43.4,50.7,27.2,58.2C11,65.7,-6,70.9,-20.4,66.3C-34.7,61.6,-46.4,47.1,-55.3,31.5C-64.3,15.9,-70.4,-0.7,-68.1,-16.7C-65.8,-32.7,-55.1,-48.1,-41.2,-55.6C-27.3,-63.1,-10.1,-62.6,5.7,-69C21.5,-75.3,43,-88.4,45.1,-62Z"/>
  </svg>

  <svg class="pointer-events-none absolute bottom-0 -right-24 w-72 h-72 text-cyan-400/10"
       viewBox="0 0 200 200" xmlns="http://www.w3.org/2000/svg"
       style="animation: blobFloat2 22s ease-in-out infinite alternate;">
    <path fill="currentColor"
          d="M35.8,-54.7C46.3,-47.4,54,-38,60.9,-27.1C67.7,-16.2,73.7,-4.1,71.9,6.8C70.1,17.7,60.5,27.3,50.4,36.6C40.4,46,29.9,55.3,17.3,60.4C4.6,65.6,-10.1,66.6,-24.4,62.4C-38.7,58.3,-52.6,49.1,-59.8,36.3C-66.9,23.4,-67.3,7,-64.6,-8.3C-61.9,-23.6,-56.1,-37.9,-45.7,-45.9C-35.2,-53.9,-20.1,-55.7,-5.2,-49.9C9.7,-44,19.3,-30.5,35.8,-54.7Z"/>
  </svg>

  <main class="mx-auto w-full max-w-[980px] relative z-10 mb-24">

    
    <div class="flex items-center justify-between mb-4 text-xs text-slate-300">
      <button type="button"
              onclick="window.history.back()"
              class="inline-flex items-center gap-1 text-slate-300 hover:text-emerald-400 transition">
        <svg class="h-4 w-4" viewBox="0 0 24 24" fill="currentColor">
          <path d="M15.75 4.75 9.5 11ল6.25 6.25-1.5 1.5L6.5 11l7.75-7.75 1.5 1.5Z"/>
        </svg>
        Back
      </button>
      <span class="tracking-[0.18em] uppercase text-emerald-400 font-semibold text-[11px]">
        Bank List
      </span>
    </div>

    
    <div class="mb-3">
      <h1 class="text-xl sm:text-2xl font-extrabold text-slate-50">Select Your Bank</h1>
      <p class="mt-1 text-xs sm:text-sm text-slate-400">Choose a bank to continue your transaction.</p>
    </div>

    
    <div class="rounded-3xl bg-slate-900/85 border border-emerald-500/25 shadow-[0_25px_70px_-35px_rgba(16,185,129,0.7)] backdrop-blur-sm p-4 sm:p-6">

      
      <form method="GET"
            class="rounded-2xl border border-slate-800 bg-slate-950/70 p-3 shadow-[0_18px_55px_-30px_rgba(15,23,42,0.9)]">
        <div class="relative">
          <span class="pointer-events-none absolute left-3 top-1/2 -translate-y-1/2 text-slate-500">🔎</span>
          <input
            name="q" value="<?php echo e($q); ?>"
            placeholder="Search for banks..."
            class="h-11 w-full rounded-2xl border-2 border-slate-700 bg-slate-900/80 pl-10 pr-3 text-sm text-slate-100 placeholder-slate-500 outline-none
                   focus:border-emerald-400 focus:ring-2 focus:ring-emerald-400/40"
          >
        </div>
      </form>

      
      <div class="mt-4 space-y-3">
        <?php $__empty_1 = true; $__currentLoopData = $banks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $b): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
          <a href="<?php echo e(route('user.bank.show',$b)); ?>"
             class="flex items-center justify-between rounded-2xl border border-slate-800 bg-slate-950/70 p-3
                    shadow-[0_22px_60px_-30px_rgba(15,23,42,0.9)]
                    hover:border-emerald-500/40 hover:shadow-[0_26px_70px_-32px_rgba(16,185,129,0.7)] transition">
            <div class="flex items-center gap-3 min-w-0">
              
              <div class="h-12 w-12 rounded-2xl bg-slate-900/80 ring-2 ring-slate-700 overflow-hidden grid place-items-center">
                <?php if($b->logo_url): ?>
                  <img src="<?php echo e($b->logo_url); ?>"
                       class="h-11 w-11 rounded-2xl object-cover"
                       alt="<?php echo e($b->name); ?>">
                <?php else: ?>
                  <?php $initial = strtoupper(mb_substr($b->name ?? 'B',0,1)); ?>
                  <span class="text-emerald-300 font-bold text-lg"><?php echo e($initial); ?></span>
                <?php endif; ?>
              </div>

              <div class="min-w-0">
                <div class="truncate text-[15px] font-semibold text-slate-50"><?php echo e($b->name); ?></div>
                <div class="mt-1 flex flex-wrap items-center gap-2">
                  <span class="inline-flex items-center gap-1 rounded-full border border-emerald-500/40 bg-emerald-500/10 px-2 py-0.5 text-[11px] font-semibold text-emerald-200">
                    Min ৳<?php echo e(number_format($b->min_transaction,0)); ?>

                  </span>
                  <?php if($b->reward_percent > 0): ?>
                    <span class="inline-flex items-center gap-1 rounded-full border border-sky-500/40 bg-sky-500/10 px-2 py-0.5 text-[11px] font-semibold text-sky-200">
                      Reward <?php echo e(rtrim(rtrim(number_format($b->reward_percent,2), '0'), '.')); ?>%
                    </span>
                  <?php endif; ?>
                  <?php if(!$b->is_active): ?>
                    <span class="inline-flex items-center gap-1 rounded-full border border-rose-500/40 bg-rose-500/10 px-2 py-0.5 text-[11px] font-semibold text-rose-200">
                      Inactive
                    </span>
                  <?php endif; ?>
                </div>
              </div>
            </div>
            <div class="shrink-0 text-slate-500 text-lg">›</div>
          </a>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
          <div class="rounded-2xl border border-slate-800 bg-slate-950/70 p-6 text-center text-slate-400 shadow-[0_22px_60px_-30px_rgba(15,23,42,0.9)]">
            No banks found.
          </div>
        <?php endif; ?>
      </div>

      
      <div class="mt-4">
        <?php echo e($banks->withQueryString()->links()); ?>

      </div>
    </div>
  </main>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ecareba2/new.rkmotorsbike.top/resources/views/frontend/bank/list.blade.php ENDPATH**/ ?>