

<!DOCTYPE html>
<html lang="en">
<head>
    

    
    <script src="https://js.pusher.com/8.4.0/pusher.min.js"></script>

    <style>
        /* ছোট্ট কিছু helper style (চাইলে Tailwind-ই ব্যবহার করতে পারো) */
        .notif-bell-wrapper { position: relative; }
        .notif-badge {
            position: absolute;
            top: -4px;
            right: -4px;
            min-width: 18px;
            height: 18px;
            border-radius: 999px;
            padding: 0 4px;
            font-size: 11px;
            font-weight: 700;
            display: flex;
            align-items: center;
            justify-content: center;
            background: #e11d48;
            color: #fff;
        }
        .notif-dropdown {
            position: absolute;
            right: 0;
            margin-top: .5rem;
            width: 280px;
            max-height: 340px;
            overflow-y: auto;
            border-radius: 1rem;
            background: #ffffff;
            box-shadow:
                0 18px 45px -24px rgba(15,23,42,.6),
                0 6px 20px -12px rgba(15,23,42,.25);
            border: 1px solid rgba(148,163,184,.4);
            z-index: 40;
        }
        .notif-item {
            padding: .6rem .85rem;
            font-size: 12px;
            border-bottom: 1px solid rgba(226,232,240,.9);
        }
        .notif-item:last-child { border-bottom: none; }
        .notif-item-title { font-weight: 600; color: #0f172a; font-size: 12px; }
        .notif-item-sub { margin-top: 2px; color: #64748b; font-size: 11px; }
    </style>
</head>
<body class="bg-slate-50">

    
    <header class="w-full border-b border-slate-200 bg-white">
        <div class="mx-auto flex max-w-6xl items-center justify-between px-4 py-3">
            <div class="font-bold text-slate-800">
                Admin Panel
            </div>

            <div class="flex items-center gap-4">

                
                <div class="relative notif-bell-wrapper">
                    <button type="button"
                            id="notifBellBtn"
                            class="relative flex h-9 w-9 items-center justify-center rounded-full border border-slate-200 bg-slate-50 text-slate-600 hover:bg-slate-100 focus:outline-none">
                        
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 24 24" fill="none">
                            <path d="M14 18v.5a2 2 0 1 1-4 0V18"
                                  stroke="currentColor" stroke-width="1.6"
                                  stroke-linecap="round" stroke-linejoin="round"/>
                            <path d="M18 10a6 6 0 1 0-12 0c0 4-2 6-2 6h16s-2-2-2-6Z"
                                  stroke="currentColor" stroke-width="1.6"
                                  stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>

                        
                        <span id="notifCount" class="notif-badge hidden">0</span>
                    </button>

                    
                    <div id="notifDropdown" class="notif-dropdown hidden">
                        <div class="px-3 py-2 text-xs font-semibold text-slate-600 border-b border-slate-200">
                            New Deposits
                        </div>
                        <ul id="notifList" class="max-h-[260px] overflow-y-auto">
                            
                        </ul>
                        <div class="px-3 py-2 text-[11px] text-slate-400 text-center border-t border-slate-200 bg-slate-50">
                            Real-time updates using Pusher
                        </div>
                    </div>
                </div>

                
            </div>
        </div>
    </header>

    
    <main class="mx-auto max-w-6xl px-4 py-6">
        <?php echo $__env->yieldContent('content'); ?>
    </main>

    
    <script>
        // 1. dropdown toggle
        const bellBtn   = document.getElementById('notifBellBtn');
        const dropdown  = document.getElementById('notifDropdown');

        if (bellBtn && dropdown) {
            bellBtn.addEventListener('click', () => {
                dropdown.classList.toggle('hidden');
            });

            // বাইরে ক্লিক করলে dropdown বন্ধ
            document.addEventListener('click', (e) => {
                if (!bellBtn.contains(e.target) && !dropdown.contains(e.target)) {
                    dropdown.classList.add('hidden');
                }
            });
        }

        // 2. Pusher init
        Pusher.logToConsole = true;

        var pusher = new Pusher('<?php echo e(config('broadcasting.connections.pusher.key')); ?>', {
            cluster: '<?php echo e(config('broadcasting.connections.pusher.options.cluster')); ?>',
            forceTLS: true
        });

        // 3. Laravel event এর channel & event name
        var channel = pusher.subscribe('add-money-channel');

        channel.bind('add-money-event', function (data) {
            console.log('AddMoney event (for bell):', data);

            const countEl = document.getElementById('notifCount');
            const listEl  = document.getElementById('notifList');

            // badge count increase
            if (countEl) {
                let current = parseInt(countEl.textContent || '0', 10);
                current = isNaN(current) ? 0 : current;
                countEl.textContent = current + 1;
                countEl.classList.remove('hidden');
            }

            // list item add
            if (listEl) {
                const li = document.createElement('li');
                li.className = 'notif-item';

                li.innerHTML = `
                    <div class="notif-item-title">
                        নতুন Deposit #${data.id} – ৳${Number(data.amount).toFixed(2)}
                    </div>
                    <div class="notif-item-sub">
                        Ref: ${data.reference || 'N/A'} • Status: ${data.status || 'pending'}
                    </div>
                    <div class="notif-item-sub">
                        Time: ${data.created_at || ''}
                    </div>
                `;

                // নতুনটা উপরে আসুক
                listEl.prepend(li);
            }

            // OPTIONAL: ছোট্ট টোস্ট
            showToast('New deposit received: ৳' + Number(data.amount).toFixed(2));
        });

        // 4. Simple toast helper
        function showToast(message) {
            const toast = document.createElement('div');
            toast.textContent = message;
            toast.className =
                'fixed bottom-6 right-4 z-50 px-4 py-2 rounded-xl bg-slate-900 text-xs text-white shadow-lg';
            document.body.appendChild(toast);
            setTimeout(() => toast.remove(), 3000);
        }
    </script>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\production_re_banking\resources\views/pusher.blade.php ENDPATH**/ ?>