

<?php $__env->startPush('styles'); ?>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" crossorigin="anonymous" referrerpolicy="no-referrer" />
<style>
:root{ --gap:12px; --border:#e9ecef; --muted:#6c757d; }
.card{ border-radius:12px; } .card-header{ border-bottom:1px solid var(--border); }

/* Table */
.table thead th{ font-weight:600; text-transform:uppercase; font-size:12px; letter-spacing:.04em; border-bottom:2px solid var(--border)!important;}
.table td{ vertical-align:middle; }
.badge{ padding:.5em .65em; font-weight:600; }
.td-actions{ white-space:normal; } .td-actions .btn{ margin-bottom:6px; }

/* Filters (mobile-first) */
.filters-wrap{ display:grid; grid-template-columns:1fr auto; gap:var(--gap);}
.filters-title{ display:flex; align-items:center; gap:10px;}
.filter-toggle{ display:inline-flex; align-items:center; gap:8px; border:1px solid var(--border); border-radius:8px; padding:6px 10px; background:#fff; cursor:pointer;}
.filters{ grid-column:1/-1; display:grid; gap:var(--gap); background:#f8f9fa; border:1px solid var(--border); border-radius:10px; padding:10px; transition:max-height .25s ease, opacity .2s ease; overflow:hidden; max-height:0; opacity:0;}
.filters.open{ max-height:360px; opacity:1; }
.filters-grid{ display:grid; gap:var(--gap); }
.filters-grid .input-group-text{ background:#fff; }

/* Desktop */
@media (min-width:768px){
  .filters-wrap{ grid-template-columns:auto 1fr; }
  .filter-toggle{ display:none; }
  .filters{ grid-column:2/3; background:transparent; border:none; padding:0; max-height:none; opacity:1; overflow:visible; }
  .filters-grid{ grid-auto-flow:column; grid-auto-columns:max-content; align-items:center; gap:var(--gap); }
  .filters-grid .form-select,.filters-grid .form-control{ width:220px; }
  .filters-grid .input-group{ width:300px; }
}

/* Custom modal */
.cmodal{ position:fixed; inset:0; z-index:1090; display:none; align-items:center; justify-content:center;}
.cmodal.show{ display:flex; }
.cmodal .cm-backdrop{ position:absolute; inset:0; background:rgba(10,12,16,.55); backdrop-filter:blur(2px);}
.cmodal .cm-dialog{ position:relative; z-index:1; width:min(560px, calc(100% - 32px)); border-radius:14px; background:#fff; box-shadow:0 20px 60px rgba(0,0,0,.25); overflow:hidden; transform:translateY(16px) scale(.98); opacity:0; transition:transform .18s ease, opacity .18s ease;}
.cmodal.show .cm-dialog{ transform:translateY(0) scale(1); opacity:1;}
.cm-header{ padding:14px 18px; border-bottom:1px solid #edf1f5; display:flex; align-items:center; gap:10px;}
.cm-title{ font-size:18px; font-weight:700; margin:0; display:flex; align-items:center; gap:10px;}
.cm-body{ padding:18px;} .cm-footer{ padding:14px 18px; border-top:1px solid #edf1f5; display:flex; justify-content:flex-end; gap:10px;}
.cm-close{ margin-left:auto; appearance:none; border:0; background:transparent; font-size:22px; line-height:1; padding:0 6px; cursor:pointer; color:var(--muted);}
.cm-close:hover{ color:#111; transform:scale(1.05); }
.cm-btn{ border:0; border-radius:10px; padding:9px 14px; cursor:pointer; font-weight:600;}
.cm-btn.light{ background:#f1f3f5; color:#111;}
.cm-btn.success{ background:#198754; color:#fff;}
.cm-btn.danger{ background:#dc3545; color:#fff;}
.cm-help{ color:var(--muted); font-size:12.5px;}
.btn-soft{ border:1px solid rgba(0,0,0,.08); background:#fff; box-shadow:0 1px 2px rgba(0,0,0,.04); }
.btn-soft:hover{ box-shadow:0 2px 6px rgba(0,0,0,.08); }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-4">
  <div class="card shadow-sm border-0">
    <div class="card-header bg-white">
      <div class="filters-wrap">
        <h5 class="filters-title mb-0">
          <i class="fa-solid fa-bolt me-2"></i> Recharges
        </h5>

        <button type="button" class="filter-toggle" id="filterToggle" aria-expanded="false" aria-controls="filters">
          <i class="fa-solid fa-filter"></i> Filters
        </button>

        <form id="filters" method="get" class="filters <?php echo e(request()->hasAny(['status','service_type','q']) ? 'open' : ''); ?>">
          <div class="filters-grid">
            <select name="status" class="form-select form-select-sm" onchange="this.form.submit()">
              <option value="">All statuses</option>
              <option value="pending"   <?php if(request('status')==='pending'): echo 'selected'; endif; ?>>Pending</option>
              <option value="succeeded" <?php if(request('status')==='succeeded'): echo 'selected'; endif; ?>>Succeeded</option>
              <option value="failed"    <?php if(request('status')==='failed'): echo 'selected'; endif; ?>>Failed</option>
            </select>

            <select name="service_type" class="form-select form-select-sm" onchange="this.form.submit()">
              <option value="">All services</option>
              <option value="prepaid"  <?php if(request('service_type')==='prepaid'): echo 'selected'; endif; ?>>Prepaid</option>
              <option value="postpaid" <?php if(request('service_type')==='postpaid'): echo 'selected'; endif; ?>>Postpaid</option>
            </select>

            <div class="input-group input-group-sm">
              <span class="input-group-text"><i class="fa-solid fa-magnifying-glass"></i></span>
              <input type="text" name="q" class="form-control" value="<?php echo e(request('q')); ?>" placeholder="Search msisdn / ref / txn / user">
            </div>

            <button class="btn btn-sm btn-primary" type="submit">
              <i class="fa-solid fa-filter me-1"></i><span class="d-none d-md-inline">Apply</span><span class="d-md-none">Go</span>
            </button>

            <?php if(request()->hasAny(['status','service_type','q'])): ?>
              <a href="<?php echo e(route('admin.recharges.index')); ?>" class="btn btn-sm btn-soft">
                <i class="fa-solid fa-rotate-left me-1"></i> Reset
              </a>
            <?php endif; ?>
          </div>
        </form>
      </div>
    </div>

    <div class="card-body">
      <?php if(session('ok')): ?>
        <div class="alert alert-success mb-3"><i class="fa-solid fa-circle-check me-1"></i><?php echo e(session('ok')); ?></div>
      <?php endif; ?>
      <?php if($errors->any()): ?>
        <div class="alert alert-danger mb-3">
          <strong><i class="fa-solid fa-triangle-exclamation me-1"></i>Validation error:</strong>
          <ul class="mb-0"><?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $e): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><li><?php echo e($e); ?></li><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?></ul>
        </div>
      <?php endif; ?>

      <div class="table-responsive">
        <table class="table align-middle">
          <thead>
            <tr>
              <th>#</th>
              <th>User</th>
              <th>Service</th>
              <th>MSISDN</th>
              <th>Amount</th>
              <th>Reference</th>
              <th>Txn</th>
              <th>Status</th>
              <th>Created</th>
              <th class="text-end">Actions</th>
            </tr>
          </thead>
          <tbody>
          <?php $__empty_1 = true; $__currentLoopData = $recharges; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <tr>
              <td class="text-muted">#<?php echo e($r->id); ?></td>
              <td><i class="fa-solid fa-user me-1 text-muted"></i><?php echo e($r->user?->name); ?></td>
              <td>
                <?php
                  $svcIcon = $r->service_type === 'postpaid' ? 'fa-file-invoice-dollar' : 'fa-sim-card';
                ?>
                <i class="fa-solid <?php echo e($svcIcon); ?> me-1 text-muted"></i><?php echo e(ucfirst($r->service_type)); ?>

              </td>
              <td><i class="fa-solid fa-mobile-screen me-1 text-muted"></i><?php echo e($r->msisdn); ?></td>
              <td><i class="fa-solid fa-bangladeshi-taka-sign me-1 text-muted"></i><?php echo e(number_format($r->amount, 2)); ?></td>
              <td><span class="text-monospace"><?php echo e($r->reference); ?></span></td>
              <td><span class="text-monospace"><?php echo e($r->txn_id); ?></span></td>
              <td>
                <?php
                  $badgeClass = match($r->status) {
                      'succeeded' => 'bg-success',
                      'failed'    => 'bg-danger',
                      default     => 'bg-warning text-dark'
                  };
                  $icon = match($r->status) {
                      'succeeded' => 'fa-circle-check',
                      'failed'    => 'fa-circle-xmark',
                      default     => 'fa-hourglass-half'
                  };
                ?>
                <span class="badge <?php echo e($badgeClass); ?>"><i class="fa-solid <?php echo e($icon); ?> me-1"></i><?php echo e(ucfirst($r->status)); ?></span>
              </td>
              <td><i class="fa-regular fa-clock me-1 text-muted"></i><?php echo e($r->created_at?->format('Y-m-d H:i')); ?></td>
              <td class="text-end td-actions">
                <?php if($r->status === 'pending'): ?>
                  <button type="button" class="btn btn-sm btn-success me-1"
                          onclick="openRechargeModal('succeed','<?php echo e(route('admin.recharges.succeed',$r)); ?>','<?php echo e($r->reference); ?>','<?php echo e($r->txn_id); ?>')">
                    <i class="fa-solid fa-check me-1"></i> Mark Succeeded
                  </button>
                  <button type="button" class="btn btn-sm btn-outline-danger btn-soft"
                          onclick="openRechargeModal('fail','<?php echo e(route('admin.recharges.fail',$r)); ?>','<?php echo e($r->reference); ?>','<?php echo e($r->txn_id); ?>')">
                    <i class="fa-solid fa-xmark me-1"></i> Mark Failed
                  </button>
                <?php else: ?>
                  <span class="text-muted"><i class="fa-regular fa-circle-check me-1"></i>—</span>
                <?php endif; ?>
              </td>
            </tr>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <tr>
              <td colspan="10" class="text-center text-muted py-5">
                <i class="fa-regular fa-folder-open fa-2x mb-2 d-block"></i>
                No recharges found.
              </td>
            </tr>
          <?php endif; ?>
          </tbody>
        </table>
      </div>

      <div class="mt-3">
        <?php echo e($recharges->links()); ?>

      </div>
    </div>
  </div>
</div>


<div id="rechargeModal" class="cmodal" aria-hidden="true">
  <div class="cm-backdrop" data-close="1"></div>
  <div class="cm-dialog" role="dialog" aria-modal="true" aria-labelledby="rcTitle">
    <form id="rechargeForm" method="post" onsubmit="return lockSubmit(this)">
      <?php echo csrf_field(); ?>
      <div class="cm-header">
        <h5 class="cm-title" id="rcTitle"><i id="rcIcon" class="fa-solid fa-circle-check"></i> Confirm</h5>
        <button type="button" class="cm-close" aria-label="Close" data-close="1">&times;</button>
      </div>
      <div class="cm-body">
        <p id="rcPrompt" class="mb-3"></p>

        <div class="row g-2">
          <div class="col-12">
            <label class="form-label mb-1">Reference (optional)</label>
            <input type="text" name="reference" id="rcRef" class="form-control" maxlength="100" placeholder="e.g., EXT-REF-12345">
          </div>
          <div class="col-12">
            <label class="form-label mb-1">Transaction ID <span id="rcTxnHelp" class="cm-help">(optional)</span></label>
            <input type="text" name="txn_id" id="rcTxn" class="form-control" maxlength="100" placeholder="Gateway txn id (if any)">
          </div>
        </div>
      </div>
      <div class="cm-footer">
        <button type="button" class="cm-btn light" data-close="1">
          <i class="fa-regular fa-circle-xmark me-1"></i> Cancel
        </button>
        <button id="rcSubmit" type="submit" class="cm-btn success">
          <i class="fa-solid fa-check me-1"></i> Confirm
        </button>
      </div>
    </form>
  </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
(function(){
  // Mobile filters toggle
  const toggle = document.getElementById('filterToggle');
  const filters = document.getElementById('filters');
  if (toggle && filters) {
    toggle.addEventListener('click', function(){
      const open = filters.classList.toggle('open');
      toggle.setAttribute('aria-expanded', open ? 'true' : 'false');
    });
  }

  // Modal logic
  const modal   = document.getElementById('rechargeModal');
  const dialog  = modal.querySelector('.cm-dialog');
  const form    = modal.querySelector('#rechargeForm');
  const titleEl = modal.querySelector('#rcTitle');
  const iconEl  = modal.querySelector('#rcIcon');
  const prompt  = modal.querySelector('#rcPrompt');
  const submit  = modal.querySelector('#rcSubmit');
  const refIpt  = modal.querySelector('#rcRef');
  const txnIpt  = modal.querySelector('#rcTxn');
  const txnHelp = modal.querySelector('#rcTxnHelp');

  window.openRechargeModal = function(type, actionUrl, refVal = '', txnVal = ''){
    form.action = actionUrl;
    refIpt.value = refVal || '';
    txnIpt.value = txnVal || '';

    if (type === 'succeed') {
      titleEl.textContent = 'Mark recharge as succeeded';
      titleEl.prepend(iconEl);
      iconEl.className = 'fa-solid fa-circle-check';
      iconEl.style.color = '#198754';

      prompt.innerHTML = '<i class="fa-solid fa-circle-info me-1"></i> This will set status to <strong>succeeded</strong>. Optionally record gateway <em>txn_id</em> and reference.';
      submit.className = 'cm-btn success';
      submit.innerHTML = '<i class="fa-solid fa-check me-1"></i> Mark Succeeded';

      txnIpt.required = false;
      txnHelp.textContent = '(optional)';
    } else {
      titleEl.textContent = 'Mark recharge as failed';
      titleEl.prepend(iconEl);
      iconEl.className = 'fa-solid fa-circle-xmark';
      iconEl.style.color = '#dc3545';

      prompt.innerHTML = '<i class="fa-solid fa-triangle-exclamation me-1"></i> This will set status to <strong>failed</strong>. You can store a failure reference.';
      submit.className = 'cm-btn danger';
      submit.innerHTML = '<i class="fa-solid fa-xmark me-1"></i> Mark Failed';

      txnIpt.required = false;
      txnHelp.textContent = '(optional)';
    }

    showModal();
  };

  function showModal(){
    modal.classList.add('show');
    modal.removeAttribute('aria-hidden');
    document.addEventListener('keydown', escClose);
    document.documentElement.style.overflow = 'hidden';
  }
  function hideModal(){
    modal.classList.remove('show');
    modal.setAttribute('aria-hidden','true');
    document.removeEventListener('keydown', escClose);
    document.documentElement.style.overflow = '';
  }
  function escClose(e){ if (e.key === 'Escape') hideModal(); }
  modal.addEventListener('click', function(e){ if (e.target.dataset.close) hideModal(); });
  dialog.addEventListener('click', function(e){ e.stopPropagation(); });
  modal.querySelectorAll('[data-close]').forEach(btn => btn.addEventListener('click', hideModal));

  // Double submit guard
  window.lockSubmit = function(frm){
    const btn = frm.querySelector('#rcSubmit');
    if (btn && !btn.dataset.loading) {
      btn.dataset.loading = '1';
      btn.disabled = true;
      btn.insertAdjacentHTML('beforeend', ' <i class="fa-solid fa-spinner fa-spin ms-1"></i>');
    }
    return true;
  };
})();
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ecareba2/new.rkmotorsbike.top/resources/views/admin/recharges/index.blade.php ENDPATH**/ ?>