
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <title>Transaction Statement - #<?php echo e($transaction->id); ?></title>
    <style>
        /* PDF friendly basic styles */
        * {
            box-sizing: border-box;
        }
        body {
            margin: 0;
            padding: 24px;
            font-family: DejaVu Sans, Arial, Helvetica, sans-serif;
            font-size: 12px;
            color: #0f172a;
            background: #f3f4f6;
        }
        .page {
            background: #ffffff;
            padding: 20px 22px;
            border-radius: 12px;
        }
        h1,h2,h3,h4,h5,h6 {
            margin: 0;
            padding: 0;
        }
        .header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 16px;
        }
        .brand-title {
            font-size: 18px;
            font-weight: 700;
            letter-spacing: .06em;
            text-transform: uppercase;
            color: #059669;
        }
        .sub-muted {
            font-size: 11px;
            color: #6b7280;
        }
        .chip {
            display: inline-block;
            padding: 2px 8px;
            border-radius: 999px;
            font-size: 10px;
            font-weight: 600;
        }
        .chip-success {
            background: #dcfce7;
            color: #15803d;
        }
        .chip-danger {
            background: #fee2e2;
            color: #b91c1c;
        }
        .chip-neutral {
            background: #e5e7eb;
            color: #374151;
        }
        .section-title {
            font-size: 12px;
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: .12em;
            color: #6b7280;
            margin-bottom: 4px;
        }
        .divider {
            border-bottom: 1px solid #e5e7eb;
            margin: 10px 0 14px;
        }
        .grid-2 {
            display: table;
            width: 100%;
            table-layout: fixed;
        }
        .grid-2 > div {
            display: table-cell;
            vertical-align: top;
            padding-right: 16px;
        }
        .grid-2 > div:last-child {
            padding-right: 0;
        }
        .info-row {
            margin-bottom: 6px;
            font-size: 11px;
        }
        .info-label {
            color: #6b7280;
        }
        .info-value {
            font-weight: 600;
            color: #111827;
        }
        .amount-box {
            border-radius: 10px;
            border: 1px solid #e5e7eb;
            padding: 10px 12px;
            margin-top: 6px;
        }
        .amount-main {
            font-size: 18px;
            font-weight: 700;
        }
        .amount-credit {
            color: #15803d;
        }
        .amount-debit {
            color: #b91c1c;
        }
        .small-muted {
            font-size: 10px;
            color: #9ca3af;
        }
        .footer {
            margin-top: 20px;
            border-top: 1px dashed #d1d5db;
            padding-top: 8px;
            font-size: 9px;
            color: #9ca3af;
            display: flex;
            justify-content: space-between;
        }
        .table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 6px;
        }
        .table td {
            padding: 5px 4px;
            font-size: 11px;
        }
        .table tr:nth-child(odd) {
            background: #f9fafb;
        }
        .text-right { text-align: right; }
        .text-center { text-align: center; }
    </style>
</head>
<body>
<?php
    // meta already passed from controller, but ensure array
    if (!is_array($meta)) {
        $meta = json_decode($meta ?? '[]', true) ?? [];
    }

    $ref        = $meta['reference_code'] ?? ('TX-'.$transaction->id);
    $status     = $meta['status'] ?? 'Success';
    $trxType    = $meta['trx_type'] ?? ucfirst($transaction->type);
    $cardBrand  = $meta['card_brand'] ?? null;
    $details    = $meta['details'] ?? $trxType;

    $isCredit   = $transaction->type === 'credit';
    $oldBalance = $isCredit
        ? $transaction->balance_after - $transaction->amount
        : $transaction->balance_after + $transaction->amount;

    $account    = $user->phone ?? $user->email ?? 'N/A';
?>

<div class="page">
    
    <div class="header">
        <div>
            <div class="brand-title">ACCOUNT STATEMENT</div>
            <div class="sub-muted">
                Single Transaction Summary
            </div>
        </div>
        <div class="text-right">
            <div class="sub-muted">Generated At</div>
            <div style="font-size:11px;font-weight:600;color:#111827;">
                <?php echo e(now()->format('d M Y, h:i A')); ?>

            </div>
            <div style="margin-top:4px;">
                <span class="chip chip-neutral">ID: #<?php echo e($transaction->id); ?></span>
            </div>
        </div>
    </div>

    <div class="divider"></div>

    
    <div class="grid-2" style="margin-bottom: 10px;">
        
        <div>
            <div class="section-title">Account Holder</div>

            <div class="info-row">
                <span class="info-label">Name: </span>
                <span class="info-value"><?php echo e($user->name); ?></span>
            </div>

            <div class="info-row">
                <span class="info-label">Account: </span>
                <span class="info-value"><?php echo e($account); ?></span>
            </div>

            <div class="info-row">
                <span class="info-label">Transaction ID: </span>
                <span class="info-value"><?php echo e($ref); ?></span>
            </div>

            <div class="info-row">
                <span class="info-label">Date &amp; Time: </span>
                <span class="info-value">
                    <?php echo e($transaction->created_at->format('d M Y, h:i A')); ?>

                </span>
            </div>
        </div>

        
        <div>
            <div class="section-title">Transaction Summary</div>

            <div class="amount-box">
                <div class="info-row">
                    <span class="info-label">Type: </span>
                    <span class="info-value"><?php echo e($trxType); ?></span>
                </div>

                <div class="info-row">
                    <span class="info-label">Direction: </span>
                    <span class="info-value"><?php echo e(ucfirst($transaction->type)); ?></span>
                </div>

                <?php if($cardBrand): ?>
                    <div class="info-row">
                        <span class="info-label">Source: </span>
                        <span class="info-value"><?php echo e($cardBrand); ?></span>
                    </div>
                <?php endif; ?>

                <div style="margin-top:6px;">
                    <div class="small-muted">Amount</div>
                    <div class="amount-main <?php echo e($isCredit ? 'amount-credit' : 'amount-debit'); ?>">
                        <?php echo e($isCredit ? '+' : '-'); ?>৳<?php echo e(number_format($transaction->amount, 2)); ?>

                    </div>
                </div>

                <div style="margin-top:6px;font-size:10px;">
                    <div><span class="info-label">Old Balance:</span> ৳<?php echo e(number_format($oldBalance, 2)); ?></div>
                    <div><span class="info-label">New Balance:</span> ৳<?php echo e(number_format($transaction->balance_after, 2)); ?></div>
                </div>
            </div>
        </div>
    </div>

    
    <div style="margin-top:4px;">
        <div class="section-title">Status &amp; Details</div>

        <table class="table">
            <tr>
                <td>Current Status</td>
                <td>
                    <?php $statusLower = strtolower($status); ?>
                    <?php if($statusLower === 'success' || $statusLower === 'approved' || $statusLower === 'completed'): ?>
                        <span class="chip chip-success"><?php echo e(ucfirst($statusLower)); ?></span>
                    <?php elseif($statusLower === 'rejected' || $statusLower === 'failed'): ?>
                        <span class="chip chip-danger"><?php echo e(ucfirst($statusLower)); ?></span>
                    <?php else: ?>
                        <span class="chip chip-neutral"><?php echo e(ucfirst($statusLower)); ?></span>
                    <?php endif; ?>
                </td>
            </tr>
            <tr>
                <td>Description</td>
                <td><?php echo e($details); ?></td>
            </tr>
            <tr>
                <td>Reference Code</td>
                <td><?php echo e($ref); ?></td>
            </tr>
            <tr>
                <td>Account</td>
                <td><?php echo e($account); ?></td>
            </tr>
            <tr>
                <td>Charge</td>
                <td>৳0.00</td>
            </tr>
            <tr>
                <td>Note</td>
                <td>
                    This is a system generated statement for a single transaction.
                    Keep this PDF for your records.
                </td>
            </tr>
        </table>
    </div>

    
    <div class="footer">
        <div>
            © <?php echo e(date('Y')); ?> &mdash; Your App Name  
            <br>Generated automatically. No signature required.
        </div>
        <div class="text-right">
            Transaction ID: <?php echo e($ref); ?><br>
            User ID: #<?php echo e($user->id); ?>

        </div>
    </div>
</div>
</body>
</html>
<?php /**PATH /home/ecareba2/new.rkmotorsbike.top/resources/views/frontend/statement/pdf.blade.php ENDPATH**/ ?>