
<?php $__env->startSection('content'); ?>
<div class="container-fluid py-3">

  <style>
    .card-edge{ border:1px solid #e6e8ef; border-radius:16px; background:#fff; box-shadow:0 4px 18px rgba(17,24,39,.06) }
    .section-title{ font-size:.95rem; font-weight:700; color:#334155 }
    .logo-preview{ height:56px; width:56px; border-radius:50%; object-fit:contain; border:1px solid #e5e7eb; background:#fff; padding:6px }
    @media (max-width:576px){ .btn-wide{ width:100% } }
  </style>

  <div class="d-flex align-items-center gap-2 mb-3">
    <a href="<?php echo e(url('/admin/billers')); ?>" class="btn btn-light border"><i class="fa-solid fa-arrow-left"></i></a>
    <h5 class="mb-0"><i class="fa-regular fa-pen-to-square me-2"></i>Edit: <?php echo e($biller->name); ?></h5>
  </div>

  <form action="<?php echo e(url('/admin/billers/'.$biller->id)); ?>" method="POST" enctype="multipart/form-data" class="card-edge p-3">
    <?php echo csrf_field(); ?> <?php echo method_field('PUT'); ?>

    <?php if($errors->any()): ?>
      <div class="alert alert-danger"><ul class="mb-0"><?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $e): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><li><?php echo e($e); ?></li><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?></ul></div>
    <?php endif; ?>

    <div class="section-title mb-2"><i class="fa-regular fa-rectangle-list me-1"></i> Basics</div>
    <div class="row g-3 mb-3">
      <div class="col-md-6">
        <label class="form-label">Category *</label>
        <select name="biller_category_id" class="form-select" required>
          <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($cat->id); ?>" <?php if(old('biller_category_id',$biller->biller_category_id)==$cat->id): echo 'selected'; endif; ?>><?php echo e($cat->name); ?></option>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
      </div>
      <div class="col-md-6">
        <label class="form-label">Name *</label>
        <input name="name" class="form-control" value="<?php echo e(old('name',$biller->name)); ?>" required>
      </div>
      <div class="col-md-6">
        <label class="form-label">Code (unique) *</label>
        <input name="code" class="form-control" value="<?php echo e(old('code',$biller->code)); ?>" required>
      </div>
      <div class="col-md-3">
        <label class="form-label">Provider</label>
        <input name="provider" class="form-control" value="<?php echo e(old('provider',$biller->provider)); ?>">
      </div>
      <div class="col-md-3">
        <label class="form-label">Type</label>
        <select name="type" class="form-select">
          <option value="" <?php if(old('type',$biller->type)===''): echo 'selected'; endif; ?>>—</option>
          <option value="prepaid"  <?php if(old('type',$biller->type)==='prepaid'): echo 'selected'; endif; ?>>Prepaid</option>
          <option value="postpaid" <?php if(old('type',$biller->type)==='postpaid'): echo 'selected'; endif; ?>>Postpaid</option>
        </select>
      </div>
    </div>

    <div class="section-title mb-2"><i class="fa-regular fa-image me-1"></i> Logo</div>
    <div class="row g-3 mb-3">
      
      <div class="col-md-12">
        <label class="form-label">Upload Image</label>
        <input type="file" id="logoFile" name="logo_file" class="form-control" accept="image/*">
        <div class="d-flex align-items-center gap-3 mt-2">
          <?php
            $logo = $biller->logo;
            $isStored = $logo && \Illuminate\Support\Facades\Storage::disk('public')->exists($logo);
            $isUrl    = $logo && \Illuminate\Support\Str::startsWith($logo, ['http://','https://']);
          ?>
          <?php if($isStored): ?>
            <img id="logoPreview" class="logo-preview" src="<?php echo e(asset('storage/'.$biller->logo)); ?>" alt="current">
          <?php elseif($isUrl): ?>
            <img id="logoPreview" class="logo-preview" src="<?php echo e($biller->logo); ?>" alt="current">
          <?php else: ?>
            <img id="logoPreview" class="logo-preview d-none" src="#" alt="preview">
          <?php endif; ?>

          <div class="form-check">
            <input class="form-check-input" type="checkbox" name="remove_logo" value="1" id="removeLogo">
            <label class="form-check-label" for="removeLogo">Remove stored logo</label>
          </div>
        </div>
      </div>
    </div>

    <div class="section-title mb-2"><i class="fa-solid fa-scale-balanced me-1"></i> Limits & Status</div>
    <div class="row g-3 mb-3">
      <div class="col-md-3">
        <label class="form-label">Min Amount *</label>
        <input type="number" step="0.01" name="min_amount" class="form-control" value="<?php echo e(old('min_amount',$biller->min_amount)); ?>" required>
      </div>
      <div class="col-md-3">
        <label class="form-label">Max Amount *</label>
        <input type="number" step="0.01" name="max_amount" class="form-control" value="<?php echo e(old('max_amount',$biller->max_amount)); ?>" required>
      </div>
      <div class="col-md-3">
        <label class="form-label">Sort Order</label>
        <input type="number" name="sort_order" class="form-control" value="<?php echo e(old('sort_order',$biller->sort_order)); ?>" min="0">
      </div>
      <div class="col-md-3">
        <label class="form-label">Status *</label>
        <select name="status" class="form-select" required>
          <option value="active"   <?php if(old('status',$biller->status)==='active'): echo 'selected'; endif; ?>>Active</option>
          <option value="inactive" <?php if(old('status',$biller->status)==='inactive'): echo 'selected'; endif; ?>>Inactive</option>
        </select>
      </div>
    </div>

    <div class="d-flex gap-2 flex-wrap">
      <button class="btn btn-primary btn-wide"><i class="fa-regular fa-circle-check me-1"></i> Update</button>
      <a class="btn btn-outline-secondary btn-wide" href="<?php echo e(url('/admin/billers')); ?>">Back</a>
    </div>
  </form>
</div>

<script>
  document.getElementById('logoFile')?.addEventListener('change', e=>{
    const f = e.target.files?.[0]; if(!f) return;
    const url = URL.createObjectURL(f);
    const img = document.getElementById('logoPreview');
    img.src = url; img.classList.remove('d-none');
  });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\production_re_banking\resources\views/backend/billers/edit.blade.php ENDPATH**/ ?>